package com.jhscale.test.other;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.File;
import java.util.List;

/**
 * @author lie_w
 * @title: XMLUtils
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/4/1113:14
 */
public class XMLTest {

    public static final File XML_File = new File("F:\\JHScale\\Resources", "settings.xml");

    public static void main(String[] args) throws Exception {

        String SpecID_format = "public static final int SpecID = %s;// %s %s %s";

        SAXReader reader = new SAXReader();
        Document doc = reader.read(XML_File);
        Element root = doc.getRootElement();
        System.out.println("获取了根元素:" + root.getName());
        List<Element> list = root.elements();

        for (Element element : list) {
            String text = element.getQualifiedName();

            if ("Spec_Info".equals(text)) {

                String SpecID = element.element("SpecID").getTextTrim();
                // System.out.println("SpecID: " + SpecID);

                String Type = element.element("Type").getTextTrim();
                // System.out.println("Type: " + Type);

                String Display = element.element("Display").getTextTrim();
                // System.out.println("Display: " + Display);

                String Visible = element.element("Visible").getTextTrim();
                // System.out.println("Visible: " + Visible);

                System.out.println(String.format(SpecID_format, SpecID, Display, Type, Visible));

            } else if ("String_Info".equals(text)) {

                String StringID = element.element("StringID").getTextTrim();
                System.out.println("StringID: " + StringID);

                String Display = element.element("Display").getTextTrim();
                System.out.println("Display: " + Display);

                String Visible = element.element("Visible").getTextTrim();
                System.out.println("Visible: " + Visible);

            }


        }
    }
}
