package com.jhscale.test.pos;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jhscale.common.em.*;
import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.model.device.DConstant;
import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.common.model.device._inner.PublicExecuteModify;
import com.jhscale.common.model.device._inner.PublicExecuteRecovery;
import com.jhscale.common.model.device._inner.ServerUnPackageObject;
import com.jhscale.common.model.device.bitmap.DBitMap;
import com.jhscale.common.model.device.bitmap.DBitMapV1;
import com.jhscale.common.model.device.font.DFont;
import com.jhscale.common.model.device.info.DInfo;
import com.jhscale.common.model.device.info.DPayment;
import com.jhscale.common.model.device.info.DServerConfig;
import com.jhscale.common.model.device.info.DServerInfo;
import com.jhscale.common.model.device.log.DLOGV1;
import com.jhscale.common.model.device.other.DSpDWL;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.FDPLU;
import com.jhscale.common.model.device.plu.em.Restriction;
import com.jhscale.common.model.device.plu.inner.DAutoDiscountV2;
import com.jhscale.common.model.device.plu.inner.DManualDiscount;
import com.jhscale.common.model.device.plu.module.*;
import com.jhscale.common.model.device.saleman.DSaleManV1;
import com.jhscale.common.model.license.JRSAEncryptDecrypt;
import com.jhscale.common.utils.DDataUtils;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.common.utils.RandomUtils;
import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.entity.CPReport;
import com.jhscale.meter.entity.LOGReport;
import com.jhscale.meter.entity.PLUReport;
import com.jhscale.meter.entity.item.PLUItem;
import com.jhscale.meter.entity.server.CPServerReport;
import com.jhscale.meter.entity.server.LOGServerReport;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.SerialPort;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.io.control.win.WTCPClientControl;
import com.jhscale.meter.io.control.win.WTCPServerControl;
import com.jhscale.meter.io.control.win.WUDPControl;
import com.jhscale.meter.model.device.Identify;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.model.device.TCPServerDevice;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ad.ADScaleProtocolManager;
import com.jhscale.meter.protocol.ad.entity.disassembly.ObtainWeightADPDResponse;
import com.jhscale.meter.protocol.constant.TMS;
import com.jhscale.meter.protocol.entity.IPackResponse;
import com.jhscale.meter.protocol.model.*;
import com.jhscale.meter.protocol.print.PrintFactory;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity.ScheduleState;
import com.jhscale.meter.protocol.print.entity.cmd.Print0000Request;
import com.jhscale.meter.protocol.print.entity.cmd.Print0200Request;
import com.jhscale.meter.protocol.print.entity.cmd.Print0200Response;
import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;
import com.jhscale.meter.protocol.print.entity.file.bitmap.PrintBitMapRequest;
import com.jhscale.meter.protocol.print.line.PrintLine;
import com.jhscale.meter.protocol.print.line.PrintLineLMR;
import com.jhscale.meter.protocol.print.link.DefaultPrintSerialMessenger;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import com.jhscale.meter.protocol.trade.CashSettlement;
import com.jhscale.meter.protocol.trade.JKYSettlement;
import com.jhscale.meter.utils.FileUtils;
import com.jhscale.meter.utils.ScannerUtils;
import com.jhscale.test.network.MeterEquipmentTest;
import com.jhscale.test.serial.PrintTest;
import org.apache.commons.lang3.StringUtils;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.util.*;
import java.util.stream.Collectors;

import static com.jhscale.meter.protocol.print.PrintConstant.NODE_A_P;
import static com.jhscale.meter.utils.AConstant.UDP_Terminal;
import static com.jhscale.test.serial.JSerialPrintTest.CP_D_REPORT;

/**
 * @author lie_w
 * @title: PrintTradeTest
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/9/2115:46
 */
public class PrintTradeTest {

    static final String bmp1_1 = "BMP\t1\t@A@@@@@@GD@@GH@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@F@@@@@@@@@@@@@@@@@@@@AON@@@@@@D@@@@@@@@@@@@@@@@@@@@NJEN@@@@@N@@@@@@@@@@@@@@@@@@@CEBIEH@@@@@@@@@@@@@@@@@@@@@@@@EBDJJF@@@@H@@@@@@@@@@@@@@@@@@@JJJIBIH@@@D@@@@@@@@@@@@@@@@@@ABEEEEED@@@D@@@@@@@@@@@@@@@@@@AJJDJDJK@@@D@@@@@@@@@@@@@@@@@@BEBJJJIDH@@N@@@@@@@@@@@@@@@@@@FIEEBJJED@@O@@@@@@FON@@@@@@@@@DJJEDIBJJ@@@@@@@@GEBEL@@@@@@@@EEBIEEEDJ@@F@@@@CJJJJK@@@@@@@@JIDJDJJEEH@I@@@@MEBDIBH@@A@L@@JJJJJIBJED@G@@@CBIEEEED@@FCA@@JEBIEEDJIB@G@@@MDJJJJJK@ALLNGFJJJEDJEDJK@M@@ABEEBIDJE@FCEEJJMDJJEBJIEE@H@@BJJEDJEBJMJLJIEEBEDJIEDJIBHN@@EEBIEBIEDJEEBJEBJJEDJJEEBJHG@@JIEBEEEBEBIEDJIDJJJEEBJIEDLM@ADJJJJDJJJJJEEDJJIBJJIEBJJEDM@BEDIEBJIDIEBIEEDIEDIBJEDJJJJJ@BJJJIEEBJJDJJEBJJIEEDJJEDIDJD@EDIDJIBJEEEEBIDIEEBJJIDJEFJJK@EEEBIEEEDHJDJJEEBJJEBEEKM@JJD@JEEEEBDIEAEEDJJJDJDIEJJ@BOHJO@JIDJEEEEB@IEEBJEEBJJJEFH@@GBG@JJEEDJJJD@EDIEBJIEEEBJ@BDDDNEADJJIEBEBHBABJIDIEBDIEEH@@@@BLAEBIEBJIE@@HEBJJJJJJJDIA@AAABJAEDJEEDJFB@@BJEEDIEEBJJ@DH@@DHBIEEDIBJH@@A@JIBJJDIEEED@@BDDGBJDIEEEA@@B@DEEDJJJJIBDJ@B@@HGBJJJJJJNH@@@@@JEBEEEFJJHD@H@HIBIEDIBE@@B@@@@BJJIDKAEEBA@@I@OBJIECEKFB@@B@A@IEBEDNIDJ@DDB@NBEBDLFDD@@B@@BBBIEECGNKJH@@D@HBIEEAHMH@@@@@L@DJJIEHCNJBA@H@NBJJJK@A@@B@@C@@@CBEG@AKI@HA@@OAEBIDAB@B@@@MH@@@FJF@@NJH@B@@OAEDKD@@B@@@BOHA@HHMJ@@GNH@L@@E@IEBA@@@@@@OAN@@@@@N@@BMDC@@@K@JJLHDB@@@CD@F@@@@@J@@CKGL@@@I@EA@@A@@@AMH@C@@@@@N@@CGD@@@@G@EFDB@@@@OG@@CHDAA@J@@CNB@@@@F@BD@HHD@CMJ@@A@A@@@N@@BIB@@@@F@BL@@B@IAGN@@AH@@@DJ@@CIB@@@@F@A@HA@@IAMD@@AH@@@AF@@CGB@@@@I@@HB@A@HAGN@@AH@@H@F@@EMA@@@@G@@D@H@BICJJ@@AHHH@@GH@NCA@@@@M@@B@BD@EBOO@@A@@@@@CDCLCA@@@@L@@AH@@HDKIE@@CH@@A@CMM@B@H@@@G@@@F@@@DBIOH@EH@@O@AGGHB@H@@@N@@@AH@@DKMGF@NHDDDDDMNLD@H@@@L@@@@GOHDIGHMMG@@@@@AFMKHDH@@@@@@@@@@DDIM@GGM@@@@@@COO@@D@@@C@@@@@@DBAK@EMF@@@@@@@@@H@D@@@C@@@@@@DB@O@GGLBAAA@H@D@@@D@@@C@@@@@@DB@N@FO@@@@@@@@A@@@GH@@M@@@@@@DBAAHOH@@@@@@A@@@@CL@@@H@@@@@@DBDJGA@H@H@@@@B@@GLD@@@F@@@@@@D@@A@@@A@@D@H@@@CH@D@@@I@@@@@@D@JJ@@@@@@@HB@@B@@@D@@@N@@@@@@D@@@@@@@@@@@@D@@A@@D@@@O@@@@@@D@@@@@B@B@@@@BB@@@@D@@@O@@@@@@B@@@@O@D@D@@@B@A@@@D@@@O@@@@@@B@@OO@@@@A@B@B@@@N@H@@@O@@@@@@BAOA@@@@@A@E@D@@@COH@@@O@@@@@@A@@@@@A@H@HHOH@@@@AG@@@O@@@@@@A@A@@@@@A@GA@@B@B@A@@@@O@@@@@@A@@@@F@@@@HN@H@H@@B@@@@O@@@@@@@H@@AH@@@@B@@@@B@@B@@@@O@@@@@@@D@@FB@D@@@H@@@@@HD@@@@O@@@@@@@D@AH@HA@@@@@B@@@@H@@@@O@@@@@@@B@FD@@@A@@@H@H@H@H@@@@O@@@@@@@AAH@@@@@D@@B@@H@A@@@@@O@@@@@@@A@@@@@@@AA@@@@@@B@@@@@O@@@@@@@@H@A@D@@@@@@@@@@D@@@@@O@@@@@@@@D@@DA@@@@@@@@@@H@@@@@J@@@@@@@@C@@@@CL@@D@O@@C@@@@@@M@@@@@@@@@H@@@DB@HAAAH@D@@@@@@@@@@@@@@@@F@A@JE@@@A@DAH@@@@@@@@@@@@@@@@AH@A@A@@@BIBB@@@@@@@A@@@@@@@@@@E@AAA@B@B@BL@@@@@@@O@@@@@@@@@@E@A@C@@@BDJD@@@@@@@O@@@@@@@@@@D@IDI@@IB@BJ@@@@@@@O@@@@@@@@@@J@A@A@@@BIDD@@@@@@@O@@@@@@@@@@L@@IC@@@B@HC@@@@@@@O@@@@@@@@@A@@@DBD@@AIAB@@@@@@@B@@@@@@@@@AI@@CLA@@@F@AH@@@@@@O@@@@@@@@@B@DD@@@BB@D@A@@@@@@@O@@@@@@@@@B@@A@@@@@H@@@L@@@@@@O@@@@@@@@@B@@@B@@@@@A@DD@@@@@@O@@@@@@@@@B@@@@HH@@@@@@D@@@@@@O@@@@@@@@@DBB@@@A@DB@D@B@@@@@@O@@@@@@@@@D@@B@@@@@@@@AB@@@@@@O@@@@@@@@@D@@@@@@D@@@@@B@@@@@@O@@@@@@@@@D@@@HHH@A@HA@B@@@@@@O@@@@@@@@@DAA@@@@@@@B@@A@@@@@@O@@@@@@@@@D@@@@@@@@@@@@I@@@@@@O@@@@@@@@@D@@@@@BB@@@@@A@@@@@@E@@@@@@@@@L@@BBB@@HD@HHA@@@@@@O@@@@@@@@ADA@@@@@@@A@@@A@@@@@@O@@@@@@@@BD@@@@@@@@@@@@B@@@@@@E@@@@@@@@DD@D@@@@@@@@@BB@@@@@@O@@@@@@@@DD@A@HHIBB@BB@B@@@@@@O@@@@@@@@BB@@@@@@@@D@@@D@@@@@@E@@@@@@@@AN@@@@@@@@@@@@D@@@@@@O@@@@@@@@@A@@@@@@@@@@@@H@@@@@@O@@@@@@@@@@H@@@@@@@@@@A@@@@@@@O@@@@@@@@@AD@@@@@@@@@@BH@@@@@@O@@@@@@@@@BCOOKONOOGOKLF@@@@@@O@@@@@@@@@DHD@FMKFMKFL@BH@@@@@O@@@@@@@@A@@NKEEEEEEEF@GD@@@@@O@@@@@@@@BLAEFMKFMKFMFOJH@@@@@O@@@@@@@@BMOFMKFMKFMKMKF@@@@@@O@@@@@@@@AKFMKFMKFMKF@@@@@@@@@O@@@@@@@@@@@@@@@@@@@@@@@@@@@@@O@@@@@@@@@@@@@@@@@@@@@@@@@@@@@O@@@@@@@@@@@@@@@@@@@@@@@@@@@@@O\t";
    static final String bmp1_2 = "BMP\t1\t@A@@@@@@LH@@IF@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@DDA@D@B@@@@D@ABDHAB@IA@@@BDB@IA@@@DH@I@I@@DDB@H@@@A@D@A@@@@@@@B@@@@H@@@@DDHH@@B@@A@@@A@@D@ABAA@DAAB@@@@D@@@@@D@@@@@@@@@B@@@@@@@@@@@@A@@@@@@@@@@@@@@@@HDABABBBIDADIABDHIAA@BDA@AABDDIBD@DHHDI@JJDJBEABD@BABDHHHHBABBBDIBABDDJDIBEBDIABADHHJEBIBD@@I@A@HDIB@@DIABBDDHDIDJBEDDIA@A@DHABBHDB@BAA@DDIBJIBEBEBJJ@@BABBDHJI@IBIADH@IDHED@AEBE@EBHJIBBDHJJDABDHHHH@A@D@BDHIB@BDBHBDBEABBDHBIB@A@JHDA@D@IBE@A@JABEABAEBD@DDIADHJDHDDDIDHHHDIBD@DJJEABIBDIADD@JBDDJEBBDHHDH@@ABBAAAB@I@B@BEABADDI@ADABBDDHHBBBHE@BHIA@DHHBBB@DABDIFBDDHBDDHE@HIB@IBABABHE@IBJD@HD@E@DBBDIAB@I@B@@AAB@IBA@DIBDHEABDJBD@EJDE@JDI@HIDHE@BJDIBDJDIDD@@DBDIE@HJBB@BHEBDDI@HJDHABIE@IBDBAAB@HE@IDIB@IDBJ@@AABDBEBA@I@D@HHHIBHE@@BJDBBEBDIDJDDBD@DDABDID@JADH@DHIDHHJHBHIDEAABDA@J@EABDDHEBDB@HIABBHIBIBBID@J@BBAEBAAB@@HDBADBDDADE@IBBDIABHIBDEABBDBDDHDDHB@AA@@@BHJJBDE@BHDHADIBBHBD@DIABBDEBDI@HDA@DJEBHIADDHDHHA@A@DHHHHH@BDJBDIDBEDDABDDI@HDHBIDIDDA@JBDBBHABBD@@EDEABJBDBHIA@HHJAD@@@J@JJBEBEADBBBAABD@HJDHB@DDH@D@IBB@@I@DDBDEEE@B@BJ@AE@ADHE@DIDDHBDDJEA@IEDJIA@@@I@HDIDDIA@DHHB@EADE@IB@JJABHBHBBIBHHAABBDB@I@BBDH@BDBBBBABJDAAE@JHEB@D@DI@DJDEEBED@DAABJDDJDIBEDDHBBDJDDHDJHA@JBBA@E@DJHBEDDI@HH@DHBIEBD@AEA@JJHHBI@@@A@IABH@BD@@HDHJHBH@D@@@HDEBEBHED@@DHBJ@BD@@EDHD@H@D@@@@A@@A@BA@B@A@ABA@HDA@@@@@A@@HI@A@A@@ABA@@B@H@B@B@B@@B@@D@@A@@@@@@HDB@HB@DDD@@@@@@@@@BA@@H@@@H@B@A@D@@@@D@@@@@@DHDH@@@@@@@H@@ABDD@@A@DH@H@@@BD@@B@@H@A@I@@A@A@DBB@B@BBA@HIBDBAA@@@@BA@D@B@@DBB@A@A@@B@A@@@D@@B@@A@@A@@@@HD@@@@@HDD@A@@H@@@@HDA@@H@DH@H@A@@D@@@@@@D@A@D@DHH@@I@HI@@@@HHA@@B@JDBA@@D@H@@@@@HDD@@@H@@D@@@E@E@@AA@@B@@D@I@@@@@@IDHJJFFDJ@B@@H@D@@@@B@A@D@A@H@B@AB@@AA@BBAB@DB@DD@BIDJBEE@JD@A@B@@B@@@@@@D@@HDBHHID@IBD@@@H@@@A@B@A@AEDJBEBAFA@HD@D@HIA@@@@@@H@@HBBDBD@@@DI@@H@E@@@@HDAEDE@FFDE@D@A@AD@@@D@H@@D@EBEEEEEBIB@@@DDBB@DA@D@ABLLJBEDABH@B@DH@I@@@HB@@@B@DJJJJJJD@D@@@@@@@@H@@A@@IHNBEEAMBA@H@@B@A@@@@DB@HIEDIBBDJJJAABAA@HI@@D@H@BHDDBEBHC@H@AB@@@@DD@@A@BAEEEEEDIABDHD@@@D@@DBA@@DBELMDMGCBH@D@@BBD@@@A@@@HJJJJJHIBJJIB@@HB@DBA@@BD@IB@A@B@DBHBAB@@@A@@@HB@BAEEEEBEBDDDJI@D@@@A@@@H@@@@@JBA@B@@B@@@B@@@BB@@@DHEEEEDJHHHIEBDE@DHD@@DDA@ABBB@HHE@JJ@HD@@H@@@@H@@@AEEJMEDBBBBIEE@@@@A@D@@@DH@BDBABHE@@H@@I@BA@@@BA@ABJJJJJEDH@HBJJIB@B@DAA@D@@@BJHJDB@EE@B@@B@@DI@@@DHEFMEEE@@@HADEED@D@HA@@DA@DB@@B@@IB@@D@H@@@@@@@@@@BJJJMEEEDHBBBIEEBA@A@AD@HBA@@@@DD@@BBA@A@HHB@@B@H@IEEJKEDH@@@@DJJJH@B@BDAD@@@IEBIAABJHHHD@D@@@AB@H@HBKEGFMEBH@@HIBJMBJ@JIBDAEDD@@@DBD@@DA@@H@BB@@@@@@BJJNJJJJH@@@BBEEED@D@BEBJ@@@E@JA@ABBADB@BA@@A@@HBB@EKEJMJJEB@@@DJJJJDIEDIDIEBI@J@DEDHHJ@HI@HA@@DDB@@BJJKGKFJH@@@HIEEEEABJJJJJID@D@D@@@BB@D@@@@@B@@@@@@HKGFMFMJJI@@ABJMKEEEECDIDJED@HAA@I@@@AB@HBD@DA@HI@CJJMKKEEDDBHJEEEFMEEEDEBABIBH@@@D@@HJH@HB@A@A@@@@DDFKGFJNJJHHBAEEKEEJJJJHJJDJJAA@D@DHB@@HB@I@B@@D@@ACMNJMOEMEEBDJEJJMJJJJIB@AABJH@D@I@B@@@B@D@B@@BAB@HFKEOKJNKJJDIEJKGKGFJJJIBDDDIED@@@A@JME@I@B@DB@@@HAEFNKGGMMEEEEEEFMFMEEEDD@ABJJJ@AAA@BBBJH@B@D@@@D@@BFMKMMMKEKEJJJKJJMJMJJE@I@@BEEE@D@B@BMEBD@H@DABA@A@MJMGGFNOFMFKFMGOKGEFJHJ@ABHJJHD@D@IA@DH@HBA@@@@DHBJOKMMOKMKFMFMKMEEJNJJI@@@@EEEEAA@H@DEEABB@H@DA@@@IGEGGGJOFNMEEFNKONMEJJJ@@@@JEEDH@BBBALJH@@H@B@HD@@BJOMKNOMOKKOOKKOEEGKGEBJ@@JAEEEAD@@@DAEDBD@BH@@A@IBOEGNOKGEFOEJNMEOOMFJMD@@@@JJKED@HDHAB@A@@B@@BA@D@BJOMGJOMOOKOGKOOEJKJBJJIB@IBJJMI@B@BD@AD@A@IB@H@@AEGJOMONOMJMENNKEOGNMDJJD@BBEFMJJB@B@@HH@ED@@@@@I@HAMGKKGKKGOOOKGOOMNK@BBJJDHEEEJKDHI@DJ@BD@@DABB@@@@KGNNOMOONMJMOMJMGKLBIDMEBBIEKFME@@A@@B@A@IA@@@B@BBBJKKNOFOGOOOFOOONNIDDCEEEEEEFKJMBIDBDHI@D@@D@@@DH@EONOKKOKMKGKOKGEKFH@KNKEEDKFJMGEDDBEAA@JABD@H@H@@IBJKNOOFNOOMNMOMOOLBEEENMEGFMOKJNHHHHBBD@H@A@BD@H@@KOOGNOOOMKGGOFOMFI@BOOEGMJMGEGGEEB@@H@A@A@HB@@B@IBBJMNOKNMOOONMOKGM@AOMJOJJKGJOMJNH@BB@I@D@D@HHA@B@@EOOKKNOOKKFOOMOOD@FJOOMGGNMGMGGEJJ@@@@BAD@D@B@@@@DKEEONOKKOOOKFOKFHAKOJKGMNKKNKMNKD@I@IB@@AB@DHBDHB@BOOKGMOOFNMOOMON@BMEOOKGKNOGOFMNJJ@D@@DD@@B@@@@A@AEMFOOGMKOOOMNOKHAGGKFMOMNKMJMOGDE@D@B@AABB@IB@@@A@CGONOOOOKKMOGMN@AFMGOOFOGOGOOEMJJEAB@E@@@@H@@@HD@DEKFOMNONONOGOGD@OMJJNMOKMMKGEOFADJD@H@DBBDB@HDA@DABOOMOOKGNOOMMNHAJKEGKOKNOGOMOMLEAB@HB@A@@@@H@@@A@HEMFOKGOOOKMOGM@BMJJEOKNOMOFOMG@JFDJA@I@ABBJBBAB@@AAGOOOMOMKOGGOD@OGFDKKNOKGMOKGNBJHH@DB@DH@@@@@@@DB@EMKKOOMONOONM@CJMDICOGKONOMOOHBJJAA@HD@@HHDHHB@A@HBKNNOGOGOMMKJ@MGEEDJOONMKMOGF@JNIDDDBAAB@B@BB@I@@BIOGOKNOOGOOOAAGMEDICKKGOOGGMLAFKBAAA@H@@B@J@@B@DB@BKMMOOKOMKGDDGJJKBBANOOGKOMOHEKMDJDDJJI@HH@DD@B@HHHNOONMOGOOMDIMGEEE@EONMNNMGJ@MEEBHJIEH@D@BA@@D@B@@BMKGGOOMOOEBCKJJE@DAGOOOMGNLCFOKNOKGEJB@B@HAB@H@ABAGOOOOMOGEEEONJJKMA@EKKEFMG@CKMFKJNNNJHB@H@@@@A@H@JEFMMNOOMJJEOEEBEHD@COFOKKL@EGGMFOEJJJ@HHBDHDB@D@D@OOOOGOFMEEONMEDIBHDIKEEEEEGNJJKEJMEJDD@B@@B@@H@B@BJKGKOKMKFKKNJJBDDA@CJNJJMEMEEEDJEBEBA@I@IA@@@BA@A@GOMOMNKFMNMMEEEBIDDIOEOOKOGMEEEDHDHE@D@D@DABD@H@HDJJONOKNKFMKJJABDDIABNOJMGEMDJDIBDIBHDIB@I@H@A@@D@ACOMKJMEMMKGMBJDJJBJEKKGKJOGMDIBIBBDE@@@D@ABD@BA@DHEKGGGFOGGFJMDDJIEDIAMENOGJMJIDDFEDI@@JDABD@@D@DA@@EFMMJKMMJJKIBI@JJIBKKNKENMGFKBJHJIBEB@A@@@DI@H@@@BIJKFOOGFNJKJEBEEDJEENKMNKJMLLMEEJJJJIBDDHD@@B@HHA@BKMKFMMKEJEMBDJEEBJKKMFMMEKGKJJMFKEEBH@@AA@H@B@B@@JNJOOOFMEBJMDIBJJJJJNKKKKJGMEEFKKNJNMHHHD@DBDHB@HDAAFKMMMKEDIJEEDJJJJOENNNMMNOOOKNOEOJKDBB@D@H@@HHBABJ@JNKGEEEEFIBEDJJJJOEEJKKGFMEFKKOFOL@H@IAB@BD@B@@@@EEKNJJJJJNJJJKEJEOMONOMLMMBJIEDJIBBJ@H@@@B@@I@@DDJ@BGEMFJJJJJJJJJ@KEOFMJKEKJJIBIE@JJL@BBABDHDH@@H@@@HDJNKEJJJOEEEEDEEOJMECNMEDMBDJDEAF@I@@H@@@@BBDBA@@BAEEJMFJJKEFKDABEMOKGOKJMMBJJJJHDBJ@@H@HBBB@@@@@BA@H@EFKEKEKEEHABEOGFJNJMJOGEEEE@AAE@HHBDB@H@I@DHH@H@ABJMJMEECKDBDIEENMGMOJKEFJJJHBDDBJ@B@@@H@B@D@@BD@B@@@AEEJMNNJDIBJOJKEOJMNGNJJJJH@@K@D@DDHAB@BA@B@@B@HDBJBEGGEJIBBEKMGJMMGMJNJJJJDABABIA@@@B@@DHHA@@A@HBA@ADJEMOJBHJJJKMFJKOEKEMFJJID@HBH@DHI@DB@@@H@HH@A@@DHBBOKEDJEEFJJJMEGBKNIEEHHBBDBGAB@B@BA@AAB@D@@B@@H@BDHMFKMDJJLIEFJMGMEFJHJIADEAABD@I@B@HD@D@B@DA@BBBA@@BKJJJJJKBBBEJKGKOEFIGJBABDDFIB@DHHB@D@B@@@H@H@@H@IDMEGJEEJDHDKGFMJ@ODJEDDJHHHJ@@B@@B@H@I@IB@@D@DD@D@AJIBIJMBJBBJNMKEGFIAOMA@EBBMEB@AB@DBB@D@@BB@A@@I@AEEEEDB@D@HIGEKFJENJJFLJBHEED@@HH@I@H@B@IA@H@HA@@A@@JJBAEEEBABNKFMEJMMBKN@DBIEABDBBB@B@DHH@@@@H@@DDHDEMEED@@@HJEMEEEFKMGDKJJHHEED@A@@@B@B@@A@HH@BBDA@@ABKDHBIEBB@JNJJJKOFMJKO@ABJDADHDJHHDHBI@D@BD@@A@AA@BMEEDB@DHEEKEEEKEMGJJKBD@@ID@B@@BA@@@@D@B@A@HHD@@DDJJIBDDIBIENJJKGOKODKNHAEE@@E@DHHDABDJABHD@DB@@HDACJJJDHIBIBJMJJJMEBBOCGID@@JE@D@BA@D@@@H@@@D@@BHB@HEFJDIABEJJKOFMFJHEEEMMH@JE@@AADHDA@DB@BDBIABDHB@@BIMJIDJEEFJMFMEJIDKBEFGDD@HEBD@@ABDA@@JHA@@@@@@@IE@FKEEBDJJMFKOFKEDJFDJGMLABA@@@JBH@@HAD@@HABBBBBH@@DJMEIEEEEKEJKMNJJIDIBIEF@@DJIB@HBEBBDAABBD@HHH@BDIAEFMFJKFMFKGOFIEEBEDIEGHDEB@@@B@H@@@@DD@@@D@@@H@@@DKMJIKFMJKEEFMOJJJJIBBNNA@@JIDHDA@DH@A@JJI@EABBJDJJMKEGEJJJJOOJJAFJJJMEDKMHAD@@@A@HE@BJDB@@@B@DEMEMEBKFONNMMEJIEFIDMFJMBJJKGNDABJBDBA@A@@A@BDE@H@D@HABFNMKKKGEJJJJJJBKLKJNJJKOC@@@@H@HD@HD@DJHA@DBJ@JBJEEMKENMJKFJJEEDJNKMNMJJKFMMNJJABA@JB@J@@ADAA@@JADEEJKFOGFMFJJJMFJJMOGEFJJEOOMCM@D@DB@@D@EBD@H@BI@JEIFOMMKMMKKEFJJMKEOKMMEDHIMKGLHJ@I@IBJAA@@ABBJHBEEJOMKGFMOJMEGDKEKFKFMECJJBJOOOJCDH@B@@@H@BDH@H@ADJKGFOOMKGFOKKJONOGMNMJIDE@HABJJONDEDHBDJAD@@BJ@JJBJJMKJNONMKEGGGEEEMGEEBBADEBDJEDJLI@@@H@@DAEBH@B@@JDJJNOKMGOOOMMMOOOGJJIEDJA@@B@IBIE@BBJADI@D@@AA@IE@JEEEEGGMKKFOGGJJJJEJDH@@DAE@EDDE@E@H@D@@B@BDHDD@@EABJIEDJKEDMBJJEEDHH@JAEDID@E@@JHE@DAB@EE@H@@EAAEA@BH@BBIBDDEADIDIBAEBJ@J@@@@D@BD@A@EBD@J@@DBEE@DD@DBHAEDDDJJJHJBBADDJ@D@I@DIEBADHABHDHA@J@HJA@@@B@HI@HAD@AAA@@@B@I@DA@@DHJDB@D@@H@AD@B@ADB@BB@HDBHHJA@BDDAEDDDBJJIB@JABEEBA@@HJ@DJBED@JIED@IBHHBEB@BB@DBHA@D@AA@H@@@@D@H@@@@DBJB@I@@D@@I@@@@J@DBA@@@DI@IBHADEBDJDBDDIBDA@BDIBE@H@IB@BI@IBDBJEB@JHHDJJJ@@D@@BDA@@@@@HB@@@A@B@@@@@BAB@@E@@B@@@H@@@B@AA@@@@EDIEDIADEEEBJDHIDI@DHIBDJI@DAEE@DJHDJIBJJJIDJDIBDJ@@@@@@DA@@@@@@@@@@D@@@@@@@D@H@@B@@A@@@@@@@@@@@@@@@EEEEEEBJJJJJJJJJDIAAABDIBEBJEBDIEBDIBEEEEEEEEEEEEE@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\t";

    private static void genMap(int[] bmps, int widthData, int height, int widthPic, String path) {
        BufferedImage image = new BufferedImage(widthPic * 8, height, BufferedImage.TYPE_INT_RGB);
        for (int x = 0; x < widthPic * 8; x++) {
            for (int y = 0; y < height; y++) {
                int rgb = 0xffffffff;
                if (((bmps[(x / 8) + y * widthData] << (x % 8)) & 0x80) != 0)
                    rgb = 0;
                image.setRGB(x, y, rgb);
            }
        }

        try {
            File outputFile = new File(path);
            ImageIO.write(image, "bmp", outputFile);
            System.out.println("BMP图像生成成功！");
        } catch (IOException e) {
            System.out.println("生成BMP图像时发生错误：" + e.getMessage());
        }
    }

    private static int[] genMap_Remove(int[] bmps, int Pos) {
        int row;
        for (row = 8; row < 46; row++) {
            int col;
            for (col = Pos; col < 40; col++)
                bmps[row * 54 + col] = bmps[row * 54 + col + 13];
            for (; col < 53; col++)
                bmps[row * 54 + col] = 0;
        }
        return bmps;
    }

    private static void genMaps() {
        int[] bmps = new int[]{
                //00	//01	//02	//03	//04	//05	//06	//07	//08	//09	//10	//11	//12	//13	//14	//15	//16	//17	//18	//19	//20	//21	//22	//23	//24	//25	//26	//27	//28	//29	//30	//31	//32	//33	//34	//35	//36	//37	//38	//39	//40	//41	//42	//43	//44	//45	//46	//47	//48	//49	//50	//51	//52	//53
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00,
                0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
                0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,
                0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60,
                0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
                0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
                0x20, 0x00, 0x0a, 0xa1, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x18,
                0x70, 0x00, 0x37, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x18,
                0x20, 0x00, 0x3f, 0xda, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x18,
                0x60, 0x00, 0xfd, 0x7e, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x08,
                0x60, 0x01, 0xf0, 0x0f, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x7f, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3f, 0xff, 0xc1, 0xf8, 0x3c, 0x07, 0x81, 0xe7, 0x8c, 0x0f, 0xe7, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x18,
                0x20, 0x01, 0xc0, 0x03, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x7f, 0xff, 0xfe, 0x3f, 0x03, 0x9e, 0x78, 0x1f, 0x8f, 0x80, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0x80, 0xf0, 0x1c, 0x03, 0x80, 0xe7, 0xd8, 0x07, 0xe7, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x08,
                0x60, 0x03, 0x80, 0x03, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x7f, 0xff, 0xfe, 0x3e, 0x01, 0x8f, 0x38, 0x0f, 0x8f, 0x10, 0x7f, 0xff, 0xf8, 0x7f, 0xff, 0x3c, 0xe3, 0x8c, 0xf1, 0x9c, 0x67, 0x99, 0xe3, 0xc3, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x18,
                0x60, 0x07, 0x80, 0x00, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xfc, 0x1e, 0x39, 0x9e, 0x73, 0xc7, 0x0f, 0x9e, 0x7f, 0xff, 0xf8, 0x3f, 0xfe, 0x3e, 0x63, 0xcc, 0xf3, 0x9e, 0x67, 0x8c, 0xf3, 0x83, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0c,
                0x60, 0x03, 0x00, 0x01, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x7f, 0xff, 0xfc, 0x9e, 0x7f, 0x8e, 0x73, 0xff, 0x27, 0xbe, 0x7f, 0xff, 0xf8, 0x7f, 0xff, 0x3f, 0xe7, 0xcc, 0xf1, 0x9e, 0x67, 0xd9, 0xf3, 0x89, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x18,
                0x20, 0x07, 0x00, 0x00, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xfc, 0x9c, 0xff, 0x9f, 0x33, 0xff, 0x27, 0x1e, 0x7f, 0xff, 0xf8, 0x7f, 0xfe, 0x7d, 0xc7, 0xcc, 0xa3, 0x9e, 0x67, 0x9c, 0xa7, 0x99, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x08,
                0x60, 0x06, 0x00, 0x00, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x7f, 0xff, 0xf9, 0x8e, 0x7f, 0x8e, 0x63, 0xfe, 0x67, 0x80, 0xff, 0xff, 0xf8, 0x3f, 0xfe, 0x70, 0x67, 0xc4, 0x07, 0x9e, 0x27, 0x88, 0x0f, 0x99, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x18,
                0x60, 0x07, 0x00, 0x00, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xf9, 0xcc, 0xff, 0x9e, 0x73, 0xfe, 0x63, 0x00, 0xff, 0xff, 0xf8, 0x7f, 0xff, 0x38, 0x47, 0xcc, 0x0f, 0x9e, 0x67, 0xdc, 0x0f, 0x19, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x08,
                0x20, 0x07, 0x00, 0x00, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x7f, 0xff, 0xf8, 0x8c, 0x7f, 0x8f, 0x33, 0xfe, 0x23, 0x91, 0xff, 0xff, 0xf8, 0x7f, 0xfe, 0x7e, 0x67, 0xcc, 0xc7, 0x9e, 0x67, 0x99, 0xc7, 0x00, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x1c,
                0x60, 0x03, 0x00, 0x01, 0xe6, 0x18, 0x18, 0x3b, 0xc5, 0xc0, 0x1f, 0x86, 0x1c, 0x30, 0xff, 0xff, 0xf8, 0x0e, 0x79, 0x9e, 0x73, 0xc6, 0x03, 0x18, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0x3e, 0x67, 0xcc, 0xe3, 0x9e, 0x67, 0x98, 0xe7, 0x00, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xfe, 0x07, 0xc1, 0xf0, 0x3c, 0xe0, 0x7f, 0xff, 0xff, 0xfe, 0x08,
                0x60, 0x07, 0x00, 0x00, 0xc4, 0x1c, 0x18, 0x3e, 0xcf, 0xe0, 0x3e, 0xcf, 0x1c, 0x30, 0x7f, 0xff, 0xf1, 0xa6, 0x39, 0x8e, 0x73, 0xcc, 0xd1, 0x9c, 0x7f, 0xff, 0xf8, 0x7f, 0xff, 0x14, 0x63, 0x1c, 0xf3, 0x98, 0xe3, 0x1d, 0xe2, 0x7c, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xfe, 0x03, 0x80, 0xe0, 0x3c, 0xe0, 0x3f, 0xff, 0xff, 0xfe, 0x18,
                0x60, 0x03, 0x80, 0x01, 0xce, 0x1c, 0x18, 0x06, 0x1c, 0x30, 0x10, 0x0e, 0x2c, 0x30, 0xff, 0xff, 0xf3, 0xe7, 0x01, 0xc0, 0x78, 0x0c, 0xf9, 0xbe, 0x7f, 0xff, 0xf8, 0x7f, 0xff, 0x80, 0xf0, 0x1c, 0xf1, 0x80, 0xf0, 0x18, 0xf2, 0x7e, 0x7f, 0xfc, 0x3f, 0xff, 0xff, 0xfc, 0x73, 0x1c, 0x73, 0x8c, 0xc7, 0x1f, 0xff, 0xff, 0xfe, 0x08,
                0x20, 0x03, 0x80, 0x03, 0xcc, 0x36, 0x18, 0x06, 0x08, 0x38, 0x18, 0x07, 0x3c, 0x30, 0x7f, 0xff, 0xf3, 0xe3, 0x03, 0xc0, 0xf8, 0x18, 0xf9, 0x1e, 0x3f, 0xff, 0xf8, 0x3f, 0xff, 0xd3, 0xfc, 0x7e, 0xfb, 0xab, 0xf8, 0x7d, 0xf5, 0x7e, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xfc, 0x77, 0x3e, 0x67, 0xcc, 0xcf, 0x9f, 0xff, 0xff, 0xfe, 0x18,
                0x60, 0x01, 0xe0, 0x07, 0x8c, 0x36, 0x18, 0x06, 0x18, 0x10, 0x30, 0x0d, 0x34, 0x30, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xfb, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xfe, 0x3e, 0x3e, 0x67, 0x8c, 0x8f, 0x9f, 0xff, 0xff, 0xfe, 0x0c,
                0x60, 0x00, 0xe8, 0x17, 0x1c, 0x37, 0x18, 0x06, 0x18, 0x18, 0x1f, 0x8f, 0x2c, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xfe, 0x07, 0x3e, 0x73, 0xcc, 0xdf, 0x9f, 0xff, 0xff, 0xfe, 0x18,
                0x20, 0x00, 0x7f, 0xfe, 0x30, 0x66, 0x18, 0x06, 0x18, 0x30, 0x1f, 0xc5, 0xa8, 0x30, 0xff, 0xff, 0xff, 0xff, 0xa7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0x82, 0x3e, 0x27, 0xc8, 0x8f, 0x8f, 0xff, 0xff, 0xfe, 0x08,
                0x60, 0x00, 0x7f, 0xfc, 0x30, 0x63, 0x18, 0x06, 0x18, 0x18, 0x38, 0x0d, 0x6c, 0x30, 0x7f, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xe3, 0x3e, 0x73, 0x8c, 0x9f, 0x9f, 0xff, 0xff, 0xfe, 0x18,
                0x60, 0x00, 0x77, 0xf0, 0x60, 0x7f, 0x18, 0x0c, 0x18, 0x10, 0x10, 0x0d, 0xac, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xfe, 0xf2, 0x3e, 0x67, 0xcc, 0xcf, 0x9f, 0xff, 0xff, 0xfe, 0x08,
                0x60, 0x01, 0xf0, 0x01, 0xc0, 0x6b, 0x18, 0x06, 0x18, 0x30, 0x18, 0x05, 0xe8, 0x30, 0x7f, 0xff, 0xbf, 0xff, 0xdf, 0xff, 0x7f, 0xff, 0xff, 0xfb, 0xff, 0xef, 0xf8, 0x3f, 0xfc, 0x1f, 0x8f, 0x00, 0x9e, 0x60, 0x3f, 0x9f, 0x03, 0xfc, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xfc, 0x73, 0x1e, 0x67, 0x8c, 0xcf, 0x9f, 0xff, 0xff, 0xfe, 0x1c,
                0x20, 0x02, 0xc0, 0x0b, 0x80, 0xc1, 0x98, 0x06, 0x0c, 0xf0, 0x30, 0x0c, 0xcc, 0x30, 0xff, 0x1f, 0x03, 0xcf, 0x07, 0x1c, 0x0f, 0x3c, 0xf8, 0xf8, 0x1f, 0x83, 0xf8, 0x7f, 0xf8, 0x0f, 0x8e, 0x00, 0x9e, 0x60, 0x1f, 0x1f, 0x01, 0xf8, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xfc, 0x53, 0x14, 0xf3, 0x1c, 0xc2, 0x3f, 0xff, 0xff, 0xfe, 0x08,
                0x60, 0x07, 0xc6, 0xfe, 0x00, 0xc1, 0x9f, 0xc6, 0x0f, 0xe0, 0x1f, 0xcc, 0xcc, 0x30, 0x7f, 0x1f, 0x21, 0xce, 0x03, 0x98, 0x07, 0x1c, 0xf0, 0xf1, 0x0f, 0x00, 0xf8, 0x3f, 0xf9, 0xc7, 0x87, 0xcf, 0x9e, 0x67, 0x9f, 0x0f, 0x3c, 0xf8, 0x7f, 0xfc, 0x3f, 0xff, 0xff, 0xfe, 0x07, 0x80, 0xe0, 0x3c, 0xe0, 0x3f, 0xff, 0xff, 0xfe, 0x18,
                0x60, 0x07, 0xc7, 0xd0, 0x00, 0x80, 0x8a, 0x84, 0x02, 0x80, 0x15, 0x44, 0x44, 0x30, 0xfe, 0x1f, 0x38, 0xcc, 0xf3, 0x19, 0xe3, 0x1c, 0xf0, 0xf9, 0xc6, 0x3c, 0xf8, 0x7f, 0xf9, 0xef, 0x07, 0xcf, 0x9e, 0x67, 0xce, 0x0f, 0x3c, 0xf2, 0x7f, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0x97, 0xe5, 0xf5, 0x7d, 0xf9, 0x7f, 0xff, 0xff, 0xfe, 0x08,
                0x20, 0x0d, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x7e, 0x0f, 0x3c, 0xcc, 0xfb, 0x11, 0xf3, 0x0c, 0xe0, 0x71, 0xe6, 0x7c, 0x78, 0x7f, 0xf8, 0x7f, 0x27, 0xcf, 0x1e, 0x67, 0x8e, 0x4f, 0x1e, 0xf2, 0x7f, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x18,
                0x60, 0x0f, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xfe, 0x4f, 0x3c, 0xcc, 0xff, 0x13, 0xf3, 0x04, 0xf2, 0x79, 0xe6, 0x7e, 0x78, 0x3f, 0xfc, 0x1f, 0x23, 0xcf, 0x9e, 0x62, 0x1e, 0x67, 0x3c, 0x72, 0x7f, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0c,
                0x60, 0x1f, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x7c, 0xcf, 0x3c, 0x4c, 0xff, 0x93, 0xf3, 0x24, 0xe6, 0x71, 0xe6, 0x7c, 0x78, 0x7f, 0xfe, 0x06, 0x73, 0xcf, 0x9e, 0x60, 0x3c, 0x66, 0x3c, 0xf3, 0x3f, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x18,
                0x60, 0x1d, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xfc, 0xcf, 0x3c, 0xcc, 0xff, 0x33, 0xf3, 0x24, 0xe6, 0x71, 0xe4, 0x7e, 0x78, 0x3f, 0xff, 0x8e, 0x73, 0xcf, 0x1e, 0x60, 0x7c, 0xe7, 0x3e, 0x67, 0x3f, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x08,
                0x20, 0x3f, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x7c, 0x46, 0x3c, 0xcc, 0xff, 0x13, 0xf3, 0x20, 0xe2, 0x39, 0xe6, 0x7c, 0x78, 0x7f, 0xfb, 0xc6, 0x01, 0xcf, 0x9e, 0x67, 0x3c, 0x07, 0x3c, 0xe0, 0x3f, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x18,
                0x60, 0x76, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xf8, 0x07, 0x3c, 0xcc, 0xfb, 0x11, 0xf3, 0x30, 0xc0, 0x31, 0xe6, 0x7c, 0x78, 0x3f, 0xf9, 0xe6, 0x09, 0xcf, 0x9e, 0x67, 0x18, 0x03, 0x3c, 0xe0, 0x1f, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0c,
                0x60, 0x7e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x78, 0xc7, 0x38, 0xcc, 0xf1, 0x99, 0xe3, 0x38, 0xcd, 0x31, 0xc6, 0x3c, 0xf8, 0x3f, 0xf8, 0x84, 0x79, 0xcf, 0x8c, 0x67, 0x99, 0xf3, 0x18, 0xc7, 0x9f, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x18,
                0x20, 0xfc, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x79, 0xf3, 0x01, 0xce, 0x03, 0x18, 0x07, 0x38, 0xcf, 0x18, 0x0f, 0x01, 0xf0, 0x3f, 0xf8, 0x0c, 0xf8, 0xcf, 0xc0, 0xe7, 0x89, 0xf1, 0x01, 0xcf, 0x8f, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x08,
                0x60, 0xdc, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x31, 0xf3, 0x03, 0xce, 0x07, 0x1c, 0x0f, 0x38, 0x8f, 0x90, 0x1f, 0x81, 0xf0, 0x1f, 0xfe, 0x3d, 0xfd, 0xdf, 0xe1, 0xef, 0xd5, 0xfb, 0x2b, 0xdf, 0xdf, 0xf8, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x18,
                0x61, 0xf8, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x1f, 0xff, 0xff, 0xff, 0xdf, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xef, 0xe0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x08,
                0x30, 0xf1, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xbf, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x18,
                0x30, 0x53, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x18,
                0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
                0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
                0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60,
                0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0,
                0x07, 0x77, 0xbd, 0xef, 0x7b, 0xde, 0xf7, 0xbd, 0xef, 0x7b, 0xde, 0xf7, 0xbd, 0xef, 0x7b, 0xde, 0xf7, 0xbd, 0xef, 0x7b, 0xde, 0xf7, 0xbd, 0xef, 0x7b, 0xde, 0xf7, 0xbd, 0xef, 0x7b, 0xde, 0xf7, 0xbd, 0xef, 0x7b, 0xde, 0xf7, 0xbd, 0xef, 0x7b, 0xde, 0xf7, 0xbd, 0xef, 0x7b, 0xde, 0xf7, 0xbd, 0xef, 0x7b, 0xde, 0xf7, 0xbf, 0x80,
                0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        };

        for (int picno = 0; picno < 8; picno++) {
            int[] nbmps = bmps.clone();
            if ((picno & 0x04) == 0)
                nbmps = genMap_Remove(nbmps, 40);
            if ((picno & 0x02) == 0)
                nbmps = genMap_Remove(nbmps, 27);
            if ((picno & 0x01) == 0)
                nbmps = genMap_Remove(nbmps, 14);
            genMap(nbmps, 54, 54, 54, "H:\\Bitmap\\S" + Integer.toString(picno) + ".bmp");
        }
    }

    public static void main(String[] args) throws MeterException, ProfessionalException, InterruptedException {

        // 初始化全局参数
        initGlobalPara();

        // number_test();

        // 营养表参数
        // spData();

        // 手动折扣测试
        // method_Discount_Manual();

        // 初始化Socket通讯
        // initSocketCommunication();

        // 打开秤重串口
        // open_weight();
        // GlobalPara.getInstance().Init_SetTMS(212, 0, true);
        // GlobalPara.getInstance().Init_SetTMS(213, 2, true);
        // WeightCal.getInstance().Init_Cap(30000, 3, 0);
        // // WeightCal.getInstance().finishOfZeroStart=true;
        // WeightCal.getInstance().SetCode(1050, 0, true, true, false);
        // WeightResult wr1 = WeightCal.getInstance().GetResult();
        // WeightCal.getInstance().SetCode(100050, 0, true, true, false);
        // WeightResult wr2 = WeightCal.getInstance().GetResult();
        // WeightCal.getInstance().SetCode(150050, 0, true, true, false);
        // WeightResult wr3 = WeightCal.getInstance().GetResult();
        // WeightCal.getInstance().SetCode(320050, 0, true, true, false);
        // WeightResult wr4 = WeightCal.getInstance().GetResult();
        // 重量 称台秤重
        initWeightCal();
        // 重量 仿真秤重
        // weight_test();

        // 打印机初始化 1个打印机 与 2个打印机 区别
        // initPrintFactory_1();
        // initPrintFactory_2();

        // 打印机初始化工作参数
        // print_before();

        // 去皮置零等按键测试
        // button_test();

        // 吉卡云交易测试
        // for_JKP();

        // 位图升级
        // bitMap_upgrade1();
        // bitMap_upgrade2();

        // 直接打印测试
        // direct_print_test();

        // 行模式打印
        // print_line_test();
        // print_line_test_1();

        // 打印报表
        // print_log();
        // print_plu();
        // print_cp();

        // 开机打印
        // open_print();

        // 销售打印测试
        // sale_test();

        // 条码测试
        // barcodetest();

        // 日志上传测试
        // log_upload();

        // 交易商品信息
        // realContentNotify();

        // 设置TMS
        // setTMS();
    }

    private static void setTMS() {
        GlobalPara.getInstance().executor().execute(() -> {
            while (true) {
                String scanner1 = ScannerUtils.scanner("TMS 编号：");
                int no = Integer.parseInt(scanner1);
                String scanner2 = ScannerUtils.scanner("TMS 数值：");
                int value = Integer.parseInt(scanner2);
                boolean result = GlobalPara.getInstance().setTMS(no, value);
                System.out.printf("参数[%s] 设置：[%s] 结果：[%s]%n", no, value, result);
            }
        });
    }

    private static void realContentNotify() throws MeterException {
        SerialDisplay.getInstance().Init_Port(new WSerialPortControl(), new SerialDevice("COM4", 9600));

        TradePipeline pipeline = new TradePipeline();
        ItemContent itemContent = null;
        while (true) {
            String scanner = SystemtUtils.scanner("操作方式： 0-添加到购物车：1-苹果 2-矿泉水 ");
            if (StringUtils.isNotBlank(scanner)) {
                if ("0".equals(scanner) && itemContent != null) {
                    pipeline.Total_AddItem(itemContent);
                } else {
                    itemContent = pipeline.Item_New(getPLU(Integer.parseInt(scanner)));
                    if ("1".equals(scanner)) {
                        for (int i = 0; i < 100; i++) {
                            try {
                                itemContent = pipeline.Item_Set_Weight(itemContent);
                                Thread.sleep(100);
                            } catch (InterruptedException e) {
                            }
                        }
                    } else if ("2".equals(scanner)) {
                        itemContent = pipeline.Item_Set_Count(itemContent, BigDecimal.valueOf(3));
                    }
                }
            }
        }


    }

    private static void number_test() {
        GlobalPara.getInstance().Init_SetTMS(180, 1, false);
        GlobalPara.getInstance().Init_SetTMS(181, 1, false);
        GlobalPara.getInstance().Init_SetTMS(285, 1, false);
        String aa = GlobalPara.getInstance().GetStringTMS(new BigDecimal("120456.789"));
        System.out.println(aa);
        String BB = GlobalPara.getInstance().GetStringDigit(new BigDecimal("120456.789"));
        System.out.println(BB);
    }

    private static void spData() {
        String sd1 = "NU3\t1\tTestNU_A\tBBB\t50\tCC\tDD\t100,0\t1,1\t200,0\t2,1\t300,0\t3,1\t400,0\t4,1\t500,0\t5,1\t600,0\t6,1\t700,0\t7,1\t800,0\t8,1\t900,0\t9,1\t1000,0\t1,0\tEE\t1100,0\t11,1\tFF\t1200,0\t12,1\t\t0,0\t0,0\t\t0,0\t0,0\t\t0,0\t0,0\t\t18,0\t0,0\t\t0,0\t0,0\t\t0,0\t0,0\t\t0,0\t0,0\t\t0,0\t0,0\t";
        String sd2 = "SU2\t1\tTEST_F1\tFFFF1\t";
        String sd3 = "SU2\t2\tTEST_F2\tFFFF2\t";
        String sd4 = "IR2\t1\tTEST_A1\tAAAA1\t";
        String sd5 = "IR2\t2\tTEST_A2\tAAAA2\t";

        List<PublicExecute> executes = DDataUtils.Public_UnPackage(sd1);

        // SpData sd = SpDWL.getInstance().setSpData_FromTMS(sd1);
        // if (sd != null) {
        //     //以KeyValue的形式写入DB
        //     //WriteDB(sd.kid, sd.content);
        // }
        // SpData spData = SpDWL.getInstance().setSpData_FromTMS(sd2);
        // SpDWL.getInstance().setSpData_FromTMS(sd3);
        // SpDWL.getInstance().setSpData_FromTMS(sd4);
        // SpDWL.getInstance().setSpData_FromTMS(sd5);

        //以KeyValue的形式从DB读取后写入SpDWL
        //WriteDB(sd.kid, sd.content);
        // SpDWL.getInstance().setSpData_FromDB("NU3\t2", "TestNU_B\tBBB\t50\tCC\tDD\t100,0\t1,1\t200,0\t2,1\t300,0\t3,1\t400,0\t4,1\t500,0\t5,1\t600,0\t6,1\t700,0\t7,1\t800,0\t8,1\t900,0\t9,1\t1000,0\t1,0\tEE\t1100,0\t11,1\tFF\t1200,0\t12,1\t\t0,0\t0,0\t\t0,0\t0,0\t\t0,0\t0,0\t\t18,0\t0,0\t\t0,0\t0,0\t\t0,0\t0,0\t\t0,0\t0,0\t\t0,0\t0,0\t");

        // String tmsNU3 = SpDWL.getInstance().getTMS("NU3");
        //来自KeyValue的数据，不再执行DB写入

        PublicExecute execute1 = DDataUtils.Public_UnPackage_Line(sd1);
        System.out.println(execute1.toJSON());
        PublicExecute execute2 = DDataUtils.Public_UnPackage_Line(sd2);
        System.out.println(execute2.toJSON());
        PublicExecute execute3 = DDataUtils.Public_UnPackage_Line(sd3);
        System.out.println(execute3.toJSON());
        PublicExecute execute4 = DDataUtils.Public_UnPackage_Line(sd4);
        System.out.println(execute4.toJSON());
        PublicExecute execute5 = DDataUtils.Public_UnPackage_Line(sd5);
        System.out.println(execute5.toJSON());

        GlobalPara.getInstance().Set_SDS((DSpDWL) ((PublicExecuteModify) execute1).getModels().get(0));
        GlobalPara.getInstance().Set_SDS((DSpDWL) ((PublicExecuteModify) execute2).getModels().get(0));
        GlobalPara.getInstance().Set_SDS((DSpDWL) ((PublicExecuteModify) execute3).getModels().get(0));
        GlobalPara.getInstance().Set_SDS((DSpDWL) ((PublicExecuteModify) execute4).getModels().get(0));
        GlobalPara.getInstance().Set_SDS((DSpDWL) ((PublicExecuteModify) execute5).getModels().get(0));


        PublicExecuteModify modify = new PublicExecuteModify();
        modify.setType(execute1.getType());
        modify.add(((PublicExecuteModify) execute1).getModels());
        String sd1_str = DDataUtils.Public_Package(modify);
        System.out.println(sd1_str);

    }

    /**
     * @description: 手动折扣测试
     **/
    private static void method_Discount_Manual() {
        TradeContent tradeContent = new TradeContent();
        List list = new ArrayList();
        list.add(new ItemContent());
        tradeContent.setItem(list);
        boolean b = tradeContent.Total_Check_Discount();
        System.out.println(b);
    }

    private static void barcodetest_Warn(BarCodeItemResult result) {
        if (result == null) {
            System.out.println("条码无匹配");
        } else if (!result.isOK()) {
            System.out.println("条码有错误");
        } else {
            System.out.println(JSONObject.toJSONString(result));
        }
    }

    private static void barcodetest() throws MeterException {
        TradePipeline pipeline = new TradePipeline(TradeType.销售);
        BarCodeItemResult result;
        result = BarCodeItemSearch.Calulate("2002022018870");
        barcodetest_Warn(result);
        result = BarCodeItemSearch.Calulate("2012345005550");
        barcodetest_Warn(result);
        result = BarCodeItemSearch.Calulate("2012345005551");
        barcodetest_Warn(result);

        if (result == null) {
            //本条码非内部条码，不做任何处理
        } else if (!result.isOK()) {
            //本条码是内部条码，但有错误，建议有报警提示
        } else {
            //根据编号或货号查找商品
            Integer number = result.getNumber();
            Integer itemCode = result.getItemcode();
            DPLUV5 plu = null;
            if (number != null) {
                //通过编号找到plu
                plu = getPLU(number);
            } else if (itemCode != null) {
                int Scanner_0Note_Deal = GlobalPara.getInstance().getTMS(TMS.Scanner_0Note_Deal);
                if ((itemCode == 0) && (Scanner_0Note_Deal == 1)) {
                    //以临时计重商品计入
                    plu = getPLU(9999999);
                } else if ((itemCode == 0) && (Scanner_0Note_Deal == 2)) {
                    //以临时计件商品计入
                    plu = getPLU(9999998);
                } else {
                    //根据货号查找商品
                    //plu=getFromItemCode(itemCode);
                }
            }
            //仅测试，假装找到的商品是商品1
            plu = getPLU(2);

            if (plu == null) {
                //如果商品不存在，建议有报警提示
            } else {
                ItemContent itemContent = pipeline.Item_New(plu);
                itemContent = pipeline.Current_TradeContent().Item_Set_Note(itemContent, result);
                System.out.println(JSONObject.toJSONString(itemContent));
            }
        }
    }

    /**
     * @description: 开机打印
     **/
    private static void open_print() {
        Map<String, String> configs = new HashMap<>();
        configs.put(ServerDeviceConfig.云支付.getType(), SwitchState.启用.getEnable());
        List<DPayment> payments = new ArrayList<>();
        payments.add(new DPayment()
                .setChannel(PayWay.ALI_PAY.getType().toString())
                .setBizType(PayBizType.主扫.getType())
                .setCstNo("2008109378975894"));
        payments.add(new DPayment()
                .setChannel(PayWay.WECHAT_PAY.getType().toString())
                .setBizType(PayBizType.主扫.getType())
                .setCstNo("123345905"));
        GlobalPara.getInstance().setServerInfo(
                new DServerInfo()
                        .setCloud(true)
                        .setStore(new DInfo("小李糖铺", "NO.01"))
                        .setLevel(new DInfo("7", "7"))
                        .setMarket(new DInfo("仙飘市场", "A-001"))
                        .setErp(new DInfo("华东小仓", "1"))
                        .setDevice(new DInfo("小刘专用", "AAA000", "PB2 TA128 V3.0.0"))
                        .setPayments(payments)
                        .setConfig(new DServerConfig(configs))
        );
        GlobalPara.getInstance().setSaleMan(new DSaleManV1<>().setNo(1).setName("小天"));
        PrintGeneralFactory.getInstance().Open_Print();
    }

    private static void log_upload() throws ProfessionalException, MeterException {
        TradeContent tradeContent = getTradeContent();
        tradeContent.Total_Log();
        System.out.println(tradeContent.getLogContent().toJSON());
        ServerUnPackageObject serverUnPackageObject = new DLOGV1<>().Server_UnPackage(tradeContent.getLogContent().getLog());
        System.out.println(JSONUtils.objectToJSON(serverUnPackageObject.getObj()));
        // 上传日志
        MeterEquipmentTest.updateLogData(tradeContent.getLogContent());
    }

    /**
     * @description: 位图升级
     **/
    private static void bitMap_upgrade1() throws MeterException {
        Print0200Request print0200Request = new Print0200Request();
        print0200Request.setSdk(true);
        print0200Request.setUpgrade(true);
        print0200Request.setPrintBack(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应原始信息
             */
            @Override
            public void responseBack(PrintResponse response) {
                try {
                    // 关闭打印保护结果
                    if (((Print0200Response) response).isResult()) {
                        //do something

                        DBitMap bitMap = new DBitMapV1<>().Public_UnPackage(bmp1_2);
                        PrintBitMapRequest request = new PrintBitMapRequest(bitMap.no().toString(), bitMap.bitMapHex());
                        request.setUpgrade(true);
                        // todo 支持4种构造 new PrintBitMapRequest
                        // todo 1 文件直接构造，
                        // todo 2 文件名+文件流
                        // todo 3 文件名+hex数据内容
                        // todo 4. 文件名 + FileBitMap[支持原始图片压缩转hexData]参考 com/jhscale/test/serial/JSerialPrintTest.java:452
                        request.setPrintBack(new IPrintBack() {
                            /**
                             * @param response
                             * @description: 操作结果响应原始信息
                             */
                            @Override
                            public void responseBack(PrintResponse response) {
                                System.out.println(response.toJSON());
                            }
                        });
                        PrintGeneralFactory.getInstance().getNode_A(true).send(request);

                    } else {
                        // todo 通知关闭打印保护失败
                        throw new MeterException(MeterStateEnum.打印升级保护失败);
                    }
                } catch (MeterException e) {
                    e.printStackTrace();
                }
            }
        });
        PrintGeneralFactory.getInstance().getNode_A(true).send(print0200Request);
    }

    /**
     * @description: 位图升级
     **/
    private static void bitMap_upgrade2() throws MeterException {
        DBitMap bitMap = new DBitMapV1<>().Public_UnPackage(bmp1_1);
        PrintBitMapRequest request = new PrintBitMapRequest(bitMap.no().toString(), bitMap.bitMapHex());
        // todo 支持4种构造 new PrintBitMapRequest
        // todo 1 文件直接构造，
        // todo 2 文件名+文件流
        // todo 3 文件名+hex数据内容
        // todo 4. 文件名 + FileBitMap[支持原始图片压缩转hexData]参考 com/jhscale/test/serial/JSerialPrintTest.java:452
        request.setPrintBack(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应原始信息
             */
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(response.toJSON());
            }
        });
        PrintGeneralFactory.getInstance().getCommunication().bitMapUpgrade(request);

    }

    /**
     * @description: 内容直接打印测试
     **/
    private static void direct_print_test() throws MeterException {
        String content = "033016002000010000000080011A0001000412002000010000000080011A00E4B88AE6B5B7E7B2BEE587BDE4BFA1E681AFE7A791E68A80E69C89E99990E585ACE58FB8000412002004010000000054001A004430001200200401540000001E001A005631001200200501030100007D001A0023303030303031000412002004010000000072001A00E99480E594AEE697B6E997B43A001200200001730000008C001A00323032332E30332E32320012002006010E01000070001A0032313A31353A30300004120020000000000000800110002D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D000412002004010000000068001A00E59586E593810012002004010E001A004C001A00E58D95E4BBB700120020050163001A00AC001A00E9878DE9878F2FE695B0E9878F00120020050118011A0068001A00E98791E9A29D000412002000000000000080010F002D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D0004120020040100000000B4001A00E79FBFE6B389E6B0B400120020050100001A0060001A00352E3030001200200401C0001A0060001A003100120020060120011A0060001A00352E30300004120020000000000000800112002D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D0004120020050204000000C8002200E5AE9EE694B6E98791E9A29D3A001200200502DD000000A0002200352E3030000412002004018F00000076001A00E694B6E993B6E98791E9A29D3A0012002005010501000078001A003130300012002004018F001A0076001A00E689BEE99BB6E98791E9A29D3A00120020050105011A0078001A0039352E3030000412002000010000000080011A00E8B0A2E8B0A2E683A0E9A1BE2CE6ACA2E8BF8EE5868DE6ACA1E58589E4B8B42100040606";
        PrintDataRequest request = new PrintDataRequest<>();
        request.setData(content);
        request.setPrintBack(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应原始信息
             */
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(response.toJSON());
            }
        });
        PrintGeneralFactory.getInstance().execute(request);
        // PrintGeneralFactory.getInstance().getNode_A(true).sendData(request);
        // PrintGeneralFactory.getInstance().getNode_A(true).sendDataWithAllPackage(request);
    }

    /**
     * @description: 打印报表
     **/
    private static void print_log() throws MeterException {
        String json = "{\"aliCount\":0,\"aliPay\":0.0,\"cardCount\":0,\"cardPay\":0.0,\"cash\":98.02,\"cashCount\":4,\"clear\":18,\"jkyCount\":0,\"jkyPay\":0.0,\"mistake\":9,\"otherCount1\":0,\"otherCount2\":0,\"otherCount3\":0,\"otherPay1\":0.0,\"otherPay2\":0.0,\"otherPay3\":0.0,\"returnAmount\":0.0,\"returnCount\":0,\"saleAmount\":98.02,\"saleCount\":46,\"specialCount2\":0,\"specialCount3\":0,\"specialCount4\":0,\"specialCount5\":0,\"specialCount6\":0,\"specialCount7\":0,\"specialPay2\":0.0,\"specialPay3\":0.0,\"specialPay4\":0.0,\"specialPay5\":0.0,\"specialPay6\":0.0,\"specialPay7\":0.0,\"time\":\"20220826\",\"totalAmount\":98.02,\"totalCount\":46,\"unconfirmed\":395.1,\"unconfirmedCount\":122,\"wechatCount\":0,\"wechat\":0.0}";
        LOGServerReport serverReport = JSONUtils.jsonToObject(json, LOGServerReport.class);
        LOGReport report = serverReport.toReport();
        report.setStoreName("小二店");
        report.setDeviceName("POS收银秤");
        report.setDate("2022-08-25");
        report.setMoney(2);
        System.out.println(report.toJSON());

        PrintGeneralFactory.getInstance().getCommunication().printReport(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应原始信息
             */
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(response.toJSON());
            }
        }, report);
    }

    private static File PLU_D_REPORT = new File("E:\\JHScale\\Resources", "plu.json");

    private static void print_plu() throws MeterException {
        List<PLUItem> items = FileUtils.readerList(PLU_D_REPORT, PLUItem.class);
        PLUReport report = new PLUReport(items);
        report.setStoreName("小二店");
        report.setDeviceName("POS收银秤");
        report.setDate("2022-08-25");
        report.setMoney(2);
        PrintGeneralFactory.getInstance().getCommunication().printReport(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应原始信息
             */
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(response.toJSON());
            }
        }, report);
    }

    private static void print_cp() throws MeterException {
        CPServerReport serverReport = FileUtils.reader(new File(CP_D_REPORT), CPServerReport.class);
        CPReport report = serverReport.toReport();
        report.setStoreName("小二店");
        report.setDeviceName("POS收银秤");
        report.setDate("2022-08-25");
        report.setMoney(2);
        PrintGeneralFactory.getInstance().getCommunication().printReport(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应原始信息
             */
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(response.toJSON());
            }
        }, report);
    }

    /**
     * @description: 行模式打印
     **/
    private static void print_line_test_1() throws MeterException {
        List<PrintLineLMR> lineLMRS = new ArrayList<>();
        for (int i = 0; i < 10; i++) {
            PrintLineLMR lineLMR = new PrintLineLMR();
            lineLMR.setLeft("左" + i);
//            lineLMR.setMid("中" + i);
            lineLMR.setRight("右" + i);
            lineLMRS.add(lineLMR);
        }
        PrintGeneralFactory.getInstance().Print_Line(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应原始信息
             */
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(response.toJSON());
            }
        }, lineLMRS.toArray(new PrintLine[lineLMRS.size()]));
    }

    /**
     * @description: 行模式打印
     **/
    private static void print_line_test() throws MeterException {
        PrintDataRequest request = new PrintDataRequest<>()
                .Input_Bitmap(1)
                .Input_String("aa", null, "bb")
                .Input_String(null, null, "cc")
                .Input_String()
                .Input_String("1234567890123456789012345678901234567890123456789012345678901234567890", true)
                .Input_QR("http://www.jhscale.com");
        request.setPrintBack(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应原始信息
             */
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(response.toJSON());
            }
        });
        PrintGeneralFactory.getInstance().getNode_A(true).send(request);
    }

    /**
     * @description: 销售打印测试
     **/
    private static void sale_test(TradeContent... tradeContents) throws MeterException {
        TradeContent tradeContent = null;

        if (tradeContents == null || tradeContents.length == 0 || tradeContents[0] == null) {
            tradeContent = getTradeContent();
        } else {
            tradeContent = tradeContents[0];
        }

        PrintGeneralFactory.getInstance().print_answer(tradeContent.getPrintContents(), new IPrintBack() {
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(response.toJSON());
            }

            @Override
            public void responseBack(PrintBackResponse response) {
                System.out.println(response.toJSON());
            }

            @Override
            public void schedule(ScheduleState scheduleState) {
                System.out.println(scheduleState.toString());
            }
        });
    }

    private static int FID = RandomUtils.integer_random(255);

    /**
     * @description: 简易交易结算数据
     **/
    public static TradeContent getTradeContent() throws MeterException {
        TradePipeline pipeline = new TradePipeline();
        ItemContent itemContent = pipeline.Item_New(getPLU(2));
        pipeline.Item_Set_Count(itemContent);
        pipeline.Total_AddItem(itemContent);

        // TradeContent tradeContent = pipeline.Current_TradeContent();
        // tradeContent.putPosOnlyString(0, "张三 180823505**");
        // tradeContent.putPosOnlyString(1, "上海闵行区春光路");

        int fid = FID + 1;
        FID = fid;

        return pipeline.Settlement_All(fid, 0,
                new CashSettlement()
                        .setCash(new BigDecimal("100"))
        );
    }

    private static TradeContent scale_to_reject(int type, TradePipeline pipeline) throws MeterException {
        TradeContent tradeContent;
        if (type == 2) {
            tradeContent = pipeline.Settlement_All(456, 10,
                    new CashSettlement()
                            .setCash(BigDecimal.ZERO));

            tradeContent = pipeline.Item_Reject(tradeContent, null).getRejectTrade();

            tradeContent.Total_Close(123, 0)       //未确认和清除的SID永远=0
                    .printCalculate()
                    .Total_Log();
        } else {//if(type==1)
            // 结算
            tradeContent = pipeline.Settlement_All(456, 10,
                    new CashSettlement()
                            .setCash(BigDecimal.ZERO));
        }
        return tradeContent;
    }

    private static void for_JKP() throws MeterException {
        //0 for JKY test
        //1 for unconfirmed test
        //2 for reject test(选择列表退货)
        //3 for refund(反向销售)
        //4 自动交易累计测试
        int type = 0;

        TradePipeline pipeline = new TradePipeline(TradeType.销售)
                .Total_VIP_Set('A', 9500);

        ItemContent itemContent = pipeline.Item_New(getPLU(1));

        if (type == 4) {
            while (true) {
                // 内码读取获取重量信息
                WeightResult wr = WeightCal.getInstance().GetResult();

                pipeline.Item_Set_Weight(itemContent, wr);

                if (wr.isAutoAllowed() && itemContent.getSingleWtax().compareTo(BigDecimal.ZERO) != 0) {
                    pipeline.Total_AddItem(itemContent);
                    itemContent = pipeline.Item_New(getPLU(1));
                    System.out.println("触发累计...");
                }
            }
        } else if (type == 1) {
            while (true) {
                // 内码读取获取重量信息
                WeightResult wr = WeightCal.getInstance().GetResult();

                pipeline.Item_Set_Weight(itemContent, wr);

                TradeContent tcUnconfirmed = pipeline.Item_Unconfirmed(itemContent, wr, false).getUnconfirmed();
                if (tcUnconfirmed != null) {
                    tcUnconfirmed.Total_Close(123, 0)       //未确认和清除的SID永远=0
                            .printCalculate()
                            .Total_Log();
                    //记录tcUnconfirmed
                    //....
                    //仅打印测试
                    PrintGeneralFactory.getInstance().print_answer(tcUnconfirmed.getPrintContents(), new IPrintBack() {
                        @Override
                        public void responseBack(PrintResponse response) {
                            System.out.println(response.toJSON());
                        }

                        @Override
                        public void responseBack(PrintBackResponse response) {
                            System.out.println(response.toJSON());
                        }

                        @Override
                        public void schedule(ScheduleState scheduleState) {
                            System.out.println(scheduleState.toString());
                        }
                    });

                    if (GlobalPara.getInstance().getTMS(TMS.SP_Unconfirmed) == 3) {
                        //需要退出界面
                        break;
                    }
                }

                if (itemContent.getAmount().compareTo(new BigDecimal(10)) >= 0)            //累计按钮
                {
                    try {
                        // 添加交易列表
                        pipeline.Total_AddItem(itemContent);
                        break;
                    } catch (Exception exp) {
                        //some error
                    }
                }

                if (false)            //取消按钮
                {
                    tcUnconfirmed = pipeline.Item_Unconfirmed(itemContent, null, true).getUnconfirmed();
                    if (tcUnconfirmed != null) {
                        //记录tcUnconfirmed
                    }
                    //pipeline.Total_Unconfirmed(1,1,itemContent);
                    break;
                }
            }
        } else {
            WeightResult wr = WeightCal.getInstance().SetCode(12505, 10005, true, true, false).GetResult();
            wr.setValidType(0);
            // 内码读取获取重量信息
            pipeline.Item_Set_Weight(itemContent, wr);
        }

//        TradeBuffer.GetInstance().Item_Set_Weight(wr);
        // 修改单价
//        pipeline.Item_Set_Price(itemContent, new BigDecimal(10));
//        TradeBuffer.GetInstance().Item_Set_Price(new BigDecimal(10));
        // 添加交易列表
        pipeline.Total_AddItem(itemContent);
//        TradeBuffer.GetInstance().Total_AddItem();


        if (type != 1) {
            // 添加第二个商品
            ItemContent itemContent2 = pipeline.Item_New(getPLU(2));
//        TradeBuffer.GetInstance().Item_New(getPLU(2));
            // 数量
            pipeline.Item_Set_Amount_Stock(itemContent2, new BigDecimal(5));
//        TradeBuffer.GetInstance().Item_Set_Count(new BigDecimal(5));
            // 添加交易列表
            pipeline.Total_AddItem(itemContent2);
//        TradeBuffer.GetInstance().Total_AddItem();
        }

        // System.out.println(TradeBuffer.GetInstance().Current_TradeContent().toJSON());

        // 清除明细操作
        // TradeContent removeTradeContent = TradeBuffer.GetInstance().Total_RemoveItem(2, 2, 0);
        // System.out.println("移除： " + removeTradeContent.toJSON());
        // System.out.println(TradeBuffer.GetInstance().Current().toJSON());

        TradeContent tradeContent;
        // 结算前登陆会员
        pipeline.Total_VIP_Set('A', 9500);

        //这里的2个数值是假设卡里所有的余额
        BigDecimal jkyBalance_all = new BigDecimal("1000.00");
        BigDecimal jkyBalance_gift = new BigDecimal("5.00");
        //判断余额足够支付
        if (pipeline.Current_TradeContent_WOE().Total_Cal_LeftPay(jkyBalance_all).compareTo(BigDecimal.ZERO) <= 0) {

            //do JKY pay
            BigDecimal jky_all = pipeline.Current_TradeContent_WOE().Total_Cal_LeftPay();
            //这里的几个数值只是模拟计算，实际以收到的云通讯数据为准
            BigDecimal jky_gift = jkyBalance_gift.multiply(jky_all).divide(jkyBalance_all, GlobalPara.getInstance().getPointOfPrice(), BigDecimal.ROUND_HALF_UP);
            BigDecimal jky = jky_all.subtract(jky_gift);
            BigDecimal jkyBalance_old = jkyBalance_all;
            BigDecimal jkyBalance_new = jkyBalance_old.subtract(jky_all);
            BigDecimal jkyPoint = jky_all.subtract(jky_gift);

            tradeContent = pipeline.Settlement_All(456, 10,
                    new JKYSettlement()
                            // .setJkyPay(jky)
                            // .setJkyPay_Gift(jky_gift)
                            .setBalanceNew(jkyBalance_new)
                            .setBalanceOld(jkyBalance_old)
                            .setAccount("123")
                            .setPoint(jkyPoint)
                            .setCash(new BigDecimal("600.00"))
            );

            sale_test(new TradeContent[]{tradeContent});

            // pipeline.Total_Set_Discount(new BigDecimal(20));
        } else {
            // 结算
            tradeContent = pipeline.Settlement_All(456, 10,
                    new CashSettlement()
                            .setCash(new BigDecimal(3000)));
        }
    }

    /**
     * @description: 初始化打印工厂
     * a 普通打印机
     * b 标签打印机
     **/
    public static void initPrintFactory_1() throws MeterException {
        PrintGeneralFactory.getInstance().Init_Print_Factory(new DefaultPrintSerialMessenger("COM5", 115200), null);
        // List<PrintBackResponse> execute = PrintGeneralFactory.getInstance().execute(new Print0000Request(), NODE_A_P, NODE_B_P);
        List<PrintBackResponse> execute = PrintGeneralFactory.getInstance().execute(new Print0000Request(), NODE_A_P);
        System.out.println(JSONUtils.objectToJSON(execute));
    }

    private static void initPrintFactory_2() throws MeterException {
        PrintGeneralFactory.getInstance()
                .Init_Print_Factory(
                        new DefaultPrintSerialMessenger("COM3", 115200),
                        new DefaultPrintSerialMessenger("COM5", 115200)
                );
    }

    /**
     * @description: 打印初始化前置  修改打印数据参数内容 进入 UpdateTms 后调用print_before 检查是否存在需要发送的参数，并发送设置参数
     **/
    private static void print_before() {
        //需要的工作：
        //标签打印机参数0灰度=
        GlobalPara.getInstance().getTMS(TMS.Print_Gray_GapPaper);
        //小票打印机参数0灰度=
        GlobalPara.getInstance().getTMS(TMS.Print_Gray_GenericPaper);
        //所有打印机参数1错误排除=ignore
        int ignore = 0;
        if ((GlobalPara.getInstance().getTMS(TMS.HW_Print_IgnorePBS) & 0x01) != 0)
            ignore |= 0x01;
        if ((GlobalPara.getInstance().getTMS(TMS.HW_Print_Ignore_P2) & 0x01) != 0)
            ignore |= 0x02;
        if (GlobalPara.getInstance().getTMS(TMS.HW_ConPaper_vPPS) > 0)
            ignore |= 0x04;
        //初始化打印机的时候执行，且每次参数表更新后执行。
        //或者每次打印都执行

        PrintGeneralFactory.getInstance().print_before();
    }

    /**
     * @description: 按键测试
     **/
    private static void button_test() throws InterruptedException {
        int action = 0;
        int count = 0;
        while (true) {
            Thread.sleep(1000);

            count++;
            if (action == 1)           //等同点击去皮键
            {
                action = 0;
                WeightCal.getInstance().SetTare_Button();
            }
            if (action == 2)           //等同点击置零键
            {
                action = 0;
                WeightCal.getInstance().SetZero_Button();
            }
            if (action == 3)           //等同点击强制置零键
            {
                action = 0;
                WeightCal.getInstance().SetZero_Force();
            }

            if (count == 100) {

            }
        }
    }

    public static int limit = 200;

    /**
     * @description: 接受数据处理
     **/
    public static JHTCPAnswer Accept_Event_By_Socket(PublicExecute acceptExecute, JHTCPAccept accept) {
        try {
            if (acceptExecute instanceof PublicExecuteRecovery) {
                if (DConstant.PLU.equals(acceptExecute.getType())) {
                    long t1 = System.currentTimeMillis();
                    for (int i = 0; i < (10000 / limit); i++) {
                        long t2 = System.currentTimeMillis();
                        System.out.printf("[%s] 分页开始%n", i);
                        PublicExecuteModify executeModify = new PublicExecuteModify(DConstant.PLU);
                        for (int j = 0; j < limit; j++) {
                            FDPLU fdplu = FDPLU();
                            ((DPLUV5) fdplu).setNo(i * limit + j);
                            ((DPLUV5) fdplu).setName(((DPLUV5) fdplu).getName() + (i * limit + j));
                            executeModify.add(fdplu);
                        }

                        long t3 = System.currentTimeMillis();
                        System.out.printf("[%s] 打包开始%n", i);
                        if (i == 0) {
                            accept.callBack().addAnswer(executeModify)
                                    .onceResultExecute(0);
                        } else if (i == 49) {
                            accept.callBack().addAnswer(executeModify)
                                    .onceResultExecute(2);
                        } else {
                            accept.callBack().addAnswer(executeModify)
                                    .onceResultExecute(1);
                        }
                        long t4 = System.currentTimeMillis();
                        System.out.printf("[%s] 打包发送结束%n", i);
                        long t5 = System.currentTimeMillis();
                        System.out.printf("[%s] 分页结束%n", i);
                        System.out.printf("第[%s]页 耗时：[%s] 分页：[%s] 打包发送：[%s] 发送：[%s] 分页结束%n", i, (t5 - t2), (t3 - t2), (t4 - t3), (t5 - t4));
                    }
                    long t6 = System.currentTimeMillis();
                    System.out.printf("Limit: [%s] 总耗时：[%s] 结束%n", limit, (t6 - t1));
                    return null;
                } else if (DConstant.REP.equals(acceptExecute.getType())) {
                    // TradeContent tradeContent = getTradeContent();
                    // ServerUnPackageObject serverUnPackageObject = new DLOGV1<>().Server_UnPackage(tradeContent.getLogContent().getLog());
                    // DLOGV1 dlogv1 = (DLOGV1) serverUnPackageObject.getObj();

                    // PublicExecuteModify executeModify = new PublicExecuteModify(DConstant.REP);
                    // executeModify.add(dlogv1);
                    // boolean result = accept.callBack().addAnswer(executeModify).onceResultExecute(3);
                    // System.out.printf("REP 写出结果：%s %n", result);
                    return null;
                } else {
                    return accept.callBack();
                }
            } else if (acceptExecute instanceof PublicExecuteModify) {
                // System.out.printf("PublicExecuteModify acceptEvent : %s%n", acceptExecute.toJSON());
                if (DConstant.PLU.equals(acceptExecute.getType())) {
                    System.out.println(acceptExecute.toJSON());
                }

                if (DConstant.BMP.equals(acceptExecute.getType())) {
                    List<DBitMap> bitMaps = Optional.of(((PublicExecuteModify) acceptExecute).getModels())
                            .orElse(Collections.emptyList())
                            .stream().map(model -> (DBitMap) model).collect(Collectors.toList());

                    PrintGeneralFactory.getInstance().bitMapUpgrade(true, bitMaps, new IPrintBack() {
                        /**
                         * @param response
                         * @description: 操作结果响应原始信息
                         */
                        @Override
                        public void responseBack(PrintBackResponse response) {
                            System.out.printf("位图升级内容： %s", response.toJSON());
                        }
                    });
                } else if (DConstant.FNT.equals(acceptExecute.getType())) {
                    DFont font = Optional.of(((PublicExecuteModify) acceptExecute).getModels())
                            .orElse(Collections.emptyList())
                            .stream().map(model -> (DFont) model).collect(Collectors.toList())
                            .stream().findFirst().get();

                    PrintGeneralFactory.getInstance().fontUpgrade(font, new IPrintBack() {
                        /**
                         * @param response
                         * @description: 操作结果响应原始信息
                         */
                        @Override
                        public void responseBack(PrintBackResponse response) {
                            System.out.printf("字库升级内容： %s", response.toJSON());
                        }
                    });
                }
                return null;
            } else {
                // System.out.printf("acceptEvent : %s%n", acceptExecute.toJSON());
                // System.out.println(String.format("acceptEvent : %s", acceptExecute.getClass().getSimpleName()));
                return null;
            }
        } catch (MeterException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * @description: 初始化Socket 通讯
     **/
    public static void initSocketCommunication() {
        // Socket通讯初始化
        SocketCommunication communication = SocketCommunication.getInstance()
                .Init_Notify(new SocketNotify() {
                    /**
                     * @param e
                     * @description: 异常信息回调
                     */
                    @Override
                    public void onClientEventExp(MeterException e) {
                        e.printStackTrace();
                    }

                    /**
                     * @param executes
                     * @param jhtcpCall
                     * @description: 接受数据处理
                     */
                    @Override
                    public JHTCPCallBack acceptEvent(List<PublicExecute> executes, JHTCPCall jhtcpCall) {
                        System.out.println(JSONUtils.objectToJSON(executes));
                        return null;
                    }

                    /**
                     * @param acceptExecute
                     * @param accept
                     * @description: 接受数据处理
                     */
                    @Override
                    public JHTCPAnswer acceptEvent(PublicExecute acceptExecute, JHTCPAccept accept) {
                        return Accept_Event_By_Socket(acceptExecute, accept);
                    }

                    /**
                     * @param execute
                     * @description: 接受数据处理
                     */
                    @Override
                    public void acceptEvent(PublicExecute execute) {
                        System.out.printf("acceptEvent : %s%n", execute.toJSON());
                    }

                    /**
                     * @param address 发现地址
                     * @param port    连接端口
                     * @param accept  接受数据
                     * @description: UDP 发现
                     **/
                    @Override
                    public void udpFoundEvent(InetAddress address, int port, String accept) {
                        // System.out.println(String.format("收到来自:%s,对方端口号为:%s,消息内容：%s",
                        //         address, port, accept));
                    }
                });

        // 初始化TCP Server
        boolean init_tcp_server_result = communication.Init_TCP_Server(new WTCPServerControl(), new TCPServerDevice());
        System.out.printf("init_tcp_server_result: %s%n", init_tcp_server_result);

        // 初始化TCP Client
        boolean init_tcp_client_result = communication.Init_TCP_Client(new WTCPClientControl());
        System.out.printf("init_tcp_client_result: %s%n", init_tcp_client_result);
//        if (init_tcp_client_result) {
//            Scanner scanner = new Scanner(System.in);
//            while (true) {
//                System.out.print("请输入：");
//                String request = scanner.next();
//                if ("out".equals(request)) {
//                    break;
//                }
//                TCPClientResponse network = communication.network(request);
//                System.out.println(network.toJSON());
//                System.out.println(network.response());
//            }
//        }

        boolean init_udp_terminal_result = communication.Init_UDP_Link(new WUDPControl(), UDP_Terminal);
        System.out.println(String.format("init_udp_terminal_result: %s", init_udp_terminal_result));

//        boolean init_udp_pc_result = communication.Init_UDP_Link(new WUDPControl(), UDP_PC);
//        System.out.println(String.format("init_udp_pc_result: %s", init_udp_pc_result));
    }

    public static FDPLU FDPLU() {
        FDPLU PLU1 = new DPLUV5<>()
                .setNo(23)
                .setItemCode(23)
                .setIndexBar("AAA1111111111")
                .setUnit(2)
                .setPrint(new DPrintWithBitMapV1()
                        .setType1(1)
                        .setBarcode1(1)
                        .setSign1(1)
                        .setType2(2)
                        .setBarcode2(2)
                        .setSign2(2)
                        .setBitmap(3))
                .setCategory(9)
                .setName("青苹果#海天酱油")
                .setText(new DTextV1()
                        .setTexts(Arrays.asList("111", "222", "33")))
                .setTime(new DTimeV2()
                        .setUseDatePS(1)
                        .setUseDatePC(10)
                        .setSaleDatePS(1)
                        .setSaleDatePC(11)
                        .setSaleTimePS(1)
                        .setSaleTimePC(12)
                        .setPackDatePS(1)
                        .setPackDatePC(13)
                        .setPackTimePS(1)
                        .setPackTimePC(14))
                .setPrice(
//                        new DPriceV2()
//                        .setPrice(new BigDecimal("8.6"))
                        new DPriceV2()
                                .setPrice(new BigDecimal("8.63"))
                                .addManualDiscounts(new DManualDiscount()
                                                .setRestriction(0)
                                                .setType(2)
                                                .setDiscount(BigDecimal.valueOf(0.78)),
                                        new DManualDiscount()
                                                .setRestriction(1)
                                                .setType(1)
                                                .setDiscount(BigDecimal.valueOf(0.56)))
                                .addAutoDiscounts(new DAutoDiscountV2()
                                                .setType(2)
                                                .setDate(127)
                                                .setLower(BigDecimal.valueOf(0.46))
                                                .setUpper(BigDecimal.valueOf(0.78))
                                                .setDiscount(BigDecimal.valueOf(0.55)),
                                        new DAutoDiscountV2()
                                                .setType(3)
                                                .setDate(126)
                                                .setLower(BigDecimal.valueOf(0.56))
                                                .setUpper(BigDecimal.valueOf(0.45))
                                                .setDiscount(BigDecimal.valueOf(0.55)))
                )
                .setSimple("QPGHTJY")
                .setPictures(Arrays.asList("123", "345", "456"))
                .setAiType(new DAIType()
                        .setType(1)
                        .addModels(
                                new DAIModel("M-AI-0001", "M-AI-0001-Name"),
                                new DAIModel("M-AI-0002", "M-AI-0002-Name")
                        ))
                .setIndexBars(Arrays.asList("98765", "QWE12345"))
                .setUnitText("瓶")

                .setSaveAsWeight(1)
                .setTare(new BigDecimal("1.0"))
                .setPercentTare(new BigDecimal("0.11"))
                .setFixedWeight(new BigDecimal("0.24"))
//                .putOtherTimes(1, new DTimeV2()
//                        .setSaleTimePS(1)
//                        .setSaleDatePC(20)
//                        .setUseDatePS(1)
//                        .setUseDatePC(20))
//                .putOtherTimes(2, new DTimeV2()
//                        .setSaleTimePS(1)
//                        .setSaleDatePC(30)
//                        .setUseDatePS(1)
//                        .setUseDatePC(30))
                .putOtherPrice(3, new DPriceV2()
                        .setPrice(new BigDecimal("3.46"))
                        .addManualDiscounts(new DManualDiscount()
                                        .restriction(Restriction.上限)
                                        .setType(1)
                                        .setDiscount(BigDecimal.valueOf(0.78)),
                                new DManualDiscount()
                                        .restriction(Restriction.下限)
                                        .setType(0)
                                        .setDiscount(BigDecimal.valueOf(0.56)))
                        .addAutoDiscounts(new DAutoDiscountV2()
                                        .setType(2)
                                        .setDate(127)
                                        .setLower(BigDecimal.valueOf(0.46))
                                        .setUpper(BigDecimal.valueOf(0.78))
                                        .setDiscount(BigDecimal.valueOf(0.55)),
                                new DAutoDiscountV2()
                                        .setType(3)
                                        .setDate(126)
                                        .setLower(BigDecimal.valueOf(0.56))
                                        .setUpper(BigDecimal.valueOf(0.45))
                                        .setDiscount(BigDecimal.valueOf(0.55))))
                .putOtherPrice(4, new DPriceV2()
                        .setPrice(new BigDecimal("4.56"))
                        .addManualDiscounts(new DManualDiscount()
                                        .restriction(Restriction.上限)
                                        .setType(0)
                                        .setDiscount(BigDecimal.valueOf(0.78)),
                                new DManualDiscount()
                                        .restriction(Restriction.下限)
                                        .setType(1)
                                        .setDiscount(BigDecimal.valueOf(0.56)))
                        .addAutoDiscounts(1, new DAutoDiscountV2()
                                .setType(2)
                                .setDate(127)
                                .setLower(BigDecimal.valueOf(0.46))
                                .setUpper(BigDecimal.valueOf(0.78))
                                .setDiscount(BigDecimal.valueOf(0.55)))
                        .addAutoDiscounts(3, new DAutoDiscountV2()
                                .setType(3)
                                .setDate(126)
                                .setLower(BigDecimal.valueOf(0.56))
                                .setUpper(BigDecimal.valueOf(0.45))
                                .setDiscount(BigDecimal.valueOf(0.55))));
//                .putText(5, new DTextV1().addTexts("111", "222", "333"))
//                .putText(6, new DTextV1().addTexts("444", "555", "666"));
        return PLU1;
    }

    /**
     * @description: 打开秤重串口
     **/
    private static void open_weight() throws MeterException {
        IProtocolManager protocolManager = new ADScaleProtocolManager()
                .initPortmanager(new SerialPort(new WSerialPortControl(), new SerialDevice("COM3", 9600)),
                        new IProtocolResponse() {

                            @Override
                            public void target(IPackResponse target) {
                                if (target instanceof ObtainWeightADPDResponse) {
                                    System.out.println(target.toJSON());
                                } else {
                                    System.out.println(target.toJSON());
                                }
                            }

                            @Override
                            public void exp(MeterException e) {
                                System.err.println(e.getMessage());
                            }
                        });
        protocolManager.openPort();
    }

    /**
     * @description: 内容打印
     **/
    @SuppressWarnings("ALL")
    public static void print(String hex) throws MeterException {
        PrintDataRequest request = new PrintDataRequest();
        request.setData(hex);
        request.setPrintBack(new PrintTest.DefaultPrintBack() {
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(JSON.toJSONString(response));
                PrintFactory.getInstance().closeMessenger();
                System.out.println("打印关闭连接");
            }

            @Override
            public void schedule(ScheduleState scheduleState) {
                System.out.println(scheduleState.toString());
            }
        });

        PrintFactory.getInstance()
                .setMessenger(new DefaultPrintSerialMessenger())
                .sendData(request);
    }

    /**
     * @description: 秤重测试
     **/
    private static void weight_test() throws MeterException {
        // 缓冲区加载
        WeightResult weightResult1 = WeightCal.getInstance()
                .SetCode(10005, 1005, false, true, false)
                .GetResult();
        System.out.println(weightResult1.toJSON());

        WeightResult weightResult2 = WeightCal.getInstance()
                .SetCode(10005, 150010, true, true, false)
                .GetResult();
        System.out.println(weightResult2.toJSON());

        // 去皮参数重置
        WeightCal.getInstance().SetTare_ClearAll();

        // 去皮按钮
        WeightCal.getInstance().SetTare_Button();
    }

    /**
     * @description: 秤重信息初始化
     **/
    public static void initWeightCal() throws MeterException {
        WeightCal.getInstance()
                .Init_Manager(new WSerialPortControl(), new SerialDevice("COM3", 9600))
                .Init_Notifies(new WeightChangeNotify() {
                    /**
                     * @description: 回调器身份信息
                     **/
                    @Override
                    public Identify identify() {
                        return new Identify("DEFAULT_Change_TEST", "默认秤重事件通知器");
                    }

                    /**
                     * @description: 开始触发
                     **/
                    @Override
                    public void start() {
                        // System.out.println("开始触发...");
                    }

                    /**
                     * @description: 再次确认触发
                     **/
                    @Override
                    public void reconfirm() {
                        // System.out.println("复检触发...");
                    }

                    /**
                     * @description: 取消触发
                     **/
                    @Override
                    public void cancel() {
                        // System.out.println("取消触发...");
                    }

                    /**
                     * @description: 打开摄像头
                     **/
                    @Override
                    public void open() {
                        // System.out.println("打开摄像头...");
                        // WeightCal.getInstance().OpenSuccess();
                    }

                    /**
                     * @description: 关闭摄像头
                     **/
                    @Override
                    public void close() {
                        // System.out.println("关闭摄像头...");
                    }
                }, new WeightInfoNotify() {
                    /**
                     * @description: 回调器身份信息
                     **/
                    @Override
                    public Identify identify() {
                        return new Identify("DEFAULT_info_TEST", "默认秤重信息通知器");
                    }

                    /**
                     * @param result
                     * @description: 重量信息回调
                     */
                    @Override
                    public void weight(WeightResult result) {
                        // System.out.println(result.toJSON());
                    }
                })
                //.Init_Cap(30000, 3, 6)
                //.Init_ZeroInfo(0,0,true)
                //.ParaCal()
                .SetTare_ClearAll();
    }

    public static String TMX_CONF = "DWL\tTMS\t\n" +
            "TMS\t0\t11\t\n" +
            "TMS\t1\t2\t\n" +
            "TMS\t2\t20\t\n" +
            "TMS\t3\t1\t\n" +
            "TMS\t4\t0\t\n" +
            "TMS\t5\t9\t\n" +
            "TMS\t6\t7\t\n" +
            "TMS\t7\t2099999\t\n" +
            "TMS\t8\t1\t\n" +
            "TMS\t9\t0\t\n" +
            "TMS\t10\t0\t\n" +
            "TMS\t11\t0\t\n" +
            "TMS\t12\t0\t\n" +
            "TMS\t13\t0\t\n" +
            "TMS\t14\t0\t\n" +
            "TMS\t15\t0\t\n" +
            "TMS\t16\t0\t\n" +
            "TMS\t17\t0\t\n" +
            "TMS\t18\t0\t\n" +
            "TMS\t19\t0\t\n" +
            "TMS\t20\t33\t\n" +
            "TMS\t21\t1\t\n" +
            "TMS\t22\t7\t\n" +
            "TMS\t23\t7\t\n" +
            "TMS\t24\t5\t\n" +
            "TMS\t25\t35\t\n" +
            "TMS\t26\t16\t\n" +
            "TMS\t27\t48\t\n" +
            "TMS\t28\t1\t\n" +
            "TMS\t29\t0\t\n" +
            "TMS\t30\t270\t\n" +
            "TMS\t31\t0\t\n" +
            "TMS\t32\t0\t\n" +
            "TMS\t33\t0\t\n" +
            "TMS\t34\t3\t\n" +
            "TMS\t35\t1\t\n" +
            "TMS\t36\t1\t\n" +
            "TMS\t37\t8\t\n" +
            "TMS\t38\t20\t\n" +
            "TMS\t39\t0\t\n" +
            "TMS\t40\t0\t\n" +
            "TMS\t41\t5\t\n" +
            "TMS\t42\t1\t\n" +
            "TMS\t43\t1\t\n" +
            "TMS\t44\t30\t\n" +
            "TMS\t45\t1\t\n" +
            "TMS\t46\t0\t\n" +
            "TMS\t47\t0\t\n" +
            "TMS\t48\t10\t\n" +
            "TMS\t49\t1\t\n" +
            "TMS\t50\t0\t\n" +
            "TMS\t51\t2\t\n" +
            "TMS\t52\t0\t\n" +
            "TMS\t53\t0\t\n" +
            "TMS\t54\t0\t\n" +
            "TMS\t55\t0\t\n" +
            "TMS\t56\t0\t\n" +
            "TMS\t57\t2\t\n" +
            "TMS\t58\t1\t\n" +
            "TMS\t59\t0\t\n" +
            "TMS\t60\t1\t\n" +
            "TMS\t61\t3\t\n" +
            "TMS\t62\t3\t\n" +
            "TMS\t63\t3\t\n" +
            "TMS\t64\t3\t\n" +
            "TMS\t65\t4\t\n" +
            "TMS\t66\t0\t\n" +
            "TMS\t67\t1\t\n" +
            "TMS\t68\t1\t\n" +
            "TMS\t69\t2\t\n" +
            "TMS\t70\t0\t\n" +
            "TMS\t71\t0\t\n" +
            "TMS\t72\t0\t\n" +
            "TMS\t73\t0\t\n" +
            "TMS\t74\t0\t\n" +
            "TMS\t75\t0\t\n" +
            "TMS\t76\t0\t\n" +
            "TMS\t77\t0\t\n" +
            "TMS\t78\t2\t\n" +
            "TMS\t79\t1\t\n" +
            "TMS\t80\t1\t\n" +
            "TMS\t81\t1\t\n" +
            "TMS\t82\t1\t\n" +
            "TMS\t83\t1\t\n" +
            "TMS\t84\t0\t\n" +
            "TMS\t85\t20\t\n" +
            "TMS\t86\t20\t\n" +
            "TMS\t87\t0\t\n" +
            "TMS\t88\t0\t\n" +
            "TMS\t89\t1\t\n" +
            "TMS\t90\t1\t\n" +
            "TMS\t91\t0\t\n" +
            "TMS\t92\t1\t\n" +
            "TMS\t93\t0\t\n" +
            "TMS\t94\t0\t\n" +
            "TMS\t95\t0\t\n" +
            "TMS\t96\t0\t\n" +
            "TMS\t97\t1\t\n" +
            "TMS\t98\t3\t\n" +
            "TMS\t99\t3\t\n" +
            "TMS\t100\t0\t\n" +
            "TMS\t101\t0\t\n" +
            "TMS\t102\t0\t\n" +
            "TMS\t103\t3\t\n" +
            "TMS\t104\t0\t\n" +
            "TMS\t105\t0\t\n" +
            "TMS\t106\t0\t\n" +
            "TMS\t107\t0\t\n" +
            "TMS\t108\t0\t\n" +
            "TMS\t109\t0\t\n" +
            "TMS\t110\t0\t\n" +
            "TMS\t111\t90\t\n" +
            "TMS\t112\t110\t\n" +
            "TMS\t113\t0\t\n" +
            "TMS\t114\t0\t\n" +
            "TMS\t115\t1\t\n" +
            "TMS\t116\t0\t\n" +
            "TMS\t117\t0\t\n" +
            "TMS\t118\t3\t\n" +
            "TMS\t119\t2\t\n" +
            "TMS\t120\t3\t\n" +
            "TMS\t121\t1\t\n" +
            "TMS\t122\t0\t\n" +
            "TMS\t123\t0\t\n" +
            "TMS\t124\t0\t\n" +
            "TMS\t125\t0\t\n" +
            "TMS\t126\t0\t\n" +
            "TMS\t127\t0\t\n" +
            "TMS\t128\t0\t\n" +
            "TMS\t129\t0\t\n" +
            "TMS\t130\t0\t\n" +
            "TMS\t131\t0\t\n" +
            "TMS\t132\t0\t\n" +
            "TMS\t133\t2\t\n" +
            "TMS\t134\t2\t\n" +
            "TMS\t135\t0\t\n" +
            "TMS\t136\t0\t\n" +
            "TMS\t137\t0\t\n" +
            "TMS\t138\t0\t\n" +
            "TMS\t139\t0\t\n" +
            "TMS\t140\t2\t\n" +
            "TMS\t141\t1\t\n" +
            "TMS\t142\t1\t\n" +
            "TMS\t143\t6\t\n" +
            "TMS\t144\t0\t\n" +
            "TMS\t145\t0\t\n" +
            "TMS\t146\t0\t\n" +
            "TMS\t147\t0\t\n" +
            "TMS\t148\t0\t\n" +
            "TMS\t149\t1\t\n" +
            "TMS\t150\t192\t\n" +
            "TMS\t151\t168\t\n" +
            "TMS\t152\t0\t\n" +
            "TMS\t153\t0\t\n" +
            "TMS\t154\t0\t\n" +
            "TMS\t155\t0\t\n" +
            "TMS\t156\t0\t\n" +
            "TMS\t157\t0\t\n" +
            "TMS\t158\t192\t\n" +
            "TMS\t159\t168\t\n" +
            "TMS\t160\t0\t\n" +
            "TMS\t161\t1\t\n" +
            "TMS\t162\t255\t\n" +
            "TMS\t163\t255\t\n" +
            "TMS\t164\t255\t\n" +
            "TMS\t165\t0\t\n" +
            "TMS\t166\t33581\t\n" +
            "TMS\t167\t33582\t\n" +
            "TMS\t168\t33583\t\n" +
            "TMS\t169\t33584\t\n" +
            "TMS\t170\t8\t\n" +
            "TMS\t171\t8\t\n" +
            "TMS\t172\t8\t\n" +
            "TMS\t173\t8\t\n" +
            "TMS\t174\t0\t\n" +
            "TMS\t175\t0\t\n" +
            "TMS\t176\t0\t\n" +
            "TMS\t177\t0\t\n" +
            "TMS\t178\t0\t\n" +
            "TMS\t179\t0\t\n" +
            "TMS\t180\t0\t\n" +
            "TMS\t181\t0\t\n" +
            "TMS\t182\t0\t\n" +
            "TMS\t183\t0\t\n" +
            "TMS\t184\t0\t\n" +
            "TMS\t185\t0\t\n" +
            "TMS\t186\t0\t\n" +
            "TMS\t187\t0\t\n" +
            "TMS\t188\t6\t\n" +
            "TMS\t189\t7\t\n" +
            "TMS\t190\t0\t\n" +
            "TMS\t191\t1\t\n" +
            "TMS\t192\t0\t\n" +
            "TMS\t193\t0\t\n" +
            "TMS\t194\t0\t\n" +
            "TMS\t195\t1\t\n" +
            "TMS\t196\t3\t\n" +
            "TMS\t197\t0\t\n" +
            "TMS\t198\t4\t\n" +
            "TMS\t199\t0\t\n" +
            "TMS\t200\t3\t\n" +
            "TMS\t201\t3\t\n" +
            "TMS\t202\t2\t\n" +
            "TMS\t203\t2\t\n" +
            "TMS\t204\t0\t\n" +
            "TMS\t205\t0\t\n" +
            "TMS\t206\t3\t\n" +
            "TMS\t207\t2\t\n" +
            "TMS\t208\t3\t\n" +
            "TMS\t209\t2\t\n" +
            "TMS\t210\t0\t\n" +
            "TMS\t211\t0\t\n" +
            "TMS\t212\t0\t\n" +
            "TMS\t213\t0\t\n" +
            "TMS\t214\t0\t\n" +
            "TMS\t215\t9\t\n" +
            "TMS\t216\t9\t\n" +
            "TMS\t217\t4\t\n" +
            "TMS\t218\t0\t\n" +
            "TMS\t219\t40\t\n" +
            "TMS\t220\t18\t\n" +
            "TMS\t221\t2\t\n" +
            "TMS\t222\t2\t\n" +
            "TMS\t223\t4\t\n" +
            "TMS\t224\t4\t\n" +
            "TMS\t225\t5\t\n" +
            "TMS\t226\t0\t\n" +
            "TMS\t227\t0\t\n" +
            "TMS\t228\t4\t\n" +
            "TMS\t229\t1\t\n" +
            "TMS\t230\t0\t\n" +
            "TMS\t231\t0\t\n" +
            "TMS\t232\t0\t\n" +
            "TMS\t233\t0\t\n" +
            "TMS\t234\t0\t\n" +
            "TMS\t235\t0\t\n" +
            "TMS\t236\t0\t\n" +
            "TMS\t237\t0\t\n" +
            "TMS\t238\t0\t\n" +
            "TMS\t239\t100\t\n" +
            "TMS\t240\t54\t\n" +
            "TMS\t241\t0\t\n" +
            "TMS\t242\t0\t\n" +
            "TMS\t243\t1\t\n" +
            "TMS\t244\t0\t\n" +
            "TMS\t245\t0\t\n" +
            "TMS\t246\t0\t\n" +
            "TMS\t247\t0\t\n" +
            "TMS\t248\t0\t\n" +
            "TMS\t249\t0\t\n" +
            "TMS\t250\t0\t\n" +
            "TMS\t251\t0\t\n" +
            "TMS\t252\t0\t\n" +
            "TMS\t253\t0\t\n" +
            "TMS\t254\t0\t\n" +
            "TMS\t255\t0\t\n" +
            "TMS\t256\t0\t\n" +
            "TMS\t257\t7\t\n" +
            "TMS\t258\t3\t\n" +
            "TMS\t259\t0\t\n" +
            "TMS\t260\t0\t\n" +
            "TMS\t261\t0\t\n" +
            "TMS\t262\t0\t\n" +
            "TMS\t263\t0\t\n" +
            "TMS\t264\t0\t\n" +
            "TMS\t265\t0\t\n" +
            "TMS\t266\t0\t\n" +
            "TMS\t267\t0\t\n" +
            "TMS\t268\t1\t\n" +
            "TMS\t269\t0\t\n" +
            "TMS\t270\t0\t\n" +
            "TMS\t271\t1\t\n" +
            "TMS\t272\t0\t\n" +
            "TMS\t273\t1\t\n" +
            "TMS\t274\t9999979\t\n" +
            "TMS\t275\t1\t\n" +
            "TMS\t276\t0\t\n" +
            "TMS\t277\t0\t\n" +
            "TMS\t278\t0\t\n" +
            "TMS\t279\t0\t\n" +
            "TMS\t280\t0\t\n" +
            "TMS\t281\t0\t\n" +
            "TMS\t282\t0\t\n" +
            "TMS\t283\t1\t\n" +
            "TMS\t284\t0\t\n" +
            "TMS\t285\t0\t\n" +
            "TMS\t286\t0\t\n" +
            "TMS\t287\t0\t\n" +
            "TMS\t288\t0\t\n" +
            "TMS\t289\t0\t\n" +
            "TMS\t290\t0\t\n" +
            "TMS\t291\t0\t\n" +
            "TMS\t292\t0\t\n" +
            "TMS\t293\t0\t\n" +
            "TMS\t294\t0\t\n" +
            "TMS\t295\t0\t\n" +
            "TMS\t296\t0\t\n" +
            "TMS\t297\t0\t\n" +
            "TMS\t298\t2\t\n" +
            "TMS\t299\t0\t\n" +
            "TMS\t300\t0\t\n" +
            "TMS\t301\t0\t\n" +
            "TMS\t302\t0\t\n" +
            "TMS\t303\t0\t\n" +
            "TMS\t304\t0\t\n" +
            "TMS\t305\t0\t\n" +
            "TMS\t306\t0\t\n" +
            "TMS\t307\t1\t\n" +
            "TMS\t308\t1\t\n" +
            "TMS\t309\t0\t\n" +
            "TMS\t310\t0\t\n" +
            "TMS\t311\t0\t\n" +
            "TMS\t312\t0\t\n" +
            "TMS\t313\t0\t\n" +
            "TMS\t314\t0\t\n" +
            "TMS\t315\t0\t\n" +
            "TMS\t316\t0\t\n" +
            "TMS\t317\t0\t\n" +
            "TMS\t318\t0\t\n" +
            "TMS\t319\t0\t\n" +
            "TMS\t320\t0\t\n" +
            "TMS\t321\t0\t\n" +
            "TMS\t322\t0\t\n" +
            "TMS\t323\t0\t\n" +
            "TMS\t324\t0\t\n" +
            "TMS\t325\t0\t\n" +
            "TMS\t326\t0\t\n" +
            "TMS\t327\t0\t\n" +
            "TMS\t328\t0\t\n" +
            "TMS\t329\t0\t\n" +
            "TMS\t330\t0\t\n" +
            "TMS\t331\t0\t\n" +
            "TMS\t332\t0\t\n" +
            "TMS\t333\t0\t\n" +
            "TMS\t334\t0\t\n" +
            "TMS\t335\t0\t\n" +
            "TMS\t336\t0\t\n" +
            "TMS\t337\t0\t\n" +
            "TMS\t338\t0\t\n" +
            "TMS\t339\t0\t\n" +
            "TMS\t340\t4\t\n" +
            "TMS\t341\t13\t\n" +
            "TMS\t342\t0\t\n" +
            "TMS\t343\t0\t\n" +
            "TMS\t344\t0\t\n" +
            "TMS\t345\t0\t\n" +
            "TMS\t346\t0\t\n" +
            "TMS\t347\t0\t\n" +
            "TMS\t348\t0\t\n" +
            "TMS\t349\t0\t\n" +
            "TMS\t350\t0\t\n" +
            "TMS\t351\t0\t\n" +
            "TMS\t352\t0\t\n" +
            "TMS\t353\t1\t\n" +
            "TMS\t354\t0\t\n" +
            "TMS\t355\t0\t\n" +
            "TMS\t356\t0\t\n" +
            "TMS\t357\t0\t\n" +
            "TMS\t358\t1\t\n" +
            "TMS\t359\t0\t\n" +
            "TMS\t360\t100\t\n" +
            "TMS\t361\t1\t\n" +
            "TMS\t362\t1\t\n" +
            "TMS\t363\t10\t\n" +
            "TMS\t364\t0\t\n" +
            "TMS\t365\t0\t\n" +
            "TMS\t366\t0\t\n" +
            "TMS\t367\t0\t\n" +
            "TMS\t368\t0\t\n" +
            "TMS\t369\t0\t\n" +
            "TMS\t370\t0\t\n" +
            "TMS\t371\t0\t\n" +
            "TMS\t372\t0\t\n" +
            "TMS\t373\t0\t\n" +
            "TMS\t374\t0\t\n" +
            "TMS\t375\t0\t\n" +
            "TMS\t376\t33591\t\n" +
            "TMS\t377\t33592\t\n" +
            "TMS\t378\t33593\t\n" +
            "TMS\t379\t33594\t\n" +
            "TMS\t380\t0\t\n" +
            "TMS\t381\t0\t\n" +
            "TMS\t382\t0\t\n" +
            "TMS\t383\t0\t\n" +
            "TMS\t384\t0\t\n" +
            "TMS\t385\t0\t\n" +
            "TMS\t386\t0\t\n" +
            "TMS\t387\t0\t\n" +
            "TMS\t388\t0\t\n" +
            "TMS\t389\t0\t\n" +
            "TMS\t390\t0\t\n" +
            "TMS\t391\t0\t\n" +
            "TMS\t392\t0\t\n" +
            "TMS\t393\t0\t\n" +
            "TMS\t394\t0\t\n" +
            "TMS\t395\t0\t\n" +
            "TMS\t396\t0\t\n" +
            "TMS\t397\t0\t\n" +
            "TMS\t398\t0\t\n" +
            "TMS\t399\t0\t\n" +
            "TMS\t400\t0\t\n" +
            "TMS\t401\t0\t\n" +
            "TMS\t402\t0\t\n" +
            "TMS\t403\t0\t\n" +
            "TMS\t404\t0\t\n" +
            "TMS\t405\t0\t\n" +
            "TMS\t406\t0\t\n" +
            "TMS\t407\t0\t\n" +
            "TMS\t408\t0\t\n" +
            "TMS\t409\t0\t\n" +
            "TMS\t410\t0\t\n" +
            "TMS\t411\t0\t\n" +
            "TMS\t412\t0\t\n" +
            "TMS\t413\t0\t\n" +
            "TMS\t414\t0\t\n" +
            "TMS\t415\t1\t\n" +
            "TMS\t416\t1\t\n" +
            "TMS\t417\t8\t\n" +
            "TMS\t418\t20\t\n" +
            "TMS\t419\t0\t\n" +
            "TMS\t420\t0\t\n" +
            "TMS\t421\t0\t\n" +
            "TMS\t422\t1\t\n" +
            "TMS\t423\t0\t\n" +
            "TMS\t424\t0\t\n" +
            "TMS\t425\t0\t\n" +
            "TMS\t426\t0\t\n" +
            "TMS\t427\t0\t\n" +
            "TMS\t428\t0\t\n" +
            "TMS\t429\t0\t\n" +
            "TMS\t430\t192\t\n" +
            "TMS\t431\t168\t\n" +
            "TMS\t432\t0\t\n" +
            "TMS\t433\t0\t\n" +
            "TMS\t434\t192\t\n" +
            "TMS\t435\t168\t\n" +
            "TMS\t436\t0\t\n" +
            "TMS\t437\t1\t\n" +
            "TMS\t438\t255\t\n" +
            "TMS\t439\t255\t\n" +
            "TMS\t440\t255\t\n" +
            "TMS\t441\t0\t\n" +
            "TMS\t442\t0\t\n" +
            "TMS\t443\t0\t\n" +
            "TMS\t444\t0\t\n" +
            "TMS\t445\t0\t\n" +
            "TMS\t446\t0\t\n" +
            "TMS\t447\t0\t\n" +
            "TMS\t448\t0\t\n" +
            "TMS\t449\t0\t\n" +
            "TMS\t450\t9\t\n" +
            "TMS\t451\t0\t\n" +
            "TMS\t452\t0\t\n" +
            "TMS\t453\t2\t\n" +
            "TMS\t454\t6\t\n" +
            "TMS\t455\t1\t\n" +
            "TMS\t456\t0\t\n" +
            "TMS\t457\t0\t\n" +
            "TMS\t458\t0\t\n" +
            "TMS\t459\t0\t\n" +
            "TMS\t460\t0\t\n" +
            "TMS\t461\t0\t\n" +
            "TMS\t462\t0\t\n" +
            "TMS\t463\t0\t\n" +
            "TMS\t464\t0\t\n" +
            "TMS\t465\t0\t\n" +
            "TMS\t466\t0\t\n" +
            "TMS\t467\t0\t\n" +
            "TMS\t468\t0\t\n" +
            "TMS\t469\t0\t\n" +
            "TMS\t470\t0\t\n" +
            "TMS\t471\t0\t\n" +
            "TMS\t472\t0\t\n" +
            "TMS\t473\t0\t\n" +
            "TMS\t474\t0\t\n" +
            "TMS\t475\t0\t\n" +
            "TMS\t476\t0\t\n" +
            "TMS\t477\t0\t\n" +
            "TMS\t478\t0\t\n" +
            "TMS\t479\t0\t\n" +
            "TMS\t480\t0\t\n" +
            "TMS\t481\t0\t\n" +
            "TMS\t482\t0\t\n" +
            "TMS\t483\t0\t\n" +
            "TMS\t484\t0\t\n" +
            "TMS\t485\t0\t\n" +
            "TMS\t486\t0\t\n" +
            "TMS\t487\t0\t\n" +
            "TMS\t488\t0\t\n" +
            "TMS\t489\t0\t\n" +
            "TMS\t490\t0\t\n" +
            "TMS\t491\t0\t\n" +
            "TMS\t492\t0\t\n" +
            "TMS\t493\t0\t\n" +
            "TMS\t494\t0\t\n" +
            "TMS\t495\t0\t\n" +
            "TMS\t496\t0\t\n" +
            "TMS\t497\t0\t\n" +
            "TMS\t498\t0\t\n" +
            "TMS\t499\t1522729470\t\n" +
            "END\tTMS\t\n" +
            "\n" +
            "DWL\tTMT\t\n" +
            "TMT\t0\t上海精函信息科技有限公司\t\n" +
            "TMT\t1\t出厂机\t\n" +
            "TMT\t2\t￥\t\n" +
            "TMT\t3\t\t\n" +
            "TMT\t4\t\t\n" +
            "TMT\t5\t\t\n" +
            "TMT\t6\t\t\n" +
            "TMT\t7\t\t\n" +
            "TMT\t8\t谢谢惠顾,欢迎再次光临!\t\n" +
            "TMT\t9\t\t\n" +
            "TMT\t10\t\t\n" +
            "TMT\t11\t\t\n" +
            "TMT\t12\t\t\n" +
            "TMT\t13\t\t\n" +
            "TMT\t14\t\t\n" +
            "TMT\t15\tJHSCALE\t\n" +
            "TMT\t16\t\t\n" +
            "TMT\t17\t\t\n" +
            "TMT\t18\t\t\n" +
            "TMT\t19\t\t\n" +
            "TMT\t20\t\t\n" +
            "TMT\t21\t\t\n" +
            "TMT\t22\t\t\n" +
            "TMT\t23\t\t\n" +
            "TMT\t24\t\t\n" +
            "TMT\t25\t\t\n" +
            "TMT\t26\t\t\n" +
            "TMT\t27\t\t\n" +
            "END\tTMT\t\n" +
            "\n" +
            "DWL\tBAR\t\n" +
            "BAR\t1\tBarcode-1\t0\t0\t0\t0\tB201E500K500A000A000A000\t\n" +
            "BAR\t2\tBarcode-2\t0\t0\t0\t0\tB201F501K500A000A000A000\t\n" +
            "BAR\t3\tBarcode-3\t0\t0\t0\t0\tF701K500A000A000A000A000\t\n" +
            "BAR\t4\tBarcode-4\t0\t0\t0\t0\tB201E400K600A000A000A000\t\n" +
            "BAR\t5\tBarcode-5\t0\t0\t0\t0\tB201F401K600A000A000A000\t\n" +
            "BAR\t6\tBarcode-6\t0\t0\t0\t0\tF601K600A000A000A000A000\t\n" +
            "BAR\t7\tB-Sum 1\t0\t0\t0\t0\tB701L500A000A000A000A000\t\n" +
            "BAR\t8\tB-Sum 2\t0\t0\t0\t0\tB601L600A000A000A000A000\t\n" +
            "BAR\t9\tB-Sum 3\t0\t0\t0\t0\tB501L700A000A000A000A000\t\n" +
            "BAR\t10\t编码金额\t0\t0\t0\t0\tB200E501L500A000A000A000\t\n" +
            "END\tBAR\t\n" +
            "\n" +
            "DWL\tLAT\t\n" +
            "LAT\t1\tPF-1\t1,1,432,296|5Y2V5Lu3CeWHgOmHjQnmlbDph48J5oC75Lu3CemUgOWUruaXpeacnwnplIDllK7ml7bpl7QJ5pyJ5pWI5pel5pyfCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQ==|0,0,0,0,1,0,5,1,0,88,281,113|1,2,0,0,1,0,5,1,0,240,432,26|2,2,1,0,1,0,5,1,0,266,431,26|3,2,3,0,1,0,5,0,1,220,138,20|4,2,4,0,1,0,5,0,141,220,136,20|5,1,0,6,1,0,5,0,362,0,70,34|6,1,0,0,1,0,5,2,0,0,362,34|7,1,0,1,1,0,5,1,139,60,141,26|8,2,27,0,1,0,5,2,282,60,149,34|9,1,0,4,1,0,5,1,0,60,137,26|10,1,0,15,9,0,5,0,280,220,148,20|11,1,0,16,1,0,5,0,285,94,147,107|12,1,0,24,1,0,4,1,236,34,57,26|13,1,0,25,1,0,4,1,82,34,60,26|14,2,16,0,1,0,4,1,380,34,42,26|15,3,0,0,1,0,6,1,0,34,80,26|16,3,1,0,2,0,6,1,160,34,74,26|17,3,2,0,3,0,6,1,160,34,74,26|18,3,3,0,1,0,6,1,300,34,72,26|19,3,4,0,1,0,5,0,2,202,138,18|20,3,5,0,1,0,5,0,142,202,134,18|21,3,6,0,9,0,5,0,283,202,144,18\t\n" +
            "LAT\t2\tPF-2\t1,1,304,216|5Y2V5Lu3CeWHgOmHjQnmlbDph48J5oC75Lu3CeacieaViOacnwkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQ==|0,0,0,0,1,0,5,0,0,70,242,97|1,2,0,0,1,0,5,1,0,185,304,26|2,2,3,0,1,0,5,0,2,167,100,18|3,2,4,0,1,0,5,0,105,167,80,18|4,1,0,6,1,0,5,0,251,70,53,30|5,1,0,0,1,0,5,1,0,0,304,26|6,1,0,1,1,0,5,0,104,47,91,18|7,2,27,0,1,0,5,1,197,44,107,26|8,1,0,4,1,0,5,0,0,47,104,18|9,1,0,15,9,0,5,0,204,167,100,18|10,1,0,24,1,0,4,0,160,26,50,18|11,1,0,25,1,0,4,0,50,26,50,18|12,2,16,0,1,0,4,0,264,26,30,18|13,3,0,0,1,0,6,0,0,26,50,18|14,3,1,0,2,0,6,0,110,26,50,18|15,3,2,0,3,0,6,0,110,26,50,18|16,3,3,0,1,0,6,0,214,26,50,18|17,3,4,0,9,0,5,0,250,149,54,18\t\n" +
            "LAT\t3\tPF-3\t1,1,432,232|5Y2V5Lu3CeWHgOmHjQnmlbDph48J5oC75Lu3CemUgOWUruaXpeacnwnplIDllK7ml7bpl7QJ5pyJ5pWI5pel5pyfCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQ==|0,0,0,0,1,0,5,1,0,80,281,93|1,2,0,0,1,0,5,2,0,193,431,34|2,2,3,0,1,0,5,0,0,173,138,20|3,2,4,0,1,0,5,0,139,173,136,20|4,1,0,6,1,0,5,0,362,0,70,34|5,1,0,0,1,0,5,2,0,0,362,34|6,1,0,1,1,0,5,1,140,54,141,26|7,2,27,0,1,0,5,2,282,60,149,34|8,1,0,4,1,0,5,1,0,54,137,26|9,1,0,15,9,0,5,0,283,173,148,20|10,1,0,24,1,0,4,1,236,34,57,18|11,1,0,25,1,0,4,1,74,34,60,18|12,2,16,0,1,0,4,1,380,34,42,18|13,3,0,0,1,0,6,1,0,34,70,18|14,3,1,0,2,0,6,1,150,34,74,18|15,3,2,0,3,0,6,1,150,34,74,18|16,3,3,0,1,0,6,1,301,34,72,18|17,3,6,0,9,0,5,0,284,155,145,18\t\n" +
            "LAT\t4\tPF-4\t2,1,432,296|5ZCI6K6h5qCH562+OgnplIDllK7ml6XmnJ8J6ZSA5ZSu5pe26Ze0CeaAu+aVsOmHjwnmgLvlh4Dph40J5oC75Lu3CQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQk=|0,0,0,0,1,0,5,1,2,32,247,143|1,2,0,0,1,0,5,1,0,241,432,26|2,2,1,0,1,0,5,1,0,267,432,26|3,2,3,0,1,0,5,0,6,191,126,18|4,2,4,0,1,0,5,0,131,191,122,18|5,2,27,0,1,0,5,2,316,207,103,34|6,2,6,0,1,0,5,1,84,209,70,32|7,2,7,0,1,0,5,1,236,209,78,32|8,2,5,0,1,0,5,2,177,0,36,32|9,1,1,0,1,0,5,0,252,0,108,18|10,1,2,0,1,0,5,0,252,18,108,18|11,1,3,0,1,0,5,0,252,36,108,18|12,1,4,0,1,0,5,0,252,54,108,18|13,1,5,0,1,0,5,0,252,72,108,18|14,1,6,0,1,0,5,0,252,90,108,18|15,1,7,0,1,0,5,0,252,108,108,18|16,1,8,0,1,0,5,0,252,126,108,18|17,1,9,0,1,0,5,0,252,144,108,18|18,1,10,0,1,0,5,0,252,160,108,18|19,1,1,5,1,0,5,0,360,0,70,18|20,1,2,5,1,0,5,0,360,18,70,18|21,1,3,5,1,0,5,0,360,36,70,18|22,1,4,5,1,0,5,0,360,54,70,18|23,1,5,5,1,0,5,0,360,72,70,18|24,1,6,5,1,0,5,0,360,90,70,18|25,1,7,5,1,0,5,0,360,108,70,18|26,1,8,5,1,0,5,0,360,126,70,18|27,1,9,5,1,0,5,0,360,144,70,18|28,1,10,5,1,0,5,0,360,160,70,18|29,3,0,0,1,0,5,2,13,0,160,32|30,3,1,0,1,0,5,0,15,175,108,16|31,3,2,0,1,0,5,0,135,175,100,16|32,3,3,0,1,0,5,1,5,209,78,32|33,3,4,0,1,0,5,1,156,209,78,32|34,3,5,0,1,0,5,1,332,179,67,26\t\n" +
            "LAT\t5\tPF-5\t2,1,304,216|5ZCI6K6h5qCH562+OgkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQk=|0,0,0,0,1,0,5,1,0,26,224,117|1,2,0,0,1,0,5,1,0,173,303,34|2,2,3,0,1,0,5,0,0,153,110,20|3,2,4,0,1,0,5,0,108,153,103,20|4,2,27,0,1,0,5,1,211,147,92,26|5,2,5,0,1,0,5,1,146,0,36,26|6,1,1,0,1,0,5,0,229,0,74,18|7,1,2,0,1,0,5,0,229,18,74,18|8,1,3,0,1,0,5,0,229,36,74,18|9,1,4,0,1,0,5,0,229,54,74,18|10,1,5,0,1,0,5,0,229,72,74,18|11,1,6,0,1,0,5,0,229,90,74,18|12,1,7,0,1,0,5,0,229,108,74,18|13,1,8,0,1,0,5,0,229,126,74,18|14,3,0,0,1,0,5,1,13,0,130,26\t\n" +
            "LAT\t6\tPF-6\t2,1,432,224|5ZCI6K6h5qCH562+OgkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQk=|0,0,0,0,1,0,5,1,2,35,247,125|1,2,0,0,1,0,5,2,0,182,432,34|2,2,3,0,1,0,5,0,6,161,125,20|3,2,4,0,1,0,5,0,132,161,124,20|4,2,27,0,1,0,5,2,279,146,114,34|5,2,5,0,1,0,5,2,177,0,36,34|6,1,1,0,1,0,5,0,252,0,108,18|7,1,2,0,1,0,5,0,252,18,108,18|8,1,3,0,1,0,5,0,252,36,108,18|9,1,4,0,1,0,5,0,252,54,108,18|10,1,5,0,1,0,5,0,252,72,108,18|11,1,6,0,1,0,5,0,252,90,108,18|12,1,7,0,1,0,5,0,252,108,108,18|13,1,8,0,1,0,5,0,252,126,108,18|14,1,1,5,1,0,5,0,360,0,70,18|15,1,2,5,1,0,5,0,360,18,70,18|16,1,3,5,1,0,5,0,360,36,70,18|17,1,4,5,1,0,5,0,360,54,70,18|18,1,5,5,1,0,5,0,360,72,70,18|19,1,6,5,1,0,5,0,360,90,70,18|20,1,7,5,1,0,5,0,360,108,70,18|21,1,8,5,1,0,5,0,360,126,70,18|22,3,0,0,1,0,5,2,13,0,160,34\t\n" +
            "LAT\t7\tPF-7\t3,1,384,1072|6ZSA5ZSu5pe26Ze0OgktIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLQnllYblk4EJCeWNleS7twnph43ph48v5pWw6YePCemHkeminQnntK/orqE6CeWunuaUtumHkeminToJ5pS26ZO26YeR6aKdOgnmipjoiI3ph5Hpop06CeaJvumbtumHkeminToJ5Y2h5Y6f6aKdOgnljaHkvZnpop06CeWNoeWPtzoJ5Y2V5ZOB5pyN5Yqh6LS5CeacjeWKoei0uQnnqI7pop06CeWPsOWPtzoJ5ZCI6K6h6YeR6aKdOgnljaHmlK/ku5g6CeaUr+S7mDE6CeaUr+S7mDI6CeaUr+S7mDM6CeS8muWRmOenr+WIhjoJ5Y6f5Lu36YeR6aKdOgnoioLnnIHph5Hpop06CeWQieWNoeS6keaUr+S7mDoJCQkJ|0,6,1,0,1,0,192,1,0,0,384,26|1,2,0,0,1,0,192,1,0,26,384,26|2,2,17,0,1,0,192,1,0,52,384,26|3,2,18,0,1,0,192,1,0,78,384,26|4,2,19,0,1,0,192,1,0,104,384,26|5,2,20,0,1,0,192,1,0,130,384,26|6,2,2,0,1,0,4,1,0,156,84,26|7,2,47,0,1,0,4,1,84,156,30,26|8,2,31,0,1,0,5,1,128,156,125,26|9,2,26,0,1,0,5,1,259,156,125,26|10,5,0,0,1,0,0,0,20,182,200,50|11,3,0,0,1,0,4,1,0,182,114,26|12,2,3,0,1,0,0,1,115,182,140,26|13,2,4,0,1,0,6,1,270,182,112,26|14,3,1,0,1,0,192,0,0,208,384,16|15,3,2,0,1,0,4,1,0,224,104,26|16,3,3,0,1,0,5,1,181,224,160,26|17,3,4,0,1,0,4,1,14,250,76,26|18,3,5,0,1,0,5,1,99,250,172,26|19,3,6,0,1,0,5,1,280,250,104,26|20,3,1,0,1,0,192,0,0,276,384,15|21,5,0,0,1,0,0,0,50,291,200,50|22,1,0,0,1,0,4,1,0,291,180,26|23,1,0,38,1,0,6,1,238,291,146,26|24,1,0,31,1,0,4,1,96,317,96,26|25,1,0,4,1,0,5,1,0,317,96,26|26,1,0,1,1,0,4,1,192,317,96,26|27,1,0,26,1,0,6,1,288,317,96,26|28,5,2,0,1,0,0,0,20,343,200,50|29,5,2,0,1,0,0,0,21,395,200,50|30,1,0,19,1,0,4,1,0,395,128,26|31,1,0,20,1,0,5,1,128,395,128,26|32,1,0,21,1,0,6,1,256,395,128,26|33,5,2,0,1,0,0,0,50,421,200,50|34,3,17,0,13,0,4,1,15,421,140,26|35,1,0,29,13,0,5,1,170,421,50,26|36,1,0,27,13,0,6,1,220,421,150,26|37,5,2,0,1,0,0,0,50,447,200,50|38,3,15,0,11,0,4,1,15,447,140,26|39,1,0,28,11,0,6,1,220,447,150,26|40,5,0,0,1,0,0,0,50,473,200,50|41,3,1,0,1,0,192,0,0,473,384,18|42,3,16,0,12,0,4,1,15,491,140,26|43,2,44,0,12,0,6,1,220,491,150,26|44,5,0,0,1,0,0,0,38,517,200,50|45,3,25,0,34,0,4,1,151,517,118,26|46,2,71,0,34,0,5,1,269,517,112,26|47,3,26,0,34,0,4,1,151,543,118,26|48,2,72,0,34,0,5,1,269,543,112,26|49,5,0,0,1,0,0,0,38,569,200,50|50,3,19,0,16,0,4,1,151,569,118,26|51,2,28,0,16,0,5,1,269,569,112,26|52,3,10,0,16,0,4,1,151,595,118,26|53,2,29,0,16,0,5,1,269,595,112,26|54,5,0,0,1,0,0,0,38,621,200,50|55,3,8,0,1,0,5,2,4,621,200,34|56,2,27,0,1,0,5,2,221,621,160,34|57,5,0,0,1,0,0,0,20,655,200,50|58,3,21,0,17,0,4,1,143,655,118,26|59,2,52,0,17,0,5,1,261,655,120,26|60,5,0,0,1,0,0,0,48,681,200,50|61,3,22,0,18,0,4,1,143,681,118,26|62,2,53,0,18,0,5,1,261,681,120,26|63,5,0,0,1,0,0,0,48,707,200,50|64,3,23,0,19,0,4,1,143,707,118,26|65,2,54,0,19,0,5,1,261,707,120,26|66,5,0,0,1,0,0,0,48,733,200,50|67,3,20,0,15,0,4,1,143,733,118,26|68,2,51,0,15,0,5,1,261,733,120,26|69,5,0,0,1,0,0,0,48,759,200,50|70,3,27,0,35,0,4,1,143,759,118,26|71,2,70,0,35,0,5,1,261,759,120,26|72,5,0,0,1,0,0,0,48,785,200,50|73,3,14,0,31,0,4,1,4,785,118,26|74,3,12,0,31,0,4,1,143,785,118,26|75,2,49,0,31,0,5,1,261,785,120,26|76,5,0,0,1,0,0,0,20,811,200,50|77,2,50,0,31,0,5,1,0,811,143,26|78,3,13,0,36,0,4,1,143,811,118,26|79,2,48,0,36,0,5,1,261,811,120,26|80,5,0,0,1,0,0,0,20,837,200,50|81,2,67,0,32,0,4,1,143,837,118,26|82,2,68,0,32,0,5,1,261,837,120,26|83,2,69,0,32,0,198,1,11,863,370,26|84,3,9,0,14,0,4,1,143,889,118,26|85,2,9,0,14,0,5,1,261,889,120,26|86,3,11,0,14,0,4,1,143,915,118,26|87,2,10,0,14,0,5,1,261,915,120,26|88,5,0,0,1,0,0,0,20,941,200,50|89,3,24,0,20,0,4,1,143,941,118,26|90,2,59,0,20,0,5,1,261,941,120,26|91,2,21,0,1,0,192,1,0,967,384,26|92,2,22,0,1,0,192,1,0,993,384,26|93,2,23,0,1,0,192,1,0,1019,384,26|94,2,24,0,1,0,192,1,0,1045,384,26|95,2,73,0,1,0,192,1,0,1071,384,1\t\n" +
            "LAT\t8\tPF-8\t3,1,384,1072|6ZSA5ZSu5pe26Ze0OgktIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLQnllYblk4HlkI3np7AJ5ZWG5ZOB57yW5Y+3CeWNleS7twnph43ph48v5pWw6YePCemHkeminQnntK/orqE6CeWunuaUtumHkeminToJ5pS26ZO26YeR6aKdOgnmipjoiI3ph5Hpop06CeaJvumbtumHkeminToJ5Y2h5Y6f6aKdOgnljaHkvZnpop06CeWNoeWPtzoJ5Y2V5ZOB5pyN5Yqh6LS5CeacjeWKoei0uQnnqI7pop06CeWPsOWPtzoJ5ZCI6K6h6YeR6aKdOgnljaHmlK/ku5g6CeaUr+S7mDE6CeaUr+S7mDI6CeaUr+S7mDM6CeS8muWRmOenr+WIhjoJ5Y6f5Lu36YeR6aKdOgnoioLnnIHph5Hpop06CeWQieWNoeS6keaUr+S7mDoJCQkJ|0,6,1,0,1,0,192,1,0,0,384,26|1,2,0,0,1,0,192,1,0,26,384,26|2,2,17,0,1,0,192,1,0,52,384,26|3,2,18,0,1,0,192,1,0,78,384,26|4,2,19,0,1,0,192,1,0,104,384,26|5,2,20,0,1,0,192,1,0,130,384,26|6,2,2,0,1,0,4,1,0,156,84,26|7,2,47,0,1,0,4,1,84,156,30,26|8,2,31,0,1,0,5,1,128,156,125,26|9,2,26,0,1,0,5,1,259,156,125,26|10,5,0,0,1,0,0,0,20,182,200,50|11,3,0,0,1,0,4,1,0,182,114,26|12,2,3,0,1,0,0,1,115,182,140,26|13,2,4,0,1,0,6,1,270,182,112,26|14,3,1,0,1,0,192,0,0,208,384,16|15,3,2,0,1,0,4,1,0,224,104,26|16,3,3,0,1,0,5,1,181,224,160,26|17,3,4,0,1,0,4,1,14,250,76,26|18,3,5,0,1,0,5,1,99,250,172,26|19,3,6,0,1,0,5,1,280,250,104,26|20,3,1,0,1,0,192,0,0,276,384,15|21,5,0,0,1,0,0,0,50,291,200,50|22,1,0,0,1,0,4,1,0,291,180,26|23,1,0,6,1,0,5,1,180,291,200,26|24,1,0,4,1,0,6,1,0,317,96,26|25,1,0,1,1,0,4,1,192,317,96,26|26,1,0,26,1,0,6,1,288,317,96,26|27,5,2,0,1,0,0,0,20,343,200,50|28,5,2,0,1,0,0,0,21,395,200,50|29,1,0,19,1,0,4,1,0,395,128,26|30,1,0,20,1,0,5,1,128,395,128,26|31,1,0,21,1,0,6,1,256,395,128,26|32,5,2,0,1,0,0,0,50,421,200,50|33,3,17,0,13,0,4,1,15,421,140,26|34,1,0,29,13,0,5,1,170,421,50,26|35,1,0,27,13,0,6,1,220,421,150,26|36,5,2,0,1,0,0,0,50,447,200,50|37,3,15,0,11,0,4,1,15,447,140,26|38,1,0,28,11,0,6,1,220,447,150,26|39,5,0,0,1,0,0,0,50,473,200,50|40,3,1,0,1,0,192,0,0,473,384,18|41,3,16,0,12,0,4,1,15,491,140,26|42,2,44,0,12,0,6,1,220,491,150,26|43,5,0,0,1,0,0,0,38,517,200,50|44,3,25,0,34,0,4,1,151,517,118,26|45,2,71,0,34,0,5,1,269,517,112,26|46,3,26,0,34,0,4,1,151,543,118,26|47,2,72,0,34,0,5,1,269,543,112,26|48,5,0,0,1,0,0,0,38,569,200,50|49,3,19,0,16,0,4,1,151,569,118,26|50,2,28,0,16,0,5,1,269,569,112,26|51,3,10,0,16,0,4,1,151,595,118,26|52,2,29,0,16,0,5,1,269,595,112,26|53,5,0,0,1,0,0,0,38,621,200,50|54,3,8,0,1,0,5,2,4,621,200,34|55,2,27,0,1,0,5,2,221,621,160,34|56,5,0,0,1,0,0,0,20,655,200,50|57,3,21,0,17,0,4,1,143,655,118,26|58,2,52,0,17,0,5,1,261,655,120,26|59,5,0,0,1,0,0,0,48,681,200,50|60,3,22,0,18,0,4,1,143,681,118,26|61,2,53,0,18,0,5,1,261,681,120,26|62,5,0,0,1,0,0,0,48,707,200,50|63,3,23,0,19,0,4,1,143,707,118,26|64,2,54,0,19,0,5,1,261,707,120,26|65,5,0,0,1,0,0,0,48,733,200,50|66,3,20,0,15,0,4,1,143,733,118,26|67,2,51,0,15,0,5,1,261,733,120,26|68,5,0,0,1,0,0,0,48,759,200,50|69,3,27,0,35,0,4,1,143,759,118,26|70,2,70,0,35,0,5,1,261,759,120,26|71,5,0,0,1,0,0,0,48,785,200,50|72,3,14,0,31,0,4,1,4,785,118,26|73,3,12,0,31,0,4,1,143,785,118,26|74,2,49,0,31,0,5,1,261,785,120,26|75,5,0,0,1,0,0,0,20,811,200,50|76,2,50,0,31,0,5,1,0,811,143,26|77,3,13,0,36,0,4,1,143,811,118,26|78,2,48,0,36,0,5,1,261,811,120,26|79,5,0,0,1,0,0,0,20,837,200,50|80,2,67,0,32,0,4,1,143,837,118,26|81,2,68,0,32,0,5,1,261,837,120,26|82,2,69,0,32,0,198,1,11,863,370,26|83,3,9,0,14,0,4,1,143,889,118,26|84,2,9,0,14,0,5,1,261,889,120,26|85,3,11,0,14,0,4,1,143,915,118,26|86,2,10,0,14,0,5,1,261,915,120,26|87,5,0,0,1,0,0,0,20,941,200,50|88,3,24,0,20,0,4,1,143,941,118,26|89,2,59,0,20,0,5,1,261,941,120,26|90,2,21,0,1,0,192,1,0,967,384,26|91,2,22,0,1,0,192,1,0,993,384,26|92,2,23,0,1,0,192,1,0,1019,384,26|93,2,24,0,1,0,192,1,0,1045,384,26\t\n" +
            "LAT\t9\tPF-9\t3,1,384,1072|6ZSA5ZSu5pe26Ze0OgktIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLQnllYblk4EJCeWNleS7twnph43ph48v5pWw6YePCemHkeminQnntK/orqE6CeWunuaUtumHkeminToJ5pS26ZO26YeR6aKdOgnmipjoiI3ph5Hpop06CeaJvumbtumHkeminToJ5Y2h5Y6f6aKdOgnljaHkvZnpop06CeWNoeWPtzoJ5Y2V5ZOB5pyN5Yqh6LS5CeacjeWKoei0uQnnqI7pop06CeWPsOWPtzoJ5ZCI6K6h6YeR6aKdOgnljaHmlK/ku5g6CeaUr+S7mDE6CeaUr+S7mDI6CeaUr+S7mDM6CeS8muWRmOenr+WIhjoJ5Y6f5Lu36YeR6aKdOgnoioLnnIHph5Hpop06CeWQieWNoeS6keaUr+S7mDoJCQkJ|0,6,1,0,1,0,192,1,0,0,384,26|1,2,0,0,1,0,192,1,0,26,384,26|2,2,17,0,1,0,192,1,0,52,384,26|3,2,18,0,1,0,192,1,0,78,384,26|4,2,19,0,1,0,192,1,0,104,384,26|5,2,20,0,1,0,192,1,0,130,384,26|6,2,2,0,1,0,4,1,0,156,84,26|7,2,47,0,1,0,4,1,84,156,30,26|8,2,31,0,1,0,5,1,128,156,125,26|9,2,26,0,1,0,5,1,259,156,125,26|10,5,0,0,1,0,0,0,20,182,200,50|11,3,0,0,1,0,4,1,0,182,114,26|12,2,3,0,1,0,0,1,115,182,140,26|13,2,4,0,1,0,6,1,270,182,112,26|14,3,1,0,1,0,192,0,0,208,384,16|15,3,2,0,1,0,4,1,0,224,104,26|16,3,3,0,1,0,5,1,181,224,160,26|17,3,4,0,1,0,4,1,14,250,76,26|18,3,5,0,1,0,5,1,99,250,172,26|19,3,6,0,1,0,5,1,280,250,104,26|20,3,1,0,1,0,192,0,0,276,384,15|21,5,0,0,1,0,0,0,50,291,200,50|22,1,0,0,1,0,4,1,0,291,180,26|23,1,0,38,1,0,6,1,238,291,146,26|24,1,0,31,1,0,4,1,96,317,96,26|25,1,0,4,1,0,5,1,0,317,96,26|26,1,0,1,1,0,4,1,192,317,96,26|27,1,0,26,1,0,6,1,288,317,96,26|28,5,2,0,1,0,0,0,20,343,200,50|29,5,2,0,1,0,0,0,21,395,200,50|30,1,0,19,1,0,4,1,0,395,128,26|31,1,0,20,1,0,5,1,128,395,128,26|32,1,0,21,1,0,6,1,256,395,128,26|33,5,2,0,1,0,0,0,50,421,200,50|34,3,17,0,13,0,4,1,15,421,140,26|35,1,0,29,13,0,5,1,170,421,50,26|36,1,0,27,13,0,6,1,220,421,150,26|37,5,2,0,1,0,0,0,50,447,200,50|38,3,15,0,11,0,4,1,15,447,140,26|39,1,0,28,11,0,6,1,220,447,150,26|40,5,0,0,1,0,0,0,50,473,200,50|41,3,1,0,1,0,192,0,0,473,384,18|42,3,16,0,12,0,4,1,15,491,140,26|43,2,44,0,12,0,6,1,220,491,150,26|44,5,0,0,1,0,0,0,38,517,200,50|45,3,25,0,34,0,4,1,151,517,118,26|46,2,71,0,34,0,5,1,269,517,112,26|47,3,26,0,34,0,4,1,151,543,118,26|48,2,72,0,34,0,5,1,269,543,112,26|49,5,0,0,1,0,0,0,38,569,200,50|50,3,19,0,16,0,4,1,151,569,118,26|51,2,28,0,16,0,5,1,269,569,112,26|52,3,10,0,16,0,4,1,151,595,118,26|53,2,29,0,16,0,5,1,269,595,112,26|54,5,0,0,1,0,0,0,38,621,200,50|55,3,8,0,1,0,5,2,4,621,200,34|56,2,27,0,1,0,5,2,221,621,160,34|57,5,0,0,1,0,0,0,20,655,200,50|58,3,21,0,17,0,4,1,143,655,118,26|59,2,52,0,17,0,5,1,261,655,120,26|60,5,0,0,1,0,0,0,48,681,200,50|61,3,22,0,18,0,4,1,143,681,118,26|62,2,53,0,18,0,5,1,261,681,120,26|63,5,0,0,1,0,0,0,48,707,200,50|64,3,23,0,19,0,4,1,143,707,118,26|65,2,54,0,19,0,5,1,261,707,120,26|66,5,0,0,1,0,0,0,48,733,200,50|67,3,20,0,15,0,4,1,143,733,118,26|68,2,51,0,15,0,5,1,261,733,120,26|69,5,0,0,1,0,0,0,48,759,200,50|70,3,27,0,35,0,4,1,143,759,118,26|71,2,70,0,35,0,5,1,261,759,120,26|72,5,0,0,1,0,0,0,48,785,200,50|73,3,14,0,31,0,4,1,4,785,118,26|74,3,12,0,31,0,4,1,143,785,118,26|75,2,49,0,31,0,5,1,261,785,120,26|76,5,0,0,1,0,0,0,20,811,200,50|77,2,50,0,31,0,5,1,0,811,143,26|78,3,13,0,36,0,4,1,143,811,118,26|79,2,48,0,36,0,5,1,261,811,120,26|80,5,0,0,1,0,0,0,20,837,200,50|81,2,67,0,32,0,4,1,143,837,118,26|82,2,68,0,32,0,5,1,261,837,120,26|83,2,69,0,32,0,198,1,11,863,370,26|84,3,9,0,14,0,4,1,143,889,118,26|85,2,9,0,14,0,5,1,261,889,120,26|86,3,11,0,14,0,4,1,143,915,118,26|87,2,10,0,14,0,5,1,261,915,120,26|88,5,0,0,1,0,0,0,20,941,200,50|89,3,24,0,20,0,4,1,143,941,118,26|90,2,59,0,20,0,5,1,261,941,120,26|91,2,21,0,1,0,192,1,0,967,384,26|92,2,22,0,1,0,192,1,0,993,384,26|93,2,23,0,1,0,192,1,0,1019,384,26|94,2,24,0,1,0,192,1,0,1045,384,26\t\n" +
            //UA128 nutrition test
            //"LAT\t10\tPF-1\t1,1,448,168|QUFBQUFBQUFBQUEJUGVzbwlQZcOnYXM6CVRvdGFsCURhdGE6CVRlbXBvCVZhbGlkYWRlOglUYXJhOglUUAlUUAlQcmXDp28va2c6CXDDpwlQcmXDp28vcMOnOgkJCQkJCQkJCQkJCQkJCQkJCQk=|39,7,0,0,1,0,1,8,0,42,448,84|40,7,1,2,1,0,0,1,16,132,124,21|41,7,2,2,1,0,0,1,288,130,115,25|42,3,0,0,1,0,0,1,20,15,353,23\t\n" +
            "LAT\t10\tPF-1\t1,1,384,168|w4fDg0EwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkJUGVzbwlQZcOnYXM6CVRvdGFsCURhdGE6CVRlbXBvCVZhbGlkYWRlOglUYXJhOglUUAlUUAlQcmXDp28va2c6CXDDpwlQcmXDp28vcMOnOgkJCQkJCQkJCQkJCQkJCQkJCQk=|38,3,0,0,1,0,0,13,0,0,384,47|39,7,0,0,1,0,1,8,0,51,384,84|40,7,1,2,1,0,0,1,16,142,124,21|41,7,2,2,1,0,0,1,237,140,115,25\t\n" +
            "LAT\t11\tPF-11\t3,1,384,993|6ZSA5ZSu5pe26Ze0OgktIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLQnllYblk4HlkI3np7AJ5ZWG5ZOB57yW5Y+3CeWNleS7twnph43ph48v5pWw6YePCemHkeminQnntK/orqE6CeWunuaUtumHkeminToJ5pS26ZO26YeR6aKdOgnmipjoiI3ph5Hpop06CeaJvumbtumHkeminToJ5Y2h5Y6f6aKdOgnljaHkvZnpop06CeWNoeWPtzoJ5Y2V5ZOB5pyN5Yqh6LS5CeacjeWKoei0uQnnqI7pop06CeWPsOWPtzoJ5ZCI6K6hOgnljaHmlK/ku5g6CeaUr+S7mDE6CeaUr+S7mDI6CeaUr+S7mDM6CeS8muWRmOenr+WIhjoJ5pS26LSn5Lq65L+h5oGv77yaCeaUtui0p+S6uuWcsOWdgO+8mgkJCQkJ|0,6,1,0,1,0,0,1,0,0,384,26|1,5,0,0,1,0,0,0,20,26,200,50|2,2,0,0,1,0,0,1,0,26,384,26|3,5,0,0,1,0,0,0,20,52,200,50|4,2,17,0,1,0,5,1,0,52,384,26|5,5,0,0,1,0,0,0,20,78,200,50|6,2,18,0,1,0,5,1,0,78,384,26|7,5,0,0,1,0,0,0,20,104,200,50|8,2,19,0,1,0,5,1,0,104,384,26|9,5,0,0,1,0,0,0,20,130,200,50|10,2,2,0,1,0,4,1,0,131,84,26|12,2,47,0,1,0,4,1,84,131,30,26|13,2,31,0,1,0,5,1,128,131,125,26|14,2,26,0,1,0,5,1,259,131,125,26|15,5,0,0,1,0,0,0,20,157,200,50|16,3,0,0,1,0,4,1,0,157,114,26|17,2,3,0,1,0,0,1,115,157,140,26|18,2,4,0,1,0,6,1,270,157,112,26|19,3,1,0,1,0,5,0,0,183,384,16|20,5,0,0,1,0,0,0,38,199,200,50|21,3,2,0,1,0,4,1,0,199,104,26|22,3,3,0,1,0,5,1,181,199,160,26|23,3,4,0,1,0,4,1,14,225,76,26|24,3,5,0,1,0,5,1,99,225,172,26|25,3,6,0,1,0,5,1,280,225,104,26|26,3,1,0,1,0,5,0,0,251,384,15|27,5,0,0,1,0,0,0,38,266,200,50|28,1,0,0,1,0,4,1,0,266,180,26|29,1,0,6,1,0,5,1,180,266,200,26|30,5,2,0,1,0,0,0,20,292,200,50|31,5,2,0,1,0,0,0,20,344,200,50|32,1,0,20,1,0,4,1,0,344,128,26|33,1,0,21,1,0,5,1,128,344,128,26|34,1,0,22,1,0,6,1,256,344,128,26|35,5,2,0,1,0,0,0,21,370,200,50|36,1,0,4,1,0,6,1,0,370,96,26|37,1,0,1,1,0,4,1,192,370,96,26|38,1,0,26,1,0,6,1,288,370,96,26|39,5,2,0,1,0,0,0,50,396,200,50|40,3,17,0,13,0,4,1,15,396,140,26|41,1,0,29,13,0,5,1,170,396,50,26|42,1,0,27,13,0,6,1,220,396,150,26|43,5,2,0,1,0,0,0,50,422,200,50|44,3,15,0,11,0,4,1,15,422,140,26|45,1,0,28,11,0,6,1,220,422,150,26|46,5,0,0,1,0,0,0,50,448,200,50|47,3,1,0,1,0,5,0,0,448,384,18|48,5,0,0,1,0,0,0,38,466,200,50|49,3,16,0,12,0,4,1,15,466,140,26|50,2,44,0,12,0,6,1,220,466,150,26|51,5,0,0,1,0,0,0,38,492,200,50|52,3,19,0,16,0,4,1,151,492,118,26|53,2,28,0,16,0,5,1,269,492,112,26|54,3,10,0,16,0,4,1,151,518,118,26|55,2,29,0,16,0,5,1,269,518,112,26|56,5,0,0,1,0,0,0,38,544,200,50|57,3,8,0,1,0,5,2,4,544,200,34|58,2,27,0,1,0,5,2,221,544,160,34|59,5,0,0,1,0,0,0,20,578,200,50|60,3,21,0,17,0,4,1,143,578,118,26|61,2,52,0,17,0,5,1,261,578,120,26|62,5,0,0,1,0,0,0,48,604,200,50|63,3,22,0,18,0,4,1,143,604,118,26|64,2,53,0,18,0,5,1,261,604,120,26|65,5,0,0,1,0,0,0,48,630,200,50|66,3,23,0,19,0,4,1,143,630,118,26|67,2,54,0,19,0,5,1,261,630,120,26|68,5,0,0,1,0,0,0,48,656,200,50|69,3,20,0,15,0,4,1,143,656,118,26|70,2,51,0,15,0,5,1,261,656,120,26|71,5,0,0,1,0,0,0,48,682,200,50|72,3,14,0,31,0,4,1,4,682,118,26|73,3,12,0,31,0,4,1,143,682,118,26|74,2,49,0,31,0,5,1,261,682,120,26|75,2,50,0,31,0,5,1,0,708,143,26|76,3,13,0,31,0,4,1,143,708,118,26|77,2,48,0,31,0,5,1,261,708,120,26|78,5,0,0,1,0,0,0,20,734,200,50|79,2,67,0,32,0,4,1,143,734,118,26|80,2,68,0,32,0,5,1,261,734,120,26|81,5,0,0,1,0,0,0,20,760,200,50|82,2,69,0,32,0,6,1,11,760,370,26|83,5,0,0,1,0,0,0,20,786,200,50|84,3,9,0,14,0,4,1,143,786,118,26|85,2,9,0,14,0,5,1,261,786,120,26|86,3,11,0,14,0,4,1,143,812,118,26|87,2,10,0,14,0,5,1,261,812,120,26|88,5,0,0,1,0,0,0,20,838,200,50|89,3,24,0,20,0,4,1,143,838,118,26|90,2,59,0,20,0,5,1,261,838,120,26|91,5,0,0,1,0,0,0,20,864,200,50|92,2,21,0,1,0,5,1,0,864,384,26|93,5,0,0,1,0,0,0,20,890,200,50|94,3,25,0,1,0,5,1,0,890,128,26|95,9,0,0,1,0,5,1,128,890,256,26|96,5,0,0,1,0,0,0,20,916,200,50|97,3,26,0,1,0,5,1,0,916,128,26|98,9,1,0,1,0,5,1,128,916,256,26|99,5,0,0,1,0,0,0,20,943,200,50\t\n" +
            "END\tLAT\t\n" +
            "\n" +
            "#TMS_Max\t0\t999\t\n" +
            "#TMS_Max\t1\t999\t\n" +
            "#TMS_Max\t2\t9999999\t\n" +
            "#TMS_Max\t3\t99\t\n" +
            "#TMS_Max\t4\t1\t\n" +
            "#TMS_Max\t5\t999\t\n" +
            "#TMS_Max\t6\t999\t\n" +
            "#TMS_Max\t7\t9999999\t\n" +
            "#TMS_Max\t8\t99\t\n" +
            "#TMS_Max\t9\t1\t\n" +
            "#TMS_Max\t10\t999\t\n" +
            "#TMS_Max\t11\t999\t\n" +
            "#TMS_Max\t12\t9999999\t\n" +
            "#TMS_Max\t13\t99\t\n" +
            "#TMS_Max\t14\t1\t\n" +
            "#TMS_Max\t15\t999\t\n" +
            "#TMS_Max\t16\t999\t\n" +
            "#TMS_Max\t17\t9999999\t\n" +
            "#TMS_Max\t18\t99\t\n" +
            "#TMS_Max\t19\t1\t\n" +
            "#TMS_Max\t20\t999\t\n" +
            "#TMS_Max\t21\t1\t\n" +
            "#TMS_Max\t22\t15\t\n" +
            "#TMS_Max\t23\t16\t\n" +
            "#TMS_Max\t24\t99\t\n" +
            "#TMS_Max\t25\t99\t\n" +
            "#TMS_Max\t26\t1999\t\n" +
            "#TMS_Max\t27\t99\t\n" +
            "#TMS_Max\t28\t5\t\n" +
            "#TMS_Max\t29\t30\t\n" +
            "#TMS_Max\t30\t999\t\n" +
            "#TMS_Max\t31\t9\t\n" +
            "#TMS_Max\t32\t19\t\n" +
            "#TMS_Max\t33\t3\t\n" +
            "#TMS_Max\t34\t19\t\n" +
            "#TMS_Max\t35\t1\t\n" +
            "#TMS_Max\t36\t2\t\n" +
            "#TMS_Max\t37\t31\t\n" +
            "#TMS_Max\t38\t31\t\n" +
            "#TMS_Max\t39\t1999\t\n" +
            "#TMS_Max\t40\t9999999\t\n" +
            "#TMS_Max\t41\t9\t\n" +
            "#TMS_Max\t42\t2\t\n" +
            "#TMS_Max\t43\t2\t\n" +
            "#TMS_Max\t44\t65535\t\n" +
            "#TMS_Max\t45\t1\t\n" +
            "#TMS_Max\t46\t9999999\t\n" +
            "#TMS_Max\t47\t1\t\n" +
            "#TMS_Max\t48\t31\t\n" +
            "#TMS_Max\t49\t1\t\n" +
            "#TMS_Max\t50\t7\t\n" +
            "#TMS_Max\t51\t2\t\n" +
            "#TMS_Max\t52\t0\t\n" +
            "#TMS_Max\t53\t0\t\n" +
            "#TMS_Max\t54\t99\t\n" +
            "#TMS_Max\t55\t99\t\n" +
            "#TMS_Max\t56\t9\t\n" +
            "#TMS_Max\t57\t99\t\n" +
            "#TMS_Max\t58\t3\t\n" +
            "#TMS_Max\t59\t1\t\n" +
            "#TMS_Max\t60\t3\t\n" +
            "#TMS_Max\t61\t16777215\t\n" +
            "#TMS_Max\t62\t4\t\n" +
            "#TMS_Max\t63\t3\t\n" +
            "#TMS_Max\t64\t3\t\n" +
            "#TMS_Max\t65\t6\t\n" +
            "#TMS_Max\t66\t99\t\n" +
            "#TMS_Max\t67\t2\t\n" +
            "#TMS_Max\t68\t3\t\n" +
            "#TMS_Max\t69\t4\t\n" +
            "#TMS_Max\t70\t1\t\n" +
            "#TMS_Max\t71\t2\t\n" +
            "#TMS_Max\t72\t1\t\n" +
            "#TMS_Max\t73\t1\t\n" +
            "#TMS_Max\t74\t9999\t\n" +
            "#TMS_Max\t75\t3\t\n" +
            "#TMS_Max\t76\t3\t\n" +
            "#TMS_Max\t77\t3\t\n" +
            "#TMS_Max\t78\t4\t\n" +
            "#TMS_Max\t79\t1\t\n" +
            "#TMS_Max\t80\t1\t\n" +
            "#TMS_Max\t81\t3\t\n" +
            "#TMS_Max\t82\t2\t\n" +
            "#TMS_Max\t83\t4\t\n" +
            "#TMS_Max\t84\t1\t\n" +
            "#TMS_Max\t85\t99\t\n" +
            "#TMS_Max\t86\t99\t\n" +
            "#TMS_Max\t87\t0\t\n" +
            "#TMS_Max\t88\t9999999\t\n" +
            "#TMS_Max\t89\t1\t\n" +
            "#TMS_Max\t90\t1\t\n" +
            "#TMS_Max\t91\t2\t\n" +
            "#TMS_Max\t92\t3\t\n" +
            "#TMS_Max\t93\t9999999\t\n" +
            "#TMS_Max\t94\t9999999\t\n" +
            "#TMS_Max\t95\t9999999\t\n" +
            "#TMS_Max\t96\t2\t\n" +
            "#TMS_Max\t97\t1\t\n" +
            "#TMS_Max\t98\t5\t\n" +
            "#TMS_Max\t99\t5\t\n" +
            "#TMS_Max\t100\t11\t\n" +
            "#TMS_Max\t101\t11\t\n" +
            "#TMS_Max\t102\t1\t\n" +
            "#TMS_Max\t103\t3\t\n" +
            "#TMS_Max\t104\t255\t\n" +
            "#TMS_Max\t105\t7\t\n" +
            "#TMS_Max\t106\t999\t\n" +
            "#TMS_Max\t107\t99\t\n" +
            "#TMS_Max\t108\t65535\t\n" +
            "#TMS_Max\t109\t1\t\n" +
            "#TMS_Max\t110\t3\t\n" +
            "#TMS_Max\t111\t255\t\n" +
            "#TMS_Max\t112\t255\t\n" +
            "#TMS_Max\t113\t2\t\n" +
            "#TMS_Max\t114\t99\t\n" +
            "#TMS_Max\t115\t3\t\n" +
            "#TMS_Max\t116\t3\t\n" +
            "#TMS_Max\t117\t9999\t\n" +
            "#TMS_Max\t118\t4\t\n" +
            "#TMS_Max\t119\t2\t\n" +
            "#TMS_Max\t120\t3\t\n" +
            "#TMS_Max\t121\t2\t\n" +
            "#TMS_Max\t122\t99\t\n" +
            "#TMS_Max\t123\t9999999\t\n" +
            "#TMS_Max\t124\t99\t\n" +
            "#TMS_Max\t125\t9999999\t\n" +
            "#TMS_Max\t126\t99\t\n" +
            "#TMS_Max\t127\t9999999\t\n" +
            "#TMS_Max\t128\t99\t\n" +
            "#TMS_Max\t129\t9999999\t\n" +
            "#TMS_Max\t130\t99\t\n" +
            "#TMS_Max\t131\t8\t\n" +
            "#TMS_Max\t132\t2\t\n" +
            "#TMS_Max\t133\t2\t\n" +
            "#TMS_Max\t134\t2\t\n" +
            "#TMS_Max\t135\t6\t\n" +
            "#TMS_Max\t136\t2\t\n" +
            "#TMS_Max\t137\t2\t\n" +
            "#TMS_Max\t138\t65535\t\n" +
            "#TMS_Max\t139\t2\t\n" +
            "#TMS_Max\t140\t6\t\n" +
            "#TMS_Max\t141\t2\t\n" +
            "#TMS_Max\t142\t0\t\n" +
            "#TMS_Max\t143\t29\t\n" +
            "#TMS_Max\t144\t3\t\n" +
            "#TMS_Max\t145\t9999999\t\n" +
            "#TMS_Max\t146\t9999999\t\n" +
            "#TMS_Max\t147\t0\t\n" +
            "#TMS_Max\t148\t1\t\n" +
            "#TMS_Max\t149\t3\t\n" +
            "#TMS_Max\t150\t255\t\n" +
            "#TMS_Max\t151\t255\t\n" +
            "#TMS_Max\t152\t255\t\n" +
            "#TMS_Max\t153\t255\t\n" +
            "#TMS_Max\t154\t255\t\n" +
            "#TMS_Max\t155\t255\t\n" +
            "#TMS_Max\t156\t255\t\n" +
            "#TMS_Max\t157\t255\t\n" +
            "#TMS_Max\t158\t255\t\n" +
            "#TMS_Max\t159\t255\t\n" +
            "#TMS_Max\t160\t255\t\n" +
            "#TMS_Max\t161\t255\t\n" +
            "#TMS_Max\t162\t255\t\n" +
            "#TMS_Max\t163\t255\t\n" +
            "#TMS_Max\t164\t255\t\n" +
            "#TMS_Max\t165\t255\t\n" +
            "#TMS_Max\t166\t65535\t\n" +
            "#TMS_Max\t167\t65535\t\n" +
            "#TMS_Max\t168\t65535\t\n" +
            "#TMS_Max\t169\t65535\t\n" +
            "#TMS_Max\t170\t255\t\n" +
            "#TMS_Max\t171\t255\t\n" +
            "#TMS_Max\t172\t255\t\n" +
            "#TMS_Max\t173\t255\t\n" +
            "#TMS_Max\t174\t0\t\n" +
            "#TMS_Max\t175\t0\t\n" +
            "#TMS_Max\t176\t0\t\n" +
            "#TMS_Max\t177\t0\t\n" +
            "#TMS_Max\t178\t0\t\n" +
            "#TMS_Max\t179\t9\t\n" +
            "#TMS_Max\t180\t1\t\n" +
            "#TMS_Max\t181\t3\t\n" +
            "#TMS_Max\t182\t1\t\n" +
            "#TMS_Max\t183\t0\t\n" +
            "#TMS_Max\t184\t0\t\n" +
            "#TMS_Max\t185\t1\t\n" +
            "#TMS_Max\t186\t1\t\n" +
            "#TMS_Max\t187\t1\t\n" +
            "#TMS_Max\t188\t6\t\n" +
            "#TMS_Max\t189\t7\t\n" +
            "#TMS_Max\t190\t3\t\n" +
            "#TMS_Max\t191\t3\t\n" +
            "#TMS_Max\t192\t31\t\n" +
            "#TMS_Max\t193\t2\t\n" +
            "#TMS_Max\t194\t7\t\n" +
            "#TMS_Max\t195\t7\t\n" +
            "#TMS_Max\t196\t5\t\n" +
            "#TMS_Max\t197\t4\t\n" +
            "#TMS_Max\t198\t19\t\n" +
            "#TMS_Max\t199\t19\t\n" +
            "#TMS_Max\t200\t3\t\n" +
            "#TMS_Max\t201\t3\t\n" +
            "#TMS_Max\t202\t5\t\n" +
            "#TMS_Max\t203\t5\t\n" +
            "#TMS_Max\t204\t1\t\n" +
            "#TMS_Max\t205\t1\t\n" +
            "#TMS_Max\t206\t3\t\n" +
            "#TMS_Max\t207\t2\t\n" +
            "#TMS_Max\t208\t5\t\n" +
            "#TMS_Max\t209\t5\t\n" +
            "#TMS_Max\t210\t9\t\n" +
            "#TMS_Max\t211\t9\t\n" +
            "#TMS_Max\t212\t9\t\n" +
            "#TMS_Max\t213\t3\t\n" +
            "#TMS_Max\t214\t1\t\n" +
            "#TMS_Max\t215\t9999999\t\n" +
            "#TMS_Max\t216\t9999999\t\n" +
            "#TMS_Max\t217\t99\t\n" +
            "#TMS_Max\t218\t9999999\t\n" +
            "#TMS_Max\t219\t255\t\n" +
            "#TMS_Max\t220\t255\t\n" +
            "#TMS_Max\t221\t99\t\n" +
            "#TMS_Max\t222\t99\t\n" +
            "#TMS_Max\t223\t255\t\n" +
            "#TMS_Max\t224\t99\t\n" +
            "#TMS_Max\t225\t99\t\n" +
            "#TMS_Max\t226\t3\t\n" +
            "#TMS_Max\t227\t2\t\n" +
            "#TMS_Max\t228\t5\t\n" +
            "#TMS_Max\t229\t2\t\n" +
            "#TMS_Max\t230\t31\t\n" +
            "#TMS_Max\t231\t1\t\n" +
            "#TMS_Max\t232\t2\t\n" +
            "#TMS_Max\t233\t1\t\n" +
            "#TMS_Max\t234\t31\t\n" +
            "#TMS_Max\t235\t2\t\n" +
            "#TMS_Max\t236\t15\t\n" +
            "#TMS_Max\t237\t4\t\n" +
            "#TMS_Max\t238\t7\t\n" +
            "#TMS_Max\t239\t9999\t\n" +
            "#TMS_Max\t240\t64\t\n" +
            "#TMS_Max\t241\t1\t\n" +
            "#TMS_Max\t242\t31\t\n" +
            "#TMS_Max\t243\t3\t\n" +
            "#TMS_Max\t244\t1\t\n" +
            "#TMS_Max\t245\t3\t\n" +
            "#TMS_Max\t246\t255\t\n" +
            "#TMS_Max\t247\t3\t\n" +
            "#TMS_Max\t248\t255\t\n" +
            "#TMS_Max\t249\t4\t\n" +
            "#TMS_Max\t250\t2\t\n" +
            "#TMS_Max\t251\t4\t\n" +
            "#TMS_Max\t252\t4\t\n" +
            "#TMS_Max\t253\t1\t\n" +
            "#TMS_Max\t254\t3\t\n" +
            "#TMS_Max\t255\t11\t\n" +
            "#TMS_Max\t256\t6\t\n" +
            "#TMS_Max\t257\t7\t\n" +
            "#TMS_Max\t258\t31\t\n" +
            "#TMS_Max\t259\t15\t\n" +
            "#TMS_Max\t260\t31\t\n" +
            "#TMS_Max\t261\t15\t\n" +
            "#TMS_Max\t262\t15\t\n" +
            "#TMS_Max\t263\t9999999\t\n" +
            "#TMS_Max\t264\t15\t\n" +
            "#TMS_Max\t265\t1\t\n" +
            "#TMS_Max\t266\t1\t\n" +
            "#TMS_Max\t267\t1\t\n" +
            "#TMS_Max\t268\t1\t\n" +
            "#TMS_Max\t269\t255\t\n" +
            "#TMS_Max\t270\t5\t\n" +
            "#TMS_Max\t271\t1\t\n" +
            "#TMS_Max\t272\t31\t\n" +
            "#TMS_Max\t273\t5\t\n" +
            "#TMS_Max\t274\t9999999\t\n" +
            "#TMS_Max\t275\t2\t\n" +
            "#TMS_Max\t276\t31\t\n" +
            "#TMS_Max\t277\t4\t\n" +
            "#TMS_Max\t278\t99\t\n" +
            "#TMS_Max\t279\t3\t\n" +
            "#TMS_Max\t280\t1\t\n" +
            "#TMS_Max\t281\t31\t\n" +
            "#TMS_Max\t282\t65535\t\n" +
            "#TMS_Max\t283\t3\t\n" +
            "#TMS_Max\t284\t31\t\n" +
            "#TMS_Max\t285\t2\t\n" +
            "#TMS_Max\t286\t3\t\n" +
            "#TMS_Max\t287\t255\t\n" +
            "#TMS_Max\t288\t255\t\n" +
            "#TMS_Max\t289\t99\t\n" +
            "#TMS_Max\t290\t99\t\n" +
            "#TMS_Max\t291\t99\t\n" +
            "#TMS_Max\t292\t99\t\n" +
            "#TMS_Max\t293\t99\t\n" +
            "#TMS_Max\t294\t15\t\n" +
            "#TMS_Max\t295\t15\t\n" +
            "#TMS_Max\t296\t4\t\n" +
            "#TMS_Max\t297\t2147483647\t\n" +
            "#TMS_Max\t298\t5\t\n" +
            "#TMS_Max\t299\t0\t\n" +
            "#TMS_Max\t300\t2\t\n" +
            "#TMS_Max\t301\t2\t\n" +
            "#TMS_Max\t302\t5\t\n" +
            "#TMS_Max\t303\t9999\t\n" +
            "#TMS_Max\t304\t1\t\n" +
            "#TMS_Max\t305\t3\t\n" +
            "#TMS_Max\t306\t9999\t\n" +
            "#TMS_Max\t307\t1\t\n" +
            "#TMS_Max\t308\t1\t\n" +
            "#TMS_Max\t309\t0\t\n" +
            "#TMS_Max\t310\t0\t\n" +
            "#TMS_Max\t311\t0\t\n" +
            "#TMS_Max\t312\t0\t\n" +
            "#TMS_Max\t313\t0\t\n" +
            "#TMS_Max\t314\t0\t\n" +
            "#TMS_Max\t315\t0\t\n" +
            "#TMS_Max\t316\t0\t\n" +
            "#TMS_Max\t317\t0\t\n" +
            "#TMS_Max\t318\t9999999\t\n" +
            "#TMS_Max\t319\t9999999\t\n" +
            "#TMS_Max\t320\t1\t\n" +
            "#TMS_Max\t321\t15\t\n" +
            "#TMS_Max\t322\t0\t\n" +
            "#TMS_Max\t323\t0\t\n" +
            "#TMS_Max\t324\t0\t\n" +
            "#TMS_Max\t325\t0\t\n" +
            "#TMS_Max\t326\t0\t\n" +
            "#TMS_Max\t327\t0\t\n" +
            "#TMS_Max\t328\t0\t\n" +
            "#TMS_Max\t329\t0\t\n" +
            "#TMS_Max\t330\t255\t\n" +
            "#TMS_Max\t331\t255\t\n" +
            "#TMS_Max\t332\t255\t\n" +
            "#TMS_Max\t333\t255\t\n" +
            "#TMS_Max\t334\t255\t\n" +
            "#TMS_Max\t335\t255\t\n" +
            "#TMS_Max\t336\t65535\t\n" +
            "#TMS_Max\t337\t0\t\n" +
            "#TMS_Max\t338\t0\t\n" +
            "#TMS_Max\t339\t0\t\n" +
            "#TMS_Max\t340\t15\t\n" +
            "#TMS_Max\t341\t31\t\n" +
            "#TMS_Max\t342\t0\t\n" +
            "#TMS_Max\t343\t0\t\n" +
            "#TMS_Max\t344\t0\t\n" +
            "#TMS_Max\t345\t0\t\n" +
            "#TMS_Max\t346\t0\t\n" +
            "#TMS_Max\t347\t0\t\n" +
            "#TMS_Max\t348\t0\t\n" +
            "#TMS_Max\t349\t0\t\n" +
            "#TMS_Max\t350\t99\t\n" +
            "#TMS_Max\t351\t99\t\n" +
            "#TMS_Max\t352\t9999999\t\n" +
            "#TMS_Max\t353\t99\t\n" +
            "#TMS_Max\t354\t1\t\n" +
            "#TMS_Max\t355\t99\t\n" +
            "#TMS_Max\t356\t99\t\n" +
            "#TMS_Max\t357\t9999999\t\n" +
            "#TMS_Max\t358\t99\t\n" +
            "#TMS_Max\t359\t1\t\n" +
            "#TMS_Max\t360\t255\t\n" +
            "#TMS_Max\t361\t3\t\n" +
            "#TMS_Max\t362\t20\t\n" +
            "#TMS_Max\t363\t65535\t\n" +
            "#TMS_Max\t364\t255\t\n" +
            "#TMS_Max\t365\t255\t\n" +
            "#TMS_Max\t366\t255\t\n" +
            "#TMS_Max\t367\t255\t\n" +
            "#TMS_Max\t368\t255\t\n" +
            "#TMS_Max\t369\t255\t\n" +
            "#TMS_Max\t370\t255\t\n" +
            "#TMS_Max\t371\t255\t\n" +
            "#TMS_Max\t372\t255\t\n" +
            "#TMS_Max\t373\t255\t\n" +
            "#TMS_Max\t374\t255\t\n" +
            "#TMS_Max\t375\t255\t\n" +
            "#TMS_Max\t376\t65535\t\n" +
            "#TMS_Max\t377\t65535\t\n" +
            "#TMS_Max\t378\t65535\t\n" +
            "#TMS_Max\t379\t65535\t\n" +
            "#TMS_Max\t380\t0\t\n" +
            "#TMS_Max\t381\t0\t\n" +
            "#TMS_Max\t382\t0\t\n" +
            "#TMS_Max\t383\t0\t\n" +
            "#TMS_Max\t384\t0\t\n" +
            "#TMS_Max\t385\t0\t\n" +
            "#TMS_Max\t386\t0\t\n" +
            "#TMS_Max\t387\t0\t\n" +
            "#TMS_Max\t388\t0\t\n" +
            "#TMS_Max\t389\t0\t\n" +
            "#TMS_Max\t390\t0\t\n" +
            "#TMS_Max\t391\t0\t\n" +
            "#TMS_Max\t392\t0\t\n" +
            "#TMS_Max\t393\t0\t\n" +
            "#TMS_Max\t394\t0\t\n" +
            "#TMS_Max\t395\t0\t\n" +
            "#TMS_Max\t396\t0\t\n" +
            "#TMS_Max\t397\t0\t\n" +
            "#TMS_Max\t398\t0\t\n" +
            "#TMS_Max\t399\t0\t\n" +
            "#TMS_Max\t400\t99\t\n" +
            "#TMS_Max\t401\t1\t\n" +
            "#TMS_Max\t402\t15\t\n" +
            "#TMS_Max\t403\t15\t\n" +
            "#TMS_Max\t404\t99\t\n" +
            "#TMS_Max\t405\t99\t\n" +
            "#TMS_Max\t406\t99\t\n" +
            "#TMS_Max\t407\t99\t\n" +
            "#TMS_Max\t408\t5\t\n" +
            "#TMS_Max\t409\t30\t\n" +
            "#TMS_Max\t410\t999\t\n" +
            "#TMS_Max\t411\t9\t\n" +
            "#TMS_Max\t412\t19\t\n" +
            "#TMS_Max\t413\t2\t\n" +
            "#TMS_Max\t414\t0\t\n" +
            "#TMS_Max\t415\t1\t\n" +
            "#TMS_Max\t416\t2\t\n" +
            "#TMS_Max\t417\t31\t\n" +
            "#TMS_Max\t418\t31\t\n" +
            "#TMS_Max\t419\t1999\t\n" +
            "#TMS_Max\t420\t1\t\n" +
            "#TMS_Max\t421\t1\t\n" +
            "#TMS_Max\t422\t255\t\n" +
            "#TMS_Max\t423\t0\t\n" +
            "#TMS_Max\t424\t0\t\n" +
            "#TMS_Max\t425\t0\t\n" +
            "#TMS_Max\t426\t0\t\n" +
            "#TMS_Max\t427\t0\t\n" +
            "#TMS_Max\t428\t0\t\n" +
            "#TMS_Max\t429\t0\t\n" +
            "#TMS_Max\t430\t255\t\n" +
            "#TMS_Max\t431\t255\t\n" +
            "#TMS_Max\t432\t255\t\n" +
            "#TMS_Max\t433\t255\t\n" +
            "#TMS_Max\t434\t255\t\n" +
            "#TMS_Max\t435\t255\t\n" +
            "#TMS_Max\t436\t255\t\n" +
            "#TMS_Max\t437\t255\t\n" +
            "#TMS_Max\t438\t255\t\n" +
            "#TMS_Max\t439\t255\t\n" +
            "#TMS_Max\t440\t255\t\n" +
            "#TMS_Max\t441\t255\t\n" +
            "#TMS_Max\t442\t0\t\n" +
            "#TMS_Max\t443\t0\t\n" +
            "#TMS_Max\t444\t0\t\n" +
            "#TMS_Max\t445\t0\t\n" +
            "#TMS_Max\t446\t0\t\n" +
            "#TMS_Max\t447\t0\t\n" +
            "#TMS_Max\t448\t2147483647\t\n" +
            "#TMS_Max\t449\t3\t\n" +
            "#TMS_Max\t450\t9\t\n" +
            "#TMS_Max\t451\t30\t\n" +
            "#TMS_Max\t452\t99\t\n" +
            "#TMS_Max\t453\t6\t\n" +
            "#TMS_Max\t454\t18\t\n" +
            "#TMS_Max\t455\t3\t\n" +
            "#TMS_Max\t456\t31\t\n" +
            "#TMS_Max\t457\t6\t\n" +
            "#TMS_Max\t458\t0\t\n" +
            "#TMS_Max\t459\t0\t\n" +
            "#TMS_Max\t460\t0\t\n" +
            "#TMS_Max\t461\t0\t\n" +
            "#TMS_Max\t462\t0\t\n" +
            "#TMS_Max\t463\t0\t\n" +
            "#TMS_Max\t464\t0\t\n" +
            "#TMS_Max\t465\t0\t\n" +
            "#TMS_Max\t466\t0\t\n" +
            "#TMS_Max\t467\t0\t\n" +
            "#TMS_Max\t468\t0\t\n" +
            "#TMS_Max\t469\t0\t\n" +
            "#TMS_Max\t470\t0\t\n" +
            "#TMS_Max\t471\t0\t\n" +
            "#TMS_Max\t472\t0\t\n" +
            "#TMS_Max\t473\t0\t\n" +
            "#TMS_Max\t474\t0\t\n" +
            "#TMS_Max\t475\t0\t\n" +
            "#TMS_Max\t476\t0\t\n" +
            "#TMS_Max\t477\t2147483647\t\n" +
            "#TMS_Max\t478\t2147483647\t\n" +
            "#TMS_Max\t479\t2147483647\t\n" +
            "#TMS_Max\t480\t2147483647\t\n" +
            "#TMS_Max\t481\t2147483647\t\n" +
            "#TMS_Max\t482\t2147483647\t\n" +
            "#TMS_Max\t483\t2147483647\t\n" +
            "#TMS_Max\t484\t2147483647\t\n" +
            "#TMS_Max\t485\t2147483647\t\n" +
            "#TMS_Max\t486\t2147483647\t\n" +
            "#TMS_Max\t487\t2147483647\t\n" +
            "#TMS_Max\t488\t2147483647\t\n" +
            "#TMS_Max\t489\t2147483647\t\n" +
            "#TMS_Max\t490\t2147483647\t\n" +
            "#TMS_Max\t491\t2147483647\t\n" +
            "#TMS_Max\t492\t2147483647\t\n" +
            "#TMS_Max\t493\t2147483647\t\n" +
            "#TMS_Max\t494\t2147483647\t\n" +
            "#TMS_Max\t495\t2147483647\t\n" +
            "#TMS_Max\t496\t2147483647\t\n" +
            "#TMS_Max\t497\t2147483647\t\n" +
            "#TMS_Max\t498\t2147483647\t\n" +
            "#TMS_Max\t499\t2147483647\t\n" +
            "\n" +
            "#TMS_Access\t0\t0\t\n" +
            "#TMS_Access\t1\t0\t\n" +
            "#TMS_Access\t2\t0\t\n" +
            "#TMS_Access\t3\t1\t\n" +
            "#TMS_Access\t4\t1\t\n" +
            "#TMS_Access\t5\t0\t\n" +
            "#TMS_Access\t6\t0\t\n" +
            "#TMS_Access\t7\t0\t\n" +
            "#TMS_Access\t8\t1\t\n" +
            "#TMS_Access\t9\t1\t\n" +
            "#TMS_Access\t10\t1\t\n" +
            "#TMS_Access\t11\t1\t\n" +
            "#TMS_Access\t12\t1\t\n" +
            "#TMS_Access\t13\t1\t\n" +
            "#TMS_Access\t14\t1\t\n" +
            "#TMS_Access\t15\t1\t\n" +
            "#TMS_Access\t16\t1\t\n" +
            "#TMS_Access\t17\t1\t\n" +
            "#TMS_Access\t18\t1\t\n" +
            "#TMS_Access\t19\t1\t\n" +
            "#TMS_Access\t20\t1\t\n" +
            "#TMS_Access\t21\t0\t\n" +
            "#TMS_Access\t22\t0\t\n" +
            "#TMS_Access\t23\t0\t\n" +
            "#TMS_Access\t24\t0\t\n" +
            "#TMS_Access\t25\t0\t\n" +
            "#TMS_Access\t26\t1\t\n" +
            "#TMS_Access\t27\t0\t\n" +
            "#TMS_Access\t28\t1\t\n" +
            "#TMS_Access\t29\t1\t\n" +
            "#TMS_Access\t30\t1\t\n" +
            "#TMS_Access\t31\t1\t\n" +
            "#TMS_Access\t32\t1\t\n" +
            "#TMS_Access\t33\t1\t\n" +
            "#TMS_Access\t34\t1\t\n" +
            "#TMS_Access\t35\t1\t\n" +
            "#TMS_Access\t36\t1\t\n" +
            "#TMS_Access\t37\t1\t\n" +
            "#TMS_Access\t38\t1\t\n" +
            "#TMS_Access\t39\t1\t\n" +
            "#TMS_Access\t40\t0\t\n" +
            "#TMS_Access\t41\t0\t\n" +
            "#TMS_Access\t42\t0\t\n" +
            "#TMS_Access\t43\t0\t\n" +
            "#TMS_Access\t44\t0\t\n" +
            "#TMS_Access\t45\t1\t\n" +
            "#TMS_Access\t46\t1\t\n" +
            "#TMS_Access\t47\t1\t\n" +
            "#TMS_Access\t48\t1\t\n" +
            "#TMS_Access\t49\t1\t\n" +
            "#TMS_Access\t50\t1\t\n" +
            "#TMS_Access\t51\t1\t\n" +
            "#TMS_Access\t52\t1\t\n" +
            "#TMS_Access\t53\t3\t\n" +
            "#TMS_Access\t54\t1\t\n" +
            "#TMS_Access\t55\t1\t\n" +
            "#TMS_Access\t56\t1\t\n" +
            "#TMS_Access\t57\t1\t\n" +
            "#TMS_Access\t58\t1\t\n" +
            "#TMS_Access\t59\t0\t\n" +
            "#TMS_Access\t60\t0\t\n" +
            "#TMS_Access\t61\t0\t\n" +
            "#TMS_Access\t62\t0\t\n" +
            "#TMS_Access\t63\t0\t\n" +
            "#TMS_Access\t64\t0\t\n" +
            "#TMS_Access\t65\t1\t\n" +
            "#TMS_Access\t66\t0\t\n" +
            "#TMS_Access\t67\t0\t\n" +
            "#TMS_Access\t68\t0\t\n" +
            "#TMS_Access\t69\t0\t\n" +
            "#TMS_Access\t70\t1\t\n" +
            "#TMS_Access\t71\t0\t\n" +
            "#TMS_Access\t72\t1\t\n" +
            "#TMS_Access\t73\t0\t\n" +
            "#TMS_Access\t74\t0\t\n" +
            "#TMS_Access\t75\t1\t\n" +
            "#TMS_Access\t76\t1\t\n" +
            "#TMS_Access\t77\t0\t\n" +
            "#TMS_Access\t78\t0\t\n" +
            "#TMS_Access\t79\t0\t\n" +
            "#TMS_Access\t80\t0\t\n" +
            "#TMS_Access\t81\t0\t\n" +
            "#TMS_Access\t82\t0\t\n" +
            "#TMS_Access\t83\t0\t\n" +
            "#TMS_Access\t84\t0\t\n" +
            "#TMS_Access\t85\t0\t\n" +
            "#TMS_Access\t86\t0\t\n" +
            "#TMS_Access\t87\t3\t\n" +
            "#TMS_Access\t88\t1\t\n" +
            "#TMS_Access\t89\t1\t\n" +
            "#TMS_Access\t90\t1\t\n" +
            "#TMS_Access\t91\t1\t\n" +
            "#TMS_Access\t92\t1\t\n" +
            "#TMS_Access\t93\t1\t\n" +
            "#TMS_Access\t94\t1\t\n" +
            "#TMS_Access\t95\t1\t\n" +
            "#TMS_Access\t96\t1\t\n" +
            "#TMS_Access\t97\t1\t\n" +
            "#TMS_Access\t98\t1\t\n" +
            "#TMS_Access\t99\t1\t\n" +
            "#TMS_Access\t100\t0\t\n" +
            "#TMS_Access\t101\t0\t\n" +
            "#TMS_Access\t102\t1\t\n" +
            "#TMS_Access\t103\t1\t\n" +
            "#TMS_Access\t104\t1\t\n" +
            "#TMS_Access\t105\t0\t\n" +
            "#TMS_Access\t106\t0\t\n" +
            "#TMS_Access\t107\t1\t\n" +
            "#TMS_Access\t108\t1\t\n" +
            "#TMS_Access\t109\t3\t\n" +
            "#TMS_Access\t110\t1\t\n" +
            "#TMS_Access\t111\t0\t\n" +
            "#TMS_Access\t112\t0\t\n" +
            "#TMS_Access\t113\t0\t\n" +
            "#TMS_Access\t114\t0\t\n" +
            "#TMS_Access\t115\t1\t\n" +
            "#TMS_Access\t116\t1\t\n" +
            "#TMS_Access\t117\t1\t\n" +
            "#TMS_Access\t118\t1\t\n" +
            "#TMS_Access\t119\t1\t\n" +
            "#TMS_Access\t120\t1\t\n" +
            "#TMS_Access\t121\t1\t\n" +
            "#TMS_Access\t122\t0\t\n" +
            "#TMS_Access\t123\t0\t\n" +
            "#TMS_Access\t124\t1\t\n" +
            "#TMS_Access\t125\t1\t\n" +
            "#TMS_Access\t126\t1\t\n" +
            "#TMS_Access\t127\t1\t\n" +
            "#TMS_Access\t128\t1\t\n" +
            "#TMS_Access\t129\t1\t\n" +
            "#TMS_Access\t130\t1\t\n" +
            "#TMS_Access\t131\t1\t\n" +
            "#TMS_Access\t132\t1\t\n" +
            "#TMS_Access\t133\t1\t\n" +
            "#TMS_Access\t134\t1\t\n" +
            "#TMS_Access\t135\t1\t\n" +
            "#TMS_Access\t136\t1\t\n" +
            "#TMS_Access\t137\t1\t\n" +
            "#TMS_Access\t138\t1\t\n" +
            "#TMS_Access\t139\t1\t\n" +
            "#TMS_Access\t140\t1\t\n" +
            "#TMS_Access\t141\t1\t\n" +
            "#TMS_Access\t142\t1\t\n" +
            "#TMS_Access\t143\t1\t\n" +
            "#TMS_Access\t144\t1\t\n" +
            "#TMS_Access\t145\t1\t\n" +
            "#TMS_Access\t146\t1\t\n" +
            "#TMS_Access\t147\t3\t\n" +
            "#TMS_Access\t148\t1\t\n" +
            "#TMS_Access\t149\t1\t\n" +
            "#TMS_Access\t150\t0\t\n" +
            "#TMS_Access\t151\t0\t\n" +
            "#TMS_Access\t152\t0\t\n" +
            "#TMS_Access\t153\t0\t\n" +
            "#TMS_Access\t154\t0\t\n" +
            "#TMS_Access\t155\t0\t\n" +
            "#TMS_Access\t156\t0\t\n" +
            "#TMS_Access\t157\t0\t\n" +
            "#TMS_Access\t158\t0\t\n" +
            "#TMS_Access\t159\t0\t\n" +
            "#TMS_Access\t160\t0\t\n" +
            "#TMS_Access\t161\t0\t\n" +
            "#TMS_Access\t162\t0\t\n" +
            "#TMS_Access\t163\t0\t\n" +
            "#TMS_Access\t164\t0\t\n" +
            "#TMS_Access\t165\t0\t\n" +
            "#TMS_Access\t166\t1\t\n" +
            "#TMS_Access\t167\t1\t\n" +
            "#TMS_Access\t168\t1\t\n" +
            "#TMS_Access\t169\t1\t\n" +
            "#TMS_Access\t170\t0\t\n" +
            "#TMS_Access\t171\t0\t\n" +
            "#TMS_Access\t172\t0\t\n" +
            "#TMS_Access\t173\t0\t\n" +
            "#TMS_Access\t174\t3\t\n" +
            "#TMS_Access\t175\t3\t\n" +
            "#TMS_Access\t176\t3\t\n" +
            "#TMS_Access\t177\t3\t\n" +
            "#TMS_Access\t178\t3\t\n" +
            "#TMS_Access\t179\t1\t\n" +
            "#TMS_Access\t180\t1\t\n" +
            "#TMS_Access\t181\t1\t\n" +
            "#TMS_Access\t182\t2\t\n" +
            "#TMS_Access\t183\t3\t\n" +
            "#TMS_Access\t184\t3\t\n" +
            "#TMS_Access\t185\t1\t\n" +
            "#TMS_Access\t186\t1\t\n" +
            "#TMS_Access\t187\t1\t\n" +
            "#TMS_Access\t188\t1\t\n" +
            "#TMS_Access\t189\t1\t\n" +
            "#TMS_Access\t190\t1\t\n" +
            "#TMS_Access\t191\t1\t\n" +
            "#TMS_Access\t192\t1\t\n" +
            "#TMS_Access\t193\t1\t\n" +
            "#TMS_Access\t194\t1\t\n" +
            "#TMS_Access\t195\t1\t\n" +
            "#TMS_Access\t196\t1\t\n" +
            "#TMS_Access\t197\t1\t\n" +
            "#TMS_Access\t198\t1\t\n" +
            "#TMS_Access\t199\t1\t\n" +
            "#TMS_Access\t200\t1\t\n" +
            "#TMS_Access\t201\t1\t\n" +
            "#TMS_Access\t202\t1\t\n" +
            "#TMS_Access\t203\t1\t\n" +
            "#TMS_Access\t204\t1\t\n" +
            "#TMS_Access\t205\t1\t\n" +
            "#TMS_Access\t206\t1\t\n" +
            "#TMS_Access\t207\t1\t\n" +
            "#TMS_Access\t208\t1\t\n" +
            "#TMS_Access\t209\t1\t\n" +
            "#TMS_Access\t210\t1\t\n" +
            "#TMS_Access\t211\t1\t\n" +
            "#TMS_Access\t212\t1\t\n" +
            "#TMS_Access\t213\t2\t\n" +
            "#TMS_Access\t214\t1\t\n" +
            "#TMS_Access\t215\t2\t\n" +
            "#TMS_Access\t216\t1\t\n" +
            "#TMS_Access\t217\t1\t\n" +
            "#TMS_Access\t218\t2\t\n" +
            "#TMS_Access\t219\t2\t\n" +
            "#TMS_Access\t220\t2\t\n" +
            "#TMS_Access\t221\t2\t\n" +
            "#TMS_Access\t222\t2\t\n" +
            "#TMS_Access\t223\t1\t\n" +
            "#TMS_Access\t224\t1\t\n" +
            "#TMS_Access\t225\t1\t\n" +
            "#TMS_Access\t226\t1\t\n" +
            "#TMS_Access\t227\t1\t\n" +
            "#TMS_Access\t228\t1\t\n" +
            "#TMS_Access\t229\t1\t\n" +
            "#TMS_Access\t230\t1\t\n" +
            "#TMS_Access\t231\t1\t\n" +
            "#TMS_Access\t232\t1\t\n" +
            "#TMS_Access\t233\t1\t\n" +
            "#TMS_Access\t234\t1\t\n" +
            "#TMS_Access\t235\t1\t\n" +
            "#TMS_Access\t236\t1\t\n" +
            "#TMS_Access\t237\t1\t\n" +
            "#TMS_Access\t238\t1\t\n" +
            "#TMS_Access\t239\t1\t\n" +
            "#TMS_Access\t240\t1\t\n" +
            "#TMS_Access\t241\t3\t\n" +
            "#TMS_Access\t242\t1\t\n" +
            "#TMS_Access\t243\t1\t\n" +
            "#TMS_Access\t244\t1\t\n" +
            "#TMS_Access\t245\t1\t\n" +
            "#TMS_Access\t246\t1\t\n" +
            "#TMS_Access\t247\t1\t\n" +
            "#TMS_Access\t248\t1\t\n" +
            "#TMS_Access\t249\t1\t\n" +
            "#TMS_Access\t250\t1\t\n" +
            "#TMS_Access\t251\t1\t\n" +
            "#TMS_Access\t252\t1\t\n" +
            "#TMS_Access\t253\t1\t\n" +
            "#TMS_Access\t254\t1\t\n" +
            "#TMS_Access\t255\t1\t\n" +
            "#TMS_Access\t256\t1\t\n" +
            "#TMS_Access\t257\t1\t\n" +
            "#TMS_Access\t258\t1\t\n" +
            "#TMS_Access\t259\t1\t\n" +
            "#TMS_Access\t260\t1\t\n" +
            "#TMS_Access\t261\t1\t\n" +
            "#TMS_Access\t262\t1\t\n" +
            "#TMS_Access\t263\t1\t\n" +
            "#TMS_Access\t264\t1\t\n" +
            "#TMS_Access\t265\t1\t\n" +
            "#TMS_Access\t266\t1\t\n" +
            "#TMS_Access\t267\t1\t\n" +
            "#TMS_Access\t268\t1\t\n" +
            "#TMS_Access\t269\t1\t\n" +
            "#TMS_Access\t270\t1\t\n" +
            "#TMS_Access\t271\t1\t\n" +
            "#TMS_Access\t272\t1\t\n" +
            "#TMS_Access\t273\t1\t\n" +
            "#TMS_Access\t274\t1\t\n" +
            "#TMS_Access\t275\t1\t\n" +
            "#TMS_Access\t276\t1\t\n" +
            "#TMS_Access\t277\t1\t\n" +
            "#TMS_Access\t278\t1\t\n" +
            "#TMS_Access\t279\t1\t\n" +
            "#TMS_Access\t280\t1\t\n" +
            "#TMS_Access\t281\t1\t\n" +
            "#TMS_Access\t282\t1\t\n" +
            "#TMS_Access\t283\t1\t\n" +
            "#TMS_Access\t284\t1\t\n" +
            "#TMS_Access\t285\t1\t\n" +
            "#TMS_Access\t286\t1\t\n" +
            "#TMS_Access\t287\t1\t\n" +
            "#TMS_Access\t288\t1\t\n" +
            "#TMS_Access\t289\t1\t\n" +
            "#TMS_Access\t290\t1\t\n" +
            "#TMS_Access\t291\t1\t\n" +
            "#TMS_Access\t292\t1\t\n" +
            "#TMS_Access\t293\t1\t\n" +
            "#TMS_Access\t294\t1\t\n" +
            "#TMS_Access\t295\t1\t\n" +
            "#TMS_Access\t296\t1\t\n" +
            "#TMS_Access\t297\t1\t\n" +
            "#TMS_Access\t298\t1\t\n" +
            "#TMS_Access\t299\t3\t\n" +
            "#TMS_Access\t300\t1\t\n" +
            "#TMS_Access\t301\t1\t\n" +
            "#TMS_Access\t302\t1\t\n" +
            "#TMS_Access\t303\t1\t\n" +
            "#TMS_Access\t304\t1\t\n" +
            "#TMS_Access\t305\t1\t\n" +
            "#TMS_Access\t306\t1\t\n" +
            "#TMS_Access\t307\t1\t\n" +
            "#TMS_Access\t308\t1\t\n" +
            "#TMS_Access\t309\t3\t\n" +
            "#TMS_Access\t310\t3\t\n" +
            "#TMS_Access\t311\t3\t\n" +
            "#TMS_Access\t312\t3\t\n" +
            "#TMS_Access\t313\t3\t\n" +
            "#TMS_Access\t314\t3\t\n" +
            "#TMS_Access\t315\t3\t\n" +
            "#TMS_Access\t316\t3\t\n" +
            "#TMS_Access\t317\t3\t\n" +
            "#TMS_Access\t318\t1\t\n" +
            "#TMS_Access\t319\t1\t\n" +
            "#TMS_Access\t320\t1\t\n" +
            "#TMS_Access\t321\t1\t\n" +
            "#TMS_Access\t322\t3\t\n" +
            "#TMS_Access\t323\t3\t\n" +
            "#TMS_Access\t324\t3\t\n" +
            "#TMS_Access\t325\t3\t\n" +
            "#TMS_Access\t326\t3\t\n" +
            "#TMS_Access\t327\t3\t\n" +
            "#TMS_Access\t328\t3\t\n" +
            "#TMS_Access\t329\t3\t\n" +
            "#TMS_Access\t330\t1\t\n" +
            "#TMS_Access\t331\t3\t\n" +
            "#TMS_Access\t332\t0\t\n" +
            "#TMS_Access\t333\t0\t\n" +
            "#TMS_Access\t334\t0\t\n" +
            "#TMS_Access\t335\t0\t\n" +
            "#TMS_Access\t336\t0\t\n" +
            "#TMS_Access\t337\t3\t\n" +
            "#TMS_Access\t338\t3\t\n" +
            "#TMS_Access\t339\t3\t\n" +
            "#TMS_Access\t340\t1\t\n" +
            "#TMS_Access\t341\t1\t\n" +
            "#TMS_Access\t342\t3\t\n" +
            "#TMS_Access\t343\t3\t\n" +
            "#TMS_Access\t344\t3\t\n" +
            "#TMS_Access\t345\t3\t\n" +
            "#TMS_Access\t346\t3\t\n" +
            "#TMS_Access\t347\t3\t\n" +
            "#TMS_Access\t348\t3\t\n" +
            "#TMS_Access\t349\t3\t\n" +
            "#TMS_Access\t350\t0\t\n" +
            "#TMS_Access\t351\t0\t\n" +
            "#TMS_Access\t352\t0\t\n" +
            "#TMS_Access\t353\t1\t\n" +
            "#TMS_Access\t354\t1\t\n" +
            "#TMS_Access\t355\t0\t\n" +
            "#TMS_Access\t356\t0\t\n" +
            "#TMS_Access\t357\t0\t\n" +
            "#TMS_Access\t358\t1\t\n" +
            "#TMS_Access\t359\t1\t\n" +
            "#TMS_Access\t360\t0\t\n" +
            "#TMS_Access\t361\t1\t\n" +
            "#TMS_Access\t362\t1\t\n" +
            "#TMS_Access\t363\t1\t\n" +
            "#TMS_Access\t364\t0\t\n" +
            "#TMS_Access\t365\t0\t\n" +
            "#TMS_Access\t366\t0\t\n" +
            "#TMS_Access\t367\t0\t\n" +
            "#TMS_Access\t368\t0\t\n" +
            "#TMS_Access\t369\t0\t\n" +
            "#TMS_Access\t370\t0\t\n" +
            "#TMS_Access\t371\t0\t\n" +
            "#TMS_Access\t372\t0\t\n" +
            "#TMS_Access\t373\t0\t\n" +
            "#TMS_Access\t374\t0\t\n" +
            "#TMS_Access\t375\t0\t\n" +
            "#TMS_Access\t376\t1\t\n" +
            "#TMS_Access\t377\t1\t\n" +
            "#TMS_Access\t378\t1\t\n" +
            "#TMS_Access\t379\t1\t\n" +
            "#TMS_Access\t380\t3\t\n" +
            "#TMS_Access\t381\t3\t\n" +
            "#TMS_Access\t382\t3\t\n" +
            "#TMS_Access\t383\t3\t\n" +
            "#TMS_Access\t384\t3\t\n" +
            "#TMS_Access\t385\t3\t\n" +
            "#TMS_Access\t386\t3\t\n" +
            "#TMS_Access\t387\t3\t\n" +
            "#TMS_Access\t388\t3\t\n" +
            "#TMS_Access\t389\t3\t\n" +
            "#TMS_Access\t390\t3\t\n" +
            "#TMS_Access\t391\t3\t\n" +
            "#TMS_Access\t392\t3\t\n" +
            "#TMS_Access\t393\t3\t\n" +
            "#TMS_Access\t394\t3\t\n" +
            "#TMS_Access\t395\t3\t\n" +
            "#TMS_Access\t396\t3\t\n" +
            "#TMS_Access\t397\t3\t\n" +
            "#TMS_Access\t398\t3\t\n" +
            "#TMS_Access\t399\t3\t\n" +
            "#TMS_Access\t400\t1\t\n" +
            "#TMS_Access\t401\t1\t\n" +
            "#TMS_Access\t402\t1\t\n" +
            "#TMS_Access\t403\t1\t\n" +
            "#TMS_Access\t404\t1\t\n" +
            "#TMS_Access\t405\t1\t\n" +
            "#TMS_Access\t406\t1\t\n" +
            "#TMS_Access\t407\t1\t\n" +
            "#TMS_Access\t408\t1\t\n" +
            "#TMS_Access\t409\t1\t\n" +
            "#TMS_Access\t410\t1\t\n" +
            "#TMS_Access\t411\t1\t\n" +
            "#TMS_Access\t412\t1\t\n" +
            "#TMS_Access\t413\t1\t\n" +
            "#TMS_Access\t414\t3\t\n" +
            "#TMS_Access\t415\t1\t\n" +
            "#TMS_Access\t416\t1\t\n" +
            "#TMS_Access\t417\t1\t\n" +
            "#TMS_Access\t418\t1\t\n" +
            "#TMS_Access\t419\t1\t\n" +
            "#TMS_Access\t420\t1\t\n" +
            "#TMS_Access\t421\t1\t\n" +
            "#TMS_Access\t422\t1\t\n" +
            "#TMS_Access\t423\t3\t\n" +
            "#TMS_Access\t424\t3\t\n" +
            "#TMS_Access\t425\t3\t\n" +
            "#TMS_Access\t426\t3\t\n" +
            "#TMS_Access\t427\t3\t\n" +
            "#TMS_Access\t428\t3\t\n" +
            "#TMS_Access\t429\t3\t\n" +
            "#TMS_Access\t430\t0\t\n" +
            "#TMS_Access\t431\t0\t\n" +
            "#TMS_Access\t432\t0\t\n" +
            "#TMS_Access\t433\t0\t\n" +
            "#TMS_Access\t434\t0\t\n" +
            "#TMS_Access\t435\t0\t\n" +
            "#TMS_Access\t436\t0\t\n" +
            "#TMS_Access\t437\t0\t\n" +
            "#TMS_Access\t438\t0\t\n" +
            "#TMS_Access\t439\t0\t\n" +
            "#TMS_Access\t440\t0\t\n" +
            "#TMS_Access\t441\t0\t\n" +
            "#TMS_Access\t442\t3\t\n" +
            "#TMS_Access\t443\t3\t\n" +
            "#TMS_Access\t444\t3\t\n" +
            "#TMS_Access\t445\t3\t\n" +
            "#TMS_Access\t446\t3\t\n" +
            "#TMS_Access\t447\t3\t\n" +
            "#TMS_Access\t448\t1\t\n" +
            "#TMS_Access\t449\t1\t\n" +
            "#TMS_Access\t450\t1\t\n" +
            "#TMS_Access\t451\t1\t\n" +
            "#TMS_Access\t452\t1\t\n" +
            "#TMS_Access\t453\t1\t\n" +
            "#TMS_Access\t454\t1\t\n" +
            "#TMS_Access\t455\t1\t\n" +
            "#TMS_Access\t456\t1\t\n" +
            "#TMS_Access\t457\t1\t\n" +
            "#TMS_Access\t458\t3\t\n" +
            "#TMS_Access\t459\t3\t\n" +
            "#TMS_Access\t460\t3\t\n" +
            "#TMS_Access\t461\t3\t\n" +
            "#TMS_Access\t462\t3\t\n" +
            "#TMS_Access\t463\t3\t\n" +
            "#TMS_Access\t464\t3\t\n" +
            "#TMS_Access\t465\t3\t\n" +
            "#TMS_Access\t466\t3\t\n" +
            "#TMS_Access\t467\t3\t\n" +
            "#TMS_Access\t468\t3\t\n" +
            "#TMS_Access\t469\t3\t\n" +
            "#TMS_Access\t470\t3\t\n" +
            "#TMS_Access\t471\t3\t\n" +
            "#TMS_Access\t472\t3\t\n" +
            "#TMS_Access\t473\t3\t\n" +
            "#TMS_Access\t474\t3\t\n" +
            "#TMS_Access\t475\t3\t\n" +
            "#TMS_Access\t476\t3\t\n" +
            "#TMS_Access\t477\t1\t\n" +
            "#TMS_Access\t478\t1\t\n" +
            "#TMS_Access\t479\t1\t\n" +
            "#TMS_Access\t480\t1\t\n" +
            "#TMS_Access\t481\t1\t\n" +
            "#TMS_Access\t482\t1\t\n" +
            "#TMS_Access\t483\t1\t\n" +
            "#TMS_Access\t484\t1\t\n" +
            "#TMS_Access\t485\t1\t\n" +
            "#TMS_Access\t486\t1\t\n" +
            "#TMS_Access\t487\t1\t\n" +
            "#TMS_Access\t488\t1\t\n" +
            "#TMS_Access\t489\t1\t\n" +
            "#TMS_Access\t490\t1\t\n" +
            "#TMS_Access\t491\t1\t\n" +
            "#TMS_Access\t492\t1\t\n" +
            "#TMS_Access\t493\t1\t\n" +
            "#TMS_Access\t494\t1\t\n" +
            "#TMS_Access\t495\t1\t\n" +
            "#TMS_Access\t496\t1\t\n" +
            "#TMS_Access\t497\t1\t\n" +
            "#TMS_Access\t498\t1\t\n" +
            "#TMS_Access\t499\t3\t\n" +
            "\n" +
            //"#SpWMUnit\tF,6\t\n" +          //在国内版本中增加这行，用于禁止lb
            "\n" +
            "#SpFNT\t30\t\n" +
            "\n" +
            "#SpWMN\t30\t0\t3\t3\t35000\t0\t0\t10\t0\t0\t\n" +
            "#SpWMN\t30\t0\t4\t0\t35000\t0\t0\t10\t0\t0\t\n" +
            "#SpWMN\t30\t0\t6\t3\t70000\t0\t0\t20\t0\t0\t\n" +
            "#SpWMN\t30\t1\t3\t3\t35000\t15000\t0\t10\t5\t0\t\n" +
            "#SpWMN\t30\t1\t4\t0\t35000\t15000\t0\t10\t5\t0\t\n" +
            "#SpWMN\t30\t1\t6\t3\t70000\t30000\t0\t20\t10\t0\t\n" +
            "#SpWMN\t30\t2\t3\t3\t35000\t15000\t6000\t10\t5\t2\t\n" +
            "#SpWMN\t30\t2\t4\t0\t35000\t15000\t6000\t10\t5\t2\t\n" +
            "#SpWMN\t30\t2\t6\t3\t70000\t30000\t15000\t20\t10\t5\t\n" +
            "#SpWMN\t30\t3\t3\t3\t35000\t15000\t6000\t5\t2\t1\t\n" +
            "#SpWMN\t30\t3\t4\t0\t35000\t15000\t6000\t5\t2\t1\t\n" +
            "#SpWMN\t30\t3\t6\t3\t70000\t30000\t15000\t10\t5\t2\t\n" +
            "#SpWMN\t35\t0\t3\t3\t35000\t0\t0\t10\t0\t0\t\n" +
            "#SpWMN\t35\t0\t4\t0\t35000\t0\t0\t10\t0\t0\t\n" +
            "#SpWMN\t35\t0\t6\t3\t70000\t0\t0\t20\t0\t0\t\n" +
            "#SpWMN\t35\t1\t3\t3\t35000\t15000\t0\t10\t5\t0\t\n" +
            "#SpWMN\t35\t1\t4\t0\t35000\t15000\t0\t10\t5\t0\t\n" +
            "#SpWMN\t35\t1\t6\t3\t70000\t30000\t0\t20\t10\t0\t\n" +
            "#SpWMN\t35\t2\t3\t3\t35000\t15000\t6000\t10\t5\t2\t\n" +
            "#SpWMN\t35\t2\t4\t0\t35000\t15000\t6000\t10\t5\t2\t\n" +
            "#SpWMN\t35\t2\t6\t3\t70000\t30000\t15000\t20\t10\t5\t\n" +
            "#SpWMN\t35\t3\t3\t3\t35000\t15000\t6000\t5\t2\t1\t\n" +
            "#SpWMN\t35\t3\t4\t0\t35000\t15000\t6000\t5\t2\t1\t\n" +
            "#SpWMN\t35\t3\t6\t3\t70000\t30000\t15000\t10\t5\t2\t\n" +
            "\n" +
            "#SpDWL\tNU3\t1\t\n" +
            "#SpDWL\tSU2\t1\t\n" +
            "#SpDWL\tIR2\t1\t\n";// +
    // "\n" +
    // "#SpVersion\t0\n" +
    // "\n" +
    // "#SpSegs\tAAA|BBB\n";

    /**
     * @description: 初始化全局参数
     **/
    public static void initGlobalPara() {
        GlobalPara.getInstance()
                .setSystemID("SCOPAAISG2704A0E126626")
                .setRunLog(true)
        ;
//                .setPriceUNIT(7)
//                .setPointOfPrice(2)
//                .setPointOfMoney(2)
//                .setMoneyPrefix("¥")
//                .setMoneySuffix("")
//                .setPrintUnitWAmount(true)
//                .setPrintUnitWPrice(true)
//                .setPrintUnitWTotal(true)
//                .setPointOfBarcodeMoney(2)
//                .setPointOfBarcodeWeight(3)
//                .setPointOfBarcodePcs(0)
//                .setDateFormat("yyyy-MM-dd")
//                .setTimeFormat("HH:mm:ss")
//                .setSpec_ShelfDay_Days(1)
//                .setSpec_ShelfDay_Type(10)
//                .setLang_Days("Days")
//                .setLang_Hours("Hours");

        GlobalPara.getInstance()
                .Init_Encrypt_Decrypt(new JRSAEncryptDecrypt())
                .TMS_Receive_MultiLine(TMX_CONF, true);
        GlobalPara.getInstance().TMS_Receive_MultiLine(
                "DWL\tAAA\t\n" +
                        "AAA\t1\t9\t92\t\n" +
                        "AAA\t2\t2\t22\t\n" +
                        "AAA\t3\t20\t230\t\n" +
                        "END\tAAA\t\n" +
                        "DWL\tBBB\t\n" +
                        "BBB\t3\t9\t92\t\n" +
                        "BBB\t4\t2\t22\t\n" +
                        "BBB\t5\t20\t230\t\n" +
                        "END\tBBB\t\n"
        );

        // GlobalPara.getInstance().setPrivilege(true);

        GlobalPara.getInstance().setTMS(213, 1);

        BigDecimal price = GlobalPara.getInstance().CalPLU_Price_wUnit(BigDecimal.ONE, 6);
        int unit = GlobalPara.getInstance().CalPLU_PriceUnit_wUnit(6);

//        GlobalPara.getInstance().AddBarcode(1, "Barcode-1", "MDAwMDAwMDAwMDAwMDAwMDpCMjAxRTUwMEs1MDBBMDAwQTAwMEEwMDA=");
//        GlobalPara.getInstance().AddBarcode(2, "Barcode-2", "MDAwMDAwMDAwMDAwMDAwMDpCMjAxRjUwMUs1MDBBMDAwQTAwMEEwMDA=");
//        GlobalPara.getInstance().AddBarcode(3, "Barcode-3", "MDAwMDAwMDAwMDAwMDAwMDpGNzAxSzUwMEEwMDBBMDAwQTAwMEEwMDA=");
//        GlobalPara.getInstance().AddBarcode(4, "Barcode-4", "MDAwMDAwMDAwMDAwMDAwMDpCMjAxRTQwMEs2MDBBMDAwQTAwMEEwMDA=");
//        GlobalPara.getInstance().AddBarcode(5, "Barcode-5", "MDAwMDAwMDAwMDAwMDAwMDpCMjAxRjQwMUs2MDBBMDAwQTAwMEEwMDA=");
//        GlobalPara.getInstance().AddBarcode(6, "Barcode-6", "MDAwMDAwMDAwMDAwMDAwMDpGNjAxSzYwMEEwMDBBMDAwQTAwMEEwMDA=");
//        GlobalPara.getInstance().AddBarcode(7, "Barcode-7", "MDAwMDAwMDAwMDAwMDAwMDpCNzAxTDUwMEEwMDBBMDAwQTAwMEEwMDA=");
//        GlobalPara.getInstance().AddBarcode(8, "Barcode-8", "MDAwMDAwMDAwMDAwMDAwMDpCNjAxTDYwMEEwMDBBMDAwQTAwMEEwMDA=");
//        GlobalPara.getInstance().AddBarcode(9, "Barcode-9", "MDAwMDAwMDAwMDAwMDAwMDpCNTAxTDcwMEEwMDBBMDAwQTAwMEEwMDA=");
//
//        GlobalPara.getInstance().AddPrintFormat(1, "PF-1", "1,1,432,296|5Y2V5Lu3CeWHgOmHjQnmlbDph48J5oC75Lu3CemUgOWUruaXpeacnwnplIDllK7ml7bpl7QJ5pyJ5pWI5pel5pyfCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQ==|0,0,0,0,1,0,5,1,0,88,281,113|1,2,0,0,1,0,5,1,0,240,432,26|2,2,1,0,1,0,5,1,0,266,431,26|3,2,3,0,1,0,5,0,1,220,138,20|4,2,4,0,1,0,5,0,141,220,136,20|5,1,0,6,1,0,5,0,362,0,70,34|6,1,0,0,1,0,5,2,0,0,362,34|7,1,0,1,1,0,5,1,139,60,141,26|8,2,27,0,1,0,5,2,282,60,149,34|9,1,0,4,1,0,5,1,0,60,137,26|10,1,0,15,9,0,5,0,280,220,148,20|11,1,0,16,1,0,5,0,285,94,147,107|12,1,0,24,1,0,4,1,236,34,57,26|13,1,0,25,1,0,4,1,82,34,60,26|14,2,16,0,1,0,4,1,380,34,42,26|15,3,0,0,1,0,6,1,0,34,80,26|16,3,1,0,2,0,6,1,160,34,74,26|17,3,2,0,3,0,6,1,160,34,74,26|18,3,3,0,1,0,6,1,300,34,72,26|19,3,4,0,1,0,5,0,2,202,138,18|20,3,5,0,1,0,5,0,142,202,134,18|21,3,6,0,9,0,5,0,283,202,144,18");
//        GlobalPara.getInstance().AddPrintFormat(2, "PF-2", "1,1,304,216|5Y2V5Lu3CeWHgOmHjQnmlbDph48J5oC75Lu3CeacieaViOacnwkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQ==|0,0,0,0,1,0,5,0,0,70,242,97|1,2,0,0,1,0,5,1,0,185,304,26|2,2,3,0,1,0,5,0,2,167,100,18|3,2,4,0,1,0,5,0,105,167,80,18|4,1,0,6,1,0,5,0,251,70,53,30|5,1,0,0,1,0,5,1,0,0,304,26|6,1,0,1,1,0,5,0,104,47,91,18|7,2,27,0,1,0,5,1,197,44,107,26|8,1,0,4,1,0,5,0,0,47,104,18|9,1,0,15,9,0,5,0,204,167,100,18|10,1,0,24,1,0,4,0,160,26,50,18|11,1,0,25,1,0,4,0,50,26,50,18|12,2,16,0,1,0,4,0,264,26,30,18|13,3,0,0,1,0,6,0,0,26,50,18|14,3,1,0,2,0,6,0,110,26,50,18|15,3,2,0,3,0,6,0,110,26,50,18|16,3,3,0,1,0,6,0,214,26,50,18|17,3,4,0,9,0,5,0,250,149,54,18");
//        GlobalPara.getInstance().AddPrintFormat(3, "PF-3", "1,1,432,232|5Y2V5Lu3CeWHgOmHjQnmlbDph48J5oC75Lu3CemUgOWUruaXpeacnwnplIDllK7ml7bpl7QJ5pyJ5pWI5pel5pyfCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQ==|0,0,0,0,1,0,5,1,0,80,281,93|1,2,0,0,1,0,5,2,0,193,431,34|2,2,3,0,1,0,5,0,0,173,138,20|3,2,4,0,1,0,5,0,139,173,136,20|4,1,0,6,1,0,5,0,362,0,70,34|5,1,0,0,1,0,5,2,0,0,362,34|6,1,0,1,1,0,5,1,140,54,141,26|7,2,27,0,1,0,5,2,282,60,149,34|8,1,0,4,1,0,5,1,0,54,137,26|9,1,0,15,9,0,5,0,283,173,148,20|10,1,0,24,1,0,4,1,236,34,57,18|11,1,0,25,1,0,4,1,74,34,60,18|12,2,16,0,1,0,4,1,380,34,42,18|13,3,0,0,1,0,6,1,0,34,70,18|14,3,1,0,2,0,6,1,150,34,74,18|15,3,2,0,3,0,6,1,150,34,74,18|16,3,3,0,1,0,6,1,301,34,72,18|17,3,6,0,9,0,5,0,284,155,145,18");
//        GlobalPara.getInstance().AddPrintFormat(4, "PF-4", "2,1,432,296|5ZCI6K6h5qCH562+OgnplIDllK7ml6XmnJ8J6ZSA5ZSu5pe26Ze0CeaAu+aVsOmHjwnmgLvlh4Dph40J5oC75Lu3CQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQk=|0,0,0,0,1,0,5,1,2,32,247,143|1,2,0,0,1,0,5,1,0,241,432,26|2,2,1,0,1,0,5,1,0,267,432,26|3,2,3,0,1,0,5,0,6,191,126,18|4,2,4,0,1,0,5,0,131,191,122,18|5,2,27,0,1,0,5,2,316,207,103,34|6,2,6,0,1,0,5,1,84,209,70,32|7,2,7,0,1,0,5,1,236,209,78,32|8,2,5,0,1,0,5,2,177,0,36,32|9,1,1,0,1,0,5,0,252,0,108,18|10,1,2,0,1,0,5,0,252,18,108,18|11,1,3,0,1,0,5,0,252,36,108,18|12,1,4,0,1,0,5,0,252,54,108,18|13,1,5,0,1,0,5,0,252,72,108,18|14,1,6,0,1,0,5,0,252,90,108,18|15,1,7,0,1,0,5,0,252,108,108,18|16,1,8,0,1,0,5,0,252,126,108,18|17,1,9,0,1,0,5,0,252,144,108,18|18,1,10,0,1,0,5,0,252,160,108,18|19,1,1,5,1,0,5,0,360,0,70,18|20,1,2,5,1,0,5,0,360,18,70,18|21,1,3,5,1,0,5,0,360,36,70,18|22,1,4,5,1,0,5,0,360,54,70,18|23,1,5,5,1,0,5,0,360,72,70,18|24,1,6,5,1,0,5,0,360,90,70,18|25,1,7,5,1,0,5,0,360,108,70,18|26,1,8,5,1,0,5,0,360,126,70,18|27,1,9,5,1,0,5,0,360,144,70,18|28,1,10,5,1,0,5,0,360,160,70,18|29,3,0,0,1,0,5,2,13,0,160,32|30,3,1,0,1,0,5,0,15,175,108,16|31,3,2,0,1,0,5,0,135,175,100,16|32,3,3,0,1,0,5,1,5,209,78,32|33,3,4,0,1,0,5,1,156,209,78,32|34,3,5,0,1,0,5,1,332,179,67,26");
//        GlobalPara.getInstance().AddPrintFormat(5, "PF-5", "2,1,304,216|5ZCI6K6h5qCH562+OgkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQk=|0,0,0,0,1,0,5,1,0,26,224,117|1,2,0,0,1,0,5,1,0,173,303,34|2,2,3,0,1,0,5,0,0,153,110,20|3,2,4,0,1,0,5,0,108,153,103,20|4,2,27,0,1,0,5,1,211,147,92,26|5,2,5,0,1,0,5,1,146,0,36,26|6,1,1,0,1,0,5,0,229,0,74,18|7,1,2,0,1,0,5,0,229,18,74,18|8,1,3,0,1,0,5,0,229,36,74,18|9,1,4,0,1,0,5,0,229,54,74,18|10,1,5,0,1,0,5,0,229,72,74,18|11,1,6,0,1,0,5,0,229,90,74,18|12,1,7,0,1,0,5,0,229,108,74,18|13,1,8,0,1,0,5,0,229,126,74,18|14,3,0,0,1,0,5,1,13,0,130,26");
//        GlobalPara.getInstance().AddPrintFormat(6, "PF-6", "2,1,432,224|5ZCI6K6h5qCH562+OgkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQk=|0,0,0,0,1,0,5,1,2,35,247,125|1,2,0,0,1,0,5,2,0,182,432,34|2,2,3,0,1,0,5,0,6,161,125,20|3,2,4,0,1,0,5,0,132,161,124,20|4,2,27,0,1,0,5,2,279,146,114,34|5,2,5,0,1,0,5,2,177,0,36,34|6,1,1,0,1,0,5,0,252,0,108,18|7,1,2,0,1,0,5,0,252,18,108,18|8,1,3,0,1,0,5,0,252,36,108,18|9,1,4,0,1,0,5,0,252,54,108,18|10,1,5,0,1,0,5,0,252,72,108,18|11,1,6,0,1,0,5,0,252,90,108,18|12,1,7,0,1,0,5,0,252,108,108,18|13,1,8,0,1,0,5,0,252,126,108,18|14,1,1,5,1,0,5,0,360,0,70,18|15,1,2,5,1,0,5,0,360,18,70,18|16,1,3,5,1,0,5,0,360,36,70,18|17,1,4,5,1,0,5,0,360,54,70,18|18,1,5,5,1,0,5,0,360,72,70,18|19,1,6,5,1,0,5,0,360,90,70,18|20,1,7,5,1,0,5,0,360,108,70,18|21,1,8,5,1,0,5,0,360,126,70,18|22,3,0,0,1,0,5,2,13,0,160,34");
//        GlobalPara.getInstance().AddPrintFormat(7, "PF-7", "3,1,384,1072|6ZSA5ZSu5pe26Ze0OgktIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLQnllYblk4EJCeWNleS7twnph43ph48v5pWw6YePCemHkeminQnntK/orqE6CeWunuaUtumHkeminToJ5pS26ZO26YeR6aKdOgnmipjoiI3ph5Hpop06CeaJvumbtumHkeminToJ5Y2h5Y6f6aKdOgnljaHkvZnpop06CeWNoeWPtzoJ5Y2V5ZOB5pyN5Yqh6LS5CeacjeWKoei0uQnnqI7pop06CeWPsOWPtzoJ5ZCI6K6h6YeR6aKdOgnljaHmlK/ku5g6CeaUr+S7mDE6CeaUr+S7mDI6CeaUr+S7mDM6CeS8muWRmOenr+WIhjoJ5Y6f5Lu36YeR6aKdOgnoioLnnIHph5Hpop06CeWQieWNoeS6keaUr+S7mDoJCQkJ|0,6,1,0,1,0,192,1,0,0,384,26|1,2,0,0,1,0,192,1,0,26,384,26|2,2,17,0,1,0,192,1,0,52,384,26|3,2,18,0,1,0,192,1,0,78,384,26|4,2,19,0,1,0,192,1,0,104,384,26|5,2,20,0,1,0,192,1,0,130,384,26|6,2,2,0,1,0,4,1,0,156,84,26|7,2,47,0,1,0,4,1,84,156,30,26|8,2,31,0,1,0,5,1,128,156,125,26|9,2,26,0,1,0,5,1,259,156,125,26|10,5,0,0,1,0,0,0,20,182,200,50|11,3,0,0,1,0,4,1,0,182,114,26|12,2,3,0,1,0,0,1,115,182,140,26|13,2,4,0,1,0,6,1,270,182,112,26|14,3,1,0,1,0,192,0,0,208,384,16|15,3,2,0,1,0,4,1,0,224,104,26|16,3,3,0,1,0,5,1,181,224,160,26|17,3,4,0,1,0,4,1,14,250,76,26|18,3,5,0,1,0,5,1,99,250,172,26|19,3,6,0,1,0,5,1,280,250,104,26|20,3,1,0,1,0,192,0,0,276,384,15|21,5,0,0,1,0,0,0,50,291,200,50|22,1,0,0,1,0,4,1,0,291,180,26|23,1,0,38,1,0,6,1,238,291,146,26|24,1,0,31,1,0,4,1,96,317,96,26|25,1,0,4,1,0,5,1,0,317,96,26|26,1,0,1,1,0,4,1,192,317,96,26|27,1,0,26,1,0,6,1,288,317,96,26|28,5,2,0,1,0,0,0,20,343,200,50|29,5,2,0,1,0,0,0,21,395,200,50|30,1,0,19,1,0,4,1,0,395,128,26|31,1,0,20,1,0,5,1,128,395,128,26|32,1,0,21,1,0,6,1,256,395,128,26|33,5,2,0,1,0,0,0,50,421,200,50|34,3,17,0,13,0,4,1,15,421,140,26|35,1,0,29,13,0,5,1,170,421,50,26|36,1,0,27,13,0,6,1,220,421,150,26|37,5,2,0,1,0,0,0,50,447,200,50|38,3,15,0,11,0,4,1,15,447,140,26|39,1,0,28,11,0,6,1,220,447,150,26|40,5,0,0,1,0,0,0,50,473,200,50|41,3,1,0,1,0,192,0,0,473,384,18|42,3,16,0,12,0,4,1,15,491,140,26|43,2,44,0,12,0,6,1,220,491,150,26|44,5,0,0,1,0,0,0,38,517,200,50|45,3,25,0,34,0,4,1,151,517,118,26|46,2,71,0,34,0,5,1,269,517,112,26|47,3,26,0,34,0,4,1,151,543,118,26|48,2,72,0,34,0,5,1,269,543,112,26|49,5,0,0,1,0,0,0,38,569,200,50|50,3,19,0,16,0,4,1,151,569,118,26|51,2,28,0,16,0,5,1,269,569,112,26|52,3,10,0,16,0,4,1,151,595,118,26|53,2,29,0,16,0,5,1,269,595,112,26|54,5,0,0,1,0,0,0,38,621,200,50|55,3,8,0,1,0,5,2,4,621,200,34|56,2,27,0,1,0,5,2,221,621,160,34|57,5,0,0,1,0,0,0,20,655,200,50|58,3,21,0,17,0,4,1,143,655,118,26|59,2,52,0,17,0,5,1,261,655,120,26|60,5,0,0,1,0,0,0,48,681,200,50|61,3,22,0,18,0,4,1,143,681,118,26|62,2,53,0,18,0,5,1,261,681,120,26|63,5,0,0,1,0,0,0,48,707,200,50|64,3,23,0,19,0,4,1,143,707,118,26|65,2,54,0,19,0,5,1,261,707,120,26|66,5,0,0,1,0,0,0,48,733,200,50|67,3,20,0,15,0,4,1,143,733,118,26|68,2,51,0,15,0,5,1,261,733,120,26|69,5,0,0,1,0,0,0,48,759,200,50|70,3,27,0,35,0,4,1,143,759,118,26|71,2,70,0,35,0,5,1,261,759,120,26|72,5,0,0,1,0,0,0,48,785,200,50|73,3,14,0,31,0,4,1,4,785,118,26|74,3,12,0,31,0,4,1,143,785,118,26|75,2,49,0,31,0,5,1,261,785,120,26|76,5,0,0,1,0,0,0,20,811,200,50|77,2,50,0,31,0,5,1,0,811,143,26|78,3,13,0,36,0,4,1,143,811,118,26|79,2,48,0,36,0,5,1,261,811,120,26|80,5,0,0,1,0,0,0,20,837,200,50|81,2,67,0,32,0,4,1,143,837,118,26|82,2,68,0,32,0,5,1,261,837,120,26|83,2,69,0,32,0,198,1,11,863,370,26|84,3,9,0,14,0,4,1,143,889,118,26|85,2,9,0,14,0,5,1,261,889,120,26|86,3,11,0,14,0,4,1,143,915,118,26|87,2,10,0,14,0,5,1,261,915,120,26|88,5,0,0,1,0,0,0,20,941,200,50|89,3,24,0,20,0,4,1,143,941,118,26|90,2,59,0,20,0,5,1,261,941,120,26|91,2,21,0,1,0,192,1,0,967,384,26|92,2,22,0,1,0,192,1,0,993,384,26|93,2,23,0,1,0,192,1,0,1019,384,26|94,2,24,0,1,0,192,1,0,1045,384,26|95,2,73,0,1,0,192,1,0,1071,384,1");
//        GlobalPara.getInstance().AddPrintFormat(8, "PF-8", "3,1,384,1072|6ZSA5ZSu5pe26Ze0OgktIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLQnllYblk4HlkI3np7AJ5ZWG5ZOB57yW5Y+3CeWNleS7twnph43ph48v5pWw6YePCemHkeminQnntK/orqE6CeWunuaUtumHkeminToJ5pS26ZO26YeR6aKdOgnmipjoiI3ph5Hpop06CeaJvumbtumHkeminToJ5Y2h5Y6f6aKdOgnljaHkvZnpop06CeWNoeWPtzoJ5Y2V5ZOB5pyN5Yqh6LS5CeacjeWKoei0uQnnqI7pop06CeWPsOWPtzoJ5ZCI6K6h6YeR6aKdOgnljaHmlK/ku5g6CeaUr+S7mDE6CeaUr+S7mDI6CeaUr+S7mDM6CeS8muWRmOenr+WIhjoJ5Y6f5Lu36YeR6aKdOgnoioLnnIHph5Hpop06CeWQieWNoeS6keaUr+S7mDoJCQkJ|0,6,1,0,1,0,192,1,0,0,384,26|1,2,0,0,1,0,192,1,0,26,384,26|2,2,17,0,1,0,192,1,0,52,384,26|3,2,18,0,1,0,192,1,0,78,384,26|4,2,19,0,1,0,192,1,0,104,384,26|5,2,20,0,1,0,192,1,0,130,384,26|6,2,2,0,1,0,4,1,0,156,84,26|7,2,47,0,1,0,4,1,84,156,30,26|8,2,31,0,1,0,5,1,128,156,125,26|9,2,26,0,1,0,5,1,259,156,125,26|10,5,0,0,1,0,0,0,20,182,200,50|11,3,0,0,1,0,4,1,0,182,114,26|12,2,3,0,1,0,0,1,115,182,140,26|13,2,4,0,1,0,6,1,270,182,112,26|14,3,1,0,1,0,192,0,0,208,384,16|15,3,2,0,1,0,4,1,0,224,104,26|16,3,3,0,1,0,5,1,181,224,160,26|17,3,4,0,1,0,4,1,14,250,76,26|18,3,5,0,1,0,5,1,99,250,172,26|19,3,6,0,1,0,5,1,280,250,104,26|20,3,1,0,1,0,192,0,0,276,384,15|21,5,0,0,1,0,0,0,50,291,200,50|22,1,0,0,1,0,4,1,0,291,180,26|23,1,0,6,1,0,5,1,180,291,200,26|24,1,0,4,1,0,6,1,0,317,96,26|25,1,0,1,1,0,4,1,192,317,96,26|26,1,0,26,1,0,6,1,288,317,96,26|27,5,2,0,1,0,0,0,20,343,200,50|28,5,2,0,1,0,0,0,21,395,200,50|29,1,0,19,1,0,4,1,0,395,128,26|30,1,0,20,1,0,5,1,128,395,128,26|31,1,0,21,1,0,6,1,256,395,128,26|32,5,2,0,1,0,0,0,50,421,200,50|33,3,17,0,13,0,4,1,15,421,140,26|34,1,0,29,13,0,5,1,170,421,50,26|35,1,0,27,13,0,6,1,220,421,150,26|36,5,2,0,1,0,0,0,50,447,200,50|37,3,15,0,11,0,4,1,15,447,140,26|38,1,0,28,11,0,6,1,220,447,150,26|39,5,0,0,1,0,0,0,50,473,200,50|40,3,1,0,1,0,192,0,0,473,384,18|41,3,16,0,12,0,4,1,15,491,140,26|42,2,44,0,12,0,6,1,220,491,150,26|43,5,0,0,1,0,0,0,38,517,200,50|44,3,25,0,34,0,4,1,151,517,118,26|45,2,71,0,34,0,5,1,269,517,112,26|46,3,26,0,34,0,4,1,151,543,118,26|47,2,72,0,34,0,5,1,269,543,112,26|48,5,0,0,1,0,0,0,38,569,200,50|49,3,19,0,16,0,4,1,151,569,118,26|50,2,28,0,16,0,5,1,269,569,112,26|51,3,10,0,16,0,4,1,151,595,118,26|52,2,29,0,16,0,5,1,269,595,112,26|53,5,0,0,1,0,0,0,38,621,200,50|54,3,8,0,1,0,5,2,4,621,200,34|55,2,27,0,1,0,5,2,221,621,160,34|56,5,0,0,1,0,0,0,20,655,200,50|57,3,21,0,17,0,4,1,143,655,118,26|58,2,52,0,17,0,5,1,261,655,120,26|59,5,0,0,1,0,0,0,48,681,200,50|60,3,22,0,18,0,4,1,143,681,118,26|61,2,53,0,18,0,5,1,261,681,120,26|62,5,0,0,1,0,0,0,48,707,200,50|63,3,23,0,19,0,4,1,143,707,118,26|64,2,54,0,19,0,5,1,261,707,120,26|65,5,0,0,1,0,0,0,48,733,200,50|66,3,20,0,15,0,4,1,143,733,118,26|67,2,51,0,15,0,5,1,261,733,120,26|68,5,0,0,1,0,0,0,48,759,200,50|69,3,27,0,35,0,4,1,143,759,118,26|70,2,70,0,35,0,5,1,261,759,120,26|71,5,0,0,1,0,0,0,48,785,200,50|72,3,14,0,31,0,4,1,4,785,118,26|73,3,12,0,31,0,4,1,143,785,118,26|74,2,49,0,31,0,5,1,261,785,120,26|75,5,0,0,1,0,0,0,20,811,200,50|76,2,50,0,31,0,5,1,0,811,143,26|77,3,13,0,36,0,4,1,143,811,118,26|78,2,48,0,36,0,5,1,261,811,120,26|79,5,0,0,1,0,0,0,20,837,200,50|80,2,67,0,32,0,4,1,143,837,118,26|81,2,68,0,32,0,5,1,261,837,120,26|82,2,69,0,32,0,198,1,11,863,370,26|83,3,9,0,14,0,4,1,143,889,118,26|84,2,9,0,14,0,5,1,261,889,120,26|85,3,11,0,14,0,4,1,143,915,118,26|86,2,10,0,14,0,5,1,261,915,120,26|87,5,0,0,1,0,0,0,20,941,200,50|88,3,24,0,20,0,4,1,143,941,118,26|89,2,59,0,20,0,5,1,261,941,120,26|90,2,21,0,1,0,192,1,0,967,384,26|91,2,22,0,1,0,192,1,0,993,384,26|92,2,23,0,1,0,192,1,0,1019,384,26|93,2,24,0,1,0,192,1,0,1045,384,26");
//        GlobalPara.getInstance().AddPrintFormat(9, "PF-9", "3,1,384,1072|6ZSA5ZSu5pe26Ze0OgktIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLQnllYblk4EJCeWNleS7twnph43ph48v5pWw6YePCemHkeminQnntK/orqE6CeWunuaUtumHkeminToJ5pS26ZO26YeR6aKdOgnmipjoiI3ph5Hpop06CeaJvumbtumHkeminToJ5Y2h5Y6f6aKdOgnljaHkvZnpop06CeWNoeWPtzoJ5Y2V5ZOB5pyN5Yqh6LS5CeacjeWKoei0uQnnqI7pop06CeWPsOWPtzoJ5ZCI6K6h6YeR6aKdOgnljaHmlK/ku5g6CeaUr+S7mDE6CeaUr+S7mDI6CeaUr+S7mDM6CeS8muWRmOenr+WIhjoJ5Y6f5Lu36YeR6aKdOgnoioLnnIHph5Hpop06CeWQieWNoeS6keaUr+S7mDoJCQkJ|0,6,1,0,1,0,192,1,0,0,384,26|1,2,0,0,1,0,192,1,0,26,384,26|2,2,17,0,1,0,192,1,0,52,384,26|3,2,18,0,1,0,192,1,0,78,384,26|4,2,19,0,1,0,192,1,0,104,384,26|5,2,20,0,1,0,192,1,0,130,384,26|6,2,2,0,1,0,4,1,0,156,84,26|7,2,47,0,1,0,4,1,84,156,30,26|8,2,31,0,1,0,5,1,128,156,125,26|9,2,26,0,1,0,5,1,259,156,125,26|10,5,0,0,1,0,0,0,20,182,200,50|11,3,0,0,1,0,4,1,0,182,114,26|12,2,3,0,1,0,0,1,115,182,140,26|13,2,4,0,1,0,6,1,270,182,112,26|14,3,1,0,1,0,192,0,0,208,384,16|15,3,2,0,1,0,4,1,0,224,104,26|16,3,3,0,1,0,5,1,181,224,160,26|17,3,4,0,1,0,4,1,14,250,76,26|18,3,5,0,1,0,5,1,99,250,172,26|19,3,6,0,1,0,5,1,280,250,104,26|20,3,1,0,1,0,192,0,0,276,384,15|21,5,0,0,1,0,0,0,50,291,200,50|22,1,0,0,1,0,4,1,0,291,180,26|23,1,0,38,1,0,6,1,238,291,146,26|24,1,0,31,1,0,4,1,96,317,96,26|25,1,0,4,1,0,5,1,0,317,96,26|26,1,0,1,1,0,4,1,192,317,96,26|27,1,0,26,1,0,6,1,288,317,96,26|28,5,2,0,1,0,0,0,20,343,200,50|29,5,2,0,1,0,0,0,21,395,200,50|30,1,0,19,1,0,4,1,0,395,128,26|31,1,0,20,1,0,5,1,128,395,128,26|32,1,0,21,1,0,6,1,256,395,128,26|33,5,2,0,1,0,0,0,50,421,200,50|34,3,17,0,13,0,4,1,15,421,140,26|35,1,0,29,13,0,5,1,170,421,50,26|36,1,0,27,13,0,6,1,220,421,150,26|37,5,2,0,1,0,0,0,50,447,200,50|38,3,15,0,11,0,4,1,15,447,140,26|39,1,0,28,11,0,6,1,220,447,150,26|40,5,0,0,1,0,0,0,50,473,200,50|41,3,1,0,1,0,192,0,0,473,384,18|42,3,16,0,12,0,4,1,15,491,140,26|43,2,44,0,12,0,6,1,220,491,150,26|44,5,0,0,1,0,0,0,38,517,200,50|45,3,25,0,34,0,4,1,151,517,118,26|46,2,71,0,34,0,5,1,269,517,112,26|47,3,26,0,34,0,4,1,151,543,118,26|48,2,72,0,34,0,5,1,269,543,112,26|49,5,0,0,1,0,0,0,38,569,200,50|50,3,19,0,16,0,4,1,151,569,118,26|51,2,28,0,16,0,5,1,269,569,112,26|52,3,10,0,16,0,4,1,151,595,118,26|53,2,29,0,16,0,5,1,269,595,112,26|54,5,0,0,1,0,0,0,38,621,200,50|55,3,8,0,1,0,5,2,4,621,200,34|56,2,27,0,1,0,5,2,221,621,160,34|57,5,0,0,1,0,0,0,20,655,200,50|58,3,21,0,17,0,4,1,143,655,118,26|59,2,52,0,17,0,5,1,261,655,120,26|60,5,0,0,1,0,0,0,48,681,200,50|61,3,22,0,18,0,4,1,143,681,118,26|62,2,53,0,18,0,5,1,261,681,120,26|63,5,0,0,1,0,0,0,48,707,200,50|64,3,23,0,19,0,4,1,143,707,118,26|65,2,54,0,19,0,5,1,261,707,120,26|66,5,0,0,1,0,0,0,48,733,200,50|67,3,20,0,15,0,4,1,143,733,118,26|68,2,51,0,15,0,5,1,261,733,120,26|69,5,0,0,1,0,0,0,48,759,200,50|70,3,27,0,35,0,4,1,143,759,118,26|71,2,70,0,35,0,5,1,261,759,120,26|72,5,0,0,1,0,0,0,48,785,200,50|73,3,14,0,31,0,4,1,4,785,118,26|74,3,12,0,31,0,4,1,143,785,118,26|75,2,49,0,31,0,5,1,261,785,120,26|76,5,0,0,1,0,0,0,20,811,200,50|77,2,50,0,31,0,5,1,0,811,143,26|78,3,13,0,36,0,4,1,143,811,118,26|79,2,48,0,36,0,5,1,261,811,120,26|80,5,0,0,1,0,0,0,20,837,200,50|81,2,67,0,32,0,4,1,143,837,118,26|82,2,68,0,32,0,5,1,261,837,120,26|83,2,69,0,32,0,198,1,11,863,370,26|84,3,9,0,14,0,4,1,143,889,118,26|85,2,9,0,14,0,5,1,261,889,120,26|86,3,11,0,14,0,4,1,143,915,118,26|87,2,10,0,14,0,5,1,261,915,120,26|88,5,0,0,1,0,0,0,20,941,200,50|89,3,24,0,20,0,4,1,143,941,118,26|90,2,59,0,20,0,5,1,261,941,120,26|91,2,21,0,1,0,192,1,0,967,384,26|92,2,22,0,1,0,192,1,0,993,384,26|93,2,23,0,1,0,192,1,0,1019,384,26|94,2,24,0,1,0,192,1,0,1045,384,26");

    }

    private static Map<Integer, DPLUV5> dpluv5Map = new HashMap<>();

    static {
        dpluv5Map.put(1,
                new DPLUV5<>()
                        .setNo(1)
                        .setName("苹果")
                        .setPrice(new DPriceV2().setPrice(new BigDecimal("11.00")))
                        .setUnit(4)
                        .setTare(new BigDecimal("5"))
                        .setSspVale_0(1)
                        .setSspVale_1(1)
                        .setSspVale_2(1)
                        .setSspVale_3(0)
        );
        dpluv5Map.put(2,
                new DPLUV5<>()
                        .setNo(2)
                        .setName("矿泉水")
                        .setPrice(new DPriceV2().setPrice(new BigDecimal("5.00")))
                        .setUnit(2)
                        .setUnitText("瓶")
                        .setSspVale_0(1)
                        .setSspVale_1(1)
                        .setSspVale_2(1)
                        .setSspVale_3(0)
        );
    }

    /**
     * @description: 获取商品信息
     **/
    private static DPLUV5 getPLU(int i) {
        return dpluv5Map.get(i);
    }

    /**
     * @description: 模板1
     **/
    public static final String T1 = "0336\n" +
            "Z\n" +
            "I0-0|1200000502000000006A012200\n" +
            "I0-6|12000005006A01000046002200\n" +
            "T单价|12000006010100200050001A00\n" +
            "I0-25|1200000401520022003C001A00\n" +
            "#2|T净重|1200000601A00022004A001A00\n" +
            "#3|T数量|1200000601A00022004A001A00\n" +
            "I0-24|1200000401EC00220039001A00\n" +
            "T总价|12000006012C01220048001A00\n" +
            "S16|12000004017C0122002A001A00\n" +
            "I0-4|120000050100003C0089001A00\n" +
            "I0-1|12000005018B003C008D001A00\n" +
            "S27|12000005021A013C0095002200\n" +
            "R1-0100000000000000:B201F501K500A000A000A000|14000005010000580019017100\n" +
            "I0-16|12000005001D015E0093006B00\n" +
            "T销售日期|12000005000200CA008A001200\n" +
            "T销售时间|12000005008E00CA0086001200\n" +
            "#9|T有效日期|12000005001B01CA0090001200\n" +
            "S3|12000005000100DC008A001400\n" +
            "S4|12000005008D00DC0088001400\n" +
            "#9|I0-15|12000005001801DC0094001400\n" +
            "S0|12000005010000F000B0011A00\n" +
            "S1|120000050100000A01AF011A00\n" +
            "0406\n" +
            "Z\n" +
            "08";

    public static final String T1T = "0336\n" +
            "T合计标签:|12000005000D000000A0002200\n" +
            "S5|1200000502B100000024002200\n" +
            "I1-0|1200000500FC0000006C001200\n" +
            "I1-5|12000005006801000046001200\n" +
            "I2-0|1200000500FC0012006C001200\n" +
            "I2-5|12000005006801120046001200\n" +
            "R1-0B01000500000000:=001B201F501K500=100=002=200=000|140000050102002200F7008F00\n" +
            "I3-0|1200000500FC0024006C001200\n" +
            "I3-5|12000005006801240046001200\n" +
            "I4-0|1200000500FC0036006C001200\n" +
            "I4-5|12000005006801360046001200\n" +
            "I5-0|1200000500FC0048006C001200\n" +
            "I5-5|12000005006801480046001200\n" +
            "I6-0|1200000500FC005A006C001200\n" +
            "I6-5|120000050068015A0046001200\n" +
            "I7-0|1200000500FC006C006C001200\n" +
            "I7-5|120000050068016C0046001200\n" +
            "I8-0|1200000500FC007E006C001200\n" +
            "I8-5|120000050068017E0046001200\n" +
            "I9-0|1200000500FC0090006C001200\n" +
            "I9-5|12000005006801900046001200\n" +
            "I10-0|1200000500FC00A0006C001200\n" +
            "I10-5|12000005006801A00046001200\n" +
            "T销售日期|12000005000F00B1006C001200\n" +
            "T销售时间|12000005008700B10064001200\n" +
            "T总价|12000005014C01B30043001A00\n" +
            "S3|12000005000600C3007E001400\n" +
            "S4|12000005008300C3007A001400\n" +
            "S27|12000005023C01CF0067002200\n" +
            "T总数量|12000005010500D7004E001A00\n" +
            "S6|12000005015400D70046001A00\n" +
            "T总净重|12000005019C00D7004E001A00\n" +
            "S7|1200000501EC00D7004E001A00\n" +
            "S0|12000005010000F100B0011A00\n" +
            "S1|120000050100000B01B0011A00\n" +
            "040608";

    public static final String T2 = "033016000000000000000080011A00010004\n" +
            "S0|12000000010000000080011A00\n" +
            "04\n" +
            "S2|12000004010000000054001A00\n" +
            "S47|1200000401540000001E001A00\n" +
            "S31|1200000501800000007D001A00\n" +
            "S26|1200000501030100007D001A00\n" +
            "04\n" +
            "S17|12000005010000000080011A00\n" +
            "04\n" +
            "S18|12000005010000000080011A00\n" +
            "04\n" +
            "S19|12000005010000000080011A00\n" +
            "04\n" +
            "S20|12000005010000000080011A00\n" +
            "04\n" +
            "T销售时间:|12000004010000000072001A00\n" +
            "S3|1200000001730000008C001A00\n" +
            "S4|12000006010E01000070001A00\n" +
            "T- - - - - - - - - - - - - - - - - - - - - - - - - - -|120000050000001A0080011000\n" +
            "04\n" +
            "T商品名称|12000004010000000068001A00\n" +
            "T商品编号|1200000501B5000000A0001A00\n" +
            "T单价|12000004010E001A004C001A00\n" +
            "T重量/数量|120000050163001A00AC001A00\n" +
            "T金额|120000050118011A0068001A00\n" +
            "T- - - - - - - - - - - - - - - - - - - - - - - - - - -|12000005000000340080010F00\n" +
            "04\n" +
            "Z\n" +
            "I0-0|120000040100000000B4001A00\n" +
            "I0-6|1200000501B4000000C8001A00\n" +
            "0404\n" +
            "I0-20|12000004010000000080001A00\n" +
            "I0-21|12000005018000000080001A00\n" +
            "I0-22|12000006010001000080001A00\n" +
            "04\n" +
            "I0-4|12000005010000000060001A00\n" +
            "I0-31|12000004016000000060001A00\n" +
            "I0-1|1200000401C000000060001A00\n" +
            "I0-26|12000006012001000060001A00\n" +
            "04\n" +
            "#13|T税额:|12000004010F0000008C001A00\n" +
            "#13|I0-29|1200000501AA00000032001A00\n" +
            "#13|I0-27|1200000601DC00000096001A00\n" +
            "0404\n" +
            "Z\n" +
            "T- - - - - - - - - - - - - - - - - - - - - - - - - - -|12000005000000000080011200\n" +
            "04\n" +
            "#12|T服务费|12000004010F0000008C001A00\n" +
            "#12|S44|1200000601DC00000096001A00\n" +
            "04\n" +
            "#16|T合计:|12000004019700000076001A00\n" +
            "#16|S28|12000005010D01000070001A00\n" +
            "#16|T折舍金额:|120000040197001A0076001A00\n" +
            "#16|S29|12000005010D011A0070001A00\n" +
            "04\n" +
            "T实收金额:|120000050204000000C8002200\n" +
            "S27|1200000502DD000000A0002200\n" +
            "04\n" +
            "#17|T支付1:|12000004018F00000076001A00\n" +
            "#17|S52|12000005010501000078001A00\n" +
            "04\n" +
            "#18|T支付2:|12000004018F00000076001A00\n" +
            "#18|S53|12000005010501000078001A00\n" +
            "04\n" +
            "#19|T支付3:|12000004018F00000076001A00\n" +
            "#19|S54|12000005010501000078001A00\n" +
            "04\n" +
            "#15|T卡支付:|12000004018F00000076001A00\n" +
            "#15|S51|12000005010501000078001A00\n" +
            "04\n" +
            "#31|T卡号:|12000004010400000076001A00\n" +
            "#31|T卡原额:|12000004018F00000076001A00\n" +
            "#31|S49|12000005010501000078001A00\n" +
            "#31|S50-0|120000050100001A008F001A00\n" +
            "#31|T卡余额:|12000004018F001A0076001A00\n" +
            "#31|S48|120000050105011A0078001A00\n" +
            "04\n" +
            "#32|S67|12000004018F00000076001A00\n" +
            "#32|S68|12000005010501000078001A00\n" +
            "04\n" +
            "#32|S69|12000006010B00000072011A00\n" +
            "04\n" +
            "#14|T收银金额:|12000004018F00000076001A00\n" +
            "#14|S9|12000005010501000078001A00\n" +
            "#14|T找零金额:|12000004018F001A0076001A00\n" +
            "#14|S10|120000050105011A0078001A00\n" +
            "04\n" +
            "#20|T会员积分:|12000004018F00000076001A00\n" +
            "#20|S59|12000005010501000078001A00\n" +
            "04\n" +
            "S21|12000005010000000080011A00\n" +
            "04\n" +
            "S22|12000005010000000080011A00\n" +
            "04\n" +
            "S23|12000005010000000080011A00\n" +
            "04\n" +
            "S24|12000005010000000080011A00\n" +
            "040608";
}

//        String bitMap = "文件绝对路径";
//        PrintBitMapRequest printBitMapRequest = new PrintBitMapRequest(new File(bitMap));
//        printBitMapRequest.setPrintBack(new IPrintBack() {
//            /**
//             * @param response
//             * @description: 操作结果响应原始信息
//             */
//            @Override
//            public void responseBack(PrintResponse response) {
//                System.out.println(response.toJSON());
//            }
//        });
//        PrintGeneralFactory.getInstance().getNode_A(true).sendDataWithAllPackage(printBitMapRequest);

//        PrintProcessor_A com3 = new PrintProcessor_A().setMessenger(new DefaultPrintSerialMessenger("COM3", 115200));
//        com3.close();
//        PrintProcessor_B com4 = new PrintProcessor_B().setMessenger(new DefaultPrintSerialMessenger("COM4", 115200));
//        com4.communication().logSwitch(true, 1024);
//
//
// 创建交易内容


// 添加第一个商品
// 添加商品 并设置 皮重
//        ItemContent itemContent1 = pipeline.Item_New(getPLU(2));
//        TradeBuffer.GetInstance().Item_New(getPLU(1));

//Item_New之后，要么Total_AddItem，要么Total_QuitItem
//        for_JKP(type, pipeline, itemContent1);
//        TradeContent tradeContent;

//        tradeContent = scale_to_reject(type, pipeline);

//        TradeContent tradeContent = TradeBuffer.GetInstance()
//                .Settlement(456, 10,
//                        new CashSettlement()
//                                .setCash(new BigDecimal(100)));
// String hex = tradeContent.printCalculate(T2,0);
// System.out.println(hex);

// System.out.println(JSONUtils.objectToJSON(tradeContent.getPrintContents()));

//        TradePipeline pipeline = new TradePipeline(TradeType.退货);
//        ItemContent itemContent = pipeline.Item_New(getPLU(2));
//        itemContent = pipeline.Item_Set_Count(itemContent, new BigDecimal(2));
//        if(pipeline.Item_Check_Price(itemContent)) {
//            if (pipeline.Item_Check_Price(itemContent, new BigDecimal(4))) {
//                pipeline.Item_Set_Price(itemContent, new BigDecimal(4));
//            }
//        }
//        pipeline.Total_AddItem(itemContent);
//
//        if(pipeline.Total_Check_Discount()) {
//            if (pipeline.Total_Check_Discount(new BigDecimal(4)))
//                pipeline.Total_Set_Discount(new BigDecimal(4));
//        }
//
//        pipeline.Settlement(56, 0);
//        TradeContent tradeContent = pipeline.Current_TradeContent_WOE();
//
//        tradeContent.Total_Log();
//        System.out.println(tradeContent.getLogContent().toJSON());
//        ServerUnPackageObject serverUnPackageObject = new DLOGV1<>().Server_UnPackage(tradeContent.getLogContent().getLog());
//        System.out.println(JSONUtils.objectToJSON(serverUnPackageObject.getObj()));
// 上传日志
// EquipmentTest.updateLogData(tradeContent.getLogContent());


//        DLOGV1 analyze = DDataUtils.analyze(tradeContent.getLogContent().getLog(), DLOGV1.class);
//        TradeContent Log_TradeContent = new TradeContent(analyze, dpluv5Map);
//        System.out.println(Log_TradeContent.toJSON());


//        //需要的工作：
//        //标签打印机参数0灰度=
//        GlobalPara.getInstance().getTMS(TMS.Print_Gray_GapPaper);
//        //小票打印机参数0灰度=
//        GlobalPara.getInstance().getTMS(TMS.Print_Gray_GenericPaper);
//        //所有打印机参数1错误排除=ignore
//        int ignore = 0;
//        if ((GlobalPara.getInstance().getTMS(TMS.HW_Print_IgnorePBS) & 0x01) != 0)
//            ignore |= 0x01;
//        if ((GlobalPara.getInstance().getTMS(TMS.HW_Print_Ignore_P2) & 0x01) != 0)
//            ignore |= 0x02;
//        if (GlobalPara.getInstance().getTMS(TMS.HW_ConPaper_vPPS) > 0)
//            ignore |= 0x04;
//        //初始化打印机的时候执行，且每次参数表更新后执行。
//        //或者每次打印都执行
//
//        PrintGeneralFactory.getInstance().print_before();
//
////        Thread.sleep(10000);
//
//        PrintGeneralFactory.getInstance().print_answer(tradeContent.getPrintContents(), new IPrintBack() {
//            @Override
//            public void responseBack(PrintResponse response) {
//                System.out.println(response.toJSON());
//            }
//
//            @Override
//            public void responseBack(PrintBackResponse response) {
//                System.out.println(response.toJSON());
//            }
//
//            @Override
//            public void schedule(ScheduleState scheduleState) {
//                System.out.println(scheduleState.toString());
//            }
//        });
//
//        int count = 0;
//        while (true) {
//            Thread.sleep(1000);
//
//            count++;
//            if (action == 1)           //等同点击去皮键
//            {
//                action = 0;
//                WeightCal.getInstance().SetTare_Button();
//            }
//            if (action == 2)           //等同点击置零键
//            {
//                action = 0;
//                WeightCal.getInstance().SetZero_Button();
//            }
//            if (action == 3)           //等同点击强制置零键
//            {
//                action = 0;
//                WeightCal.getInstance().SetZero_Force();
//            }
//
//            if (count == 100) {
//
//            }
//        }

//        PrintGeneralFactory.getInstance()
//                .build_A(new DefaultPrintSerialMessenger("COM3", 115200))
//                .build_B(new DefaultPrintSerialMessenger("COM4", 115200));
//        PrintGeneralFactory.getInstance().getNode_B().logSwitch(true, 2048);
//
//        tradeContent.getPrintContents().forEach(printContent -> {
//            for (int i = 0; i < printContent.getPcs(); i++) {
//                try {
//                    print(printContent.getHex());
//                } catch (MeterException e) {
//                    e.printStackTrace();
//                }
//            }
//        });
//
//        // 内容打印
//        print(hex);