package com.jhscale.test.pos;

import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.common.model.device._inner.ServerUnPackageObject;
import com.jhscale.common.model.device.log.DLOGV1;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.control.win.WTCPServerControl;
import com.jhscale.meter.io.control.win.WUDPControl;
import com.jhscale.meter.protocol.model.*;
import com.jhscale.meter.protocol.other.CMPT;
import com.jhscale.meter.utils.ScannerUtils;

import java.util.Date;

import static com.jhscale.meter.protocol.constant.TMS.Ethernet_CustomProtocol;
import static com.jhscale.test.pos.PrintTradeTest.Accept_Event_By_Socket;

/**
 * @author lie_w
 * @title: SocketTest
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/5/1517:54
 */
public class SocketTest {

    static {
        PrintTradeTest.initGlobalPara();
        GlobalPara.getInstance().setRunLog(false);
        // GlobalPara.getInstance().TMS_Receive_Default();

        // GlobalPara.getInstance().setTMS(AI_Fun, AI_Enable);
        // GlobalPara.getInstance().setTMS(Server_AI_Function, AI_Enable);
        // GlobalPara.getInstance().set_ai_version("R.241.298.0");

        communication = SocketCommunication.getInstance()
                .Init_CMPT_Control(new WTCPServerControl(), new WUDPControl())
                .Init_Notify(new SocketNotify() {
                                 /**
                                  * @param e
                                  * @description: 异常信息回调
                                  */
                                 @Override
                                 public void onClientEventExp(MeterException e) {
                                     e.printStackTrace();
                                 }

                                 /**
                                  * @param acceptExecute
                                  * @param accept
                                  * @description: 接受数据处理
                                  */
                                 @Override
                                 public JHTCPAnswer acceptEvent(PublicExecute acceptExecute, JHTCPAccept accept) {
                                     return Accept_Event_By_Socket(acceptExecute, accept);
                                 }

                                 /**
                                  * @param execute
                                  * @description: 接受数据处理
                                  */
                                 @Override
                                 public void acceptEvent(PublicExecute execute) {
                                     System.out.printf("acceptEvent ： %s%n", execute.toJSON());
                                 }
                             }
                );

        // new Thread() {
        //     @Override
        //     public void run() {
        //         for (int i = 0; i < 10; i++) {
        //             SystemtUtils.sleep(10);
        //             TradeContent tradeContent = getTradeContent();
        //             System.out.println(tradeContent.toJSON());
        //         }
        //     }
        // }.start();
    }

    // 参数类型
    private static int type = 0;
    // 通讯器
    private static SocketCommunication communication;

    public static void main(String[] args) {
        // Socket_YS();
        Socket_CMPT();
    }

    /**
     * @description: 友声Socket
     **/
    private static void Socket_YS() {
        // boolean init_tcp_server_result = communication.Init_TCP_Server(new WTCPServerControl(), new TCPServerDevice());
        // System.out.println(String.format("Socket_YS init_tcp_server_result: %s", init_tcp_server_result));

        // boolean init_tcp_server_result = communication.Init_TCP_Server(new TCPServerDevice());
        // System.out.println(String.format("Socket_YS init_tcp_server_result: %s", init_tcp_server_result));
//
        // boolean init_udp_terminal_result = communication.Init_UDP_Link(new WUDPControl(), UDP_Terminal);
        // System.out.println(String.format("Socket_YS init_udp_terminal_result: %s", init_udp_terminal_result));

        String data = "09B500000155EA652F0100000015000020020089E01188800000000015000020030000000000000001001900000018000000033132333400150000200A00001015000020080A00";
        ServerUnPackageObject serverUnPackageObject = new DLOGV1<>().Server_UnPackage(data);
        DLOGV1 before = (DLOGV1) serverUnPackageObject.getObj();
        before.setTradeTime(new Date());
        System.out.println("加密前时间 " + DateUtils.getFormatDate(before.getTradeTime(), DateUtils.YYYY_MM_DD_HH_MM_SS));

        String server_package = before.Server_Package();
        ServerUnPackageObject afterPackage = new DLOGV1<>().Server_UnPackage(server_package);
        DLOGV1 after = (DLOGV1) afterPackage.getObj();
        System.out.println("解密后时间 " + DateUtils.getFormatDate(after.getTradeTime(), DateUtils.YYYY_MM_DD_HH_MM_SS));
    }

    /**
     * @description: 其他协议Socket
     **/
    private static void Socket_CMPT() {
        switch (type) {
            case 0:
                while (true) {
                    CMPT cmpt = ScannerUtils.scanner("选项协议", CMPT.values());
                    GlobalPara.getInstance().setTMS(Ethernet_CustomProtocol, cmpt.getSerial());
                    boolean result = communication.Init_CMPT();
                    System.out.printf("Init_CMPT %s-%s result: %s%n",
                            communication.cmptAction().CMPT().getSimple(),
                            communication.cmptAction().CMPT().getDescription(),
                            result);
                }
            case 1:
                GlobalPara.getInstance().setTMS(Ethernet_CustomProtocol, CMPT.大华.getSerial());
                boolean result = communication.Init_CMPT();
                System.out.printf("Init_CMPT %s-%s result: %s%n",
                        communication.cmptAction().CMPT().getSimple(),
                        communication.cmptAction().CMPT().getDescription(),
                        result);
                break;
        }


    }
}
