package com.jhscale.test.seal;

import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.seal.SealManager;
import com.jhscale.meter.seal.cmd.*;
import com.jhscale.meter.seal.entity.SealRequest;
import com.jhscale.meter.seal.entity.SealResponse;
import com.jhscale.meter.seal.entity.inner.Offset;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: SealTest
 * @description: TODO
 * @date 2024/9/5 12:30
 */
public class BLESealTest {

    static Offset offset = new Offset(2, 16);

    public static void main(String[] args) throws MeterException {
        handShake();

        // bleObtainStatus();

        bleReset();

        // bleInit();

        // bleClose();
    }

    /**
     * @description: 握手指令
     * @date: 2024-09-06 13:53:03
     */
    private static Offset handShake() throws MeterException {
        offset = null;
        SealRequest sealRequest = SealManager.getInstance().assembly_command(new HandShakeRequest());
        System.out.printf("偏移量 指令：[%s]%n", sealRequest.toJSON());

        String scanner = SystemtUtils.scanner("蓝牙收到指令：");
        scanner = scanner.trim().replace(" ", "");
        HandShakeResponse response = (HandShakeResponse) SealManager.getInstance().disassembly_command(offset, scanner);
        System.out.printf("偏移量 结果：[%s]%n", response.toJSON());

        offset = new Offset(response.offset1(), response.offset2());
        System.out.printf("偏移量：%s%n", offset.toJSON());
        return offset;
    }

    private static void bleClose() throws MeterException {
        SealRequest sealRequest = SealManager.getInstance().assembly_command(new CloseBLERequest(offset));
        System.out.printf("关闭蓝牙 指令：[%s]%n", sealRequest.toJSON());

        String scanner = SystemtUtils.scanner("蓝牙收到指令：");
        scanner = scanner.trim().replace(" ", "");
        SealResponse sealResponse = SealManager.getInstance().disassembly_command(offset, scanner);
        System.out.printf("关闭蓝牙 结果：[%s]%n", sealResponse.toJSON());
    }

    // 57335041183437342B920C00  SCOPAIBW1B704A0E126A38
    private static void bleInit() throws MeterException {
        BLEInitRequest bleInitRequest = new BLEInitRequest(offset);
        bleInitRequest.setUid("57335041183437342B920C00");
        bleInitRequest.setSize(2);
        bleInitRequest.setR1("295C3824");
        // bleInitRequest.setR1(RandomUtils.getRandomHex(4));
        SealRequest sealRequest = SealManager.getInstance().assembly_command(bleInitRequest);
        System.out.printf("蓝牙初始化 指令：[%s]%n", sealRequest.toJSON());

        String scanner = SystemtUtils.scanner("蓝牙收到指令：");
        scanner = scanner.trim().replace(" ", "");
        SealResponse sealResponse = SealManager.getInstance().disassembly_command(offset, scanner);
        System.out.printf("蓝牙初始化 结果：[%s]%n", sealResponse.toJSON());
    }

    private static void bleReset() throws MeterException {
        BLEResetRequest bleResetRequest = new BLEResetRequest(offset);
        bleResetRequest.setUid("57335041183437342B920C00");
        bleResetRequest.setR1("295C3824");
        SealRequest sealRequest = SealManager.getInstance().assembly_command(bleResetRequest);
        System.out.printf("蓝牙铅封复位 指令：[%s]%n", sealRequest.toJSON());

        String scanner = SystemtUtils.scanner("蓝牙收到指令：");
        scanner = scanner.trim().replace(" ", "");
        SealResponse sealResponse = SealManager.getInstance().disassembly_command(offset, scanner);
        System.out.printf("蓝牙铅封复位 结果：[%s]%n", sealResponse.toJSON());
    }

    private static void bleObtainStatus() throws MeterException {
        SealRequest sealRequest = SealManager.getInstance().assembly_command(new BLEObtainStatusRequest(offset));
        System.out.printf("蓝牙读取状态 指令：[%s]%n", sealRequest.toJSON());

        String scanner = SystemtUtils.scanner("蓝牙收到指令：");
        scanner = scanner.trim().replace(" ", "");
        SealResponse sealResponse = SealManager.getInstance().disassembly_command(offset, scanner);
        System.out.printf("蓝牙读取状态 结果：[%s]%n", sealResponse.toJSON());
    }
}
