package com.jhscale.test.seal;

import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.seal.SealBLENotify;
import com.jhscale.meter.seal.SealManager;
import com.jhscale.meter.seal.cmd.ObtainStatusResponse;
import com.jhscale.meter.seal.cmd.OpenBLEResponse;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: SealTest
 * @description: TODO
 * @date 2024/9/5 12:30
 */
public class TerminalSealTest {

    public static void main(String[] args) throws MeterException {
        GlobalPara.getInstance().setRunLog(true);

        SealManager.getInstance()
                .Init_Manager(new WSerialPortControl(), new SerialDevice("COM3", 9600));

        obtainStatus();

        SystemtUtils.sleep(3);

        openBLE();
    }

    private static void openBLE() throws MeterException {
        // 打开蓝牙
        String unique = "SCOPAIBW1B704A0E126A38";
        OpenBLEResponse openBLEResponse = SealManager.getInstance().openBLE(unique, new SealBLENotify() {
            @Override
            public void notify(OpenBLEResponse response) {
                System.out.printf("业务完成 蓝牙通知：[%s]%n", response.toJSON());
            }
        });
        System.out.printf("打开蓝牙 结果：[%s]%n", openBLEResponse.toJSON());
    }

    private static void obtainStatus() throws MeterException {
        // 获取状态
        ObtainStatusResponse statusResponse = SealManager.getInstance().status();
        System.out.printf("获取状态：[%s]%n", statusResponse.toJSON());

        // SealRequest sealRequest = SealManager.getInstance().assembly_command(new ObtainStatusRequest(new Offset(27, 15)));
        // System.out.println(sealRequest.toJSON());
    }
}
