package com.jhscale.test.serial;

import com.jhscale.meter.em.WeighingMode;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.SerialPort;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.protocol.IDebugProtocolResponse;
import com.jhscale.meter.protocol.IOProtocolResponse;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ad.ADScaleProtocolManager;
import com.jhscale.meter.protocol.ad.em.ADProtocol;
import com.jhscale.meter.protocol.ad.entity.assembly.*;
import com.jhscale.meter.protocol.ad.entity.disassembly.*;
import com.jhscale.meter.protocol.entity.IPackResponse;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;

/**
 * @author lie_w
 * @title: ADDeviceTest
 * @projectName meter-jar
 * @description: AD 设备测试
 * @date 2021/6/1715:02
 */
public class ADDeviceTest {

    private static IProtocolManager protocolManager;

    static {
        try {
            protocolManager = new ADScaleProtocolManager().initPortmanager(
                    new WSerialPortControl(),
                    new SerialDevice("COM3", 9600, 0),
                    new IProtocolResponse() {
                        /**
                         * @param target
                         * @description: 目标数据
                         */
                        @Override
                        public void target(IPackResponse target) throws MeterException {
                            // System.out.println(target.toJSON());
                        }

                        @Override
                        public void exp(MeterException e) {
                            System.out.println(e.getMessage());
                        }
                    }
            );
            protocolManager.openPort();

            protocolManager.log(true);
        } catch (MeterException e) {
            e.printStackTrace();
        }
    }

    private static final String SCALE_UPGRADE = "E:\\JHScale\\Resources\\weight\\C000064_230412.eup";
    private static final String SCALE_UPGRADE_NEW = "C:\\Users\\lie_w\\Desktop\\底层开发协议\\meter\\scale\\C000064_210924.eup";
    private static final String SCALE_UPGRADE_WL = "C:\\Users\\lie_w\\Desktop\\底层开发协议\\meter\\scale\\WL_DZ\\C000064_220523.eup";

    public static void main(String[] args) throws MeterException, InterruptedException {
        // initOpen();
        // A();
        // upgrade();
        // upgradeWithoutRequest();
        // switchProtocol();
        // IOPortocol();

        // ObtainVersionADPARequest();
        // for (int i = 0; i < 5; i++) {
        //     ObtainVersionADPARequest_2();
        // }

        // MemoryWriteADPARequest();
        // MemoryReadADPARequest();
        // RestartADPARequest();
        // ObtainZeroCodeOpenADPARequest();
        // CheckStableAndSetZeroCodeADPARequest();
        // SetInternalCodeZeroADPARequest();
        ObtainFullScaleADPARequest();
    }

    private static void ObtainFullScaleADPARequest() throws MeterException {
        ObtainFullScaleADPARequest request = new ObtainFullScaleADPARequest();
        protocolManager.execute(request, new IProtocolResponse<ObtainVersionADPDResponse>() {
            @Override
            public void target(ObtainVersionADPDResponse target) throws MeterException {
                System.out.println("版本号读取命令:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("内码置零命令 异常:---" + e.getMessage());
            }
        });
    }

    /**
     * @description: 升级
     **/
    private static void upgrade() throws MeterException {
        IProtocolManager protocolManager = new ADScaleProtocolManager().initPortmanager(
                new WSerialPortControl(),
                new SerialDevice("COM3", 9600, 0)
        );
        // protocolManager.log(true);

        // 升级文件
        byte[] bytes = FileUtils.fileToBytes(new File(SCALE_UPGRADE));
        // System.out.println(ByteUtils.toHexString(bytes));

        protocolManager.shake(new IProtocolResponse<IPackResponse>() {
            @Override
            public void target(IPackResponse target) {
                if (target instanceof UpgradeFirmwareADPDResponse) {
                    System.out.println("upgrade 握手响应:" + target.toJSON());
                    if (StringUtils.isNotBlank(((UpgradeFirmwareADPDResponse) target).getVersion())) {
                        try {
                            protocolManager.upgrade(bytes, new IProtocolResponse() {
                                @Override
                                public void target(IPackResponse target) {
                                    System.out.println("upgrade 升级响应:" + target.toJSON());
                                }

                                /**
                                 * @param target
                                 * @description: 升级进度条完成
                                 */
                                @Override
                                public void upgrade_finish(IPackResponse target) {
                                    System.out.println("upgrade 升级结束 响应:" + target.toJSON());

                                    try {
                                        protocolManager.execute(new ObtainFullScaleADPARequest(), new IProtocolResponse<ObtainFullScaleADPDResponse>() {
                                            @Override
                                            public void target(ObtainFullScaleADPDResponse target) throws MeterException {
                                                System.out.println("满量程读取 响应:" + target.toJSON());
                                            }

                                            @Override
                                            public void exp(MeterException e) {

                                            }
                                        });
                                    } catch (MeterException e) {
                                        e.printStackTrace();
                                    }
                                }

                                @Override
                                public void exp(MeterException e) {
                                }
                            });
                        } catch (MeterException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    System.out.println(target.toJSON());
                }
            }

            @Override
            public void exp(MeterException e) {
                System.out.println("upgrade 升级响应:" + e.getMessage());
            }
        });

//        PortManagerTest.sleep(60);
//
//        protocolManager.closePort();
    }

    private static void upgradeWithoutRequest() throws MeterException {
        IProtocolManager protocolManager = new ADScaleProtocolManager().initPortmanager(
                new WSerialPortControl(),
                new SerialDevice("COM3", 9600, 0)
        );
        // protocolManager.log(true);

        // 升级文件
        byte[] bytes = FileUtils.fileToBytes(new File(SCALE_UPGRADE));
        System.out.println(ByteUtils.toHexString(bytes));

        protocolManager.shakeWithoutUpgradeFirmware(new IProtocolResponse() {
            @Override
            public void target(IPackResponse target) {
                if (target instanceof UpgradeFirmwareADPDResponse) {
                    System.out.println("upgradeWithoutRequest 握手响应:" + target.toJSON());
                    if (StringUtils.isNotBlank(((UpgradeFirmwareADPDResponse) target).getVersion())) {
                        try {
                            protocolManager.upgrade(bytes, new IProtocolResponse() {
                                @Override
                                public void target(IPackResponse target) {
                                    System.out.println("upgradeWithoutRequest 升级响应:" + target.toJSON());
                                }

                                /**
                                 * @param target
                                 * @description: 升级进度条完成
                                 */
                                @Override
                                public void upgrade_finish(IPackResponse target) {
                                    IProtocolResponse.super.upgrade_finish(target);
                                }

                                @Override
                                public void exp(MeterException e) {
                                }
                            });
                        } catch (MeterException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    System.out.println(target.toJSON());
                }
            }

            @Override
            public void exp(MeterException e) {
            }
        });

//        PortManagerTest.sleep(60);
//
//        protocolManager.closePort();
    }


    private static void ObtainVersionADPARequest_2() throws MeterException, InterruptedException {
        IProtocolManager protocolManager = new ADScaleProtocolManager().initPortmanager(
                new WSerialPortControl(),
                new SerialDevice("COM3", 9600, 0)
        );
        protocolManager.openPort();

        protocolManager.execute(new ObtainVersionADPARequest(), new IProtocolResponse<ObtainVersionADPDResponse>() {
            @Override
            public void target(ObtainVersionADPDResponse target) throws MeterException {
                System.out.println("版本号读取命令:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("内码置零命令 异常:---" + e.getMessage());
            }
        });

        Thread.sleep(3000);

        protocolManager.closePort();
    }

    private static void ObtainVersionADPARequest() throws MeterException {
        ObtainVersionADPARequest request = new ObtainVersionADPARequest();
        protocolManager.execute(request, new IProtocolResponse<ObtainVersionADPDResponse>() {
            @Override
            public void target(ObtainVersionADPDResponse target) throws MeterException {
                System.out.println("版本号读取命令:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("内码置零命令 异常:---" + e.getMessage());
            }
        });
    }

    private static void SetInternalCodeZeroADPARequest() throws MeterException {
        SetInternalCodeZeroADPARequest request = new SetInternalCodeZeroADPARequest();
        request.setZero(1230456);
        protocolManager.execute(request, new IProtocolResponse<SetInternalCodeZeroADPAResponse>() {
            @Override
            public void target(SetInternalCodeZeroADPAResponse target) throws MeterException {
                System.out.println("内码置零命令:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("内码置零命令 异常:---" + e.getMessage());
            }
        });
    }

    private static void CheckStableAndSetZeroCodeADPARequest() throws MeterException {
        CheckStableAndSetZeroCodeADPARequest request = new CheckStableAndSetZeroCodeADPARequest();
        request.setStable(1230456);
        request.setZero(4561203);
        protocolManager.execute(request, new IProtocolResponse<CheckStableAndSetZeroCodeADPAResponse>() {
            @Override
            public void target(CheckStableAndSetZeroCodeADPAResponse target) throws MeterException {
                System.out.println("判稳跟零内码设定命令:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("判稳跟零内码设定命令 异常:---" + e.getMessage());
            }
        });
    }

    private static void ObtainZeroCodeOpenADPARequest() throws MeterException {
        ObtainZeroCodeOpenADPARequest request = new ObtainZeroCodeOpenADPARequest();
        protocolManager.execute(request, new IProtocolResponse<ObtainZeroCodeOpenADPAResponse>() {
            @Override
            public void target(ObtainZeroCodeOpenADPAResponse target) throws MeterException {
                System.out.println("开机零位内码读取命令:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("开机零位内码读取命令 异常:---" + e.getMessage());
            }
        });
    }

    private static void RestartADPARequest() throws MeterException {
        RestartADPARequest request = new RestartADPARequest();
        protocolManager.execute(request, new IProtocolResponse<RestartADPAResponse>() {
            @Override
            public void target(RestartADPAResponse target) throws MeterException {
                System.out.println("重启命令:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("重启命令 异常:---" + e.getMessage());
            }
        });
    }

    private static void MemoryWriteADPARequest() throws MeterException {
        MemoryWriteADPARequest request = new MemoryWriteADPARequest();
        request.setAddr(1);
        request.setData("0000000000000001");
        protocolManager.execute(request, new IProtocolResponse<MemoryWriteADPAResponse>() {
            @Override
            public void target(MemoryWriteADPAResponse target) throws MeterException {
                System.out.println("内存读命令:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("内存读命令 异常:---" + e.getMessage());
            }
        });
    }

    private static void MemoryReadADPARequest() throws MeterException {
        MemoryReadADPARequest request = new MemoryReadADPARequest();
        request.setAddr(1);
        protocolManager.execute(request, new IProtocolResponse<MemoryReadADPAResponse>() {
            @Override
            public void target(MemoryReadADPAResponse target) throws MeterException {
                System.out.println("内存读命令:---" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println("内存读命令 异常:---" + e.getMessage());
            }
        });
    }

    /**
     * @description: 其他协议重量监听
     **/
    private static void IOPortocol() throws MeterException {
        IProtocolManager protocolManager = new ADScaleProtocolManager().initPortmanager(
                new WSerialPortControl(),
                new SerialDevice("COM3", 9600, 0),
                new IOProtocolResponse() {
                    @Override
                    public void target(byte[] bytes) {
                        System.out.println(ByteUtils.toHexString(bytes));
                    }

                    @Override
                    public void exp(MeterException e) {
                        System.out.println(e.getMessage());
                    }
                }
        );

        protocolManager.openPort();

        PortManagerTest.sleep(60);

        protocolManager.closePort();
    }

    /**
     * @description: 切换协议
     **/
    private static void switchProtocol() throws MeterException {
        IProtocolManager protocolManager = new ADScaleProtocolManager().initPortmanager(
                new WSerialPortControl(),
                new SerialDevice("COM3", 9600, 0),
                new IProtocolResponse() {
                    @Override
                    public void target(IPackResponse target) {
                        System.out.println(target.toJSON());
                    }

                    @Override
                    public void exp(MeterException e) {
                        System.err.println(e.getMessage());
                    }
                }
        );
        protocolManager.openPort();
        boolean b = protocolManager.executeSendOnly(new SwitchProtocolRequest(ADProtocol.协议C));
        System.out.println(b);
    }

    /**
     * @description: 设备模式
     **/
    private static void A() throws MeterException {
//        IProtocolManager protocolManager = new ADScaleProtocolManager().initPortmanager(new WSerialPortControl(),
//                new SerialDevice("COM3", 9600, 0),
//                new IProtocolResponse() {
////                    @Override
////                    public void source(byte[] bytes) {
////                        System.out.println(ByteUtils.toHexString(bytes));
////                    }
//
//                    @Override
//                    public void target(IPackResponse target) {
//                        System.out.println(target.toJSON());
//                    }
//
//                    @Override
//                    public void exp(MeterException e) {
//                        System.err.println(e.getMessage());
//                    }
//                });
//
//        protocolManager.openPort();

        protocolManager.execute(new SetWeighingModelADPARequest(WeighingMode.Gross_Continuous), new IDebugProtocolResponse() {
            @Override
            public void source(byte[] bytes) {
                System.out.println("选择模式响应模式HEX字节流:" + ByteUtils.toHexString(bytes));
            }

            @Override
            public void target(byte[] bytes) {
                System.out.println("选择模式响应模式DECODE字节流:" + ByteUtils.toHexString(bytes));
            }

            @Override
            public void target(IPackResponse target) {
                System.out.println("选择模式响应模式:" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.out.println("选择模式响应模式异常:" + e.getMessage());
            }
        });

        PortManagerTest.sleep(60);

        protocolManager.closePort();
    }

    /**
     * @description: 初始化打开
     **/
    private static void initOpen() throws MeterException {
        SerialPort serialPort = new SerialPort(new WSerialPortControl(), new SerialDevice("COM3", 9600));
        IProtocolManager protocolManager = new ADScaleProtocolManager().initPortmanager(serialPort, new IProtocolResponse() {
//            /**
//             * @param bytes
//             * @description: 响应源数据
//             */
//            @Override
//            public void source(byte[] bytes) {
//                System.out.println(ByteUtils.toHexString(bytes));
//            }

            @Override
            public void target(IPackResponse target) {
                System.out.println(target.toJSON());
            }

            @Override
            public void exp(MeterException e) {
                System.err.println(e.getMessage());
            }
        });
        protocolManager.openPort();
    }


}
