package com.jhscale.test.serial;

import com.alibaba.fastjson.JSON;
import com.jhscale.common.em.Version;
import com.jhscale.common.model.device._inner.DLOGContent;
import com.jhscale.common.model.device._inner.ServerUnPackageObject;
import com.jhscale.common.model.device.log.DLOGV1;
import com.jhscale.common.model.license.JRSAEncryptDecrypt;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.meter.entity.CPReport;
import com.jhscale.meter.entity.LOGReport;
import com.jhscale.meter.entity.PLUReport;
import com.jhscale.meter.entity.item.PLUItem;
import com.jhscale.meter.entity.server.CPServerReport;
import com.jhscale.meter.entity.server.LOGServerReport;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.model.TradeContent;
import com.jhscale.meter.protocol.print.PrintFactory;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.data.PrintVal;
import com.jhscale.meter.protocol.print.dither.BitMapFile;
import com.jhscale.meter.protocol.print.dither.DitherFactory;
import com.jhscale.meter.protocol.print.dither.DitherVal;
import com.jhscale.meter.protocol.print.em.*;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity.ScheduleState;
import com.jhscale.meter.protocol.print.entity.bitmap.FileBitMap;
import com.jhscale.meter.protocol.print.entity.bitmap.RealBitMap;
import com.jhscale.meter.protocol.print.entity.cmd.*;
import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;
import com.jhscale.meter.protocol.print.entity.data.PrintRealBitmapRequest;
import com.jhscale.meter.protocol.print.entity.file.bitmap.PrintBitMapRequest;
import com.jhscale.meter.protocol.print.entity.file.font.PrintFontRequest;
import com.jhscale.meter.protocol.print.entity.file.upgrade.PrintUpgradeRequest;
import com.jhscale.meter.protocol.print.entity.para.*;
import com.jhscale.meter.protocol.print.link.DefaultPrintSerialMessenger;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import com.jhscale.meter.protocol.print.produce.entity.PrintSetRequest;
import com.jhscale.meter.protocol.print.produce.impl.PrintProcessor_A;
import com.jhscale.meter.protocol.print.produce.impl.PrintProduce;
import com.jhscale.meter.protocol.print.temp.Temp1;
import com.jhscale.meter.protocol.print.temp.Temp2;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.FileUtils;
import com.jhscale.test.pos.PrintTradeTest;
import com.jhscale.test.third.B;
import com.jhscale.test.third.TradeOffLineProductBean;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: SerialPrintTest
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-080:57
 */
@SuppressWarnings("all")
public class JSerialPrintTest {

    public static final String PIC1 = "I:\\文档\\底层开发协议\\Printer Tester\\source1.jpg";
    public static final String PIC2 = "I:\\文档\\底层开发协议\\Printer Tester\\source.jpg";
    public static final String PIC4 = "C:\\Users\\lie_w\\Desktop\\dither\\test1.jpg";
    public static final String PIC5 = "C:\\Users\\lie_w\\Desktop\\dither\\test2.jpg";
    public static final String PIC6 = "C:\\Users\\lie_w\\Desktop\\dither\\1.jpg";
    public static final String PIC7 = "C:\\Users\\lie_w\\Desktop\\dither\\2.png";
    public static final String PIC8 = "C:\\Users\\lie_w\\Desktop\\dither\\3.png";
    public static final String TEST_DIR = "C:\\Users\\lie_w\\Desktop\\dither\\GG";
    public static final String YS_1 = "F:\\TEST\\dither\\ys1.png";
    public static final String YS_2 = "F:\\TEST\\dither\\ys2.jpg";
    public static final String YS_11 = "F:\\TEST\\dither\\ys11.png";
    public static final String YS_21 = "F:\\TEST\\dither\\ys21.jpg";
    public static final String TEST_1 = "F:\\TEST\\dither\\test1.png";
    public static final String TEST_2 = "F:\\TEST\\dither\\test21.jpg";
    public static final String PLU_REPORT = "F:\\TEST\\plu.json";
    public static final String PLU_D_REPORT = "F:\\TEST\\plu_d.json";
    public static final String LOG_REPORT = "F:\\TEST\\plu.json";
    public static final String LOG_D_REPORT = "F:\\TEST\\log-d.json";
    public static final String CP_D_REPORT = "F:\\TEST\\cp-d.json";

    public static void main(String[] args) throws InterruptedException, MeterException {
//        cmd0000();
//        cmd0100();
//        cmd0100_01();
//        cmd0200();
//        cmd0300();
//        cmd0400();
//        cmd04001();
//        cmd0500();
//        cmd0600();
//        cmd0700();
//        cmd0800();
//        cmd0900();
//        cmd0A00();

//        StringPara();
//        StringAutoLinePara();
//        BarCodePara();
//        FramePara();
//        TempBitmapPara();

//        bitMapUpdate(PrintTest.bitMapA1);
//        fontUpdate(PrintTest.FONT_FULL);
//        upgrade(PrintTest.VERSION6);
//        printTemp();
//        printTemp1();

//        printTemp1Val();
//        printTemp1Val2();
//        printTemp1Val3();
//        printTemp1Val4();

//        printLog();
//        printPLU();
//        printCP();
        printDetail();

//        printPara();
//        printPara2();

//        getPrintInfo();
//        setPrintGrayscale();

//        fontUpgrade(PrintTest.B_030);
//        bitMapUpgrade(PrintTest.bitMapA1);
//        verisonUpgrade(PrintTest.VERSION7);

//        bitMapUpdateDither();
//        bitMapUpdateDither1();
//        bitMapUpdateDither2();
//        bitMapUpdateDither3();

//        RealTimeBitmapPara();
//        RealTimeBitmapPara1();
//        RealTimeBitmapPara2();
//        RealTimeBitmapPara3();

//        fontCheck(PrintTest.B_021);
//        versionCheck(PrintTest.VERSION1);
//        PrintTest();
//        taocaimao();
//        taocaimao3();
//        for (int i = 0; i < 3; i++) {
//            taocaimao3();
//        }
    }

    /**
     * @description: 打印明细
     * @date: 2024-11-11 14:47:22
     **/
    private static void printDetail() throws MeterException {
        String data = "990200000112D5C42E11000000BFB40720000089E011888000000000BFB40720030000000000000003001B0000000100000003E6898BE69CBA000F0000200F00001017000020080A00200000000200000002E6898BE69CBA32000A00001050C3001050C3001088E4BBB6000A001B0000000300000002E69D8EE5AD90000A000010F4010010F4010010080A00";
        ServerUnPackageObject serverUnPackageObject = new DLOGV1<>().Server_UnPackage(data, Version.VERSION03);
        System.out.println(serverUnPackageObject.toJSON());

        PrintTradeTest.initGlobalPara();
        PrintGeneralFactory.getInstance().Init_Print_Factory(new DefaultPrintSerialMessenger("COM5", 115200), null);

        DLOGContent content = new DLOGContent()
                .setFid(665)// ifid
                .setSid(17)// sid
                .setLog(data)// dData
                .setLogType(0)// logType
                .setTradeDate(DateUtils.timeStrFormat("2024-11-11 14:45:38").getTime());// reviseTime

        TradeContent tradeContent = new TradeContent()
                .Total_Log(content)
                .printCalculate();

        PrintGeneralFactory.getInstance().print_answer(tradeContent.getPrintContents(), new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应业务信息
             */
            @Override
            public void responseBack(PrintBackResponse response) {
                System.out.println("打印完成：" + response.toJSON());
            }
        });
    }

    /**
     * @description: 打印云支付报表
     **/
    private static void printCP() throws MeterException {
        CPServerReport serverReport = FileUtils.reader(new File(CP_D_REPORT), CPServerReport.class);
        CPReport report = serverReport.toReport();
        report.setStoreName("小二店");
        report.setDeviceName("POS收银秤");
        report.setDate("2022-08-25");
        report.setMoney(2);

        PrintProcessor_A printProduce = new PrintProcessor_A();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.printReport(new PrintTest.DefaultPrintBack(), report);
    }

    /**
     * @description: 打印PLU报表
     **/
    private static void printPLU() throws MeterException {
        List<PLUItem> items = FileUtils.readerList(new File(PLU_D_REPORT), PLUItem.class);
        PLUReport report = new PLUReport(items);
        report.setStoreName("小二店");
        report.setDeviceName("POS收银秤");
        report.setDate("2022-08-25");
        report.setMoney(2);

        PrintProcessor_A printProduce = new PrintProcessor_A();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.printReport(new PrintTest.DefaultPrintBack(), report);
    }

    /**
     * @description: 打印日志报表
     **/
    private static void printLog() throws MeterException {
        String json = "{\"aliCount\":0,\"aliPay\":0.0,\"cardCount\":0,\"cardPay\":0.0,\"cash\":98.02,\"cashCount\":4,\"clear\":18,\"jkyCount\":0,\"jkyPay\":0.0,\"mistake\":9,\"otherCount1\":0,\"otherCount2\":0,\"otherCount3\":0,\"otherPay1\":0.0,\"otherPay2\":0.0,\"otherPay3\":0.0,\"returnAmount\":0.0,\"returnCount\":0,\"saleAmount\":98.02,\"saleCount\":46,\"specialCount2\":0,\"specialCount3\":0,\"specialCount4\":0,\"specialCount5\":0,\"specialCount6\":0,\"specialCount7\":0,\"specialPay2\":0.0,\"specialPay3\":0.0,\"specialPay4\":0.0,\"specialPay5\":0.0,\"specialPay6\":0.0,\"specialPay7\":0.0,\"time\":\"20220826\",\"totalAmount\":98.02,\"totalCount\":46,\"unconfirmed\":395.1,\"unconfirmedCount\":122,\"wechatCount\":0,\"wechat\":0.0}";
        LOGServerReport serverReport = JSONUtils.jsonToObject(json, LOGServerReport.class);
//        LOGServerReport serverReport = FileUtils.reader(new File(LOG_D_REPORT), LOGServerReport.class);
        LOGReport report = serverReport.toReport();
        report.setStoreName("小二店");
        report.setDeviceName("POS收银秤");
        report.setDate("2022-08-25");
        report.setMoney(2);
        System.out.println(report.toJSON());

        PrintProcessor_A printProduce = new PrintProcessor_A();
        printProduce.setMessenger(new DefaultPrintSerialMessenger("COM5", 115200));
        printProduce.printReport(new PrintTest.DefaultPrintBack(), report);

    }

    private static void taocaimao3() throws MeterException {
        String result2 = "{\"addTime\":\"2021-04-25 10:03:08\",\"dib\":\"0.00\",\"discount\":\"0.00\",\"id\":\"1153406267135971328\",\"isTcmOrder\":\"false\",\"marketName\":\"睡醒了吗\",\"memberId\":\"1147361053902139392\",\"memberName\":\"积分关联卡\",\"memberNo\":\"17621661603\",\"onLineOrOfLine\":\"线下订单\",\"operator\":\"只卖猪肉\",\"orderId\":\"2821341320318799872\",\"orderPoints\":\"40\",\"orderTotalPoints\":\"1248\",\"payType\":\"现金\",\"receivable\":\"3.02\",\"receiveTotalPrice\":\"3.02\",\"salesProductInfoList\":[{\"counts\":\"0\",\"id\":\"1153406270910844928\",\"price\":\"1.00\",\"productName\":\"开门大吉\",\"showStoreName\":false,\"sourceTrace\":0,\"storeId\":1147329448678834176,\"storeName\":\"二克猪肉\",\"totalPrice\":\"1.01\",\"types\":\"0\",\"unitPrice\":\"1/kg\",\"weight\":\"1.008\"},{\"counts\":\"0\",\"id\":\"1153406271288332288\",\"price\":\"1.00\",\"productName\":\"苹果\",\"showStoreName\":false,\"sourceTrace\":0,\"storeId\":1147329448678834176,\"storeName\":\"二克猪肉\",\"totalPrice\":\"1.01\",\"types\":\"0\",\"unitPrice\":\"1/kg\",\"weight\":\"1.008\"},{\"counts\":\"1\",\"id\":\"1153406271556767744\",\"price\":\"1.00\",\"productName\":\"新的\",\"showStoreName\":false,\"sourceTrace\":0,\"storeId\":1147329448678834176,\"storeName\":\"二克猪肉\",\"totalPrice\":\"1.00\",\"types\":\"1\",\"unitPrice\":\"散装\",\"weight\":\"0.000\"}],\"status\":\"已完成\",\"storeName\":\"二克猪肉\",\"tcmBalance\":\"\",\"tcmDiscount\":\"\",\"tcmIntegral\":\"\",\"ticketCount\":\"0\",\"totalPrice\":\"3.02\",\"weighCode\":\"62:98:6D:A4:0A:B0\"}";
        TradeOffLineProductBean.OffLineProduct offLineProduct = JSON.parseObject(result2, TradeOffLineProductBean.OffLineProduct.class);
//这个秤开钱箱和打印都是大电流操作不能同时进行，要有间隔时间
        if ("数字人民币".equals(offLineProduct.getPayType())) {
            offLineProduct.setPayType("数币");
        }
        List<Para> paras = new B().printOffLine(offLineProduct);
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.logSwitch(true, 8192);
        printProduce.addParas(paras.toArray(new Para[paras.size()]));
        printProduce.printSend(new PrintTest.DefaultPrintBack());
    }

    private static void taocaimao2() throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());

        List<Para> paras = new ArrayList<>();
        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("2021年04月25日 13:37"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("________________________________"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("                                "));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("            睡醒了吗"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("            儿科猪肉"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("支付方式：现金"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("订单号：2821341320318799872"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("下单时间：2021-04-25 10:03:08"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("______________商品______________"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("商品名称  单价  数/重量     金额"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("开门大吉  1.00  1.008       1.01"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("苹果      1.00  1.008       1.01"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("新的 散装"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("          1.00  1           1.00"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("________________________________"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("合计：                      3.02"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("优惠：                      0.00"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("已付：                      3.02"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("找零：                      0.00"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("现金支付：                  3.02"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("________________________________"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content(" "));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("会员信息：      积分关联卡[1603]"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("会员卡号：                      "));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("本单积分：                    40"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("可用积分：                  1248"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("________________________________"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content(" "));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("           扫码查追溯"));
        paras.add(new PrintPara());

        paras.add(new BarCodePara().setStartX(0).setStartY(0).setOffsetX(384).setOffsetY(26).set_Dir(Dir.ZERO).set_BarCode("0B03050600000000").set_Grid(Grid.Defaul_Grid).set_Content("ojtesdfkvsjvsjvjasdjfjsfdkajskfjaklsdjf"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content(" "));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content("_______________完_______________"));
        paras.add(new PrintPara());

        paras.add(new StringPara<>().setStartX(0).setStartY(0).setOffsetX(0).setOffsetY(0).set_Dir(Dir.ZERO).set_Font(Font.FONT1).set_Grid(Grid.Defaul_Grid).set_Content(" "));
        paras.add(new PrintPara());
        paras.add(new CuttingPosition());

        printProduce.addParas(paras.toArray(new Para[paras.size()]));
        printProduce.printSend(new PrintTest.DefaultPrintBack());
    }

    private static void taocaimao() throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        PrintDataRequest request = new PrintDataRequest();
        request.setContent("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");
        printProduce.send(request);
    }

    private static void PrintTest() throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.addParas(new BarCodePara()
                        .set_Dir(Dir.ZERO)
                        .set_Grid(Grid.Middle_Middle_Grid)
                        .set_Barcode(Barcode.QR)
                        .setStartX(0)
                        .setStartY(0)
                        .setOffsetX(384)
                        .setOffsetY(26)
                        .set_Content("http://ts2.taocaimall.com/order/index/qrIndex/745804518026993664"),
                new PrintPara(),
                new BarCodePara()
                        .set_Dir(Dir.ZERO)
                        .set_Grid(Grid.Middle_Middle_Grid)
                        .set_BarCode("0B00030000000000")
                        .setStartX(0)
                        .setStartY(0)
                        .setOffsetX(384)
                        .setOffsetY(26)
                        .set_Content("http://ts2.taocaimall.com/order/index/qrIndex/745804518026993664"),
                new PrintPara(),
                new BarCodePara()
                        .set_Dir(Dir.ZERO)
                        .set_Grid(Grid.Middle_Middle_Grid)
                        .set_BarCode("0B00070000000000")
                        .setStartX(0)
                        .setStartY(0)
                        .setOffsetX(384)
                        .setOffsetY(26)
                        .set_Content("http://ts2.taocaimall.com/order/index/qrIndex/745804518026993664"),
                new PrintPara(),
                new BarCodePara()
                        .set_Dir(Dir.ZERO)
                        .set_Grid(Grid.Middle_Middle_Grid)
                        .set_BarCode("0B00050600000000")
                        .setStartX(0)
                        .setStartY(0)
                        .setOffsetX(384)
                        .setOffsetY(26)
                        .set_Content("http://ts2.taocaimall.com/order/index/qrIndex/745804518026993664"),
                new PrintPara(),
                new CuttingPosition());
        printProduce.printSend(new PrintTest.DefaultPrintBack());
        printProduce.openBox(new PrintTest.DefaultPrintBack());
        printProduce.versionUpgrade(new PrintTest.DefaultPrintBack(), new File("C:\\Users\\lie_w\\Desktop\\Printer Tester\\D000048_210419.eup"));
    }

    private static void RealTimeBitmapPara3() throws MeterException {
        RealBitMap bitMap = new RealBitMap()
                .addSource(new File(PIC5))
                .compress(0.4)
                .preterate()
                .bulid();
        System.out.println(String.format("位图 每行字节数： %s 全部信息：%s", bitMap.getLineLength(), bitMap.getContent()));
        RealBitmapPara bitmapPara = new RealBitmapPara()
                .setStartX(50)
                .setStartY(30)
                .setBitMap(bitMap);

        PrintRealBitmapRequest request = new PrintRealBitmapRequest(bitmapPara, true);
        request.setPrintBack(new PrintTest.DefaultPrintBack());
        PrintFactory.getInstance()
                .setMessenger(new DefaultPrintSerialMessenger())
                .sendDataWithoutAssemble(request);
    }

    /**
     * @description: 实时位图打印
     **/
    public static void RealTimeBitmapPara1() throws MeterException {
        File source = new File(PIC1);
        // 压缩
        File compress = new File("C:\\Users\\lie_w\\Desktop\\dither\\compress\\" + source.getName());
        DitherFactory.compress(source, compress, 0.4);

        // 抖动
        File target = new File("C:\\Users\\lie_w\\Desktop\\dither\\print\\" + source.getName());
        DitherVal dither = DitherFactory.dither(compress, target);
        String bulid = new BitMapFile(2, dither).bulid();

        RealBitmapPara tempBitmapPara = new RealBitmapPara()
                .setStartX(50)
                .setStartY(30)
                .setSizeX(dither.getWidth())
                .setSizeY(dither.getHeight())
                .setData(bulid);
        basePrint(tempBitmapPara);
    }

    /**
     * @description: 实时位图打印
     **/
    public static void RealTimeBitmapPara2() throws MeterException {
        RealBitmapPara tempBitmapPara = new RealBitmapPara()
                .setStartX(0)
                .setStartY(0)
                .setSizeX(20)
                .setSizeY(17)
                .setData("E01F30E01F30E01F30FFFFF0FFFFF0FFFFF0FFFFF0FFFFF0E01F30E01F30E01F30E31F30E49F30E49F30E49F30E31F30E01F30");
//                .setSizeX(10)
//                .setSizeY(12)
//                .setData("F8C0F8C0F8C0F8C0F8C0FFC0F8C0F8C0F8C0F8C0F8C0FFC0");
        basePrint(tempBitmapPara);
    }

    /**
     * @description: 实时位图打印
     **/
    public static void RealTimeBitmapPara() throws MeterException {
        RealBitmapPara tempBitmapPara = new RealBitmapPara()
                .setStartX(50)
                .setStartY(30)
                .setSizeX(20)
                .setSizeY(29)
                .setData("E01F30E01F30E01F30FFFFF0FFFFF0FFFFF0FFFFF0FFFFF0E01F30E01F30E01F30E31F30E49F30E49F30E49F30E31F30E01F30E01F30FFFFF0E01F30E01F30E01F30E01F30E01F30E01F30E01F30E01F30E01F30FFFFF0");
//                .setSizeX(10)
//                .setSizeY(12)
//                .setData("F8C0F8C0F8C0F8C0F8C0FFC0F8C0F8C0F8C0F8C0F8C0FFC0");
        basePrint(tempBitmapPara);
    }

    private static void bitMapUpdateDither3() throws MeterException {
        File source = new File(PIC5);
        FileBitMap bitMap = new FileBitMap()
                .addSource(source)
                .compress(0.4)
                .preterate()
                .setNumber(2)
                .bulid();

        PrintBitMapRequest request = new PrintBitMapRequest(source.getName(), bitMap);
        request.setSdk(true);
        request.setPrintBack(new IPrintBack() {
            @Override
            public void responseBack(PrintResponse response) {
                TempBitmapPara tempBitmapPara = new TempBitmapPara()
                        .set_Dir(Dir.ZERO)
                        .set_Grid(Grid.Defaul_Grid)
                        .setStartX(0)
                        .setStartY(0)
                        .setOffsetX(384)
                        .setOffsetY(26)
                        .set_InnerBitmapNumber(2);
                try {
                    basePrint(tempBitmapPara);
                } catch (MeterException e) {
                    e.printStackTrace();
                }
            }
        });
        PrintFactory.getInstance()
                .build(new DefaultPrintSerialMessenger())
                .upgrade(request);
    }

    private static void bitMapUpdateDither2() throws MeterException {
        File source = new File(PIC5);
        FileBitMap bitMap = new FileBitMap()
                .addSource(source)
                .compress(0.4)
                .preterate()
                .setNumber(2)
                .bulid();

        PrintBitMapRequest request = new PrintBitMapRequest(source.getName(), bitMap.getContent());
        request.setSdk(true);
        request.setPrintBack(new IPrintBack() {
            @Override
            public void responseBack(PrintResponse response) {
                TempBitmapPara tempBitmapPara = new TempBitmapPara()
                        .set_Dir(Dir.ZERO)
                        .set_Grid(Grid.Defaul_Grid)
                        .setStartX(0)
                        .setStartY(0)
                        .setOffsetX(384)
                        .setOffsetY(26)
                        .set_InnerBitmapNumber(2);
                try {
                    basePrint(tempBitmapPara);
                } catch (MeterException e) {
                    e.printStackTrace();
                }
            }
        });
        PrintFactory.getInstance()
                .build(new DefaultPrintSerialMessenger())
                .upgrade(request);
    }

    private static void bitMapUpdateDither1() throws MeterException {
        File source = new File(PIC7);
        File target = new File("C:\\Users\\lie_w\\Desktop\\dither\\print\\" + source.getName());
        DitherVal dither = DitherFactory.dither(source, target);
        String bulid = new BitMapFile(2, dither).bulid();
        System.out.println(bulid);

        PrintBitMapRequest request = new PrintBitMapRequest(source.getName(), bulid);
        request.setSdk(true);
        request.setPrintBack(new IPrintBack() {
            @Override
            public void responseBack(PrintResponse response) {
                TempBitmapPara tempBitmapPara = new TempBitmapPara()
                        .set_Dir(Dir.ZERO)
                        .set_Grid(Grid.Defaul_Grid)
                        .setStartX(0)
                        .setStartY(0)
                        .setOffsetX(384)
                        .setOffsetY(26)
                        .set_InnerBitmapNumber(2);
                try {
                    basePrint(tempBitmapPara);
                } catch (MeterException e) {
                    e.printStackTrace();
                }
            }
        });
        PrintFactory.getInstance()
                .build(new DefaultPrintSerialMessenger())
                .upgrade(request);
    }

    /**
     * @description: 图片 dither算法转位图升级
     **/
    private static void bitMapUpdateDither() throws MeterException {
        File source = new File(PIC1);
        // 压缩
        File compress = new File("C:\\Users\\lie_w\\Desktop\\dither\\compress\\" + source.getName());
        DitherFactory.compress(source, compress, 0.2);

        // 抖动
        File target = new File("C:\\Users\\lie_w\\Desktop\\dither\\print\\" + source.getName());
        DitherVal dither = DitherFactory.dither(compress, target);
        String bulid = new BitMapFile(2, dither).bulid();
        System.out.println(bulid);

        PrintBitMapRequest request = new PrintBitMapRequest(source.getName(), bulid);
        request.setSdk(true);
        request.setPrintBack(new IPrintBack() {
            @Override
            public void responseBack(PrintResponse response) {
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                TempBitmapPara tempBitmapPara = new TempBitmapPara()
                        .set_Dir(Dir.ZERO)
                        .set_Grid(Grid.Defaul_Grid)
                        .setStartX(0)
                        .setStartY(0)
                        .setOffsetX(384)
                        .setOffsetY(26)
                        .set_InnerBitmapNumber(1);
                try {
                    basePrint(tempBitmapPara);
                } catch (MeterException e) {
                    e.printStackTrace();
                }
            }
        });
        PrintFactory.getInstance()
                .build(new DefaultPrintSerialMessenger())
                .upgrade(request);
    }

    /**
     * @description: 打印机状态
     **/
    public static void cmd0100_01() throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());

        PrintSetRequest request = new PrintSetRequest();
        request.setItem(1);
        request.setSave(PrintParamSave.FOREVER);
        request.setVal(1);

        printProduce.setPrintParam(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应原始信息
             */
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(response.toJSON());
            }
        }, request);
    }

    /**
     * @description: 打印机状态
     **/
    public static void cmd0100() throws MeterException {
        Print0100Request request = new Print0100Request();
        request.setItem(1);
        request.setVal(0);
        printCmd(request);
    }

    static int count = 0;
    static PrintProcessor_A printProcessor_a;

    static {
        try {
            printProcessor_a = new PrintProcessor_A().setMessenger(new DefaultPrintSerialMessenger());
        } catch (MeterException e) {
            e.printStackTrace();
        }
    }

    /**
     * @description: 打印机状态
     **/
    public static void cmd0000() throws MeterException {
//        printCmd(request);
        PrintFactory.getInstance().setMax(50, false);
        printProcessor_a.getPrintInfo(new PrintTest.DefaultPrintBack() {
            @Override
            public void responseBack(PrintBackResponse response) {
                System.out.println(JSON.toJSONString(response));

//                if (count < 5) {
//                    try {
//                        count++;
//                        cmd0000();
//                    } catch (MeterException e) {
//                        e.printStackTrace();
//                    }
//                }
            }
        });
    }

    /**
     * @description: 关机保护
     **/
    public static void cmd0200() throws MeterException {
        Print0200Request request = new Print0200Request();
        printCmd(request);
    }

    private static void cmd0A00() throws MeterException {
        Print0A00Request request = new Print0A00Request();
        request.setGroupId(0);
        request.setPwd("FFFFFF");
        printCmd(request);
    }

    private static void cmd0900() throws MeterException {
        Print0900Request request = new Print0900Request();
        request.setPage(8);
        request.setWriterContent("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        printCmd(request);
    }

    private static void cmd0800() throws MeterException {
        Print0800Request request = new Print0800Request();
        request.setPage(8);
        printCmd(request);
    }

    private static void cmd0700() throws MeterException {
        Print0700Request request = new Print0700Request().specify();
        printCmdDelayClose(request);
    }

    private static void cmd0600() throws MeterException {
        Print0600Request request = new Print0600Request();
        request.setInnerId("AC595A2C83080400020A0C9ED2EAF31D");
        request.setOuterId("J00000179");
        request.innerHex(new JRSAEncryptDecrypt());
        printCmd(request);
    }

    private static void cmd0500() throws MeterException {
//        Print0500Request request = new Print0500Request();
//        request.setInnerId("8C0E962C38");
//        request.setOuterId("J0000000123");
//        request.innerHex(new JRSAEncryptDecrypt());
//        printCmd(request);

        String encrypt = new String(new JRSAEncryptDecrypt().encrypt(ByteUtils.fromHexString("FC1D012C")));

        System.out.println(encrypt);

        String part = ByteUtils.toHexString(encrypt.getBytes()).toUpperCase() + "00";

        System.out.println(part);


//        new PrintProduce()
//                .setMessenger(new DefaultPrintSerialMessenger())
//                .addEncryptDecrypt(new JRSAEncryptDecrypt())
//                .writeCard(new EntityCard("8C0E962C38", "J0000000123"), new IPrintBack() {
//                    /**
//                     * @param response
//                     * @description: 操作结果响应业务信息
//                     */
//                    @Override
//                    public void responseBack(PrintBackResponse response) {
//                        System.out.println(response.toJSON());
//                    }
//                });
    }

    /**
     * @description: 2.5  获取JKY卡信息(CMD=0x0004)
     **/
    public static void cmd0400() throws MeterException {
        Print0400Request request = new Print0400Request().specify(0);
        printCmdDelayClose(request);
    }

    /**
     * @description: 2.5  获取JKY卡信息(CMD=0x0004)
     **/
    public static void cmd04001() throws MeterException {
        Print0400Request request = new Print0400Request().specify();
        printCmdDelayClose2(request);
    }

    private static void versionCheck(String version) throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.versionUpgradeCheck(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应业务信息
             */
            @Override
            public void responseBack(PrintBackResponse response) {
                System.out.println(JSON.toJSONString(response));
                PrintFactory.getInstance().closeMessenger();
            }
        }, new File(version));
    }

    private static void fontCheck(String fileName) throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.fontUpgradeCheck(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应业务信息
             */
            @Override
            public void responseBack(PrintBackResponse response) {
                System.out.println(JSON.toJSONString(response));
                PrintFactory.getInstance().closeMessenger();
            }
        }, new File(fileName));
    }

    /**
     * @description: 版本升级
     **/
    private static void verisonUpgrade(String version) throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.versionUpgrade(new IPrintBack() {
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(JSON.toJSONString(response));
                try {
                    Thread.sleep(60000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    getPrintInfo();
                } catch (MeterException e) {
                    e.printStackTrace();
                }
                System.out.println("关闭连接");
            }
        }, new File(version));
    }

    /**
     * @description: 字库升级
     **/
    private static void fontUpgrade(String font) throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.fontUpgrade(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应信息
             */
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println("发送文件升级结果：" + JSON.toJSONString(response));
                try {
                    Thread.sleep(2000);
                } catch (InterruptedException e) {
                }
                try {
                    StringPara();
                } catch (MeterException e) {
                    e.printStackTrace();
                }
            }
        }, new File(font));
    }

    /**
     * @description: 位图升级
     **/
    private static void bitMapUpgrade(String bitMap) throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.bitMapUpgrade(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应信息
             */
            @Override
            public void responseBack(PrintBackResponse response) {
                System.out.println("发送文件升级结果：" + JSON.toJSONString(response));
                try {
                    Thread.sleep(200);
                } catch (InterruptedException e) {
                }
                try {
                    TempBitmapPara();
                } catch (MeterException e) {
                    e.printStackTrace();
                }
            }
        }, new File(bitMap));
    }

    /**
     * @description: 获取打印机信息
     **/
    private static void getPrintInfo() throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.getPrintInfo(new PrintTest.DefaultPrintBack());
    }

    /**
     * @description: 设置打印机灰度
     **/
    private static void setPrintGrayscale() throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.setPrintGrayscale(new PrintTest.DefaultPrintBack(), PrintParamSave.FOREVER, 15);
    }

    /**
     * @description: 获取缓冲打印信息
     **/
    private static void printPara2() throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.addParas(new StringPara()
                        .set_Font(Font.FONT5)
                        .set_Dir(Dir.ZERO)
                        .set_Grid(Grid.Middle_Middle_Grid)
                        .setStartX(0)
                        .setStartY(0)
                        .setOffsetX(384)
                        .setOffsetY(26)
                        .set_Content("-------------------sfds20---fff----------------------"),
                new TempBitmapPara()
                        .set_Dir(Dir.ZERO)
                        .set_Grid(Grid.Defaul_Grid)
                        .setStartX(0)
                        .setStartY(0)
                        .setOffsetX(384)
                        .setOffsetY(50)
                        .set_InnerBitmapNumber(1),
                new PrintPara(), new CuttingPosition());

        System.out.println(JSON.toJSONString(printProduce.getParas()));
    }

    /**
     * @description: 添加打印部件并打印
     **/
    private static void printPara() throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.addParas(new StringPara()
                        .set_Font(Font.FONT5)
                        .set_Dir(Dir.ZERO)
                        .set_Grid(Grid.Middle_Middle_Grid)
                        .setStartX(0)
                        .setStartY(0)
                        .setOffsetX(384)
                        .setOffsetY(26)
                        .set_Content("-------------------sfds20---fff----------------------"),
                new TempBitmapPara()
                        .set_Dir(Dir.ZERO)
                        .set_Grid(Grid.Defaul_Grid)
                        .setStartX(0)
                        .setStartY(0)
                        .setOffsetX(384)
                        .setOffsetY(50)
                        .set_InnerBitmapNumber(1),
                new PrintPara(), new CuttingPosition());
        printProduce.printSend(new PrintTest.DefaultPrintBack());
    }

    /**
     * @description: 打印模板1数据
     **/
    private static void printTemp1Val2() throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.printValTemp1(new PrintTest.DefaultPrintBack(), PrintTest.printVal());
    }

    /**
     * @description: 打印模板1数据
     **/
    private static void printTemp1Val3() throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.printValTemp(new PrintTest.DefaultPrintBack(), PrintTest.printVal(), new Temp1());
    }

    /**
     * @description: 打印模板2数据
     **/
    private static void printTemp1Val4() throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.printValTemp(new PrintTest.DefaultPrintBack(), PrintTest.memberPrintVal(), new Temp2());
    }

    /**
     * @description: 打印模板1数据
     **/
    public static void printTemp1Val() throws MeterException {
        PrintVal printVal = PrintTest.printVal();
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        new Temp1().tempInit();
        printProduce.printVal(new PrintTest.DefaultPrintBack(), printVal);

    }

    /**
     * @description: 打印发送数据测试
     **/
    private static void printTemp1() throws MeterException {
        String data = "033016000000000000000080011A0001000412000000010000000080011A00E6B58BE8AF95E5BA97E993BA0004120000050100000000" +
                "80011A00000412000005010000000080011A00000412000005010000000080011A00000412000005010000000080011A000004120000040100" +
                "00000054001A004430001200000401540000001E001A005631001200000501800000007D001A00001200000501030100007D001A0023303030" +
                "303031000412000004010000000072001A00E99480E594AEE697B6E997B43A001200000001730000008C001A00323032302D31322D32350012" +
                "000006010E01000070001A0031323A30303A303000120000050000001A00800110002D202D202D202D202D202D202D202D202D202D202D202D" +
                "202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D000412000004010000000068001A00E59586E59381E5908DE7A7B0" +
                "001200000501B5000000A0001A00E59586E59381E7BC96E58FB70012000004010E001A004C001A00E58D95E4BBB700120000050163001A00AC" +
                "001A00E9878DE9878F2FE695B0E9878F00120000050118011A0068001A00E98791E9A29D0012000005000000340080010F002D202D202D202D" +
                "202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D0004120000040100000000" +
                "B4001A00E781ABE99485E4B8B8E5AD90001200000501B4000000C8001A0034353300040412000004010000000080001A000012000005018000" +
                "000080001A000012000006010001000080001A00000412000006010000000060001A0031352E38302F6B67001200000401C000000060001A00" +
                "302E36376B670012000006012001000060001A00EFBFA52031302E35390004120000040100000000B4001A00E9B8A1E885BF001200000501B4" +
                "000000C8001A0032353300040412000004010000000080001A000012000005018000000080001A000012000006010001000080001A00000412" +
                "000006010000000060001A0031372E38302F6B67001200000401C000000060001A00302E36376B670012000006012001000060001A00EFBFA5" +
                "2031312E39330004120000040100000000B4001A00E9B8A1E8BEB9E885BF001200000501B4000000C8001A0032353400040412000004010000" +
                "000080001A000012000005018000000080001A000012000006010001000080001A00000412000006010000000060001A00392E36302FE4BBB6" +
                "001200000401C000000060001A00310012000006012001000060001A00EFBFA520392E36300004120000050000000000800112002D202D202D" +
                "202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D202D000400041200000502" +
                "04000000C8002200E5AE9EE694B6E98791E9A29D3A001200000502DD000000A000220033322E313200040012000004018F00000076001A00E6" +
                "94B6E993B6E98791E9A29D3A0012000005010501000078001A0033322E31320012000004018F001A0076001A00E689BEE99BB6E98791E9A29D" +
                "3A00120000050105011A0078001A00302E30300000040412000005010000000080011A00E8B0A2E8B0A2E683A0E9A1BEEFBC8CE6ACA2E8BF8E" +
                "E5868DE6ACA1E58589E4B8B4000412000005010000000080011A00000412000005010000000080011A00000412000005010000000080011A00" +
                "00040608";

        PrintDataRequest request = new PrintDataRequest();
        request.setData(data);
        request.setPrintBack(new PrintTest.DefaultPrintBack() {
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(JSON.toJSONString(response));
                PrintFactory.getInstance().closeMessenger();
                System.out.println("打印关闭连接");
            }

            @Override
            public void schedule(ScheduleState scheduleState) {
                System.out.println(scheduleState.toString());
            }
        });

        PrintFactory.getInstance()
                .setMessenger(new DefaultPrintSerialMessenger())
                .sendData(request);
    }

    /**
     * @description: 临时打印
     **/
    public static void printTemp() throws MeterException {
        PrintFactory.getInstance()
                .setMessenger(new DefaultPrintSerialMessenger())
                .printTemp(new PrintTest.DefaultPrintBack() {
                    @Override
                    public void responseBack(PrintResponse response) {
                        System.out.println(JSON.toJSONString(response));
                        PrintFactory.getInstance().closeMessenger();
                        System.out.println("关闭连接");
                    }

                    @Override
                    public void schedule(ScheduleState scheduleState) {
                        System.out.println(scheduleState.toString());
                    }
                }, PrintTest.printVal());
    }

    /**
     * @description: 打印机状态
     **/
    public static void cmd0300() throws MeterException {
        Print0300Request request = new Print0300Request();
        printCmd(request);
    }

    /**
     * @description: 打印命令操作
     **/
    public static void printCmd(PrintCmdRequest request) throws MeterException {
        request.setSdk(true);
        request.setPrintBack(new PrintTest.DefaultPrintBack() {
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(JSON.toJSONString(response));

                if (response instanceof Print0500Response) {
                    System.out.println("inner id: " + ((Print0500Response) response).innerHex(new JRSAEncryptDecrypt()));
                } else if (response instanceof Print0600Response) {
                    System.out.println("inner id: " + ((Print0600Response) response).innerHex(new JRSAEncryptDecrypt()));
                }

                PrintFactory.getInstance().closeMessenger();
                System.out.println("关闭连接");
            }
        });
        PrintFactory.getInstance()
                .build(new DefaultPrintSerialMessenger())
                .sendData(request);
    }

    /**
     * @description: 打印命令操作
     **/
    public static void printCmdDelayClose(PrintCmdRequest request) throws MeterException {
        request.setSdk(true);
        request.setPrintBack(new PrintTest.DefaultPrintBack() {
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(JSON.toJSONString(response));
                if (response instanceof Print0400Response) {
                    System.out.println("inner id: " + ((Print0400Response) response).innerHex(new JRSAEncryptDecrypt()));
                }
            }
        });
        PrintFactory.getInstance()
                .build(new DefaultPrintSerialMessenger())
                .addRSAEncryptDecrypt(new JRSAEncryptDecrypt())
                .sendData(request);

        PortManagerTest.sleep(120);
        PrintFactory.getInstance().closeMessenger();
        System.out.println("关闭连接");
    }

    /**
     * @description: 打印命令操作
     **/
    public static void printCmdDelayClose2(PrintCmdRequest request) throws MeterException {
        request.setSdk(true);
        request.setPrintBack(new PrintTest.DefaultPrintBack() {
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(JSON.toJSONString(response));
                if (response instanceof Print0400Response) {
                    System.out.println("inner id: " + ((Print0400Response) response).innerHex(new JRSAEncryptDecrypt()));
                }
            }
        });
        PrintFactory.getInstance()
//                .build(new DefaultPrintSerialMessenger("COM34", 115200))
                .build(new DefaultPrintSerialMessenger("COM3", 9600))
                .addRSAEncryptDecrypt(new JRSAEncryptDecrypt())
                .sendDataWithAllPackage(request);

        PortManagerTest.sleep(120);
        PrintFactory.getInstance().closeMessenger();
        System.out.println("关闭连接");
    }

    /**
     * @description: 版本升级
     **/
    public static void upgrade(String version) throws MeterException {
        long start = System.currentTimeMillis();

        PrintUpgradeRequest printUpgradeRequest = new PrintUpgradeRequest(new File(version));
        System.out.println("升级版本 Hex信息：" + printUpgradeRequest.assembler().toString());

        printUpgradeRequest.setPrintBack(new PrintTest.DefaultPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应信息
             */
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println("发送文件升级结果：" + JSON.toJSONString(response));
                PrintFactory.getInstance().closeMessenger();
                System.out.println("关闭连接");
            }
        });

        PrintFactory.getInstance()
                .setMessenger(new DefaultPrintSerialMessenger())
                .upgrade(printUpgradeRequest);

        System.out.println("升级版本耗时：" + (System.currentTimeMillis() - start));
    }

    /**
     * @description: 字库升级
     **/
    public static void fontUpdate(String FONT_SIM) throws MeterException {
        long start = System.currentTimeMillis();

        PrintFontRequest printFontRequest = new PrintFontRequest(new File(FONT_SIM));
        System.out.println("升级字库 Hex信息：" + printFontRequest.assembler().toString());

        printFontRequest.setPrintBack(new PrintTest.DefaultPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应信息
             */
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println("发送文件升级结果：" + JSON.toJSONString(response));
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                }
                try {
                    StringPara();
                } catch (MeterException e) {
                    e.printStackTrace();
                }
            }
        });

        PrintFactory.getInstance()
                .setMessenger(new DefaultPrintSerialMessenger())
                .upgrade(printFontRequest);

        System.out.println("升级字库耗时：" + (System.currentTimeMillis() - start));
    }

    /**
     * @description: 位图升级
     **/
    public static void bitMapUpdate(String bitMap) throws MeterException {
        PrintBitMapRequest printBitMapRequest = new PrintBitMapRequest(new File(bitMap));
        System.out.println("升级位图Hex信息：" + printBitMapRequest.assembler().toString());
        printBitMapRequest.setPrintBack(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应信息
             */
            @Override
            public void responseBack(PrintBackResponse response) {
                System.out.println("发送文件升级结果：" + JSON.toJSONString(response));
                try {
                    Thread.sleep(200);
                } catch (InterruptedException e) {
                }
                try {
                    TempBitmapPara();
                } catch (MeterException e) {
                    e.printStackTrace();
                }
            }
        });

        PrintFactory.getInstance()
                .setMessenger(new DefaultPrintSerialMessenger())
                .originalResponse(true)
                .upgrade(printBitMapRequest);
    }

    /**
     * @description: 条码打印
     **/
    public static void BarCodePara() throws MeterException {
        BarCodePara barCodePara = new BarCodePara()
                .set_Dir(Dir.ZERO)
                .set_Grid(Grid.Middle_Middle_Grid)
                .set_Barcode(Barcode.QR)
                .setStartX(0)
                .setStartY(0)
                .setOffsetX(250)
                .setOffsetY(250)
                .set_Content("https://check-local.smartpos.top/portal/bigScreen/commentIndex?tenantId=201255&branchId=1420&saleCode=4032103251720430012");
        basePrint(barCodePara);
    }

    public static void FramePara() throws MeterException {
        FramePara framePara = new FramePara()
                .set_Dir(Dir.ZERO)
                .set_Border(5)
                .setStartX(0)
                .setStartY(0)
                .setOffsetX(250)
                .setOffsetY(250);
        basePrint(framePara);
    }

    /**
     * @description: 暂存位图打印
     **/
    public static void TempBitmapPara() throws MeterException {
        TempBitmapPara tempBitmapPara = new TempBitmapPara()
                .set_Dir(Dir.ZERO)
                .set_Grid(Grid.Defaul_Grid)
                .setStartX(0)
                .setStartY(0)
                .setOffsetX(384)
                .setOffsetY(50)
                .set_InnerBitmapNumber(1);
        basePrint(tempBitmapPara);
    }

    /**
     * @description: 基础字符串打印
     **/
    public static void StringPara() throws MeterException {
        StringPara stringPara = new StringPara()
                .set_Font(Font.FONT4)
                .set_Dir(Dir.ZERO)
                .addParas(StrPara.AutoNewLine, StrPara.DeleteFlag)
                .set_Grid(Grid.Middle_Middle_Grid)
                .setStartX(0)
                .setStartY(0)
                .setOffsetX(384)
                .setOffsetY(26)
                .set_Content("----()--()ffｆｆｆ（）----fdf----sfds20---fff----------------------");
        basePrint(stringPara);
    }

    /**
     * @description: 换行字符串打印
     **/
    public static void StringAutoLinePara() throws MeterException {
        StringAutoLinePara stringAutoLinePara = new StringAutoLinePara()
                .addParas(StrPara.AutoNewLine, StrPara.DeleteFlag)
                .set_Font(Font.FONT6)
                .set_Grid(Grid.Upper_Middle_Grid)
                .set_Content("大中国\n大世界\n大地球");
        basePrint(stringAutoLinePara);
    }

    /**
     * @description: 单部件打印
     **/
    public static void basePrint(Para para) throws MeterException {
        PrintDataRequest printDataRequest = new PrintDataRequest()
                .addPara(para)
                .addPrintPointAndCutPoint();
        System.out.println("单部件" + para.getClass() + "打印: " + printDataRequest.assembler().toString());

        printDataRequest.setPrintBack(new IPrintBack() {
            @Override
            public void responseBack(PrintResponse response) {
                System.out.println(JSON.toJSONString(response));
//                PrintFactory.getInstance().closeMessenger();
                System.out.println("关闭连接");
            }

            @Override
            public void schedule(ScheduleState scheduleState) {
                System.out.println(scheduleState.toString());
            }
        });

        PrintFactory.getInstance()
                .build(new DefaultPrintSerialMessenger())
                .sendData(printDataRequest);
    }
}
