package com.jhscale.test.serial;

import com.alibaba.fastjson.JSON;
import com.jhscale.common.model.device.DConstant;
import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.common.model.device._inner.PublicExecuteRecovery;
import com.jhscale.common.model.device.info.DDeviceInfo;
import com.jhscale.common.model.device.info.DDeviceInfoV1;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INA;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INF;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INM;
import com.jhscale.common.utils.DDataUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.*;
import com.jhscale.meter.io.control.win.*;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.DeviceDiscoverEventListener;
import com.jhscale.meter.io.listener.SocketClientEventListener;
import com.jhscale.meter.model.device.*;
import com.jhscale.meter.protocol.ad.em.CommunicationState;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.protocol.ad.entity.assembly.UpgradeFirmwareADPARequest;
import com.jhscale.meter.protocol.entity.ProtocolEntity;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.MeterConstant;

import java.util.List;
import java.util.Scanner;
import java.util.Set;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: PortManagerTest
 * @projectName jh-meter
 * @description: TODO
 * @date 2021/6/414:36
 */
public class PortManagerTest {

//    static {
//        JLog.init(new JavaLog());
//    }

    public static void main(String[] args) throws MeterException {
//        SerialPort_Found();
//        SerialPort_Listener();
//        SerialPort_Read();
//        Bluetooth_Found();
//        Bluetooth_Listener();
//        USB_Found();
//        USB_Listener();
        TCP_Server();
        TCP_Client();
        UDP_LINK_Terminal();
//        UDP_LINK_PC();
    }

    private static void UDP_LINK_PC() throws MeterException {
        UDPLink udpLink = new UDPLink(new WUDPControl(),
                UDPDevice.UDP_PC(),
                new DeviceClientEventListener() {
                    /**
                     * @param bytes
                     * @description: 连接监听
                     */
                    @Override
                    public void onClientEvent(byte[] bytes) {
                        System.out.println(new String(bytes));
                    }

                    /**
                     * @param e
                     * @description: 连接异常监听
                     */
                    @Override
                    public void onClientEventExp(MeterException e) {

                    }
                });
        udpLink.log(true);

        boolean OPEN = udpLink.openPort();
        System.out.println("OPEN: " + OPEN);

        String send_33583 = "UDP\t\r\n";
        for (int i = 0; i < 10; i++) {
            udpLink.writeDataImmediately(send_33583.getBytes());
//            sleep(1);
        }

        sleep(20);

        boolean CLOSE = udpLink.closePort();
        System.out.println("CLOSE: " + CLOSE);
    }

    /**
     * @description: UDP通讯
     **/
    private static void UDP_LINK_Terminal() throws MeterException {
        UDPLink udpLink = new UDPLink(new WUDPControl(),
                UDPDevice.UDP_Terminal(),
                new DeviceClientEventListener() {
                    /**
                     * @param bytes
                     * @description: 连接监听
                     */
                    @Override
                    public void onClientEvent(byte[] bytes) {
                        System.out.println(new String(bytes));
                    }

                    /**
                     * @param e
                     * @description: 连接异常监听
                     */
                    @Override
                    public void onClientEventExp(MeterException e) {

                    }
                });
        udpLink.log(true);

        boolean OPEN = udpLink.openPort();
        System.out.println("OPEN: " + OPEN);

        sleep(20);

        boolean CLOSE = udpLink.closePort();
        System.out.println("CLOSE: " + CLOSE);
    }

    /**
     * @description: TCP客户端模式
     **/
    private static void TCP_Client() throws MeterException {
        Scanner scanner = new Scanner(System.in);
        TCPClient tcpClient = new TCPClient(new WTCPClientControl(),
                new TCPClientDevice("192.168.0.107", 33582));
        tcpClient.log(true);

        boolean OPEN = tcpClient.openPort();
        System.out.println("OPEN: " + OPEN);

        while (true) {
            // 给服务端发点东西
            System.out.print("请输入：");
            String request = scanner.next();
            if ("out".equals(request)) {
                boolean CLOSE = tcpClient.closePort();
                System.out.println("CLOSE: " + CLOSE);
                break;
            }
            byte[] response = tcpClient.sendWithAccept(request.getBytes());
            if (response != null && response.length > 0) {
                System.out.println(String.format("服务端响应：%s", new String(response)));
            } else {
                System.out.println("服务端:未响应信息");
            }
        }

    }

    /**
     * @description: TCP 服务端模式
     **/
    private static void TCP_Server() throws MeterException {
        TCPServer tcpServer = new TCPServer(new WTCPServerControl(),
                new TCPServerDevice(33581),
                new SocketClientEventListener() {
                    /**
                     *
                     * @param portManager
                     * @param bytes
                     * @description: 连接监听
                     */
                    @Override
                    public byte[] onClientEventResponse(PortManager portManager, byte[] bytes) throws MeterException {
                        String accept = new String(bytes);
                        System.out.println(String.format("Accept: %s", accept));
                        List<PublicExecute> publicExecutes = DDataUtils.Public_UnPackage(accept);
                        if (publicExecutes != null && !publicExecutes.isEmpty()) {
                            for (PublicExecute publicExecute : publicExecutes) {
                                switch (publicExecute.getExecute()) {
                                    case PUBLIC_MDF:
                                        break;
                                    case PUBLIC_CLR:
                                        break;
                                    case PUBLIC_UPL:
                                        switch (publicExecute.getType()) {
                                            case MAC:
                                                break;
                                        }
                                        break;
                                    case PUBLIC_ASK:
                                        break;
                                }
                            }
                        }

                        if (publicExecutes != null
                                && publicExecutes.size() == 1
                                && publicExecutes.get(0) instanceof PublicExecuteRecovery
                                && DConstant.MAC.equals(publicExecutes.get(0).getType())) {
                            DDeviceInfo deviceInfo1 = new DDeviceInfoV1<>()
                                    .setIna(new DDeviceInfo_INA()
                                            .setEncoding("GB2312")
                                            .setWord_encoding("GB2312")
                                            .setRom(0)
                                            .setWord_rom(8388608)
                                            .setF1(8388608)
                                            .setF2(8)
                                            .setF3(8))
                                    .setInm(new DDeviceInfo_INM()
                                            .setSign("0023F0141292")
                                            .setUnique_sign("0023F0141292")
                                            .setLan(0))
                                    .setInf(new DDeviceInfo_INF()
                                            .setStore_name("富百汇生鲜超市（人民街）")
                                            .setDevice_name("33")
                                            .setDevice_serial(33)
                                            .setDevice_version("JB-xA CC138 V3.11D7"));
                            String INF_public_package = deviceInfo1.Public_Package();
                        }
                        return new byte[0];
                    }

                    /**
                     * @param e
                     * @description: 连接异常监听
                     */
                    @Override
                    public void onClientEventExp(MeterException e) {

                    }
                });
        tcpServer.log(true);

        boolean OPEN = tcpServer.openPort();
        System.out.println("OPEN: " + OPEN);

        sleep(200);

        boolean CLOSE = tcpServer.closePort();
        System.out.println("CLOSE: " + CLOSE);
    }

    /**
     * @description: USB 连接
     **/
    private static void USB_Listener() throws MeterException {
        USBPort usbPort = new USBPort(new WUSBControl(),
                new USBDevice(MeterConstant.DEFAULT_PID, MeterConstant.DEFAULT_VID),
                new DefaultDeviceClientEventListener());

        boolean OPEN = usbPort.openPort();
        System.out.println("OPEN: " + OPEN);

        sleep(20);

        boolean CLOSE = usbPort.closePort();
        System.out.println("CLOSE: " + CLOSE);
    }

    /**
     * @description: USB查找
     **/
    private static void USB_Found() throws MeterException {
        USBPort usbPort = new USBPort(new WUSBControl(), new DefaultDeviceDiscoverEventListener());
        boolean DISCOVERY = usbPort.discovery();
        System.out.println("DISCOVERY: " + DISCOVERY);

        sleep(20);

        boolean CANCEL_DISCOVERY = usbPort.cancelDiscovery(true);
        System.out.println("CANCEL_DISCOVERY: " + CANCEL_DISCOVERY);
        System.out.println("设备列表： " + JSON.toJSONString(usbPort.getDevices()));
    }

    /**
     * @description: 蓝牙连接监听
     **/
    private static void Bluetooth_Listener() throws MeterException {
        BluetoothPort bluetoothPort = new BluetoothPort(new WSerialPortControl(),
                new BlueDevice("000CBF12487E", "HC-02"),
                new DefaultDeviceClientEventListener());

        boolean OPEN = bluetoothPort.openPort();
        System.out.println("OPEN: " + OPEN);

        sleep(20);

        boolean CLOSE = bluetoothPort.closePort();
        System.out.println("CLOSE: " + CLOSE);
    }

    /**
     * @description: 蓝牙检索
     **/
    private static void Bluetooth_Found() throws MeterException {
        BluetoothPort bluetoothPort = new BluetoothPort(new WBluetoothControl(),
                new DefaultDeviceDiscoverEventListener());

        boolean DISCOVERY = bluetoothPort.discovery();
        System.out.println("DISCOVERY: " + DISCOVERY);

        sleep(20);

        boolean CANCEL_DISCOVERY = bluetoothPort.cancelDiscovery(false);
        System.out.println("CANCEL_DISCOVERY: " + CANCEL_DISCOVERY);
        System.out.println("设备列表： " + JSON.toJSONString(bluetoothPort.getDevices()));
    }

    private static void SerialPort_Read() throws MeterException {
        SerialPort serialPort = new SerialPort(new WSerialPortControl(),
                new SerialDevice<>("COM3", 9600, 0));

        boolean OPEN = serialPort.openPort();
        System.out.println("OPEN: " + OPEN);

        int time = 20;
        int min = 0;
        do {
            min++;
            try {
                System.out.println("休眠[ " + time + "s ]-第[" + min + "]分钟");
                Thread.sleep(1000);
                byte[] bytes = serialPort.readData();
                System.out.println(ByteUtils.toHexAscii(bytes));
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (min < time);

        boolean CLOSE = serialPort.closePort();
        System.out.println("CLOSE: " + CLOSE);
    }

    /**
     * @description: 串口连接监听
     **/
    private static void SerialPort_Listener() throws MeterException {
        SerialPort serialPort = new SerialPort(new WSerialPortControl(),
                new SerialDevice<>("COM3", 9600, 0),
                new DefaultDeviceClientEventListener());

        boolean OPEN = serialPort.openPort();
        System.out.println("OPEN: " + OPEN);

        ADPackAssemblyResponse execute = new UpgradeFirmwareADPARequest().execute();
        serialPort.writeDataImmediately(execute.HEX());

        sleep(2);

//        for (int i = 0; i < 20; i++) {
//            System.out.println("发送5555[" + i + "]次");
//            serialPort.writeDataImmediately(ByteUtils.fromHexString("55555555555555555555555555555555"));
//        }

        sleep(20);

//        boolean CLOSE = serialPort.closePort();
//        System.out.println("CLOSE: " + CLOSE);
    }

    /**
     * @description: 串口端口发现
     **/
    private static void SerialPort_Found() throws MeterException {
        SerialPort serialPort = new SerialPort(new WSerialPortControl(),
                new DefaultDeviceDiscoverEventListener());

        boolean DISCOVERY = serialPort.discovery();
        System.out.println("DISCOVERY: " + DISCOVERY);

        sleep(5);

        boolean CANCEL_DISCOVERY = serialPort.cancelDiscovery(true);
        System.out.println("CANCEL_DISCOVERY: " + CANCEL_DISCOVERY);
        System.out.println("设备列表： " + JSON.toJSONString(serialPort.getDevices()));
    }

    /**
     * @description: 休眠
     **/
    public static void sleep(int time) {
        int min = 0;
        do {
            min++;
            try {
                if (min % 10 == 0)
                    System.out.println("休眠[ " + time + "s ]-第[" + min + "]秒");
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (min < time);
    }

    private static class DefaultDeviceClientEventListener implements DeviceClientEventListener {
        /**
         * @param bytes
         * @description: 连接监听
         */
        @Override
        public void onClientEvent(byte[] bytes) {
            System.out.println("onClientEvent: " + ByteUtils.toHexAscii(bytes));
        }

//        /**
//         * @param bytes
//         * @description: 连接监听
//         */
//        @Override
//        public byte[] onClientEventResponse(byte[] bytes) throws MeterException {
//            String request = new String(bytes);
//            System.out.println(String.format("TCPClient Request : %s", request));
//            String response = String.format("Response: %s", request);
//            System.out.println(String.format("TCPClient Response : %s", response));
//            return response.getBytes();
//        }

        /**
         * @param e
         * @description: 连接异常监听
         */
        @Override
        public void onClientEventExp(MeterException e) {
            System.out.println("onClientEventExp: " + e.getMessage());
        }

        /**
         * @param key
         * @param response
         * @description: 发送命令添加回调
         */
        @Override
        public void addProtocolResponse(String key, ProtocolEntity response) {
            System.out.println("addProtocolResponse: " + key);
        }

        /**
         * @param communication
         * @description: 设置通讯状态模式
         */
        @Override
        public void setCommunication(CommunicationState communication) {

        }

        /**
         * @description: 获取当前通讯协议状态
         **/
        @Override
        public CommunicationState getCommunication() {
            return null;
        }

        /**
         * @description: 监听器停止
         **/
        @Override
        public void stop() {

        }
    }

    private static class DefaultDeviceDiscoverEventListener implements DeviceDiscoverEventListener<Device> {
        /**
         * @param device
         * @description: 发现监听事件
         */
        @Override
        public void onDiscoverEvent(Device device) {
            System.out.println("onDiscoverEvent: " + device.getDevice());
        }

        /**
         * @param devicesDiscovered
         * @description: 完成设备查找 返回全部设备列表
         */
        @Override
        public void onDiscoverSuccessEvent(Set<Device> devicesDiscovered) {
            String deviceNames = "";
            for (Device device : devicesDiscovered) {
                deviceNames += device.getDevice() + ",";
            }
            System.out.println("onDiscoverSuccesEvent: " + deviceNames);
        }

        /**
         * @param e
         * @description: 查找设备异常
         */
        @Override
        public void onDiscoverEventExp(MeterException e) {
            System.out.println("onDiscoverEventExp: " + e.getMessage());
        }
    }
}
