package com.jhscale.test.serial;

import com.alibaba.fastjson.JSON;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintFactory;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.data.PrintDataParse;
import com.jhscale.meter.protocol.print.data.PrintVal;
import com.jhscale.meter.protocol.print.em.*;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity.ScheduleState;
import com.jhscale.meter.protocol.print.entity.cmd.Print0000Request;
import com.jhscale.meter.protocol.print.entity.cmd.Print0100Request;
import com.jhscale.meter.protocol.print.entity.cmd.Print0200Request;
import com.jhscale.meter.protocol.print.entity.cmd.Print0400Request;
import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;
import com.jhscale.meter.protocol.print.entity.file.bitmap.PrintBitMapRequest;
import com.jhscale.meter.protocol.print.entity.file.font.PrintFontRequest;
import com.jhscale.meter.protocol.print.entity.file.upgrade.PrintUpgradeRequest;
import com.jhscale.meter.protocol.print.entity.para.*;
import com.jhscale.meter.protocol.print.link.*;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import com.jhscale.meter.protocol.print.produce.impl.PrintProcessor;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.FileUtils;
import com.jhscale.meter.utils.PrintUtils;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lie_w
 * @title: PrintTest
 * @projectName jhscale-agreement
 * @description: 打印测试
 * @date 2020-12-1113:21
 */
public class PrintTest {

    /**
     * @description: 默认结果回调
     **/
    public static class DefaultPrintBack implements IPrintBack {
        @Override
        public void responseBack(PrintResponse response) {
            System.out.println(JSON.toJSONString(response));
            // PrintFactory.getInstance().closeMessenger();
        }

        @Override
        public void responseBack(PrintBackResponse response) {
            System.out.println(JSON.toJSONString(response));
            // PrintFactory.getInstance().closeMessenger();
        }

        @Override
        public void schedule(ScheduleState scheduleState) {
            System.out.println(scheduleState.toString());
        }
    }

    public static void main(String[] args) throws MeterException {
//        printContent();
//        printContent();
//        sendTest();
//        printTemp();
//        basePrint();
//        testCmd();
//        test0000();
//        test0100();
//        test0200();
//        test0300();
        test0400();
//        fileToHex();
//        bitMapUpdate();
//        fontUpdate();
//        fontUpdate_1();
//        upgrade();
    }

    private static void fontUpdate_1() throws MeterException {
        long start = System.currentTimeMillis();

        // 打印机初始化
        PrintGeneralFactory.getInstance().Init_Print_Factory(new DefaultPrintSerialMessenger("COM3", 115200), null);

        PrintProcessor communication = PrintGeneralFactory.getInstance().getCommunication();

        PrintFontRequest printFontRequest = new PrintFontRequest(new File(PrintTest.B_023));
        printFontRequest.setPrintBack(new IPrintBack() {
            /**
             * @param response
             * @description: 操作结果响应业务信息
             */
            @Override
            public void responseBack(PrintBackResponse response) {
                System.out.printf("升级完成。。。%s \n", response.toJSON());
            }
        });
        communication.fontUpgrade(printFontRequest);
    }

    static String VERSION1 = "I:\\文档\\底层开发协议\\Printer Tester\\D000048_210101.eup";
    static String VERSION2 = "I:\\文档\\底层开发协议\\Printer Tester\\D000048_210104.eup";
    static String VERSION3 = "I:\\文档\\底层开发协议\\Printer Tester\\D000048_210108.eup";
    static String VERSION4 = "I:\\文档\\底层开发协议\\Printer Tester\\D000048_210426.eup";
    static String VERSION5 = "I:\\文档\\底层开发协议\\Printer Tester\\D000048_220801.eup";
    static String VERSION6 = "E:\\JHScale\\Resources\\D000048_230610.eup";
    static String VERSION7 = "E:\\JHScale\\Resources\\spp\\D000048_231219.eup";

    /**
     * @description: 版本升级
     **/
    public static void upgrade() throws MeterException {
        long start = System.currentTimeMillis();

        // 打印机初始化
        PrintGeneralFactory.getInstance().Init_Print_Factory(new DefaultPrintSerialMessenger("COM3", 115200), null);

        PrintUpgradeRequest printUpgradeRequest = new PrintUpgradeRequest(new File(VERSION6));
        PrintProcessor communication = PrintGeneralFactory.getInstance().getCommunication();
        communication.versionUpgrade(printUpgradeRequest);

//        PrintUpgradeRequest printUpgradeRequest = new PrintUpgradeRequest(new File(VERSION5));
//        String printUpgradeRequestStr = printUpgradeRequest.assembler().toString();
//        long start1 = System.currentTimeMillis();
//        System.out.println("升级版本1 耗时：[ " + (start1 - start) + " ] 长度：[ " + printUpgradeRequestStr.length() + " ] \n信息：" + printUpgradeRequestStr);
//        PrintUpgradeRequest printUpgradeRequest2 = new PrintUpgradeRequest(new File(VERSION2));
//        String printUpgradeRequest2Str = printUpgradeRequest2.assembler().toString();
//        long start2 = System.currentTimeMillis();
//        System.out.println("升级版本2 耗时：[ " + (start2 - start1) + " ] 长度：[ " + printUpgradeRequest2Str.length() + " ] \n信息：" + printUpgradeRequest2Str);
    }

    static String FONT_SIM1 = "I:\\文档\\底层开发协议\\Printer Tester\\Font_Sim1.bin";
    static String FONT_SIM2 = "I:\\文档\\底层开发协议\\Printer Tester\\Font_Sim2.bin";
    static String FONT_FULL = "I:\\文档\\底层开发协议\\Printer Tester\\Font_Full_宋A.bin";
    static String FONT_FULL_NEW = "I:\\文档\\底层开发协议\\Printer Tester\\B_021.bin";
    static String B_022 = "I:\\文档\\底层开发协议\\Printer Tester\\B_022.bin";
    static String B_021 = "I:\\文档\\底层开发协议\\Printer Tester\\B_021.bin";
    static String B_023 = "E:\\JHScale\\Resources\\spp\\B_023.bin";
    static String B_030 = "E:\\JHScale\\Resources\\spp\\B_030.bin";

    /**
     * @description: 字库升级
     **/
    public static void fontUpdate() {
        long start = System.currentTimeMillis();
        PrintFontRequest printFontRequest = new PrintFontRequest(new File(FONT_SIM1));
        String printFontRequestStr = printFontRequest.assembler().toString();
        long start1 = System.currentTimeMillis();
        System.out.println("升级字库1 耗时：[ " + (start1 - start) + " ] 长度：[ " + printFontRequestStr.length() + " ] \n信息：" + printFontRequestStr);
        PrintFontRequest printFontRequest2 = new PrintFontRequest(new File(FONT_SIM2));
        String printFontRequest2Str = printFontRequest2.assembler().toString();
        long start2 = System.currentTimeMillis();
        System.out.println("升级字库2 耗时：[ " + (start2 - start1) + " ] 长度：[ " + printFontRequest2Str.length() + " ]\n信息：" + printFontRequest2Str);
        PrintFontRequest printFontRequestFull = new PrintFontRequest(new File(FONT_FULL));
        String printFontRequestFullStr = printFontRequestFull.assembler().toString();
        long start3 = System.currentTimeMillis();
        System.out.println("升级字库全 耗时：[ " + (start3 - start2) + " ] 长度：[ " + printFontRequestFullStr.length() + " ]\n信息： 文件中");
        FileUtils.writer(printFontRequestFullStr, "I:\\文档\\底层开发协议\\Printer Tester\\FontFullHexStr.txt");
    }

    public static String bitMapA1 = "I:\\文档\\底层开发协议\\Printer Tester\\Bitmap_1A.bin";
    public static String bitMapB1 = "I:\\文档\\底层开发协议\\Printer Tester\\Bitmap_1B.bin";

    /**
     * @description: 位图升级
     **/
    public static void bitMapUpdate() throws MeterException {
        List<String> responses = Arrays.asList(
                "02 C0 03 00 FF 00",
                "02 98 06 00 FF 42 02 00 01",
                "02 C2 03 00 FF 00",
                "02 D2 03 00 FF FF",
                "02 C2 03 00 FF FF",
                "02 C2 03 00 FF FF",
                "02 C2 03 00 FF FF",
                "02 C2 03 00 FF FF",
                "02 C2 03 00 FF FF",
                "02 C2 03 00 FF FF",
                "02 CA 03 00 FF 6F");
        PrintBitMapRequest printBitMapRequest = new PrintBitMapRequest(new File(bitMapA1));
        printBitMapRequest.setPrintBack(new DefaultPrintBack());
        System.out.println("升级位图Hex信息：" + printBitMapRequest.assembler().toString());
        PrintFactory.getInstance()
                .setMessenger(new DefaultMessenger(responses))
                .upgrade(printBitMapRequest);

        PrintBitMapRequest printBitMapRequest2 = new PrintBitMapRequest(new File(bitMapB1));
        System.out.println("升级位图2Hex信息：" + printBitMapRequest2.assembler().toString());
    }

    /**
     * @description: 文件转HEX发送
     **/
    public static void fileToHex() {
        File file1 = new File("I:\\文档\\底层开发协议\\Printer Tester\\Bitmap_1A.bin");
        String Bitmap_1A = FileUtils.fileToHex(file1);
        System.out.println("Bitmap_1A.bin: " + Bitmap_1A);
        StringBuffer assembler_Bitmap_1A = new PrintBitMapRequest(file1).assembler();
        System.out.println("assembler_Bitmap_1A.bin: " + assembler_Bitmap_1A.toString());

        File file2 = new File("I:\\文档\\底层开发协议\\Printer Tester\\Bitmap_1B.bin");
        String Bitmap_1B = FileUtils.fileToHex(file2);
        System.out.println("Bitmap_1B.bin: " + Bitmap_1B);
        StringBuffer assembler_Bitmap_1B = new PrintBitMapRequest(file2).assembler();
        System.out.println("assembler_Bitmap_1B.bin: " + assembler_Bitmap_1B.toString());
    }

    public static void test0200() {
        Print0200Request print0200Request = new Print0200Request();
        StringBuffer request0200Str = print0200Request.assembler();
        System.out.println("0200发送长度：" + request0200Str.length() + " 内容： " + request0200Str.toString());
    }

    public static void test0400() {
        Print0400Request request = new Print0400Request();
        StringBuffer requestStr = request.assembler();
        System.out.println("0400发送长度：" + requestStr.length() + " 内容： " + requestStr.toString());
    }

    public static void test0100() {
        List<String> responses = Arrays.asList("02 C0 03 00 FF 00", "02 98 06 00 FF 05 01 00 00");
        Print0100Request print0100Request = new Print0100Request();
        print0100Request.setPrintBack(new DefaultPrintBack());
        print0100Request.setItem(0);
        print0100Request.setVal(10);
        StringBuffer request0100Str = print0100Request.assembler();
        System.out.println("0100发送长度：" + request0100Str.length() + " 内容： " + request0100Str.toString());
//        PrintFactory.getInstance()
//                .setMessenger(new DefaultMessenger(responses))
//                .sendData(print0100Request);

        Print0100Request print0100Request1 = new Print0100Request();
        print0100Request1.setPrintBack(new DefaultPrintBack());
        print0100Request1.setItem(1);
        print0100Request1.setVal(0);
        StringBuffer request0100Str1 = print0100Request1.assembler();
        System.out.println("发送长度：" + request0100Str1.length() + " 内容： " + request0100Str1.toString());
//        PrintFactory.getInstance()
//                .setMessenger(new DefaultMessenger(responses))
//                .sendData(print0100Request1);
    }

    public static void test0000() throws MeterException {
        List<String> responses = Arrays.asList("02 C0 03 00 FF 00", "02 98 13 00 FF 02 00 00 30 00 00 00 98 29 00 00 00 00 00 00 80 80");
        Print0000Request print0000Request = new Print0000Request();
        print0000Request.setPrintBack(new DefaultPrintBack());
        StringBuffer request0000Str = print0000Request.assembler();
        System.out.println("0000发送长度：" + request0000Str.length() + " 内容： " + request0000Str.toString());
        PrintFactory.getInstance()
                .setMessenger(new DefaultMessenger(responses))
                .sendData(print0000Request);
    }

    /**
     * @description: 测试命令
     **/
    public static void testCmd() {
//        String init = PrintFactory.getInstance().init(PrintType.CMD);
        String init = PrintType.CMD.init();
        System.out.println("命令初始化：" + init);
    }

    /**
     * @description: 临时打印
     **/
    public static void printTemp() throws MeterException {
        List<String> responses = Arrays.asList("02 C1 05 00 FF 00 80 80", "02 D9 05 00 FF FF 80 80 ", "02 D9 05 00 FF FF 80 80 ", "02 D9 05 00 FF FF 80 80", "02 D9 05 00 FF FF 80 80", "02 D9 05 00 FF EB 80 80", "02 D9 05 00 FF FF 80 80", "02 D9 05 00 FF FF 80 80", "02 D9 05 00 FF FF 80 80");
        PrintFactory.getInstance()
                .setMessenger(new DefaultMessenger(responses))
                .printTemp(new DefaultPrintBack(), printVal());
    }

    /**
     * @description: 基础打印
     **/
    public static void basePrint() throws MeterException {
        StringPara stringPara = new StringPara()
                .set_Font(Font.FONT5)
                .set_Dir(Dir.ZERO)
                .set_Grid(Grid.Middle_Middle_Grid)
                .setStartX(0)
                .setStartY(0)
                .setOffsetX(384)
                .setOffsetY(26)
                .set_Content("-------------------sfds20---fff----------------------");

        String compile = PrintUtils.compile(stringPara);
        System.out.println("字符串： " + compile);
        System.out.println("字符串打印输出： " + compile + "0407");

        BarCodePara barCodePara = new BarCodePara()
                .set_Dir(Dir.ZERO)
                .set_Grid(Grid.Middle_Middle_Grid)
                .set_Barcode(Barcode.EAN128_C)
                .setStartX(0)
                .setStartY(0)
                .setOffsetX(384)
                .setOffsetY(26)
                .set_Content("1234567894561");
        compile = PrintUtils.compile(barCodePara);
        System.out.println("条码： " + compile);

        TempBitmapPara tempBitmapPara = new TempBitmapPara()
                .set_Dir(Dir.ZERO)
                .set_Grid(Grid.Defaul_Grid)
                .setStartX(0)
                .setStartY(0)
                .setOffsetX(384)
                .setOffsetY(50)
                .set_InnerBitmapNumber(1);
        compile = PrintUtils.compile(tempBitmapPara);
        System.out.println("暂存位图： " + compile);
        System.out.println("暂存位图打印输出： " + compile + "0407");

        FramePara framePara = new FramePara()
                .set_Dir(Dir.Ninety)
                .set_Border(2)
                .setStartX(0)
                .setStartY(0)
                .setOffsetX(384)
                .setOffsetY(26);
        compile = PrintUtils.compile(framePara);
        System.out.println("边框： " + compile);

        ChangeBitLines changeBitLines = new ChangeBitLines()
                .setLine(0);
        compile = PrintUtils.compile(changeBitLines);
        System.out.println("设置绘图位置： " + compile);

        PrintPara printPara = new PrintPara();
        compile = PrintUtils.compile(printPara);
        System.out.println("打印： " + compile);

        PrintLinePara printLinePara = new PrintLinePara()
                .setType(1)
                .setLine(1);
        compile = PrintUtils.compile(printLinePara);
        System.out.println("指定行数打印： " + compile);

        PaperPara paperPara = new PaperPara()
                .set_Line(400);
        compile = PrintUtils.compile(paperPara);
        System.out.println("走纸： " + compile);

        CuttingPosition cuttingPosition = new CuttingPosition();
        compile = PrintUtils.compile(cuttingPosition);
        System.out.println("走纸切割位： " + compile);
    }

    /**
     * @description: 发送测试
     **/
    public static void sendTest() throws MeterException {
        List<String> responses = Arrays.asList("02 C1 05 00 FF 00 80 80", "02 D9 05 00 FF FF 80 80 ", "02 D9 05 00 FF FF 80 80 ", "02 D9 05 00 FF FF 80 80 ", "02 D9 05 00 FF E1 80 80 ");
        String data = "12000006020000000080011A00e88bb9e69e9ce9a699e89589000402591b12000006020000000080011A00e88bb9e69e9ce9a699e895890" +
                "00402591b12000006020000000080011A00e88bb9e69e9ce9a699e89589000402591b12000006020000000080011A00e88bb9e69e9ce9a699e895" +
                "89000402591b12000006020000000080011A00e88bb9e69e9ce9a699e89589000402591b12000006020000000080011A00e88bb9e69e9ce9a699e" +
                "89589000402591b12000006020000000080011A00e88bb9e69e9ce9a699e89589000402591b12000006020000000080011A00e88bb9e69e9ce9a6" +
                "99e89589000402591b12000006020000000080011A00e88bb9e69e9ce9a699e89589000402591b12000006020000000080011A00e88bb9e69e9ce" +
                "9a699e89589000402591b12000006020000000080011A00e88bb9e69e9ce9a699e89589000402591b12000006020000000080011A00e88bb9e69e" +
                "9ce9a699e89589000402591b12000006020000000080011A00e88bb9e69e9ce9a699e89589000402591b12000006020000000080011A00e88bb9e" +
                "69e9ce9a699e89589000402591b12000006020000000080011A00e88bb9e69e9ce9a699e89589000402591b12000006020000000080011A00e88b" +
                "b9e69e9ce9a699e89589000412000006020000000080011A00e88bb9e69e9ce9a699e89589000412000006020000000080011A00e88bb9e69e9ce" +
                "9a699e89589000412000006020000000080011A00e88bb9e69e9ce9a699e89589000412000006020000000080011A00e88bb9e69e9ce9a699e895" +
                "89000412000006020000000080011A00e88bb9e69e9ce9a699e89589000412000006020000000080011A00e88bb9e69e9ce9a699e895890004120" +
                "00006020000000080011A00e88bb9e69e9ce9a699e89589000412000006020000000080011A00e88bb9e69e9ce9a699e895890004120000060200" +
                "00000080011A00e88bb9e69e9ce9a699e89589000412000006020000000080011A00e88bb9e69e9ce9a699e895890004120000060200000000800" +
                "11A00e88bb9e69e9ce9a699e89589000412000006020000000080011A00e88bb9e69e9ce9a699e89589000412000006020000000080011A00e88b" +
                "b9e69e9ce9a699e89589000412000006020000000080011A00e88bb9e69e9ce9a699e89589000412000006020000000080011A00e88bb9e69e9ce" +
                "9a699e89589000412000006020000000080011A00e88bb9e69e9ce9a699e89589000412000006020000000080011A00e88bb9e69e9ce9a699e895" +
                "89000412000006020000000080011A00e88bb9e69e9ce9a699e89589000412000006020000000080011A00e88bb9e69e9ce9a699e895890004";
        System.out.println(data);
        PrintDataRequest printDataRequest = new PrintDataRequest();
        printDataRequest.setData(data);

        PrintFactory.getInstance().build(new DefaultMessenger(responses)).sendData(printDataRequest);
    }

    public void strChange() {
        System.out.println(ByteUtils.toHexString("苹果香蕉".getBytes(Charset.forName("UTF-8"))) + "00");
        System.out.println(ByteUtils.toHexString("香蕉".getBytes(Charset.forName("UTF-8"))) + "00");
        System.out.println(ByteUtils.toHexString("范德萨国防大厦股份收到fdsafdsafds1351514545454324324@$R#%^%$#$#$#^#$%$#$#$#$@#@#@%#%%#gfdgfdsgfd风格的三个人犯得上广泛热带水果热帖热帖".getBytes(Charset.forName("UTF-8"))) + "00");
    }

    public static void printContent2() throws MeterException {
        List<String> responses = Arrays.asList("02 C1 05 00 FF 00 80 C0");
        // 添加模板映射关系
        Map<String, String> mapping1 = new HashMap<>();
        mapping1.put("S0", "storeName");
        mapping1.put("S2", "storeNo");
        mapping1.put("S47", "orderNo");
        mapping1.put("S31", "tradeTime");

        Map<String, String> mapping2 = new HashMap<>();
        mapping2.put("I0-30", "pluName");
        mapping2.put("I0-20", "price");
        mapping2.put("I0-21", "number");
        mapping2.put("I0-22", "item");

        List<PrintDataParse.PrintPart> printParts = PrintFactory.getInstance().templateAnalysisAndSet(data).getUsingPrintParts();

        System.out.println(JSON.toJSONString(printParts));

        Messenger messenger = new DefaultMessenger(responses);
        String printData = PrintFactory.getInstance()
                .build(printParts, messenger)
                .putMappings(0, mapping1)
                .putMappings(1, mapping2)
                .assemblePrintData(printVal());

        List<PrintDataParse.PrintPart> usingPrintParts = PrintFactory.getInstance().getUsingPrintParts();
        System.out.println(JSON.toJSONString(usingPrintParts));

        System.out.println(printData);
    }

    /**
     * @description: 打印内容
     **/
    public static String printContent() throws MeterException {
        // 解析模板数据
        List<PrintDataParse.PrintPart> printParts = PrintFactory.getInstance().templateAnalysisAndSet(data).getUsingPrintParts();
        for (PrintDataParse.PrintPart part : printParts) {
            System.out.println(JSON.toJSONString(part));
        }

        // 添加模板映射关系
        Map<String, String> mapping1 = new HashMap<>();
        mapping1.put("S0", "storeName");
        mapping1.put("S17", "text1");
        mapping1.put("S18", "text2");
        mapping1.put("S19", "text3");
        mapping1.put("S20", "text4");
        mapping1.put("S2", "marchaNo");// 机器号
        mapping1.put("S47", "terrace");// 台号
        mapping1.put("S31", "salespersionNo");// 营业员编号
        mapping1.put("S26", "sid");// 当前单号
        mapping1.put("S3", "saleDate");// 销售日期
        mapping1.put("S4", "saleTime");// 销售时间

        Map<String, String> mapping2 = new HashMap<>();
        mapping2.put("I0-0", "pluName");
        mapping2.put("I0-6", "pluNo");
        mapping2.put("I0-4", "price");
        mapping2.put("I0-1", "number");
        mapping2.put("I0-26", "item");

        Map<String, String> mapping3 = new HashMap<>();
        mapping3.put("S27", "actualAmount");
        mapping3.put("S9", "cashierAmount");
        mapping3.put("S10", "changeAmount");
        mapping3.put("S21", "text5");
        mapping3.put("S22", "text6");
        mapping3.put("S23", "text7");
        mapping3.put("S24", "text8");

        PrintFactory.getInstance().putMappings(0, mapping1)
                .putMappings(1, mapping2)
                .putMappings(2, mapping3);


        System.out.println(JSON.toJSONString(PrintFactory.getInstance().getUsingPrintParts()));

        // 设备模板映射值
        String assemble = PrintFactory.getInstance().assemblePrintData(printVal());
        System.out.println(assemble);
        return assemble;
    }

    /**
     * @description: 设备模板映射值
     **/
    public static PrintVal printVal() {

        // 设备模板映射值
        Map<String, String> simple = new HashMap<>();
        simple.put("storeName", "测试店铺");
        simple.put("marchaNo", "D0");
        simple.put("terrace", "V1");
        simple.put("sid", "#000001");
        simple.put("saleDate", "2020-12-25");
        simple.put("saleTime", "12:00:00");
        simple.put("actualAmount", "32.12");
        simple.put("cashierAmount", "32.12");
        simple.put("changeAmount", "0.00");
        simple.put("text5", "谢谢惠顾，欢迎再次光临");
//        simple.put("tracebility", "http://192.168.1.53:8899?type=tbs&mac=0023F016114C&fid=000798&date=2103");

        Map<String, String> cycle1 = new HashMap<>();
        cycle1.put("pluName", "火锅丸子");
        cycle1.put("pluNo", "453");
        cycle1.put("price", "15.80/kg");
        cycle1.put("number", "0.67kg");
        cycle1.put("item", "￥ 10.59");

        Map<String, String> cycle2 = new HashMap<>();
        cycle2.put("pluName", "鸡腿");
        cycle2.put("pluNo", "253");
        cycle2.put("price", "17.80/kg");
        cycle2.put("number", "0.67kg");
        cycle2.put("item", "￥ 11.93");

        Map<String, String> cycle3 = new HashMap<>();
        cycle3.put("pluName", "鸡边腿");
        cycle3.put("pluNo", "254");
        cycle3.put("price", "9.60/件");
        cycle3.put("number", "1");
        cycle3.put("item", "￥ 9.60");

        Map<String, String> cycle4 = new HashMap<>();
        cycle4.put("pluName", "鸡胸肉");
        cycle4.put("pluNo", "268");
        cycle4.put("price", "4.5/g");
        cycle4.put("number", "10");
        cycle4.put("item", "￥ 45");

        return new PrintVal()
                .addSimple(simple)
                .addCycle(1, cycle1)
                .addCycle(1, cycle2)
                .addCycle(1, cycle3)
                .addCycle(1, cycle4);

    }

    /**
     * @description: 设备模板映射值
     **/
    public static PrintVal memberPrintVal() {

        // 设备模板映射值
        Map<String, String> simple = new HashMap<>();
        simple.put("storeName", "测试店铺");
        simple.put("marchaNo", "D0");
        simple.put("terrace", "V1");
        simple.put("sid", "#000001");
        simple.put("saleDate", "2020-12-25");
        simple.put("saleTime", "12:00:00");
        simple.put("originalAmount", "0.50");
        simple.put("thriftAmount", "0.06");
        simple.put("actualAmount", "0.44");
        simple.put("storedAmount", "0.44");
        simple.put("otherAmount", "0.00");// 吉卡云其他支付
        simple.put("otherNo", "20210908141203");// 吉卡云其他支付订单号
        simple.put("cardId", "10000212");// 会员卡号
        simple.put("originalMoney", "660.00");// 卡原额
        simple.put("surplusMoney", "652.00");// 卡余额
        simple.put("surplusIntegral", "3542.86");// 卡积分

        simple.put("text5", "谢谢惠顾，欢迎再次光临");
        simple.put("tracebility", "http://192.168.1.53:8899?type=tbs&mac=0023F016114C&fid=000798&date=2103");

        Map<String, String> cycle1 = new HashMap<>();
        cycle1.put("pluName", "火锅丸子");
        cycle1.put("pluNo", "453");
        cycle1.put("price", "15.80/kg");
        cycle1.put("originalPrice", "12.80/kg");
        cycle1.put("number", "0.67kg");
        cycle1.put("item", "￥ 10.59");
        cycle1.put("originalItem", "￥ 8.59");

        Map<String, String> cycle4 = new HashMap<>();
        cycle4.put("pluName", "鸡胸肉");
        cycle4.put("pluNo", "268");
        cycle4.put("price", "234.52/g");
        cycle4.put("originalPrice", "224.52/g");
        cycle4.put("number", "40.12");
        cycle4.put("item", "￥200.79");
        cycle4.put("originalItem", "￥223.79");

        return new PrintVal()
                .addSimple(simple)
                .addCycle(1, cycle1)
                .addCycle(1, cycle4);
    }

    private static String data = "033016000000000000000080011A0001000412000000010000000080011A00\n" +
            "S0\n" +
            "0412000005010000000080011A00\n" +
            "S17\n" +
            "0412000005010000000080011A00\n" +
            "S18\n" +
            "0412000005010000000080011A00\n" +
            "S19\n" +
            "0412000005010000000080011A00\n" +
            "S20\n" +
            "0412000004010000000054001A00\n" +
            "S2\n" +
            "1200000401540000001E001A00\n" +
            "S47\n" +
            "1200000501800000007D001A00\n" +
            "S31\n" +
            "1200000501030100007D001A00\n" +
            "S26\n" +
            "0412000004010000000072001A00\n" +
            "T销售时间:\n" +
            "1200000001730000008C001A00\n" +
            "S3\n" +
            "12000006010E01000070001A00\n" +
            "S4\n" +
            "120000050000001A0080011000\n" +
            "T- - - - - - - - - - - - - - - - - - - - - - - - - - -\n" +
            "0412000004010000000068001A00\n" +
            "T商品名称\n" +
            "1200000501B5000000A0001A00\n" +
            "T商品编号\n" +
            "12000004010E001A004C001A00\n" +
            "T单价\n" +
            "120000050163001A00AC001A00\n" +
            "T重量/数量\n" +
            "120000050118011A0068001A00\n" +
            "T金额\n" +
            "12000005000000340080010F00\n" +
            "T- - - - - - - - - - - - - - - - - - - - - - - - - - -\n" +
            "04\n" +
            "z\n" +
            "120000040100000000B4001A00\n" +
            "I0-0\n" +
            "1200000501B4000000C8001A00\n" +
            "I0-6\n" +
            "040412000004010000000080001A00\n" +
            "I0-20\n" +
            "12000005018000000080001A00\n" +
            "I0-21\n" +
            "12000006010001000080001A00\n" +
            "I0-22\n" +
            "0412000006010000000060001A00\n" +
            "I0-4\n" +
            "1200000401C000000060001A00\n" +
            "I0-1\n" +
            "12000006012001000060001A00\n" +
            "I0-26\n" +
            "04\n" +
            "Z\n" +
            "12000005000000000080011200\n" +
            "T- - - - - - - - - - - - - - - - - - - - - - - - - - -\n" +
            "04\n" +
            "#1\n" +
            "04120000050204000000C8002200\n" +
            "T实收金额:\n" +
            "1200000502DD000000A0002200\n" +
            "S27\n" +
            "04\n" +
            "#14\n" +
            "12000004018F00000076001A00\n" +
            "T收银金额:\n" +
            "12000005010501000078001A00\n" +
            "S9\n" +
            "12000004018F001A0076001A00\n" +
            "T找零金额:\n" +
            "120000050105011A0078001A00\n" +
            "S10\n" +
            "#1\n" +
            "04\n" +
            "0412000005010000000080011A00\n" +
            "S21\n" +
            "0412000005010000000080011A00\n" +
            "S22\n" +
            "0412000005010000000080011A00\n" +
            "S23\n" +
            "0412000005010000000080011A00\n" +
            "S24\n" +
            "040608";

    /**
     * @description: 默认通讯组件
     **/
    public static class DefaultMessenger implements Messenger {

        private List<String> responses;
        private int count = 0;

        public DefaultMessenger(List<String> responses) {
            this.responses = responses;
        }

        /**
         * @param data
         * @description: 发送数据
         */
        @Override
        public SendResult send(String data) {
            System.out.println("仿真 发送数据： " + data);
            return new SendResult(true, String.valueOf(System.currentTimeMillis()));
        }

        /**
         * @param communicationLogo
         * @description: 收到数据
         */
        @Override
        public ReadReuslt read(String communicationLogo) {
            String response = responses.get(0);
            System.out.println("仿真 收到数据： " + response);
            count++;
            return new ReadReuslt(true, response);
        }

        /**
         * @param communicationLogo
         * @description: 通讯有效时间
         */
        @Override
        public boolean effectiveCommunicationTime(String communicationLogo) {
            return true;
        }

        /**
         * @param cmd
         * @param request
         * @param response
         * @description: 发送有效数据
         */
        @Override
        public void sendCmd(String cmd, PrintRequest request, PrintResponse response) {
            // todo 发送数据
            System.out.println("发送数据：" + cmd);
            new MangerThread(request, response).start();
        }

        /**
         * @description: 通讯去编号标识(串口通讯, 串口号)
         **/
        @Override
        public String identify() {
            return "TEST";
        }


        private class MangerThread extends Thread {

            private PrintRequest request;
            private PrintResponse printResponse;

            public MangerThread(PrintRequest request, PrintResponse printResponse) {
                this.request = request;
                this.printResponse = printResponse;
            }

            @Override
            public void run() {
                while (true) {
                    if (responses != null) {
                        printResponse.callBack(responses.get(count), request);
                        count++;
                        break;
                    }
                }
            }
        }
    }
}
