package com.jhscale.test.serial;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.SerialPort;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author lie_w
 * @title: SerialPortManagerTest
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/4/2513:13
 */
@SuppressWarnings("all")
public class SerialPortDemo1 {

    private static SerialPort serialPort;

    static {
        try {
            serialPort = new SerialPort(new WSerialPortControl(),
                    new SerialDevice<>("COM3", 9600, 0),
                    new DeviceClientEventListener() {
                        @Override
                        public void onClientEvent(byte[] bytes) throws MeterException {
                            String accept = ByteUtils.toHexString(bytes);
                            System.out.println("接受数据： " + accept);
                        }

                        @Override
                        public void onClientEventExp(MeterException e) {
                            e.printStackTrace();
                        }
                    });

            serialPort.openPort();
        } catch (MeterException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws MeterException {
        // String send = "0258020000";
        String send = cmd1();
        System.out.println("发送数据： " + send);
        serialPort.writeDataImmediately(ByteUtils.fromHexString(send));
    }

    /**
     * @description: 第一个组装指令
     **/
    public static String cmd1() {
        return "fe53039f80ffff";
    }

}
