package com.jhscale.test.serial;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.SerialPort;
import com.jhscale.meter.io.control.win.WSerialPortControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.lora.LoRaDevice;
import com.jhscale.meter.lora.LoRaHost;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author lie_w
 * @title: SerialPortManagerTest
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/4/2513:13
 */
@SuppressWarnings("all")
public class SerialPortDemo_LoRa {

    private static SerialPort serialPort;

    static {
        try {
            serialPort = new SerialPort(new WSerialPortControl(),
                    new SerialDevice<>("COM3", 9600, 0),
                    new DeviceClientEventListener() {
                        /**
                         * @param bytes
                         * @description: 连接监听
                         */
                        @Override
                        public void onClientEvent(byte[] bytes) throws MeterException {
                            LoRaHost.getInstance().Receive(bytes);
                            //String accept = ByteUtils.toHexString(bytes);
                            //System.out.println("接受数据： " + accept);
                        }

                        /**
                         * @param e
                         * @description: 连接异常监听
                         */
                        @Override
                        public void onClientEventExp(MeterException e) {
                            e.printStackTrace();
                        }
                    });

            serialPort.openPort();
        } catch (MeterException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws MeterException {
        // String send = "0258020000";
        String send = cmd1();
        System.out.println("发送数据： " + send);
        serialPort.writeDataImmediately(ByteUtils.fromHexString(send));

        int taskevent = 0;

        //初始化LoRa Remote信息
        LoRaDevice device;
        LoRaHost.getInstance().clearDevices();
        device = new LoRaDevice();
        device.setAddr(1);
        device.setDescription("Left");
        device.setFirmware(293);
        device.setFirmwareDate_Need(230426);
        LoRaHost.getInstance().addDevice(device);
        device = new LoRaDevice();
        device.setAddr(2);
        device.setDescription("Right");
        device.setFirmware(293);
        device.setFirmwareDate_Need(230426);
        LoRaHost.getInstance().addDevice(device);

        while (true) {
            // 休眠20秒结束
            try {
                Thread.sleep(10);
            } catch (InterruptedException e) {
            }

            if (taskevent == 1) {
                taskevent = 0;
                // LoRaHost.getInstance().Task_InitDefault();
            } else if (taskevent == 2) {
                taskevent = 0;
                // LoRaHost.getInstance().Task_Init(0);
            } else if (taskevent == 3) {
                taskevent = 0;
                // LoRaHost.getInstance().Task_Matching(1);
            }
        }
    }

    /**
     * @description: 第一个组装指令
     **/
    public static String cmd1() {
        return "fe53039f80ffff";
    }

}
