package com.jhscale.test.serial;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.data.PrintVal;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity.ScheduleState;
import com.jhscale.meter.protocol.print.link.DefaultPrintSerialMessenger;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import com.jhscale.meter.protocol.print.produce.impl.PrintProduce;
import com.jhscale.meter.protocol.print.temp.Temp1;
import com.jhscale.meter.protocol.print.temp.Temp2;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lie_w
 * @title: SerialPrintTest
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/9/813:00
 */
public class SerialPrintTest {

    /**
     * @description: 默认结果回调
     **/
    public static class DefaultPrintBack implements IPrintBack {
        @Override
        public void responseBack(PrintResponse response) {
            System.out.println(response.toJSON());
        }

        @Override
        public void responseBack(PrintBackResponse response) {
            System.out.println(response.toJSON());
//            PrintFactory.getInstance().closeMessenger();
        }

        @Override
        public void schedule(ScheduleState scheduleState) {
            System.out.println(scheduleState.toJSON());
        }
    }


    public static void main(String[] args) throws MeterException {

        /**
         * @description: 普通收银模板数据
         **/
//        printTemp1Val();

        /**
         * @description: 会员收银模板数据
         **/
        memberTempVal();

//        printTempVal();
//        printTemp2Val();
    }

    /**
     * @description: 模板2打印输出
     **/
    private static void printTemp2Val() throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.printValTemp(new DefaultPrintBack(), memberPrintVal(), new Temp2());
    }

    /**
     * @description: 模板1打印输出
     **/
    private static void printTempVal() throws MeterException {
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        printProduce.printValTemp(new DefaultPrintBack(), printVal(), new Temp1());
    }

    private static void memberTempVal() throws MeterException {
        PrintVal printVal = SerialPrintTest.memberPrintVal();
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        new Temp2().tempInit();
        printProduce.printVal(new DefaultPrintBack(), printVal);
    }

    /**
     * @description: 设备模板映射值
     **/
    public static PrintVal memberPrintVal() {

        // 设备模板映射值
        Map<String, String> simple = new HashMap<>();
        simple.put("storeName", "测试店铺");
        simple.put("marchaNo", "D0");
        simple.put("terrace", "V1");
        simple.put("sid", "#000001");
        simple.put("saleDate", "2020-12-25");
        simple.put("saleTime", "12:00:00");
        simple.put("originalAmount", "0.50");
        simple.put("thriftAmount", "0.06");
        simple.put("actualAmount", "0.44");
        simple.put("storedAmount", "0.44");
        simple.put("otherAmount", "0.00");// 吉卡云其他支付
        simple.put("otherNo", "20210908141203");// 吉卡云其他支付订单号
        simple.put("cardId", "10000212");// 会员卡号
        simple.put("originalMoney", "660.00");// 卡原额
        simple.put("surplusMoney", "652.00");// 卡余额
        simple.put("surplusIntegral", "3542.86");// 卡积分

        simple.put("text5", "谢谢惠顾，欢迎再次光临");
        simple.put("tracebility", "http://192.168.1.53:8899?type=tbs&mac=0023F016114C&fid=000798&date=2103");

        Map<String, String> cycle1 = new HashMap<>();
        cycle1.put("pluName", "火锅丸子");
        cycle1.put("pluNo", "453");
        cycle1.put("price", "15.80/kg");
        cycle1.put("originalPrice", "12.80/kg");
        cycle1.put("number", "0.67kg");
        cycle1.put("item", "￥ 10.59");
        cycle1.put("originalItem", "￥ 8.59");

        Map<String, String> cycle4 = new HashMap<>();
        cycle4.put("pluName", "鸡胸肉");
        cycle4.put("pluNo", "268");
        cycle4.put("price", "234.52/g");
        cycle4.put("originalPrice", "224.52/g");
        cycle4.put("number", "40.12");
        cycle4.put("item", "￥200.79");
        cycle4.put("originalItem", "￥223.79");

        return new PrintVal()
                .addSimple(simple)
                .addCycle(1, cycle1)
                .addCycle(1, cycle4);
    }

    private static void printTemp1Val() throws MeterException {
        PrintVal printVal = SerialPrintTest.printVal();
        PrintProduce printProduce = new PrintProduce();
        printProduce.setMessenger(new DefaultPrintSerialMessenger());
        new Temp1().tempInit();
        printProduce.printVal(new DefaultPrintBack(), printVal);
    }

    /**
     * @description: 设备模板映射值
     **/
    public static PrintVal printVal() {

        // 设备模板映射值
        Map<String, String> simple = new HashMap<>();
        simple.put("storeName", "测试店铺");
        simple.put("marchaNo", "D0");
        simple.put("terrace", "V1");
        simple.put("sid", "#000001");
        simple.put("saleDate", "2020-12-25");
        simple.put("saleTime", "12:00:00");
        simple.put("actualAmount", "32.12");
        simple.put("cashierAmount", "32.12");
        simple.put("changeAmount", "0.00");
        simple.put("text5", "谢谢惠顾，欢迎再次光临");
        simple.put("tracebility", "http://192.168.1.53:8899?type=tbs&mac=0023F016114C&fid=000798&date=2103");

        Map<String, String> cycle4 = new HashMap<>();
        cycle4.put("pluName", "鸡胸肉");
        cycle4.put("pluNo", "268");
        cycle4.put("price", "4.5/g");
        cycle4.put("number", "10");
        cycle4.put("item", "￥ 45");

        return new PrintVal()
                .addSimple(simple)
                .addCycle(1, cycle4);
    }
}
