package com.jhscale.test.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.*;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

import static com.jhscale.test.serial.PortManagerTest.sleep;

/**
 * @author lie_w
 * @title: SocketTest
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/10/1710:21
 */
public class TCP_UDP_Test {

    public static void main(String[] args) throws IOException {
//        tcp_client();
//        tcp_server();

//        UDP_Broadcast_Accept();
//        UDP_Broadcast_Send();

//        UDP_Broadcast_Terminal();
//        UDP_Broadcast_PC();

        tcp_client_1();
    }

    /**
     * @description: TCP 客户端
     **/
    private static void tcp_client_1() throws IOException {
        Scanner scanner = new Scanner(System.in);
        System.out.println("等待连接服务端！");
        Socket socket = new Socket("192.168.101.68", 33581);
        System.out.println("连接服务端成功！");

        String s = "UPL\tREP\t0\r\n";
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(s.getBytes(StandardCharsets.UTF_8));
        outputStream.flush();

        int count = 0;

        while (true) {

            // if (count % 10 == 0) {
            //     outputStream.write("\r\n".getBytes(StandardCharsets.UTF_8));
            //     outputStream.flush();
            // }

            byte[] bytes = new byte[10240];
            // 读一下服务端发来的东西
            InputStream inputStream = socket.getInputStream();
            int read = inputStream.read(bytes);
            if (read != -1) {
                System.out.println("服务端：" + new String(bytes, 0, read, Charset.defaultCharset()));
            } else {
                System.out.println("服务端:未响应信息");
            }
            try {
                Thread.sleep(1);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            count++;
        }
    }

    /**
     * @description: TCP 客户端
     **/
    private static void tcp_client() throws IOException {
        Scanner scanner = new Scanner(System.in);
        System.out.println("等待连接服务端！");
        Socket socket = new Socket("192.168.0.104", 33581);
        System.out.println("连接服务端成功！");

        while (true) {
            // 给服务端发点东西
            System.out.print("请输入：");
            String s = scanner.next();
            if ("out".equals(s)) {
                break;
            }
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(s.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();

            byte[] bytes = new byte[1024];
            // 读一下服务端发来的东西
            InputStream inputStream = socket.getInputStream();
            int read = inputStream.read(bytes);
            if (read != -1) {
                System.out.println("服务端：" + new String(bytes, 0, read, Charset.defaultCharset()));
            } else {
                System.out.println("服务端:未响应信息");
            }
        }
    }

    /**
     * @description: TCP 服务端
     **/
    public static void tcp_server() throws IOException {
        Scanner scanner = new Scanner(System.in);
        // 服务端监听 9528 端口
        ServerSocket serverSocket = new ServerSocket(33582);
        System.out.println("等待连接");
        Socket client = serverSocket.accept();
        System.out.println("连接成功！");
        while (true) {
            // 获取客户端输入流
            InputStream inputStream = client.getInputStream();
            byte[] bytes = new byte[1024];
            int read = inputStream.read(bytes);
            // 客户端发来的消息
            String request = new String(bytes, 0, read, Charset.defaultCharset());
            System.out.println("客户端：" + request);

            // 给客户端发端东西
            // System.out.print("请输入：");
            // String nextLine = scanner.next();
            // if ("out".equals(nextLine)) {
            //     break;
            // }

            String nextLine = String.format("Response: %s", request);

            client.getOutputStream().write(nextLine.getBytes(StandardCharsets.UTF_8));

        }
    }


    private static final String Send_33583 = "UDP\t\r\n";
    private static final String Send_33584 = "UDP\t33581\t251\r\n";

    /**
     * @description: UPD 广播(终端)
     **/
    private static void UDP_Broadcast_Terminal() {
        try {
            // 1.创建接受对象
            DatagramSocket socket = new DatagramSocket(33583);
            new Thread("UDP_Broadcast_Terminal") {
                @Override
                public void run() {
                    while (!isInterrupted()) {
                        try {
                            // 2.创建一个数据包接收数据
                            byte[] buffer = new byte[1024];
                            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                            // 3.等待接受数据
                            socket.receive(packet);
                            // 4.取出数据
                            String accept = new String(buffer, 0, packet.getLength());
                            System.out.println(String.format("终端 收到来自:%s,对方端口号为:%s,消息内容：%s",
                                    packet.getAddress(), packet.getPort(), accept));
                            if (accept.equals(Send_33583)) {
                                byte[] bytes = Send_33584.getBytes();
                                DatagramPacket dp = new DatagramPacket(bytes, bytes.length,
                                        InetAddress.getByName("255.255.255.255"), 33584);
                                socket.send(dp);
                            }
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }.start();
        } catch (SocketException e) {
            e.printStackTrace();
        }
    }

    /**
     * @description: UPD 广播(PC)
     **/
    private static void UDP_Broadcast_PC() {
        try {
            // 1.创建接受对象
            DatagramSocket socket = new DatagramSocket(33584);
            new Thread("UDP_Broadcast_PC") {
                @Override
                public void run() {
                    while (!isInterrupted()) {
                        try {
                            // 2.创建一个数据包接收数据
                            byte[] buffer = new byte[1024];
                            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                            // 3.等待接受数据
                            socket.receive(packet);
                            // 4.取出数据
                            String accept = new String(buffer, 0, packet.getLength());
                            System.out.println(String.format("PC端 收到来自:%s,对方端口号为:%s,消息内容：%s",
                                    packet.getAddress(), packet.getPort(), accept));
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }.start();

            while (true) {
                byte[] bytes = Send_33583.getBytes();
                DatagramPacket dp = new DatagramPacket(bytes, bytes.length,
                        InetAddress.getByName("255.255.255.255"), 33583);
                socket.send(dp);
                sleep(5);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * @description: UDP广播（发送）
     **/
    private static void UDP_Broadcast_Send() {
        try {
            DatagramSocket ds = new DatagramSocket();
            String send_33584 = "UDP\t33581\t251\t\r\n";
            String send_33583 = "UDP\t\r\n";
            byte[] bytes = send_33583.getBytes();
            InetAddress address = InetAddress.getByName("255.255.255.255");
            int port = 33584;
            DatagramPacket dp = new DatagramPacket(bytes, bytes.length, address, port);
            ds.send(dp);
            ds.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * @description: UDP广播（监听）
     **/
    private static void UDP_Broadcast_Accept() {
        try {
            // 1.创建接受对象
            DatagramSocket socket = new DatagramSocket(33583);

            // 2.创建一个数据包接收数据
            byte[] buffer = new byte[1024];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);

            while (true) {

                // 3.等待接受数据
                socket.receive(packet);

                // 4.取出数据
                int len = packet.getLength();
                String rs = new String(buffer, 0, len);
                // System.out.println("收到来自: " + packet.getAddress() + ",对方端口号为: " + packet.getPort() + "的消息: " + rs);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

//        try {
//            DatagramSocket ds = new DatagramSocket(33583);
//            byte[] bytes = new byte[1024];
//            DatagramPacket dp = new DatagramPacket(bytes, bytes.length);
//            ds.receive(dp);
//            //byte[] data=dp.getData();
//            int length = dp.getLength();
//            String accept = new String(bytes, 0, length);
//            System.out.println(accept);
//            ds.close();
//        } catch (IOException e) {
//            e.printStackTrace();
//        }


//        try {
//            DatagramSocket ds = new DatagramSocket();
//            String s = "UDP\t33581\t251\t\r\n";
//            byte[] bytes = s.getBytes();
//            InetAddress address = InetAddress.getByName("255.255.255.255");
//            int port = 10000;
//            DatagramPacket dp = new DatagramPacket(bytes, bytes.length, address, port);
//            ds.send(dp);
//            ds.close();
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
    }
}
