package com.jhscale.test.socket;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.model.GlobalPara;
import io.swagger.annotations.ApiModelProperty;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ServerHandshake;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;

import static com.jhscale.test.pos.PrintTradeTest.initGlobalPara;
import static com.jhscale.test.pos.PrintTradeTest.initPrintFactory_1;
import static com.jhscale.test.serial.PortManagerTest.sleep;

/**
 * @author lie_w
 * @title: WebSocketTest
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/10/1712:31
 */
public class WebSocketTest {

    public static void main(String[] args) throws Exception {

        GlobalPara.getInstance().setRunLog(false);
        // 初始化全局参数
        initGlobalPara();
        // 重量计算 秤重初始化
        // initWeightCal();
        // 打印机初始化
        initPrintFactory_1();
        // 初始化设备通讯
        // initSocketCommunication();
        sleep(2);

        WebSocketClient socketClient = new WebSocketClient(new URI("ws://192.168.101.100:33574?key=2007000000000433")) {
            //        WebSocketClient socketClient = new WebSocketClient(new URI("ws://121.40.165.18:8800")) {
            @Override
            public void onOpen(ServerHandshake serverHandshake) {
                System.out.println(">>>>>>>>>>>WebSocket onOpen");
            }

            @Override
            public void onMessage(String s) {
                System.out.println(">>>>>>>>>>>WebSocket onMessage: " + s);
            }

            @Override
            public void onClose(int i, String s, boolean b) {
                System.out.println(">>>>>>>>>>>WebSocket onClose: " + i + "  " + s + "  " + b);
            }

            @Override
            public void onError(Exception e) {
                e.printStackTrace();
                System.err.println(">>>>>>>>>>>WebSocket onError" + e.getMessage());
            }

            @Override
            public void onWebsocketPong(WebSocket conn, Framedata f) {
                super.onWebsocketPong(conn, f);
                System.out.println(">>>>>>>>>>>WebSocket onWebsocketPong");
            }

            @Override
            public void onWebsocketPing(WebSocket conn, Framedata f) {
                super.onWebsocketPing(conn, f);
                System.out.println(">>>>>>>>>>>WebSocket onWebsocketPing");
            }
        };

        socketClient.connect();
        System.out.println("连接中。。。");

        while (true) {
            SystemtUtils.sleep(30);

            WebSocketContent content = new WebSocketContent();
            content.key = "2007000000000433";
            content.type = "HEART";

            socketClient.send(content.toJSON());
        }

        // 连接成功往websocket服务端发送数据
        // JSONObject object = new JSONObject();
        // object.put("key", "xx");
        // object.put("type", "HEART");
        // socketClient.send(object.toJSONString());

        // int count = 0;
        // while (count < 20) {
        //     // socketClient.sendPing();

        //     Thread.sleep(5000);

        //     count++;
        // }

    }

    public static class WebSocketContent extends JSONModel {
        @ApiModelProperty(value = "通讯戳", name = "nonce")
        private String nonce;

        @ApiModelProperty(value = "通讯状态码", name = "code", required = true)
        private Object code;

        @ApiModelProperty(value = "通讯异常信息", name = "msg")
        private String msg;

        @ApiModelProperty(value = "类型", name = "type", required = true)
        private String type;

        @ApiModelProperty(value = "通讯设备唯一标识", name = "key", required = true)
        private String key;

        @ApiModelProperty(value = "发送信息", name = "send")
        private Object send;

        @ApiModelProperty(value = "离线保存时间(分钟)", name = "timeLive")
        private Long timeLive;

        @ApiModelProperty(value = "密钥", name = "msg", hidden = true)
        private String aeskey;

        public String getNonce() {
            return nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public Object getCode() {
            return code;
        }

        public void setCode(Object code) {
            this.code = code;
        }

        public String getMsg() {
            return msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Object getSend() {
            return send;
        }

        public void setSend(Object send) {
            this.send = send;
        }

        public Long getTimeLive() {
            return timeLive;
        }

        public void setTimeLive(Long timeLive) {
            this.timeLive = timeLive;
        }

        public String getAeskey() {
            return aeskey;
        }

        public void setAeskey(String aeskey) {
            this.aeskey = aeskey;
        }
    }
}
