package com.jhscale.test.third;

import com.jhscale.meter.protocol.print.em.Dir;
import com.jhscale.meter.protocol.print.em.Font;
import com.jhscale.meter.protocol.print.em.Grid;
import com.jhscale.meter.protocol.print.entity.para.*;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class B {

    private final List<Para> list = new ArrayList<>();

    public void addString(String s) {
        StringPara para = new StringPara()
                .set_Font(Font.FONT1);
        try {
            para.set_Dir(Dir.ZERO)
                    .set_Grid(Grid.Defaul_Grid)
                    .setStartX(0)
                    .setStartY(0)
                    .setOffsetX(0)
                    .setOffsetY(0);
        } catch (Exception e) {
            e.printStackTrace();
        }
        para.set_Content(s);
        list.add(para);

        addPrint();
    }

    public void addPrint() {
        PrintPara para = new PrintPara();
        list.add(para);
    }

    //居中
    private void addStringCenter(String s) {
        StringPara para = new StringPara()
                .set_Font(Font.FONT1);
        try {
            para.set_Dir(Dir.ZERO)
                    .set_Grid(Grid.Defaul_Grid)
                    .setStartX(0)
                    .setStartY(0)
                    .setOffsetX(0)
                    .setOffsetY(0);
        } catch (Exception e) {
            e.printStackTrace();
        }
        para.set_Content(getSpace((32 - getLength(s)) / 2) + s);

        list.add(para);

        addPrint();
    }

    private void printQRCode(String code) {
        BarCodePara para = new BarCodePara()
                .set_Dir(Dir.ZERO)
                .set_Grid(Grid.Defaul_Grid);
        try {
            para.set_BarCode("0B03050600000000");
        } catch (Exception e) {
            e.printStackTrace();
        }
        para.setStartX(0)
                .setStartY(0)
                .setOffsetX(384)
                .setOffsetY(26)
                .set_Content("ojtesdfkvsjvsjvjasdjfjsfdkajskfjaklsdjf");

        list.add(para);

        addPrint();
    }

    private void printDoubleForLine(String key, String value) {
        addString(key + getSpace(32 - getLength(key) - getLength(value)) + value);
    }

    private String switchNullString(String str) {
        if (null == str) {
            return "";
        }
        return str;
    }

    private String getSpace(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; i++) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private int getLength(String string) {
        if (null == string) {
            return 0;
        }
        char[] charArray = string.toCharArray();
        int length = 0;
        for (char c : charArray) {
            length++;
            if (c / 0x80 > 0) {
                length++;
            }
        }
        return length;
    }

    private void printForThreeContent(String str0, String str1, String str2, String str3) {
        final int PRODUCT_PRICE_GOODS_NAME = 8;
        final int PRODUCT_PRICE_SPACE = 6;
        final int PRODUCT_QUANTITY_SPACE = 8;
        final int PRODUCT_SUM_SPACE = 7;
        final int SPACE = 1;
        String firstLine = str0;
        String secondLine = "";
        String thirdLine = "";
        if (8 < getLength(str0)) {
            System.out.println("Line11" + firstLine);
            addString(firstLine);
            secondLine = getSpace(10) + str1;
            if (6 < getLength(str1)) {
                addString(secondLine);
                System.out.println("Line22" + secondLine);
                thirdLine = getSpace(16) + str2;
                System.out.println("Line33" + thirdLine);
                if (8 < getLength(str2)) {
                    addString(thirdLine);
                    addString(getSpace(32 - getLength(str3)) + str3);
                } else {
                    if (8 < getLength(str3)) {
                        addString(thirdLine);
                        addString(getSpace(32 - getLength(str3)) + str3);
                    } else {
                        thirdLine = thirdLine + getSpace(32 - getLength(thirdLine) - getLength(str3)) + str3;
                        addString(thirdLine);
                    }
                }
            } else {
                secondLine = secondLine + getSpace(16 - getLength(secondLine)) + str2;
                if (8 < getLength(str2)) {
                    addString(secondLine);
                    addString(getSpace(32 - getLength(str3)) + str3);
                } else {
                    if (8 < getLength(str3)) {
                        addString(secondLine);
                        addString(getSpace(32 - getLength(str3)) + str3);
                    } else {
                        secondLine = secondLine + getSpace(32 - getLength(secondLine) - getLength(str3)) + str3;
                        addString(secondLine);
                    }
                }
            }
        } else {
            firstLine = firstLine + getSpace(8 - getLength(firstLine) + 2) + str1;
            System.out.println("Line1" + firstLine);
            if (6 < getLength(str1)) {
                addString(firstLine);
                secondLine = getSpace(16) + str2;
                if (8 < getLength(str2)) {
                    System.out.println("Line2" + secondLine);
                    addString(secondLine);
                    addString(getSpace(32 - getLength(str3)) + str3);
                } else {
                    if (8 < getLength(str3)) {
                        addString(secondLine);
                        addString(getSpace(32 - getLength(str3)) + str3);
                    } else {
                        secondLine = secondLine + getSpace(32 - getLength(secondLine) - getLength(str3)) + str3;
                        System.out.println("Line3" + secondLine);
                        addString(secondLine);
                    }

                }
            } else {
                firstLine = firstLine + getSpace(16 - getLength(firstLine)) + str2;
                System.out.println("secondLine0" + firstLine);
                if (8 < getLength(str2)) {
                    addString(firstLine);
                    addString(getSpace(32 - getLength(str3)) + str3);
                } else {
                    if (8 < getLength(str3)) {
                        addString(firstLine);
                        addString(getSpace(32 - getLength(str3)) + str3);
                    } else {
                        firstLine = firstLine + getSpace(32 - getLength(firstLine) - getLength(str3)) + str3;
                        System.out.println("secondLine" + firstLine);
                        addString(firstLine);
                    }
                }
            }
        }
    }

    public List<Para> printOffLine(TradeOffLineProductBean.OffLineProduct objs) {
        try {
            String payType = objs.getPayType();
            SimpleDateFormat sdformat = new SimpleDateFormat("yyyy年MM月dd日 HH:mm");
            addString(sdformat.format(new Date()));
            addString("________________________________");
            addString(getSpace(32));
//        Longfly_UsbPrt.SetDHFontCmd_LF();//大号字
            addStringCenter(switchNullString(objs.getMarketName()));
            addStringCenter(switchNullString("儿科猪肉"));
            addString("支付方式：" + switchNullString(payType));
            addString("订单号：" + switchNullString(objs.getOrderId()));
            addString("下单时间：" + switchNullString(objs.getAddTime()));
            addString("______________商品______________");
            addString("商品名称" + getSpace(2) + "单价" + getSpace(2) + "数/重量" + getSpace(5) + "金额");
            //商品清单
            for (TradeOffLineListItem item : objs.getSalesProductInfoList()) {
                System.out.println("print 1" + item.getTypes());
                String goodsName = "";
//            if (item.getSourceTrace()==1){
//                goodsName = "【溯】";
//            }
                if ("0".equals(item.getTypes())) {
                    System.out.println("print 称重" + item.getPrice());
                    goodsName = goodsName + switchNullString(item.getProductName());
                    printForThreeContent(goodsName, switchNullString(item.getPrice()),
                            switchNullString(item.getWeight()), switchNullString(item.getTotalPrice()));
                } else if ("1".equals(item.getTypes())) {
                    // 计件 masterCount masterUnit"/"masterUnitDetail
                    System.out.println("print 计件" + item.getPrice());
                    goodsName = goodsName + switchNullString(item.getProductName() + " " + item.getUnitPrice());
                    printForThreeContent(goodsName, switchNullString(item.getPrice()),
                            switchNullString(item.getCounts()), switchNullString(item.getTotalPrice()));
                } else if ("2".equals(item.getTypes())) {
                    // 计件 masterCount masterUnit"/"masterUnitDetail
                    System.out.println("print 计件" + item.getPrice());
                    goodsName = goodsName + switchNullString(item.getProductName() + " " + item.getUnitPrice());
                    printForThreeContent(goodsName, switchNullString(item.getPrice()),
                            switchNullString(item.getWeight()), switchNullString(item.getTotalPrice()));
                }

            }
            addString("________________________________");
            printDoubleForLine("合计：", switchNullString(objs.getTotalPrice() + ""));
            printDoubleForLine("优惠：", switchNullString(objs.getDiscount()));
            if (!"未完成".equals(objs.getStatus())) {
                if ("现金".equals(payType)) {
                    printDoubleForLine("已付：", switchNullString(objs.getReceiveTotalPrice() + ""));
                    printDoubleForLine("找零：", switchNullString(objs.getDib()));
                }
                if ("true".equals(objs.getIsTcmOrder())) {
                    try {
                        if (new BigDecimal(objs.getTcmDiscount()).compareTo(BigDecimal.ZERO) > 0) {
                            printDoubleForLine("线上优惠：", switchNullString(objs.getTcmDiscount() + ""));
                        }
                    } catch (Exception e) {
                    }
                    try {
                        if (new BigDecimal(objs.getTcmIntegral()).compareTo(BigDecimal.ZERO) > 0) {
                            printDoubleForLine("积分抵扣：", switchNullString(objs.getTcmIntegral() + ""));
                        }
                    } catch (Exception e) {
                    }
                    try {
                        if (new BigDecimal(objs.getTcmBalance()).compareTo(BigDecimal.ZERO) > 0) {
                            printDoubleForLine("余额支付：", switchNullString(objs.getTcmBalance() + ""));
                        }
                    } catch (Exception e) {
                    }


                }
                try {
                    if ("现金".equals(payType) || new BigDecimal(objs.getReceivable()).compareTo(BigDecimal.ZERO) > 0) {
                        if (payType != null && !"".equals(payType)) {
                            printDoubleForLine("" + payType + "支付：", switchNullString(objs.getReceivable() + ""));
                        }
                    }
                } catch (Exception e) {
//            printDoubleForLine("" + payType + "支付：", switchNullString(objs.getReceivable() + ""));
                }
                addString("________________________________");
                if (!StringUtils.isEmpty(objs.getMemberId())) {
                    addString(" ");
                    String memberAndPhone = objs.getMemberName();
                    if (!StringUtils.isEmpty(objs.getMemberNo()) && objs.getMemberNo().length() >= 4) {
                        memberAndPhone = memberAndPhone + "[" + objs.getMemberNo().substring(objs.getMemberNo().length() - 4, objs.getMemberNo().length()) + "]";
                    } else {
                        memberAndPhone = memberAndPhone + "[" + objs.getMemberNo() + "]";
                    }
                    printDoubleForLine("会员信息：", switchNullString(memberAndPhone));
                    printDoubleForLine("会员卡号：", switchNullString(objs.getMemberCard()));
                    printDoubleForLine("本单积分：", switchNullString(objs.getOrderPoints()));
                    printDoubleForLine("可用积分：", switchNullString(objs.getOrderTotalPoints()));
                    addString("________________________________");
                }
                addString(" ");

//        Longfly_UsbPrt.SetDHFontCmd_LF();
                addStringCenter("扫码查追溯");
                //商品追溯
                printQRCode("http://ts2.taocaimall.com/order/index/qrIndex/" + objs.getOrderId());
                addString(" ");
                addString("_______________完_______________");
            } else {
                try {
                    if ("现金".equals(payType) || new BigDecimal(objs.getReceivable()).compareTo(BigDecimal.ZERO) > 0) {
                        printDoubleForLine("应付：", switchNullString(objs.getReceivable() + ""));
                    }
                } catch (Exception e) {
//            printDoubleForLine("" + payType + "支付：", switchNullString(objs.getReceivable() + ""));
                }
                addString("________________________________");
                addString(" ");
//        Longfly_UsbPrt.SetDHFontCmd_LF();
                addStringCenter("请使用微信扫描下方二维码");
                //商品追溯
                printQRCode("http://ts2.taocaimall.com/payment-rest-server/payment/umsweb/pay/gzh/" + objs.getOrderId());
                addString(" ");
                addString("_______________完_______________");
            }
            addString(" ");
            CuttingPosition para = new CuttingPosition();
            list.add(para);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}
