package com.jhscale.test.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

/**
 * @author lie_w
 * @title: ReceiveThread
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/12/3019:53
 */
public class ReceiveThread implements Runnable {

    private DatagramSocket ds;

    public ReceiveThread(DatagramSocket dreceive) {
        this.ds = dreceive;
    }

    /**
     * When an object implementing interface <code>Runnable</code> is used
     * to create a thread, starting the thread causes the object's
     * <code>run</code> method to be called in that separately executing
     * thread.
     * <p>
     * The general contract of the method <code>run</code> is that it may
     * take any action whatsoever.
     *
     * @see Thread#run()
     */
    @Override
    public void run() {
        try {
            while (true) {
                byte[] b = new byte[1024];
                DatagramPacket dp = new DatagramPacket(b, b.length);

                ds.receive(dp);

                String ip = dp.getAddress().getHostAddress();
                String s = new String(dp.getData(), 0, dp.getLength());
                System.out.println(ip + " 向您发送了:" + s);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
