/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.ai;

import com.jhscale.meter.protocol.model.GlobalPara;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AIInfo {
    @ApiModelProperty(value="type", name="\u7c7b\u578b\uff0c0=\u5173\uff0c1=\u5f00\uff0c2=\u5f85\u8bad\u7ec3")
    private int type;
    @ApiModelProperty(value="aiMain", name="\u4e3bAI")
    private String aiMain = "";
    @ApiModelProperty(value="aiB", name="\u57fa\u7840AI")
    private List<AIInfo_B> aiBs;
    @ApiModelProperty(value="aiC", name="\u590d\u6742AI")
    private List<AIInfo_C> aiCs;
    private static final DecimalFormat df = new DecimalFormat("#.0000", new DecimalFormatSymbols(Locale.ENGLISH));

    public AIInfo() {
        this.type = 1;
        this.aiBs = new ArrayList<AIInfo_B>();
        this.aiCs = new ArrayList<AIInfo_C>();
    }

    public AIInfo(String input) {
        int cttype;
        this.aiBs = new ArrayList<AIInfo_B>();
        this.aiCs = new ArrayList<AIInfo_C>();
        this.type = 0;
        String[] ts = input.split("#");
        if (ts.length > 1 && ((cttype = Integer.parseInt(ts[0])) == 1 || cttype == 2) && ts[1].length() > 0) {
            this.type = cttype;
            String[] ids = ts[1].split("&");
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] == "") continue;
                if (ids[i].contains("%")) {
                    AIInfo_C ac = new AIInfo_C(ids[i]);
                    if (ac.parts.size() <= 0) continue;
                    this.aiCs.add(ac);
                    continue;
                }
                int mpos = ids[i].indexOf(":");
                if (mpos == 0) continue;
                if (mpos < 0) {
                    this.aiBs.add(new AIInfo_B(ids[i], ""));
                } else {
                    this.aiBs.add(new AIInfo_B(ids[i].substring(0, mpos), ids[i].substring(mpos + 1)));
                }
                if (this.aiMain != "") continue;
                this.aiMain = ids[i];
            }
        }
    }

    private static Double getMaxValue_NoZero(Map<String, Double> input) {
        Double max = 0.0;
        if (input != null) {
            for (Map.Entry<String, Double> entry : input.entrySet()) {
                Double ct = entry.getValue();
                if (!(ct > max)) continue;
                max = ct;
            }
        }
        if (max <= 0.0) {
            max = 1.0;
        }
        return max;
    }

    public Double Check(Map<String, Double> input) {
        return this.Check(input, AIInfo.getMaxValue_NoZero(input));
    }

    public Double Check(Map<String, Double> input, Double inmax) {
        int i;
        Double max = 0.0;
        for (i = 0; i < this.aiBs.size(); ++i) {
            String tip = this.aiBs.get((int)i).tip;
            if (!input.containsKey(tip)) continue;
            Double va = input.get(tip) / inmax;
            if (!(max < va)) continue;
            max = va;
        }
        for (i = 0; i < this.aiCs.size(); ++i) {
            Double totalLast = 0.0;
            Double totalDif = 0.0;
            for (Map.Entry<String, Double> entry : this.aiCs.get((int)i).parts.entrySet()) {
                Double ct = input.get(entry.getKey());
                ct = ct != null ? ct : 0.0;
                Double last = entry.getValue();
                totalLast = totalLast + last * last;
                totalDif = totalDif + (last - ct) * (last - ct);
            }
            if (!(totalDif < totalLast)) continue;
            Double va = Math.sqrt(totalLast) / (Math.sqrt(totalLast) + Math.sqrt(totalDif));
            if (!(max < va)) continue;
            max = va;
        }
        return Double.parseDouble(df.format(max));
    }

    public void Learn(Map<String, Double> input) {
        AIInfo_C ac = new AIInfo_C(input);
        if (ac.parts.size() > 0) {
            this.aiCs.add(ac);
            while (this.aiCs.size() > GlobalPara.getInstance().getTMS(1037, 10)) {
                this.aiCs.remove(0);
            }
        }
    }

    public String GetString() {
        String output = Integer.toString(this.type);
        boolean first = true;
        if (this.type == 1 || this.type == 2) {
            int i;
            for (i = 0; i < this.aiBs.size(); ++i) {
                if (first) {
                    output = output + "#";
                    first = false;
                } else {
                    output = output + "&";
                }
                AIInfo_B aiB = this.aiBs.get(i);
                output = aiB.des == "" ? output + aiB.tip : output + aiB.tip + ":" + aiB.des;
            }
            for (i = 0; i < this.aiCs.size(); ++i) {
                if (first) {
                    output = output + "#";
                    first = false;
                } else {
                    output = output + "&";
                }
                ArrayList<Map.Entry<String, Double>> list = new ArrayList<Map.Entry<String, Double>>(this.aiCs.get((int)i).parts.entrySet());
                Collections.sort(list, new Comparator<Map.Entry<String, Double>>(){

                    @Override
                    public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                        Double cp = o1.getValue() - o2.getValue();
                        if (cp == 0.0) {
                            return 0;
                        }
                        if (cp > 0.0) {
                            return -1;
                        }
                        return 1;
                    }
                });
                for (int k = 0; k < list.size(); ++k) {
                    BigDecimal tv = new BigDecimal((Double)((Map.Entry)list.get(k)).getValue() * 100.0).setScale(0, 4).divide(new BigDecimal(100));
                    output = output + (String)((Map.Entry)list.get(k)).getKey() + "=" + tv.toString() + "%";
                }
            }
        }
        return output;
    }

    static class AIInfo_C {
        public Map<String, Double> parts = new HashMap<String, Double>();

        public AIInfo_C(String input) {
            try {
                String[] ps = input.split("%");
                for (int i = 0; i < ps.length; ++i) {
                    int mpos = ps[i].indexOf("=");
                    if (mpos <= 0) continue;
                    String tip = ps[i].substring(0, mpos);
                    Double percent = Double.parseDouble(ps[i].substring(mpos + 1));
                    if (!(percent >= 0.01)) continue;
                    this.parts.put(tip, percent);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public AIInfo_C(Map<String, Double> input) {
            ArrayList<Map.Entry<String, Double>> list = new ArrayList<Map.Entry<String, Double>>(input.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<String, Double>>(){

                @Override
                public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                    Double cp = o1.getValue() - o2.getValue();
                    if (cp == 0.0) {
                        return 0;
                    }
                    if (cp > 0.0) {
                        return -1;
                    }
                    return 1;
                }
            });
            int MaxPerComplex = GlobalPara.getInstance().getTMS(1038, 5);
            for (int i = 0; i < list.size() && i < MaxPerComplex; ++i) {
                this.parts.put((String)((Map.Entry)list.get(i)).getKey(), (Double)((Map.Entry)list.get(i)).getValue());
            }
        }
    }

    static class AIInfo_B {
        public String tip;
        public String des;

        public AIInfo_B(String tip, String des) {
            this.tip = tip;
            this.des = des;
        }
    }
}

