/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.ai;

import com.jhscale.common.ai.ProbablyScore;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.module.DAIType;
import com.jhscale.meter.ai.AIInfo;
import com.jhscale.meter.ai.AIRecord;
import com.jhscale.meter.ai.AIResult;
import com.jhscale.meter.ai.EscapeResult;
import com.jhscale.meter.protocol.model.GlobalPara;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class AILocalFactory {
    private final Map<Integer, AIInfo> PLU_AI_INFO = new HashMap<Integer, AIInfo>();

    private AILocalFactory() {
    }

    public static AILocalFactory getInstance() {
        return SingleAIFactory.INSTANCE;
    }

    public AILocalFactory add(DPLUV5 ... plus) {
        return this.add(false, plus);
    }

    public AILocalFactory add(List<DPLUV5> plus) {
        return this.add(false, plus);
    }

    public AILocalFactory add(boolean clear, DPLUV5 ... plus) {
        return plus != null && plus.length > 0 ? this.add(clear, Arrays.asList(plus)) : this;
    }

    public AILocalFactory add(boolean clear, List<DPLUV5> plus) {
        if (clear) {
            this.clear();
        }
        Optional.ofNullable(plus).orElse(Collections.emptyList()).forEach(plu -> {
            if (plu.getNo() != null && plu.getAiType() != null) {
                this.PLU_AI_INFO.put(plu.getNo(), new AIInfo(plu.getAiType().toPackage()));
            }
        });
        return this;
    }

    public AILocalFactory remove(Integer ... nos) {
        return nos != null && nos.length > 0 ? this.remove(Arrays.asList(nos)) : this;
    }

    public AILocalFactory remove(List<Integer> nos) {
        Optional.ofNullable(nos).orElse(Collections.emptyList()).forEach(no -> {
            if (no != null) {
                this.PLU_AI_INFO.remove(no);
            }
        });
        return this;
    }

    public AILocalFactory clear() {
        this.PLU_AI_INFO.clear();
        return this;
    }

    public AIRecord collection(AIRecord record) {
        long start = System.currentTimeMillis();
        AIInfo aiInfo = this.PLU_AI_INFO.get(record.getPluno());
        if (aiInfo == null) {
            aiInfo = new AIInfo();
            this.PLU_AI_INFO.put(record.getPluno(), aiInfo);
        }
        EscapeResult escape = this.escape(record.getScores());
        aiInfo.Learn(escape.getResult());
        record.setDaiType(new DAIType(aiInfo.GetString()));
        long end = System.currentTimeMillis();
        if (GlobalPara.getInstance().isRunLog()) {
            System.out.printf("collection-[%s] : %s%n", start, end - start);
        }
        return record;
    }

    public List<AIResult> identify(List<ProbablyScore> scores) {
        long start = System.currentTimeMillis();
        EscapeResult escape = this.escape(scores);
        ArrayList<AIResult> results = new ArrayList<AIResult>();
        if (!this.PLU_AI_INFO.isEmpty()) {
            for (Map.Entry<Integer, AIInfo> entry : this.PLU_AI_INFO.entrySet()) {
                if (entry == null) continue;
                results.add(new AIResult(entry.getKey(), entry.getValue().Check(escape.getResult(), escape.getMax())));
            }
        }
        Collections.sort(results);
        long end = System.currentTimeMillis();
        if (GlobalPara.getInstance().isRunLog()) {
            System.out.printf("identify-[%s] : %s%n", start, end - start);
        }
        return results;
    }

    private EscapeResult escape(List<ProbablyScore> scores) {
        long start = System.currentTimeMillis();
        EscapeResult result = new EscapeResult();
        Optional.ofNullable(scores).orElse(Collections.emptyList()).forEach(score -> {
            double dv = Double.parseDouble(Float.toString(score.getSource()));
            result.add(StringUtils.isNotBlank((CharSequence)score.getModel()) ? score.getModel() : score.getImageName(), dv);
            result.compare(dv);
        });
        long end = System.currentTimeMillis();
        if (GlobalPara.getInstance().isRunLog()) {
            System.out.printf("escape-[%s] : %s%n", start, end - start);
        }
        return result;
    }

    private static class SingleAIFactory {
        private static final AILocalFactory INSTANCE = new AILocalFactory();

        private SingleAIFactory() {
        }
    }
}

