/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.auncel;

import com.jhscale.meter.auncel.AuncelNotify;
import com.jhscale.meter.auncel.AuncelUtils;
import com.jhscale.meter.auncel.cmd.AL_0B_ReadWeightRequest;
import com.jhscale.meter.auncel.cmd.AL_0B_ReadWeightResponse;
import com.jhscale.meter.auncel.cmd.AL_Handle_Reset_Notify;
import com.jhscale.meter.auncel.cmd.Handle1Request;
import com.jhscale.meter.auncel.cmd.Handle1Response;
import com.jhscale.meter.auncel.cmd.Handle2Request;
import com.jhscale.meter.auncel.cmd.Handle2Response;
import com.jhscale.meter.auncel.em.CPT;
import com.jhscale.meter.auncel.entity.AuncelRequest;
import com.jhscale.meter.auncel.entity.AuncelResponse;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.model.device.SerialDevice;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

public class AuncelManager {
    private PortManager portManager;
    private long timeout = 500L;
    private int recount = 3;
    private long cycle_timeout = 10L;
    private int cycle_count = 100;
    private String cache = "";
    private AuncelRequest request;
    private AuncelResponse response;
    private AuncelNotify notify;
    private String seed;
    private Read_Weight_Thread read_weight_thread;
    private long read_cycle = 100L;

    private AuncelManager() {
    }

    public static AuncelManager getInstance() {
        return SingleAuncelManagerFactory.INSTANCE;
    }

    public AuncelManager Settings(long timeout, Integer recount, long cycle_timeout, long read_cycle) {
        this.timeout = timeout;
        this.recount = recount;
        this.cycle_timeout = cycle_timeout;
        this.cycle_count = (int)(this.timeout / this.cycle_timeout) + 1;
        this.read_cycle = read_cycle;
        return this;
    }

    public boolean Init_Manager(DeviceControl control, SerialDevice device, final AuncelNotify notify) throws MeterException {
        if (this.portManager != null) {
            this.portManager.closePort();
            this.portManager = null;
        }
        this.Execute_Reset();
        this.seed = null;
        this.portManager = new PortManager<SerialDevice>(control, device, new DeviceClientEventListener(){

            @Override
            public void onClientEvent(byte[] bytes) throws MeterException {
                long timestamp = System.currentTimeMillis();
                String accept = AuncelManager.this.cache + ByteUtils.bytes2HexString(bytes);
                System.out.printf("%s \u4e32\u53e3\u76d1\u542c \u5185\u5bb9\uff1a %s%n", timestamp, accept);
                while (StringUtils.isNotBlank((CharSequence)accept)) {
                    int start_index = ByteUtils.indexOf(accept, "A5");
                    if (start_index == -1) {
                        return;
                    }
                    int end_index = ByteUtils.indexOf(accept = accept.substring(start_index), "5A");
                    if (end_index == -1) {
                        AuncelManager.this.cache = accept;
                        return;
                    }
                    String command = accept.substring(0, end_index + 2);
                    System.out.printf("%s \u4e32\u53e3\u76d1\u542c \u6709\u6548\u6570\u636e\u5305 \u5185\u5bb9 %s%n", timestamp, AuncelUtils.hexPrint(command));
                    AuncelRequest auncelResponse = new AuncelResponse(command).execute();
                    System.out.printf("%s [%s] \u63a5\u53d7\u6570\u636e\u5305\uff1a %s %s%n", timestamp, auncelResponse.getNid(), auncelResponse.getClass().getName(), auncelResponse.toJSON());
                    if (auncelResponse instanceof AL_Handle_Reset_Notify) {
                        AuncelManager.this.Execute_Reset();
                        GlobalPara.getInstance().executor().execute(() -> {
                            try {
                                AuncelManager.this.al_handle();
                            }
                            catch (MeterException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    } else {
                        AuncelManager.this.response = (AuncelResponse)auncelResponse;
                    }
                    accept = accept.substring(end_index + 2);
                }
            }

            @Override
            public void onClientEventExp(MeterException e) {
                if (notify != null) {
                    notify.exp(e);
                }
            }
        });
        boolean result = this.portManager.openPort();
        if (!result) {
            this.portManager = null;
        } else {
            this.notify = notify;
        }
        return result;
    }

    private synchronized boolean al_handle() throws MeterException {
        Handle2Response handle2Response;
        Handle1Response handle1Response;
        if (this.read_weight_thread != null) {
            this.read_weight_thread.action = false;
            this.read_weight_thread = null;
        }
        if ((handle1Response = this.execute(new Handle1Request())) != null && handle1Response.isResult() && (handle2Response = this.execute(new Handle2Request().setCpt(CPT.Color_Acl).setSeed(handle1Response.getSeed()))) != null && handle2Response.isResult()) {
            this.seed = handle1Response.getSeed();
            this.read_weight_thread = new Read_Weight_Thread();
            this.read_weight_thread.start();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T extends AuncelRequest, U extends AuncelResponse> U execute(AuncelRequest<T, U> request) throws MeterException {
        if (this.request != null) {
            throw new MeterException(MeterStateEnum.TP\u8bf7\u6c42\u4e2d\u7a0d\u540e\u518d\u8bd5);
        }
        long timestamp = System.currentTimeMillis();
        String command = ((AuncelRequest)request.execute()).over();
        System.out.printf("%s [%s] \u53d1\u9001\u6570\u636e\u5305\uff1a %s %s%n", timestamp, request.getNid(), request.getClass().getName(), request.toJSON());
        AuncelResponse response = null;
        try {
            if (this.read_weight_thread != null) {
                this.read_weight_thread.pause();
            }
            this.request = request;
            for (int recount = 0; recount < this.recount; ++recount) {
                System.out.printf("%s \u4e32\u53e3\u53d1\u9001 \u5185\u5bb9\uff1a %s%n", timestamp, AuncelUtils.hexPrint(command));
                this.portManager.writeDataImmediately(ByteUtils.fromHexString(command));
                for (int cycle_count = 0; cycle_count < this.cycle_count; ++cycle_count) {
                    this.cycle_sleep();
                    if (this.response == null) continue;
                    response = this.response;
                    break;
                }
                if (response != null) break;
            }
            this.Execute_Reset();
        }
        finally {
            if (this.read_weight_thread != null) {
                this.read_weight_thread.pause();
            }
        }
        return (U)response;
    }

    public AuncelManager Execute_Reset() {
        this.request = null;
        this.response = null;
        this.cache = "";
        return this;
    }

    private void cycle_sleep() {
        try {
            Thread.sleep(this.cycle_timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getSeed() {
        return this.seed;
    }

    public class Read_Weight_Thread
    extends Thread {
        private boolean action = true;
        private boolean pause = false;

        @Override
        public void run() {
            while (this.action) {
                block7: {
                    if (!this.pause) {
                        try {
                            AL_0B_ReadWeightResponse al_0B_readWeightResponse = AuncelManager.this.execute(new AL_0B_ReadWeightRequest());
                            if (AuncelManager.this.notify != null) {
                                AuncelManager.this.notify.notify(al_0B_readWeightResponse);
                            }
                        }
                        catch (MeterException e) {
                            if (AuncelManager.this.notify == null) break block7;
                            AuncelManager.this.notify.exp(e);
                        }
                    }
                }
                try {
                    Thread.sleep(AuncelManager.this.read_cycle);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void pause() {
            this.pause = !this.pause;
        }
    }

    private static class SingleAuncelManagerFactory {
        private static final AuncelManager INSTANCE = new AuncelManager();

        private SingleAuncelManagerFactory() {
        }
    }
}

