/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.auncel;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.utils.AesHexUtils;
import com.jhscale.meter.utils.ByteUtils;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class AuncelUtils {
    public static final String TOP = "A5";
    public static final int TOP_V = 165;
    public static final String TOP_T = "85";
    public static final int TOP_TV = 133;
    public static final String END = "5A";
    public static final int END_V = 90;
    public static final String END_T = "7A";
    public static final int END_TV = 122;
    public static final String REPLACE = "55";
    public static final int REPLACE_V = 85;
    public static final String REPLACE_T = "75";
    public static final int REPLACE_TV = 117;
    private static final String AES_KEY1 = "57A2F04822775D16875B6398E9C51E37";
    private static final int[] Protocal2_Encode1 = new int[]{201, 89, 20, 82, 108, 4, 236, 173, 67, 166, 170, 208, 7, 116, 104, 113, 143, 30, 98, 223, 254, 62, 150, 105, 160, 141, 14, 138, 60, 190, 226, 196, 83, 229, 195, 61, 112, 13, 249, 154, 114, 127, 133, 233, 65, 177, 231, 54, 244, 11, 71, 214, 198, 188, 161, 15, 119, 38, 46, 56, 1, 94, 184, 247, 32, 110, 246, 204, 156, 63, 77, 242, 118, 91, 53, 85, 69, 48, 44, 49, 232, 205, 174, 126, 99, 26, 66, 157, 27, 16, 9, 224, 202, 142, 136, 117, 135, 88, 145, 221, 180, 2, 111, 90, 84, 155, 194, 51, 252, 109, 152, 92, 148, 132, 165, 58, 74, 139, 234, 209, 215, 124, 213, 36, 230, 57, 86, 22, 101, 29, 47, 121, 72, 25, 228, 87, 178, 24, 159, 191, 248, 95, 42, 18, 235, 0, 240, 255, 40, 107, 128, 106, 172, 237, 245, 10, 187, 129, 43, 181, 206, 219, 151, 55, 50, 140, 147, 217, 28, 168, 210, 35, 253, 59, 70, 185, 158, 131, 222, 41, 102, 93, 171, 182, 192, 122, 76, 176, 149, 39, 189, 211, 225, 37, 125, 33, 207, 241, 6, 130, 251, 193, 68, 216, 103, 81, 80, 134, 5, 123, 162, 137, 144, 220, 45, 163, 75, 78, 243, 179, 250, 8, 64, 186, 239, 31, 12, 218, 3, 73, 146, 167, 79, 238, 169, 197, 175, 100, 183, 23, 199, 19, 96, 203, 227, 21, 17, 164, 212, 115, 52, 120, 153, 97, 34, 200};
    private static final int[] Protocal2_Encode2 = new int[]{123, 87, 179, 68, 43, 252, 56, 50, 11, 41, 30, 149, 34, 121, 191, 221, 29, 105, 86, 31, 157, 178, 242, 199, 144, 103, 194, 21, 188, 12, 78, 186, 125, 51, 238, 35, 126, 94, 187, 233, 131, 224, 210, 48, 170, 72, 165, 118, 245, 250, 138, 129, 100, 175, 101, 49, 93, 154, 239, 214, 13, 110, 115, 244, 182, 77, 113, 7, 46, 66, 54, 80, 243, 76, 0, 143, 206, 133, 232, 152, 236, 216, 127, 230, 128, 139, 102, 47, 132, 27, 84, 82, 73, 37, 174, 8, 36, 240, 200, 135, 215, 114, 136, 10, 145, 248, 146, 226, 89, 23, 112, 122, 44, 217, 74, 19, 155, 40, 162, 24, 150, 64, 237, 33, 71, 168, 167, 61, 17, 92, 111, 196, 108, 119, 91, 254, 161, 58, 81, 16, 235, 195, 14, 181, 95, 255, 63, 45, 229, 142, 60, 184, 22, 70, 190, 109, 5, 15, 141, 208, 158, 134, 140, 209, 148, 26, 55, 222, 4, 192, 205, 62, 253, 204, 166, 159, 20, 65, 213, 9, 198, 39, 228, 234, 189, 183, 79, 251, 90, 197, 83, 177, 97, 53, 116, 173, 88, 218, 231, 246, 180, 124, 120, 176, 25, 163, 99, 57, 247, 59, 211, 202, 223, 85, 207, 160, 164, 107, 6, 1, 96, 106, 169, 212, 32, 117, 153, 75, 203, 172, 3, 225, 28, 201, 147, 67, 104, 137, 98, 171, 69, 227, 185, 220, 2, 52, 219, 18, 38, 130, 151, 156, 241, 42, 193, 249};
    private static final String AES_KEY2 = "C30A8F7E529B1D5F4C6E2B0D91438AE7";
    private static final int[] Protocal2_Encode3 = new int[]{171, 67, 232, 62, 150, 117, 11, 88, 215, 199, 36, 98, 51, 23, 127, 192, 223, 204, 61, 77, 160, 134, 200, 227, 96, 175, 131, 136, 239, 9, 93, 89, 48, 27, 231, 212, 208, 81, 252, 161, 105, 58, 92, 219, 73, 106, 34, 246, 203, 25, 79, 244, 211, 26, 197, 201, 13, 243, 6, 162, 213, 20, 145, 228, 70, 218, 183, 64, 68, 103, 3, 10, 174, 248, 238, 151, 76, 194, 31, 33, 126, 2, 102, 235, 135, 66, 12, 255, 214, 54, 91, 207, 113, 7, 191, 206, 130, 141, 38, 107, 28, 146, 95, 182, 149, 152, 37, 132, 234, 168, 114, 41, 237, 55, 90, 57, 164, 118, 220, 198, 78, 123, 154, 159, 32, 179, 122, 129, 111, 119, 155, 249, 169, 94, 45, 115, 156, 166, 40, 139, 17, 233, 4, 142, 185, 184, 163, 108, 86, 85, 1, 240, 144, 148, 84, 189, 83, 172, 104, 173, 30, 52, 250, 247, 202, 181, 19, 60, 230, 8, 18, 125, 15, 165, 80, 29, 222, 170, 226, 254, 101, 221, 124, 100, 75, 120, 72, 137, 225, 35, 21, 241, 5, 217, 193, 63, 59, 186, 0, 167, 242, 140, 195, 16, 128, 236, 143, 39, 229, 43, 190, 133, 205, 188, 44, 99, 14, 56, 251, 177, 210, 42, 121, 82, 178, 158, 153, 24, 110, 47, 53, 74, 147, 69, 50, 245, 97, 65, 209, 46, 87, 112, 187, 224, 180, 71, 109, 253, 116, 49, 22, 176, 138, 216, 157, 196};
    private static final int[] Protocal2_Encode4 = new int[]{198, 150, 81, 70, 142, 192, 58, 93, 169, 29, 71, 6, 86, 56, 216, 172, 203, 140, 170, 166, 61, 190, 250, 13, 227, 49, 53, 33, 100, 175, 160, 78, 124, 79, 46, 189, 10, 106, 98, 207, 138, 111, 221, 209, 214, 134, 239, 229, 32, 249, 234, 12, 161, 230, 89, 113, 217, 115, 41, 196, 167, 18, 3, 195, 67, 237, 85, 1, 68, 233, 64, 245, 186, 44, 231, 184, 76, 19, 120, 50, 174, 37, 223, 156, 154, 149, 148, 240, 7, 31, 114, 90, 42, 30, 133, 102, 24, 236, 11, 215, 183, 180, 82, 69, 158, 40, 45, 99, 147, 246, 228, 128, 241, 92, 110, 135, 248, 5, 117, 129, 185, 222, 126, 121, 182, 171, 80, 14, 204, 127, 96, 26, 107, 211, 21, 84, 27, 187, 252, 139, 201, 97, 143, 206, 152, 62, 101, 232, 153, 104, 4, 75, 105, 226, 122, 130, 136, 254, 225, 123, 20, 39, 59, 146, 116, 173, 137, 199, 109, 132, 177, 0, 157, 159, 72, 25, 251, 219, 224, 125, 244, 165, 103, 66, 145, 144, 197, 242, 213, 155, 210, 94, 15, 194, 77, 202, 255, 54, 119, 9, 22, 55, 164, 48, 17, 212, 95, 91, 36, 238, 220, 52, 35, 60, 88, 8, 253, 193, 65, 43, 118, 181, 176, 16, 243, 188, 178, 23, 63, 208, 168, 34, 2, 141, 108, 83, 205, 112, 74, 28, 151, 191, 200, 57, 51, 235, 47, 163, 73, 131, 162, 218, 38, 247, 179, 87};
    private static Integer nid;

    private AuncelUtils() {
    }

    private static String code(String str, int[] arr) throws MeterException {
        if (StringUtils.isBlank((CharSequence)str) || str.length() % 2 != 0) {
            throw new MeterException(MeterStateEnum.TP\u6570\u636e\u5305\u683c\u5f0f\u9519\u8bef);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < str.length() / 2; ++i) {
            int index = Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16);
            String val = Integer.toHexString(arr[index]);
            if (val.length() != 2) {
                val = "0" + val;
            }
            stringBuffer.append(val);
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static String handshake_ack(String seed) throws MeterException {
        byte[] ebs1 = AesHexUtils.encrypt_byte(AuncelUtils.code(seed, Protocal2_Encode1), AES_KEY1);
        byte[] ebs2 = AuncelUtils.reverse(ebs1);
        return ByteUtils.toHexString(ebs2);
    }

    public static String token(String seed) throws MeterException {
        return AuncelUtils.token(seed, null);
    }

    public static String token(String seed, String aeskey) throws MeterException {
        byte[] ebs1 = AesHexUtils.encrypt_byte(AuncelUtils.code(seed, Protocal2_Encode2), StringUtils.isNotBlank((CharSequence)aeskey) ? aeskey : AES_KEY2);
        byte[] ebs2 = AuncelUtils.reverse(ebs1);
        return ByteUtils.toHexString(ebs2);
    }

    public static String encrypt(String content, String seed) throws MeterException {
        byte[] ebs1 = AesHexUtils.encrypt_byte(AuncelUtils.code(content, Protocal2_Encode3), AuncelUtils.token(seed));
        byte[] ebs2 = AuncelUtils.reverse(ebs1);
        return ByteUtils.toHexString(ebs2);
    }

    public static String decrypt(String content, String seed) throws MeterException {
        byte[] eds1 = ByteUtils.fromHexString(content);
        byte[] eds2 = AuncelUtils.reverse(eds1);
        return AuncelUtils.code(AesHexUtils.decrypt_byte(eds2, AuncelUtils.token(seed)), Protocal2_Encode4);
    }

    public static byte[] reverse(byte[] bs1) {
        byte[] bs2 = new byte[bs1.length];
        for (int i = 0; i < bs1.length; i += 4) {
            byte[] p = Arrays.copyOfRange(bs1, i, i + 4);
            for (int j = 0; j < p.length; ++j) {
                bs2[i + j] = p[p.length - 1 - j];
            }
        }
        return bs2;
    }

    public static String hexPrint(String hex) {
        if (StringUtils.isBlank((CharSequence)hex)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < hex.length(); i += 2) {
            builder.append(hex.substring(i, i + 2)).append(" ");
        }
        return builder.toString();
    }

    public static void main(String[] args) throws MeterException {
        String str = "000102030405060708090A0B0C0D0E0F";
        byte[] ebs1 = AesHexUtils.encrypt_byte(str, str);
        byte[] ebs2 = AuncelUtils.reverse(ebs1);
        String encrypt = ByteUtils.toHexString(ebs2);
        System.out.println("\u52a0\u5bc6\u540e\uff1a" + encrypt);
        byte[] eds1 = ByteUtils.fromHexString(encrypt);
        byte[] eds2 = AuncelUtils.reverse(eds1);
        String decrypt = AesHexUtils.decrypt_byte(eds2, str);
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + decrypt);
    }

    public static synchronized int nid() {
        nid = nid == null ? Integer.valueOf((int)(Math.random() * 255.0)) : Integer.valueOf(nid + 1);
        return nid;
    }
}

