/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.auncel.cmd;

import com.jhscale.meter.auncel.cmd.AL_08_ReadOnlyRequest;
import com.jhscale.meter.auncel.entity.AuncelResponse;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.utils.ByteUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class AL_08_ReadOnlyResponse
extends AuncelResponse<AL_08_ReadOnlyRequest, AL_08_ReadOnlyResponse> {
    private String manufacturer;
    private String model;
    private String serialNo;
    private String firmware;

    public AL_08_ReadOnlyResponse() {
    }

    public AL_08_ReadOnlyResponse(AL_08_ReadOnlyRequest request, String content) {
        super(request, content);
    }

    @Override
    protected void inner_execute() throws MeterException {
        this.inner_crc();
        String manufacturer_len_str = this.source_inner.substring(2, 4);
        String manufacturer_len_bin = ByteUtils.formatMark(manufacturer_len_str);
        int manufacturer_len = Integer.parseInt(manufacturer_len_bin.substring(1), 2);
        Charset manufacturer_charset = manufacturer_len_bin.charAt(0) == '0' ? StandardCharsets.US_ASCII : StandardCharsets.UTF_8;
        String manufacturer_source = this.source_inner.substring(4, 26) + this.source_inner.substring(32, 58) + this.source_inner.substring(64, 90) + this.source_inner.substring(96, 118);
        this.manufacturer = new String(ByteUtils.fromHexAscii(manufacturer_source.substring(0, manufacturer_len * 2)), manufacturer_charset);
        String model_len_str = this.source_inner.substring(118, 120);
        String model_len_bin = ByteUtils.formatMark(model_len_str);
        int model_len = Integer.parseInt(model_len_bin.substring(1), 2);
        Charset model_charset = manufacturer_len_bin.charAt(0) == '0' ? StandardCharsets.US_ASCII : StandardCharsets.UTF_8;
        String model_source = this.source_inner.substring(120, 122) + this.source_inner.substring(128, 148);
        this.model = new String(ByteUtils.fromHexAscii(model_source.substring(0, model_len * 2)), model_charset);
        this.serialNo = ByteUtils.hex2Ascii(this.source_inner.substring(148, 154) + this.source_inner.substring(160, 178));
        this.firmware = ByteUtils.hex2Ascii(this.source_inner.substring(178, 184));
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getModel() {
        return this.model;
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public String getFirmware() {
        return this.firmware;
    }
}

