/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.auncel.entity;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.auncel.em.CPT;
import com.jhscale.meter.mqtt.em.ACK;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.utils.MQTTUtils;

public class ALMack
extends JSONModel {
    private String bin;
    private Encrypt encrypt;
    private ACK ack;
    private Confirm confirm;
    private CPT cpt;

    public ALMack() {
    }

    public ALMack(ACK ack, Confirm confirm, CPT cpt) {
        this(Encrypt.Not_Encrypt, ack, confirm, cpt);
    }

    public ALMack(Encrypt encrypt, ACK ack, Confirm confirm, CPT cpt) {
        this.encrypt = encrypt;
        this.ack = ack;
        this.confirm = confirm;
        this.cpt = cpt;
    }

    public ALMack(String markContent) {
        this.bin = MQTTUtils.hex2Bit(markContent);
        this.encrypt = Encrypt.bit(this.bin.substring(0, 1));
        this.ack = ACK.bit(this.bin.substring(1, 2));
        this.confirm = Confirm.bit(this.bin.substring(2, 4));
        this.cpt = CPT.bit(this.bin.substring(4));
    }

    public String assembleMark() {
        String bin;
        this.bin = bin = this.encrypt.getBit() + this.ack.getBit() + this.confirm.getBit() + this.cpt.getBit();
        return MQTTUtils.bit2Hex(bin);
    }

    public String getBin() {
        return this.bin;
    }

    public ALMack setBin(String bin) {
        this.bin = bin;
        return this;
    }

    public Encrypt getEncrypt() {
        return this.encrypt;
    }

    public ALMack setEncrypt(Encrypt encrypt) {
        this.encrypt = encrypt;
        return this;
    }

    public ACK getAck() {
        return this.ack;
    }

    public ALMack setAck(ACK ack) {
        this.ack = ack;
        return this;
    }

    public Confirm getConfirm() {
        return this.confirm;
    }

    public ALMack setConfirm(Confirm confirm) {
        this.confirm = confirm;
        return this;
    }

    public CPT getCpt() {
        return this.cpt;
    }

    public ALMack setCpt(CPT cpt) {
        this.cpt = cpt;
        return this;
    }
}

