/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.auncel.entity;

import com.jhscale.meter.auncel.AuncelManager;
import com.jhscale.meter.auncel.AuncelUtils;
import com.jhscale.meter.auncel.entity.ALMack;
import com.jhscale.meter.auncel.entity.AuncelResponse;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.model.base.JSONMeter;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.CrcUtils;

public abstract class AuncelRequest<T extends AuncelRequest, U extends AuncelResponse>
implements JSONMeter {
    protected ALMack alMack;
    protected Integer nid;
    protected StringBuilder builder;
    protected StringBuilder source_inner;
    protected String aes_inner;

    public AuncelRequest() {
    }

    public AuncelRequest(ALMack mack) {
        this.alMack = mack;
    }

    public T execute() throws MeterException {
        int length;
        String len;
        this.nid = AuncelUtils.nid();
        this.source_inner = new StringBuilder();
        this.inner_execute();
        String mark = this.alMack.assembleMark();
        String frame = Integer.toHexString(this.nid);
        frame = (frame.length() % 2 != 0 ? "0" + frame : frame).toUpperCase();
        this.aes_inner = this.source_inner.toString();
        if (Encrypt.AES_Encrypt.equals((Object)this.alMack.getEncrypt())) {
            int append = this.source_inner.length() / 2 % 16;
            append = append == 0 ? 0 : 16 - append;
            for (int i = 0; i < append; ++i) {
                this.source_inner.append(ByteUtils.ten2Hex(i, 2));
            }
            this.aes_inner = AuncelUtils.encrypt(this.source_inner.toString(), AuncelManager.getInstance().getSeed());
        }
        len = (len = Integer.toHexString(length = this.aes_inner.length() / 2 / 4 - 1)).length() % 2 == 0 ? len : "0" + len;
        this.builder = new StringBuilder(mark).append(len).append(frame).append(this.aes_inner);
        String crc = CrcUtils.crc_0xff(this.builder.toString());
        this.builder.append(crc);
        this.builder = this.request_transfer();
        this.builder.insert(0, "A5").append("5A");
        return (T)this;
    }

    private StringBuilder request_transfer() {
        String content = this.builder.toString();
        StringBuilder _content = new StringBuilder();
        for (int i = 0; i < content.length() / 2; ++i) {
            String _c = content.substring(i * 2, i * 2 + 2);
            int _cv = Integer.parseInt(_c, 16);
            if (_cv == 165) {
                _content.append("85");
                continue;
            }
            if (_cv == 90) {
                _content.append("7A");
                continue;
            }
            if (_cv == 85) {
                _content.append("75");
                continue;
            }
            _content.append(_c);
        }
        if (GlobalPara.getInstance().isRunLog()) {
            System.out.printf("Transfer Before: [%s] After: [%s]%n", content, _content);
        }
        return _content;
    }

    protected String inner_crc() throws MeterException {
        return CrcUtils.crc_0xff(this.source_inner.toString());
    }

    protected abstract void inner_execute() throws MeterException;

    public String over() {
        return this.builder.toString();
    }

    public ALMack getAlMack() {
        return this.alMack;
    }

    public Integer getNid() {
        return this.nid;
    }

    public StringBuilder getBuilder() {
        return this.builder;
    }

    public StringBuilder getSource_inner() {
        return this.source_inner;
    }

    public String getAes_inner() {
        return this.aes_inner;
    }
}

