/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.auncel.entity;

import com.jhscale.meter.auncel.AuncelManager;
import com.jhscale.meter.auncel.AuncelUtils;
import com.jhscale.meter.auncel.cmd.AL_05_LoginResponse;
import com.jhscale.meter.auncel.cmd.AL_06_LogoutResponse;
import com.jhscale.meter.auncel.cmd.AL_07_EditPWDResponse;
import com.jhscale.meter.auncel.cmd.AL_08_ReadOnlyResponse;
import com.jhscale.meter.auncel.cmd.AL_09_WriteOnlyResponse;
import com.jhscale.meter.auncel.cmd.AL_0A_WriteRWResponse;
import com.jhscale.meter.auncel.cmd.AL_0B_ReadWeightResponse;
import com.jhscale.meter.auncel.cmd.AL_0C_ReadTareResponse;
import com.jhscale.meter.auncel.cmd.AL_0D_SetTareResponse;
import com.jhscale.meter.auncel.cmd.AL_0E_SetZeroResponse;
import com.jhscale.meter.auncel.cmd.AL_0F_ReadRWResponse;
import com.jhscale.meter.auncel.cmd.AL_Handle_Reset_Notify;
import com.jhscale.meter.auncel.cmd.Handle1Response;
import com.jhscale.meter.auncel.cmd.Handle2Response;
import com.jhscale.meter.auncel.entity.ALMack;
import com.jhscale.meter.auncel.entity.AuncelRequest;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.CrcUtils;

public class AuncelResponse<T extends AuncelRequest, U extends AuncelResponse>
extends AuncelRequest {
    private T request;

    public AuncelResponse() {
    }

    public AuncelResponse(String content) {
        this.builder = new StringBuilder(content);
    }

    public AuncelResponse(T request, String content) {
        this(content);
        this.request = request;
    }

    public U execute() throws MeterException {
        String _crc;
        this.builder = this.response_transfer();
        String crc = this.builder.substring(this.builder.length() - 4, this.builder.length() - 2);
        if (!crc.equalsIgnoreCase(_crc = CrcUtils.crc_0xff(this.builder.substring(2, this.builder.length() - 4)))) {
            throw new MeterException(MeterStateEnum.MQTT_CRC\u68c0\u67e5\u9519\u8bef);
        }
        this.alMack = new ALMack(this.builder.substring(2, 4));
        int len = (Integer.parseInt(this.builder.substring(4, 6)) + 1) * 4 * 2;
        this.nid = Integer.parseInt(this.builder.substring(6, 8), 16);
        this.aes_inner = this.builder.substring(8, 8 + len);
        this.source_inner = new StringBuilder(this.aes_inner);
        if (Encrypt.AES_Encrypt.equals((Object)this.alMack.getEncrypt())) {
            this.source_inner = new StringBuilder(AuncelUtils.decrypt(this.aes_inner, AuncelManager.getInstance().getSeed()));
        }
        AuncelResponse u = this;
        String command = this.source_inner.substring(0, 2);
        Class clazz = this.responseClass(this.alMack, command);
        if (!this.getClass().equals(clazz)) {
            try {
                u = (AuncelResponse)clazz.newInstance();
                u.builder = this.builder;
                u.alMack = this.alMack;
                u.nid = this.nid;
                u.aes_inner = this.aes_inner;
                u.source_inner = this.source_inner;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        u.inner_execute();
        return (U)u;
    }

    private StringBuilder response_transfer() {
        String content = this.builder.substring(2, this.builder.length() - 2);
        StringBuilder _content = new StringBuilder();
        for (int i = 0; i < content.length() / 2; ++i) {
            String _c = content.substring(i * 2, i * 2 + 2);
            int _cv = Integer.parseInt(_c, 16);
            if (_cv == 133) {
                _content.append("A5");
                continue;
            }
            if (_cv == 122) {
                _content.append("5A");
                continue;
            }
            if (_cv == 117) {
                _content.append("55");
                continue;
            }
            _content.append(_c);
        }
        if (GlobalPara.getInstance().isRunLog()) {
            System.out.printf("Transfer Before: [%s] After: [%s]%n", content, _content);
        }
        return _content.insert(0, "A5").append("5A");
    }

    private Class responseClass(ALMack alMack, String command) {
        Class clazz = null;
        if (alMack.getAck().isRequest()) {
            clazz = AL_Handle_Reset_Notify.class;
        } else {
            switch (command) {
                case "00": {
                    clazz = Handle1Response.class;
                    break;
                }
                case "01": {
                    clazz = Handle2Response.class;
                    break;
                }
                case "05": {
                    clazz = AL_05_LoginResponse.class;
                    break;
                }
                case "06": {
                    clazz = AL_06_LogoutResponse.class;
                    break;
                }
                case "07": {
                    clazz = AL_07_EditPWDResponse.class;
                    break;
                }
                case "08": {
                    clazz = AL_08_ReadOnlyResponse.class;
                    break;
                }
                case "09": {
                    clazz = AL_09_WriteOnlyResponse.class;
                    break;
                }
                case "0A": {
                    clazz = AL_0A_WriteRWResponse.class;
                    break;
                }
                case "0B": {
                    clazz = AL_0B_ReadWeightResponse.class;
                    break;
                }
                case "0C": {
                    clazz = AL_0C_ReadTareResponse.class;
                    break;
                }
                case "0D": {
                    clazz = AL_0D_SetTareResponse.class;
                    break;
                }
                case "0E": {
                    clazz = AL_0E_SetZeroResponse.class;
                    break;
                }
                case "0F": {
                    clazz = AL_0F_ReadRWResponse.class;
                }
            }
        }
        return clazz;
    }

    @Override
    protected String inner_crc() throws MeterException {
        String _crc;
        String crc = CrcUtils.crc_0xff(this.source_inner.substring(0, this.source_inner.length() - 2));
        if (!crc.equalsIgnoreCase(_crc = this.source_inner.substring(this.source_inner.length() - 2))) {
            throw new MeterException(MeterStateEnum.MQTT_CRC\u68c0\u67e5\u9519\u8bef);
        }
        return crc;
    }

    @Override
    protected void inner_execute() throws MeterException {
    }

    public T getRequest() {
        return this.request;
    }

    public void setRequest(T request) {
        this.request = request;
    }
}

