/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.call.agreement;

import com.alibaba.fastjson.JSON;
import com.jhscale.meter.call.agreement.A;
import com.jhscale.meter.call.agreement.B;
import com.jhscale.meter.call.agreement.C;
import com.jhscale.meter.call.agreement.D;
import com.jhscale.meter.call.agreement.G;
import com.jhscale.meter.call.agreement.I;
import com.jhscale.meter.call.agreement.IAgreement;
import com.jhscale.meter.call.agreement.Z;
import com.jhscale.meter.call.entity.Request;
import com.jhscale.meter.call.entity.Response;
import com.jhscale.meter.call.model.Assemble;
import com.jhscale.meter.call.model.Parse;
import com.jhscale.meter.call.model.ParseData;
import com.jhscale.meter.call.service.IPort;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.CodeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Agreement
implements IAgreement,
IPort {
    private Assemble assemble;
    private String cmdData;
    private IAgreement agreement;

    public Agreement() {
    }

    public Agreement(Request request) {
        this.assemble = new Assemble(request.getCmd(), request.getData());
        switch (this.assemble.getCmd()) {
            case "A": {
                this.agreement = new A();
                break;
            }
            case "I": {
                this.agreement = new I(this.assemble);
                break;
            }
            case "Z": {
                this.agreement = new Z();
                break;
            }
            default: {
                this.agreement = new Agreement();
            }
        }
    }

    public Agreement(String cmdData) {
        this.cmdData = cmdData;
    }

    @Override
    public boolean assembleCheck(Assemble assemble) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)assemble.getData())) {
            assemble.setData("");
        }
        return true;
    }

    @Override
    public String assemble() {
        Response response = null;
        try {
            String length;
            String cmd;
            int cmdNum;
            int temp;
            if (StringUtils.isBlank((CharSequence)this.assemble.getCmd())) {
                throw new Exception("201-\u6570\u636e\u6307\u4ee4\u4e3a\u7a7a");
            }
            this.agreement.assembleCheck(this.assemble);
            int frameNum = (int)(Math.random() * 255.0);
            String frame = Integer.toHexString(frameNum);
            if (frame.length() % 2 != 0) {
                frame = "0" + frame;
            }
            if ((temp = (cmdNum = Integer.parseInt(cmd = ByteUtils.ascii2Hex(this.assemble.getCmd()), 16)) + CodeUtils.codeArr[(frameNum + 1) % 256]) > 255) {
                temp -= 256;
            }
            if ((cmd = Integer.toHexString(temp)).length() % 2 != 0) {
                cmd = "0" + cmd;
            }
            int dataNum = 0;
            int assembleDataLength = 0;
            StringBuffer data = new StringBuffer();
            if (StringUtils.isNotBlank((CharSequence)this.assemble.getData())) {
                if (this.assemble.getData().length() % 2 != 0) {
                    throw new Exception("200-\u6570\u636e\u683c\u5f0f\u9519\u8bef");
                }
                assembleDataLength = this.assemble.getData().length();
                for (int i = 0; i < this.assemble.getData().length() / 2; ++i) {
                    String bitData;
                    String bit = this.assemble.getData().substring(i * 2, i * 2 + 2);
                    int bitVal = Integer.parseInt(bit, 16);
                    dataNum += bitVal;
                    if ((bitVal += CodeUtils.codeArr[(frameNum + 2 + i) % 256]) > 255) {
                        bitVal -= 256;
                    }
                    if ((bitData = Integer.toHexString(bitVal)).length() % 2 != 0) {
                        data.append("0" + bitData);
                        continue;
                    }
                    data.append(bitData);
                }
            }
            if ((length = Integer.toHexString((cmd.length() + assembleDataLength) / 2)).length() % 2 != 0) {
                length = "0" + length;
            }
            String verify = Integer.toHexString(frameNum + cmdNum + dataNum);
            verify = verify.substring(verify.length() - 2, verify.length());
            String cmdData = "02" + length + frame + cmd + data.toString() + verify + "03";
            cmdData = CodeUtils.encode(cmdData);
            response = Response.success(cmdData);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (StringUtils.isNotBlank((CharSequence)message) && message.contains("-")) {
                String[] split = message.split("-");
                response = Response.fail(split[0], split[1]);
            }
            response = Response.fail("101", message);
        }
        return JSON.toJSONString((Object)response);
    }

    @Override
    public String parseCheck(String data) throws Exception {
        String decode = CodeUtils.decode(data.trim());
        return CodeUtils.checkData(decode);
    }

    @Override
    public String paese() {
        Response response = null;
        try {
            this.cmdData = this.parseCheck(this.cmdData);
            String lengthStr = this.cmdData.substring(0, 2);
            String frameStr = this.cmdData.substring(2, 4);
            String cmdStr = this.cmdData.substring(4, 6);
            String dataStr = this.cmdData.substring(6, this.cmdData.length() - 2);
            String verifyStr = this.cmdData.substring(this.cmdData.length() - 2, this.cmdData.length());
            int cLength = (cmdStr.length() + dataStr.length()) / 2;
            if (Integer.parseInt(lengthStr, 16) != cLength) {
                throw new Exception("105-\u6570\u636e\u5305\u957f\u5ea6\u68c0\u67e5\u9519\u8bef");
            }
            int frame = Integer.parseInt(frameStr, 16);
            int cmdVal = Integer.parseInt(cmdStr, 16) - CodeUtils.codeArr[(frame + 1) % 256];
            if (cmdVal < 0) {
                cmdVal += 256;
            }
            String cmd = ByteUtils.hex2Ascii(Integer.toHexString(cmdVal)).toUpperCase();
            int dataVal = 0;
            String data = "";
            if (StringUtils.isNotBlank((CharSequence)dataStr)) {
                for (int i = 0; i < dataStr.length() / 2; ++i) {
                    String bit = dataStr.substring(i * 2, i * 2 + 2);
                    int bitVal = Integer.parseInt(bit, 16) - CodeUtils.codeArr[(frame + 2 + i) % 256];
                    if (bitVal < 0) {
                        bitVal += 256;
                    }
                    dataVal += bitVal;
                    String bitData = Integer.toHexString(bitVal);
                    data = bitData.length() % 2 != 0 ? data + "0" + bitData : data + bitData;
                }
            }
            String cVerify = Integer.toHexString(frame + cmdVal + dataVal);
            if (!(cVerify = cVerify.substring(cVerify.length() - 2, cVerify.length())).equalsIgnoreCase(verifyStr)) {
                throw new Exception("106-\u6821\u9a8c\u7801\u65e0\u6548");
            }
            Parse parse = new Parse(Integer.parseInt(lengthStr, 16), cmd, data);
            Agreement agreement = null;
            switch (parse.getYcmd().toUpperCase()) {
                case "B": {
                    agreement = new B();
                    break;
                }
                case "C": {
                    agreement = new C();
                    break;
                }
                case "D": {
                    agreement = new D();
                    break;
                }
                case "G": {
                    agreement = new G();
                    break;
                }
                default: {
                    agreement = new Agreement();
                }
            }
            ParseData parseData = agreement.parseData(parse);
            String ret = "";
            if (parseData != null) {
                ret = parseData.getCmd() + "&&" + parseData.getData();
            }
            response = Response.success(ret);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message.contains("-")) {
                String[] split = message.split("-");
                response = Response.fail(split[0], split[1]);
            }
            response = Response.fail("101", message);
        }
        return JSON.toJSONString((Object)response);
    }

    @Override
    public ParseData parseData(Parse parse) throws Exception {
        return new ParseData(parse.getYcmd(), ByteUtils.hex2Ascii(parse.getYdata()));
    }

    @Override
    public List<String> split(String responseStr) {
        if (StringUtils.isNotBlank((CharSequence)responseStr)) {
            if ((responseStr = responseStr.toUpperCase()).contains("8B9C")) {
                ArrayList<String> responseStrs = new ArrayList<String>();
                String[] split = responseStr.split("8B9C");
                for (int i = 0; i < split.length; ++i) {
                    if (i == 0) {
                        responseStrs.add(split[i] + "8B");
                        continue;
                    }
                    if (i == split.length - 1) {
                        responseStrs.add("9C" + split[i]);
                        continue;
                    }
                    responseStrs.add("9C" + split[i] + "8B");
                }
                return responseStrs;
            }
            return Arrays.asList(responseStr);
        }
        return null;
    }
}

