/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.call.service.impl;

import com.alibaba.fastjson.JSON;
import com.jhscale.meter.call.agreement.Agreement;
import com.jhscale.meter.call.entity.Request;
import com.jhscale.meter.call.entity.Response;
import com.jhscale.meter.call.link.CallMessenger;
import com.jhscale.meter.call.link.ICallBack;
import com.jhscale.meter.call.link.UpgradeParam;
import com.jhscale.meter.call.model.BCCache;
import com.jhscale.meter.call.service.IPort;
import com.jhscale.meter.call.service.IWeight;
import com.jhscale.meter.em.WeighingMode;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.entity.ScheduleState;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class BCPort
implements IPort,
IWeight {
    private Request request;
    private String cmd;
    private UpgradeParam param = new UpgradeParam();
    private CallMessenger messenger;
    private static final String VERSION_CHECK = "55555555555555555555555555555555";

    public BCPort() {
    }

    public BCPort(Request request) {
        this.request = request;
    }

    public BCPort(String cmd) {
        this.cmd = cmd;
    }

    @Override
    public String assemble() {
        Agreement port = new Agreement(this.request);
        return port.assemble();
    }

    @Override
    public String paese() {
        Agreement port = new Agreement(this.cmd);
        return port.paese();
    }

    @Override
    public List<String> split(String responseStr) {
        return new Agreement().split(responseStr);
    }

    @Override
    public String assemble(Request request) {
        return new Agreement(request).assemble();
    }

    @Override
    public String parse(String cmd) {
        return new Agreement(cmd).paese();
    }

    @Override
    public String setModel(WeighingMode weighingMode) {
        return new Agreement(new Request("A", weighingMode.getVal())).assemble();
    }

    @Override
    public String setZero() {
        return new Agreement(new Request("B")).assemble();
    }

    @Override
    public String setPeeling() {
        return new Agreement(new Request("C")).assemble();
    }

    @Override
    public String setPeeling(String weight) {
        return new Agreement(new Request("I", weight)).assemble();
    }

    @Override
    public String powerOff() {
        return new Agreement(new Request("H")).assemble();
    }

    @Override
    public String readWeight() {
        return new Agreement(new Request("C")).assemble();
    }

    @Override
    public String parseResponse(String responseStr) {
        return new Agreement(responseStr).paese();
    }

    @Override
    public String readWeight(String cmd) {
        return new Agreement(cmd).paese();
    }

    @Override
    public String readMac() {
        return new Agreement(new Request("B")).assemble();
    }

    @Override
    public String readVersion() {
        return new Agreement(new Request("G")).assemble();
    }

    @Override
    public UpgradeParam getUpgradeParam() {
        return this.param;
    }

    @Override
    public void setUpgradeParam(UpgradeParam param) {
        this.param = param;
    }

    @Override
    public void shake(CallMessenger callMessenger, ICallBack callBack) throws MeterException {
        if (callMessenger == null || callBack == null) {
            throw new MeterException(MeterStateEnum.\u5347\u7ea7\u63e1\u624b\u5931\u8d25);
        }
        BCCache.getInstance().clearCache();
        ICallBack iCallBack = new ICallBack(){

            @Override
            public void response(Response response) {
                BCCache.getInstance().addCache(response.hexToStr());
            }

            @Override
            public void schedule(ScheduleState scheduleState) {
            }
        };
        int count = 0;
        while (count <= this.param.getShakeTryCount()) {
            String version;
            String[] split = BCCache.getInstance().getCache().split("\r\n");
            if (split != null && split.length >= 2 && (version = split[split.length - 2]).startsWith("U")) {
                this.messenger = callMessenger;
                if (callBack != null) {
                    callBack.response(Response.success(version));
                }
                return;
            }
            callMessenger.sendCmd(VERSION_CHECK, iCallBack);
            try {
                Thread.sleep(this.param.getShakeSleep());
                ++count;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        throw new MeterException(MeterStateEnum.\u5347\u7ea7\u63e1\u624b\u8d85\u65f6);
    }

    @Override
    public void upgrade(File file, ICallBack callBack) throws MeterException {
        long start = System.currentTimeMillis();
        byte[] bytes = FileUtils.upgradeBytes(FileUtils.fileToBytes(file));
        System.out.println(String.format("\u6587\u4ef6\u8f6c\u6362\u8017\u65f6\uff1a%s", System.currentTimeMillis() - start));
        this.upgrade(bytes, callBack);
    }

    @Override
    public void upgrade(InputStream inputStream, ICallBack callBack) throws MeterException {
        byte[] bytes = FileUtils.upgradeBytes(FileUtils.inputStreamToBytes(inputStream));
        this.upgrade(bytes, callBack);
    }

    private void upgrade(byte[] bytes, ICallBack callBack) throws MeterException {
        if (this.messenger == null) {
            throw new MeterException(MeterStateEnum.\u672a\u5b8c\u6210\u5347\u7ea7\u63e1\u624b);
        }
        System.out.println("Upgrade Starting......");
        int size = this.param.getSize();
        int length = bytes.length % size == 0 ? bytes.length / size : bytes.length / size + 1;
        ICallBack iCallBack = new ICallBack(){

            @Override
            public void response(Response response) {
                System.out.println("\u5347\u7ea7\u54cd\u5e94\u6536\u53d6\uff1a" + JSON.toJSONString((Object)response));
            }

            @Override
            public void schedule(ScheduleState scheduleState) {
            }
        };
        for (int i = 0; i < length; ++i) {
            int start = i * this.param.getSize();
            int end = (i + 1) * this.param.getSize();
            end = end > bytes.length ? bytes.length : end;
            String sendMsg = ByteUtils.toHexString(Arrays.copyOfRange(bytes, start, end));
            this.messenger.sendCmd(sendMsg, iCallBack);
            if (callBack != null && i % 256 == 0) {
                callBack.schedule(new ScheduleState(i + 1, length));
            }
            try {
                if (this.param.getShakeSleep() <= 0L) continue;
                Thread.sleep(this.param.getUpgradeSleep());
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Upgrade Ending......");
        if (callBack != null) {
            callBack.response(Response.success("SUCCESS"));
        }
    }
}

