/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.em;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum PayCode {
    ALI_PAY(1),
    WECHAT_PAY(2),
    CASH_PAY(3),
    JK_PAY(4),
    ORTHER_PAY(5),
    WECHAT_OA_PAY(6),
    UNION_T_PAY(7),
    UNION_PAY(70),
    JH_PAY(71),
    YZ_PAY(72),
    QQ_PAY(8),
    TOTAL_PAY(10),
    UNKNOWN(9999);

    private int type;

    private PayCode(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String toString() {
        return String.valueOf(this.type);
    }

    public static PayCode type(Integer type) {
        if (Objects.nonNull(type)) {
            for (PayCode payCode : PayCode.values()) {
                if (!payCode.getType().equals(type)) continue;
                return payCode;
            }
        }
        return null;
    }

    public static PayCode type(String type) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            for (PayCode payCode : PayCode.values()) {
                if (!payCode.getType().toString().equals(type)) continue;
                return payCode;
            }
        }
        return null;
    }
}

