/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.entity;

import com.jhscale.common.annotation.FieldName;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.entity.item.CAItem;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.em.Font;
import com.jhscale.meter.protocol.print.em.Grid;
import com.jhscale.meter.protocol.print.entity.para.CuttingPosition;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.protocol.print.entity.para.PrintPara;
import com.jhscale.meter.protocol.print.entity.para.StringPara;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class DeviceReport
extends JSONModel {
    private String storeName;
    private String deviceName;
    private String suffix;
    private String date;
    private Integer money;
    private Integer weight;

    public DeviceReport() {
    }

    public DeviceReport(String suffix) {
        this.suffix = suffix;
    }

    public abstract List<Para> innerPara(Integer var1, Integer var2) throws MeterException;

    public List<Para> topPara() throws MeterException {
        return Arrays.asList(((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)new StringPara().set_Font(Font.FONT1)).set_Grid(Grid.Defaul_Grid)).setStartX(0)).setStartY(0)).setOffsetX(384)).setOffsetY(0)).set_Content(String.format("%s%s%s", this.getStoreName(), this.getDeviceName(), this.getSuffix())), new PrintPara());
    }

    public List<Para> datePara() throws MeterException {
        return Arrays.asList(((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)new StringPara().set_Font(Font.FONT1)).set_Grid(Grid.Middle_Right_Grid)).setStartX(0)).setStartY(8)).setOffsetX(384)).setOffsetY(0)).set_Content(String.format("%s\uff1a%s", PrintGeneralFactory.getInstance().dict("\u65e5\u671f"), this.getDate())), new PrintPara());
    }

    public List<Para> splitPara() throws MeterException {
        return Arrays.asList(((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)new StringPara().set_Font(Font.FONT1)).set_Grid(Grid.Middle_Left_Grid)).setStartX(0)).setStartY(8)).setOffsetX(0)).setOffsetY(0)).set_Content("------------------------------------"), new PrintPara());
    }

    public List<Para> titlePara(String title) throws MeterException {
        return Arrays.asList(((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)new StringPara().set_Font(Font.FONT1)).set_Grid(Grid.Middle_Left_Grid)).setStartX(0)).setStartY(8)).setOffsetX(0)).setOffsetY(0)).set_Content(title), new PrintPara());
    }

    public Para textPara(String text) throws MeterException {
        return ((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)new StringPara().set_Font(Font.FONT1)).set_Grid(Grid.Middle_Left_Grid)).setStartX(25)).setStartY(8)).setOffsetX(0)).setOffsetY(0)).set_Content(text);
    }

    public List<Para> cuttingPara() throws MeterException {
        return Arrays.asList(((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)new StringPara().set_Font(Font.FONT1)).set_Grid(Grid.Defaul_Grid)).setStartX(0)).setStartY(0)).setOffsetX(384)).setOffsetY(0)).set_Content(PrintGeneralFactory.getInstance().dict("\u5b8c")), new PrintPara(), new CuttingPosition());
    }

    protected List<Para> fieldPara(Integer money) throws MeterException {
        ArrayList<Para> paras = new ArrayList<Para>();
        Field[] fields = ((Object)((Object)this)).getClass().getDeclaredFields();
        if (fields.length > 0) {
            List<Field> fieldList = Arrays.asList(fields);
            Collections.sort(fieldList, new Comparator<Field>(){

                @Override
                public int compare(Field o1, Field o2) {
                    FieldName fo1 = o1.getAnnotation(FieldName.class);
                    FieldName fo2 = o2.getAnnotation(FieldName.class);
                    int fov1 = Objects.nonNull(fo1) ? fo1.sort() : 9999;
                    int fov2 = Objects.nonNull(fo2) ? fo2.sort() : 9999;
                    return fov1 > fov2 ? 1 : -1;
                }
            });
            for (Field field : fieldList) {
                try {
                    FieldName annotation;
                    field.setAccessible(true);
                    CAItem item = (CAItem)((Object)field.get((Object)this));
                    if (item == null || !item.checkPara() || (annotation = field.getAnnotation(FieldName.class)) == null) continue;
                    if (annotation.title()) {
                        paras.addAll(this.titlePara(PrintGeneralFactory.getInstance().dict(annotation.name())));
                        paras.addAll(item.para(false, PrintGeneralFactory.getInstance().dict("\u7d2f\u8ba1\u989d/\u7b14\u6570"), money));
                        continue;
                    }
                    paras.addAll(item.para(true, PrintGeneralFactory.getInstance().dict(annotation.name()) + PrintGeneralFactory.getInstance().dict("\u7d2f\u8ba1\u989d/\u7b14\u6570"), money));
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        return paras;
    }

    public String getStoreName() {
        return StringUtils.isNotBlank((CharSequence)this.storeName) ? this.storeName + "-" : "";
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getDeviceName() {
        return StringUtils.isNotBlank((CharSequence)this.deviceName) ? this.deviceName + "-" : "";
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getSuffix() {
        return StringUtils.isNotBlank((CharSequence)this.suffix) ? this.suffix : "";
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getDate() {
        return StringUtils.isNotBlank((CharSequence)this.date) ? this.date : "";
    }

    public void setDate(String date) {
        this.date = date;
    }

    public Integer getMoney() {
        return this.money;
    }

    public void setMoney(Integer money) {
        this.money = money;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }
}

