/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.entity;

import com.jhscale.common.ysscale.UnitEnum;
import com.jhscale.meter.entity.DeviceReport;
import com.jhscale.meter.entity.item.PLUItem;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.em.Font;
import com.jhscale.meter.protocol.print.em.Grid;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.protocol.print.entity.para.PrintPara;
import com.jhscale.meter.protocol.print.entity.para.StringPara;
import com.jhscale.meter.utils.BigDecimalUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PLUReport
extends DeviceReport {
    private List<PLUItem> items;

    public PLUReport() {
        super(PrintGeneralFactory.getInstance().dict("PLU\u62a5\u8868"));
    }

    public PLUReport(List<PLUItem> items) {
        this();
        this.items = items;
    }

    @Override
    public List<Para> innerPara(Integer money, Integer weight) throws MeterException {
        this.sort();
        ArrayList<Para> paras = new ArrayList<Para>();
        for (PLUItem item : this.items) {
            Object left = ((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)new StringPara().set_Font(Font.FONT1)).set_Grid(Grid.Middle_Left_Grid)).setStartX(0)).setStartY(6)).setOffsetX(0)).setOffsetY(0)).set_Content(String.format("%s:%s", Objects.nonNull(item.getPluNo()) ? item.getPluNo() : " ", item.getPluName()));
            Object right = ((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)((StringPara)new StringPara().set_Font(Font.FONT1)).set_Grid(Grid.Middle_Right_Grid)).setStartX(0)).setStartY(6)).setOffsetX(384)).setOffsetY(0)).set_Content(String.format("%s%s %s%s%s", UnitEnum.\u8ba1\u4ef6.equals((Object)item.unit()) ? BigDecimalUtils.bigDecimalToString(item.getAmount(), null, 0) : BigDecimalUtils.bigDecimalToString(item.getAmount(), weight, 3), Objects.nonNull(item.unit()) ? item.unit().getName() : " su ", GlobalPara.getInstance().getTMT(2, "\u00a5"), BigDecimalUtils.bigDecimalToString(item.getSingleMeter(), money), GlobalPara.getInstance().getTMT(3, "\u5143")));
            paras.add((Para)left);
            paras.add((Para)right);
            paras.add(new PrintPara());
        }
        return paras;
    }

    public void sort() {
        if (this.items != null) {
            Collections.sort(this.items);
        }
    }

    public List<PLUItem> getItems() {
        return this.items;
    }

    public void setItems(List<PLUItem> items) {
        this.items = items;
    }
}

