/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.entity.item;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DoubleToBigDecimal;
import com.jhscale.common.annotation.FieldName;
import com.jhscale.meter.entity.item.CAItem;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.utils.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ScaleItem
extends CAItem {
    @FieldName(group=0, sort=3, jsl="", name="\u7a0e\u989d")
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=DoubleToBigDecimal.class)
    private BigDecimal cesse;
    @FieldName(group=0, sort=4, jsl="", name="\u7a0e\u7387")
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=DoubleToBigDecimal.class)
    private BigDecimal cost;
    @FieldName(group=0, sort=5, jsl="", name="\u670d\u52a1\u8d39")
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=DoubleToBigDecimal.class)
    private BigDecimal serviceCharge;

    public ScaleItem() {
    }

    public ScaleItem(BigDecimal amount, Integer count, BigDecimal cesse, BigDecimal cost, BigDecimal serviceCharge) {
        super(amount, count);
        this.cesse = cesse;
        this.cost = cost;
        this.serviceCharge = serviceCharge;
    }

    @Override
    public boolean checkPara() {
        return super.checkPara() || Objects.nonNull(this.cesse) && this.cesse.compareTo(new BigDecimal(0)) == 1 || Objects.nonNull(this.cost) && this.cost.compareTo(new BigDecimal(0)) == 1 || Objects.nonNull(this.serviceCharge) && this.serviceCharge.compareTo(new BigDecimal(0)) == 1;
    }

    @Override
    public List<Para> para(boolean title, String text, Integer money) throws MeterException {
        List<Para> para = super.para(title, text, money);
        if (para != null) {
            if (Objects.nonNull(this.cesse) && this.cesse.compareTo(new BigDecimal(0)) == 1) {
                if (para == null) {
                    para = new ArrayList<Para>();
                }
                para.addAll(this.line(title, "\u7a0e\u989d", BigDecimalUtils.bigDecimalToString(this.cesse, money)));
            }
            if (Objects.nonNull(this.cost) && this.cost.compareTo(new BigDecimal(0)) == 1) {
                if (para == null) {
                    para = new ArrayList<Para>();
                }
                para.addAll(this.line(title, "\u7a0e\u7387", BigDecimalUtils.bigDecimalToString(this.cost, money)));
            }
            if (Objects.nonNull(this.serviceCharge) && this.serviceCharge.compareTo(new BigDecimal(0)) == 1) {
                if (para == null) {
                    para = new ArrayList<Para>();
                }
                para.addAll(this.line(title, "\u670d\u52a1\u8d39", BigDecimalUtils.bigDecimalToString(this.serviceCharge, money)));
            }
        }
        return para;
    }

    public BigDecimal getCesse() {
        return this.cesse;
    }

    public void setCesse(BigDecimal cesse) {
        this.cesse = cesse;
    }

    public BigDecimal getCost() {
        return this.cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    public BigDecimal getServiceCharge() {
        return this.serviceCharge;
    }

    public void setServiceCharge(BigDecimal serviceCharge) {
        this.serviceCharge = serviceCharge;
    }
}

