/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.entity.server;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DoubleToBigDecimal;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.entity.CPReport;
import com.jhscale.meter.entity.item.CAItem;
import com.jhscale.meter.entity.server.ServerReport;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CPServerReport
extends ServerReport {
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=DoubleToBigDecimal.class)
    private BigDecimal alipay;
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=DoubleToBigDecimal.class)
    private BigDecimal alipayActual;
    private Integer alipayCount;
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=DoubleToBigDecimal.class)
    private BigDecimal weixin;
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=DoubleToBigDecimal.class)
    private BigDecimal weixinActual;
    private Integer weixinCount;
    private List<BillSpecial> billSpecial;

    public CPReport toReport() {
        CPReport report = new CPReport();
        report.setAliPay(new CAItem(this.alipay, this.alipayCount));
        report.setWechat(new CAItem(this.weixin, this.getAlipayCount()));
        if (this.billSpecial != null && !this.billSpecial.isEmpty()) {
            for (BillSpecial special : this.billSpecial) {
                if (!StringUtils.isNotBlank((CharSequence)special.getPayWay())) continue;
                switch (special.getPayWay()) {
                    case "70": {
                        report.setUnion(new CAItem(special.getTotal(), special.getTotalCount()));
                        break;
                    }
                    case "71": {
                        report.setJh(new CAItem(special.getTotal(), special.getTotalCount()));
                        break;
                    }
                    case "72": {
                        report.setYz(new CAItem(special.getTotal(), special.getTotalCount()));
                    }
                }
            }
        }
        return report;
    }

    public BigDecimal getAlipay() {
        return this.alipay;
    }

    public void setAlipay(BigDecimal alipay) {
        this.alipay = alipay;
    }

    public BigDecimal getAlipayActual() {
        return this.alipayActual;
    }

    public void setAlipayActual(BigDecimal alipayActual) {
        this.alipayActual = alipayActual;
    }

    public Integer getAlipayCount() {
        return this.alipayCount;
    }

    public void setAlipayCount(Integer alipayCount) {
        this.alipayCount = alipayCount;
    }

    public BigDecimal getWeixin() {
        return this.weixin;
    }

    public void setWeixin(BigDecimal weixin) {
        this.weixin = weixin;
    }

    public BigDecimal getWeixinActual() {
        return this.weixinActual;
    }

    public void setWeixinActual(BigDecimal weixinActual) {
        this.weixinActual = weixinActual;
    }

    public Integer getWeixinCount() {
        return this.weixinCount;
    }

    public void setWeixinCount(Integer weixinCount) {
        this.weixinCount = weixinCount;
    }

    public List<BillSpecial> getBillSpecial() {
        return this.billSpecial;
    }

    public void setBillSpecial(List<BillSpecial> billSpecial) {
        this.billSpecial = billSpecial;
    }

    public static class BillSpecial
    extends JSONModel {
        private String payWay;
        @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=DoubleToBigDecimal.class)
        private BigDecimal total;
        @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=DoubleToBigDecimal.class)
        private BigDecimal totalActual;
        private Integer totalCount;

        public String getPayWay() {
            return this.payWay;
        }

        public void setPayWay(String payWay) {
            this.payWay = payWay;
        }

        public BigDecimal getTotal() {
            return this.total;
        }

        public void setTotal(BigDecimal total) {
            this.total = total;
        }

        public BigDecimal getTotalActual() {
            return this.totalActual;
        }

        public void setTotalActual(BigDecimal totalActual) {
            this.totalActual = totalActual;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }
    }
}

