/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.entity.server;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.StringToBigDecimal;
import com.jhscale.common.em.PayWay;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.GJSONUtils;
import com.jhscale.meter.entity.server.order.Address;
import com.jhscale.meter.entity.server.order.DistributorNote;
import com.jhscale.meter.entity.server.order.MerchantNote;
import com.jhscale.meter.entity.server.order.OrderNoteDetail;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.print.line.PrintLine;
import com.jhscale.meter.protocol.print.line.PrintLineBC;
import com.jhscale.meter.protocol.print.line.PrintLineBP;
import com.jhscale.meter.protocol.print.line.PrintLineLMR;
import com.jhscale.meter.protocol.print.line.PrintLineN;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ZXDOrder
extends JSONModel {
    @ApiModelProperty(value="\u6253\u5370\u4f4d\u56fe", name="bitmap")
    private Integer bitmap;
    @ApiModelProperty(value="\u8ba2\u5355\u7f16\u53f7", name="orderNo")
    private String orderNo;
    @ApiModelProperty(value="\u8ba2\u5355\u6807\u9898", name="title")
    private String title;
    @ApiModelProperty(value="\u65e5\u7ed3\u7f16\u53f7", name="dailyNo")
    private String dailyNo;
    @ApiModelProperty(value="\u9001\u8fbe\u53d6\u5355\u65f6\u95f4", name="arriveTime")
    private Date arriveTime;
    @ApiModelProperty(value="\u914d\u9001\u65b9\u5f0f 0-\u914d\u9001 1-\u81ea\u63d0", name="delivery")
    private Integer delivery;
    @ApiModelProperty(value="\u6536\u8d27\u5730\u5740\u4fe1\u606f", name="address")
    private String address;
    @ApiModelProperty(value="\u6d88\u8d39\u8005\u5907\u6ce8", name="customerRemark")
    private String customerRemark;
    @ApiModelProperty(value="\u751f\u4ea7\u8005\u5907\u6ce8", name="producerRemark")
    private String producerRemark;
    @ApiModelProperty(value="\u660e\u7ec6\u6570\u91cf", name="count")
    private Integer count;
    @ApiModelProperty(value="\u8ba2\u5355\u6298\u6263\u540e\u91d1\u989d\uff08\u53ea\u9488\u5bf9 \u8ba2\u5355\u539f\u59cb\u91d1\u989d \u6253\u6298\uff09", name="originalGoodsMoney")
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=StringToBigDecimal.class)
    private BigDecimal originalGoodsMoney;
    @ApiModelProperty(value="\u8ba2\u5355\u6700\u7ec8\u4ef7\u683c", name="finalGoodsMoney")
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=StringToBigDecimal.class)
    private BigDecimal finalGoodsMoney;
    @ApiModelProperty(value="\u6253\u5305\u539f\u59cb\u91d1\u989d\uff08\u6253\u5305\u8d39 \u4e0d\u53c2\u4e0e\u6298\u6263\u7b49\u4f18\u60e0\uff09", name="originalPackMoney")
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=StringToBigDecimal.class)
    private BigDecimal originalPackMoney;
    @ApiModelProperty(value="\u6253\u5305\u6700\u7ec8\u91d1\u989d", name="finalPackMoney")
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=StringToBigDecimal.class)
    private BigDecimal finalPackMoney;
    @ApiModelProperty(value="\u670d\u52a1\u8d39\u91d1\u989d \uff08\u670d\u52a1\u8d39 \u4e0d\u53c2\u4e0e\u6298\u6263\u7b49\u4f18\u60e0\uff09", name="originalServiceMoney")
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=StringToBigDecimal.class)
    private BigDecimal originalServiceMoney;
    @ApiModelProperty(value="\u670d\u52a1\u6700\u7ec8\u91d1\u989d", name="finalServiceMoney")
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=StringToBigDecimal.class)
    private BigDecimal finalServiceMoney;
    @ApiModelProperty(value="\u8ba2\u5355\u91d1\u989d", name="finalMoney")
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=StringToBigDecimal.class)
    private BigDecimal finalMoney;
    @ApiModelProperty(value="\u652f\u4ed8\u7c7b\u578b(Binary 0000 0000) 128-\u4f1a\u5458\u652f\u4ed8 64-\u4e09\u65b9\u652f\u4ed8 192-\u4f1a\u5458+\u4e09\u65b9\u7ec4\u5408\u652f\u4ed8", name="paymentType")
    private Integer paymentType;
    @ApiModelProperty(value="\u4e09\u65b9\u652f\u4ed8\u6e20\u9053", name="vpsChannel")
    private Integer vpsChannel;
    @ApiModelProperty(value="\u652f\u4ed8\u5907\u6ce8", name="paymentRemark")
    private String paymentRemark;
    @ApiModelProperty(value="\u652f\u4ed8\u65f6\u95f4", name="paymentTime")
    private Date paymentTime;
    @ApiModelProperty(value="\u8865\u5dee\u91d1\u989d", name="subsidyMoney")
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=StringToBigDecimal.class)
    private BigDecimal subsidyMoney;
    @ApiModelProperty(value="\u8ba2\u5355\u5185\u5bb9\u4fe1\u606f", name="orderDetail")
    private String orderDetail;

    public Integer bitmap() {
        return Objects.nonNull(this.bitmap) ? this.bitmap : 1;
    }

    public String customerRemark() {
        return StringUtils.isNotBlank((CharSequence)this.customerRemark) ? this.customerRemark : "";
    }

    public String producerRemark() {
        return StringUtils.isNotBlank((CharSequence)this.producerRemark) ? this.producerRemark : "";
    }

    public Address address() {
        return (Address)GJSONUtils.jsonToObject((String)this.address, Address.class);
    }

    public MerchantNote merchantNote() {
        return (MerchantNote)GJSONUtils.jsonToObject((String)this.orderDetail, MerchantNote.class);
    }

    public DistributorNote distributorNote() {
        return (DistributorNote)GJSONUtils.jsonToObject((String)this.orderDetail, DistributorNote.class);
    }

    public String finalGoodsMoney() {
        return GlobalPara.getInstance().Cal_Item(this.finalGoodsMoney).toString();
    }

    public String finalPackMoney() {
        return GlobalPara.getInstance().Cal_Item(this.finalPackMoney).toString();
    }

    public String finalMoney() {
        return GlobalPara.getInstance().Cal_Item(this.finalMoney).toString();
    }

    public String paymentType() {
        String paymentType = "";
        if (Objects.nonNull(this.paymentType)) {
            paymentType = this.paymentType == 128 ? paymentType + "\u4f1a\u5458\u652f\u4ed8" : (this.paymentType == 64 ? paymentType + PayWay.orderPay((Integer)this.vpsChannel).getDescription() : (this.paymentType == 192 ? paymentType + "\u4f1a\u5458\u652f\u4ed8" + PayWay.orderPay((Integer)this.vpsChannel).getDescription() : paymentType + this.paymentType + "\u652f\u4ed8"));
        }
        return paymentType;
    }

    public List<PrintLine> toDistributorPrintLine() {
        Address address = this.address();
        DistributorNote distributorNote = this.distributorNote();
        ArrayList<PrintLine> lines = new ArrayList<PrintLine>();
        lines.add(new PrintLineBP(this.bitmap()));
        lines.add(new PrintLineN().setContent(String.format("\u9884\u7ea6\u65f6\u95f4\uff1a%s", DateUtils.getDate_YYYY_MM_DD_HH_MM_SS((Date)this.getArriveTime()))).setFont(1));
        lines.add(new PrintLineN().setContent(String.format("%s %s", address.getName(), address.phone())).setFont(5));
        String addressStr = address.address();
        if (StringUtils.isNotBlank((CharSequence)addressStr)) {
            lines.add(new PrintLineN().setContent(String.format("\u5730\u5740: %s", addressStr)).setFont(4));
        } else if (this.delivery == 1) {
            lines.add(new PrintLineN().setContent("\u5730\u5740: \u5ba2\u6237\u81ea\u53d6").setFont(4));
        }
        lines.add(PrintLineN.separator(4));
        lines.add(new PrintLineLMR().setMid(this.getDailyNo()).setFont(7));
        if (StringUtils.isNotBlank((CharSequence)this.getCustomerRemark())) {
            lines.add(new PrintLineN().setContent(String.format("\u987e\u5ba2\u5907\u6ce8\uff1a%s", this.customerRemark())).setFont(4));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getProducerRemark())) {
            lines.add(new PrintLineN().setContent(String.format("\u5546\u5bb6\u5907\u6ce8\uff1a%s", this.getProducerRemark())).setFont(4));
        }
        lines.add(PrintLineN.separator(4));
        lines.add(new PrintLineLMR().setLeft("\u5e97\u94fa").setFont(1));
        lines.add(new PrintLineLMR().setLeft("\u54c1\u540d").setMid("\u6570\u91cd\u91cf").setRight("\u5c0f\u8ba1").setFont(1));
        lines.add(PrintLineN.separator(1));
        for (int i = 0; i < distributorNote.getMerchantNotes().size(); ++i) {
            MerchantNote merchantNote = distributorNote.getMerchantNotes().get(i);
            lines.add(new PrintLineN().setContent(String.format("%s[%s\u4ef6]", merchantNote.getMallStoreOverall().getName(), merchantNote.getNoteDetails().size())).setFont(1));
            lines.add(PrintLineN.separator(1));
            for (OrderNoteDetail detail : merchantNote.getNoteDetails()) {
                lines.add(new PrintLineLMR().setLeft(detail.getGoodsName()).setMid(detail.amount()).setRight(detail.item()).setFont(1));
            }
            if (i == distributorNote.getMerchantNotes().size() - 1) continue;
            lines.add(PrintLineN.separator(1));
        }
        lines.add(PrintLineN.separator(1));
        lines.add(new PrintLineLMR().setRight(String.format("\u5171\u8ba1(%s)\u4ef6", this.getCount())).setFont(4));
        lines.add(new PrintLineN());
        lines.add(new PrintLineLMR().setLeft("\u5546\u54c1\u603b\u989d").setRight(this.finalGoodsMoney()).setFont(1));
        if (Objects.nonNull(this.finalPackMoney) && this.finalPackMoney.compareTo(BigDecimal.ZERO) > 0) {
            lines.add(new PrintLineLMR().setLeft("\u6253\u5305\u603b\u989d").setRight(this.finalPackMoney()).setFont(1));
        }
        lines.add(new PrintLineLMR().setLeft("\u5546\u54c1\u603b\u8ba1").setRight(this.finalMoney()).setFont(1));
        lines.add(new PrintLineLMR().setLeft("\u652f\u4ed8\u65b9\u5f0f").setRight(this.paymentType()).setFont(1));
        lines.add(new PrintLineLMR().setLeft("\u652f\u4ed8\u65f6\u95f4").setRight(DateUtils.getDate_YYYY_MM_DD_HH_MM_SS((Date)this.getPaymentTime())).setFont(1));
        lines.add(PrintLineN.separator(4));
        List<String> text = GlobalPara.getInstance().Mall_Text();
        if (!text.isEmpty()) {
            if (text.size() == 1) {
                lines.add(new PrintLineLMR().setMid(text.get(0)).setFont(1));
            } else {
                for (String t : text) {
                    lines.add(new PrintLineN().setContent(t).setFont(1));
                }
            }
        }
        lines.add(new PrintLineBC().setContent(this.orderNo));
        lines.add(new PrintLineLMR().setMid(this.orderNo));
        return lines;
    }

    public List<PrintLine> toMerchantPrintLine() {
        Address address = this.address();
        MerchantNote merchantNote = this.merchantNote();
        ArrayList<PrintLine> lines = new ArrayList<PrintLine>();
        lines.add(new PrintLineBP(this.bitmap()));
        lines.add(new PrintLineN().setContent(String.format("\u9884\u7ea6\u65f6\u95f4\uff1a%s", DateUtils.getDate_YYYY_MM_DD_HH_MM_SS((Date)this.getArriveTime()))).setFont(1));
        lines.add(new PrintLineN().setContent(String.format("%s %s", address.getName(), address.phone())).setFont(5));
        String addressStr = address.address();
        if (StringUtils.isNotBlank((CharSequence)addressStr)) {
            lines.add(new PrintLineN().setContent(String.format("\u5730\u5740: %s", addressStr)).setFont(4));
        } else if (this.delivery == 1) {
            lines.add(new PrintLineN().setContent("\u5730\u5740: \u5ba2\u6237\u81ea\u53d6").setFont(4));
        }
        lines.add(PrintLineN.separator(4));
        lines.add(new PrintLineLMR().setMid(this.getDailyNo()).setFont(7));
        if (StringUtils.isNotBlank((CharSequence)this.getCustomerRemark())) {
            lines.add(new PrintLineN().setContent(String.format("\u987e\u5ba2\u5907\u6ce8\uff1a%s", this.customerRemark())).setFont(4));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getProducerRemark())) {
            lines.add(new PrintLineN().setContent(String.format("\u5546\u5bb6\u5907\u6ce8\uff1a%s", this.getProducerRemark())).setFont(4));
        }
        lines.add(PrintLineN.separator(4));
        lines.add(new PrintLineLMR().setLeft("\u54c1\u540d").setMid("\u6570\u91cd\u91cf").setRight("\u5c0f\u8ba1").setFont(1));
        lines.add(PrintLineN.separator(1));
        for (OrderNoteDetail detail : merchantNote.getNoteDetails()) {
            lines.add(new PrintLineLMR().setLeft(detail.getGoodsName()).setMid(detail.amount()).setRight(detail.item()).setFont(1));
        }
        lines.add(PrintLineN.separator(1));
        lines.add(new PrintLineLMR().setRight(String.format("\u5171\u8ba1(%s)\u4ef6", this.getCount())).setFont(4));
        lines.add(new PrintLineN());
        lines.add(new PrintLineLMR().setLeft("\u5546\u54c1\u603b\u989d").setRight(this.finalGoodsMoney()).setFont(1));
        if (Objects.nonNull(this.finalPackMoney) && this.finalPackMoney.compareTo(BigDecimal.ZERO) > 0) {
            lines.add(new PrintLineLMR().setLeft("\u6253\u5305\u603b\u989d").setRight(this.finalPackMoney()).setFont(1));
        }
        lines.add(new PrintLineLMR().setLeft("\u5546\u54c1\u603b\u8ba1").setRight(this.finalMoney()).setFont(1));
        lines.add(new PrintLineLMR().setLeft("\u652f\u4ed8\u65b9\u5f0f").setRight(this.paymentType()).setFont(1));
        lines.add(new PrintLineLMR().setLeft("\u652f\u4ed8\u65f6\u95f4").setRight(DateUtils.getDate_YYYY_MM_DD_HH_MM_SS((Date)this.getPaymentTime())).setFont(1));
        lines.add(PrintLineN.separator(4));
        List<String> text = GlobalPara.getInstance().Mall_Text();
        if (!text.isEmpty()) {
            if (text.size() == 1) {
                lines.add(new PrintLineLMR().setMid(text.get(0)).setFont(1));
            } else {
                for (String t : text) {
                    lines.add(new PrintLineN().setContent(t).setFont(1));
                }
            }
        }
        lines.add(new PrintLineBC().setContent(this.orderNo));
        lines.add(new PrintLineLMR().setMid(this.orderNo));
        return lines;
    }

    public Integer getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(Integer bitmap) {
        this.bitmap = bitmap;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDailyNo() {
        return this.dailyNo;
    }

    public void setDailyNo(String dailyNo) {
        this.dailyNo = dailyNo;
    }

    public Date getArriveTime() {
        return this.arriveTime;
    }

    public void setArriveTime(Date arriveTime) {
        this.arriveTime = arriveTime;
    }

    public Integer getDelivery() {
        return this.delivery;
    }

    public void setDelivery(Integer delivery) {
        this.delivery = delivery;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCustomerRemark() {
        return this.customerRemark;
    }

    public void setCustomerRemark(String customerRemark) {
        this.customerRemark = customerRemark;
    }

    public String getProducerRemark() {
        return this.producerRemark;
    }

    public void setProducerRemark(String producerRemark) {
        this.producerRemark = producerRemark;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public BigDecimal getOriginalGoodsMoney() {
        return this.originalGoodsMoney;
    }

    public void setOriginalGoodsMoney(BigDecimal originalGoodsMoney) {
        this.originalGoodsMoney = originalGoodsMoney;
    }

    public BigDecimal getFinalGoodsMoney() {
        return this.finalGoodsMoney;
    }

    public void setFinalGoodsMoney(BigDecimal finalGoodsMoney) {
        this.finalGoodsMoney = finalGoodsMoney;
    }

    public BigDecimal getOriginalPackMoney() {
        return this.originalPackMoney;
    }

    public void setOriginalPackMoney(BigDecimal originalPackMoney) {
        this.originalPackMoney = originalPackMoney;
    }

    public BigDecimal getFinalPackMoney() {
        return this.finalPackMoney;
    }

    public void setFinalPackMoney(BigDecimal finalPackMoney) {
        this.finalPackMoney = finalPackMoney;
    }

    public BigDecimal getOriginalServiceMoney() {
        return this.originalServiceMoney;
    }

    public void setOriginalServiceMoney(BigDecimal originalServiceMoney) {
        this.originalServiceMoney = originalServiceMoney;
    }

    public BigDecimal getFinalServiceMoney() {
        return this.finalServiceMoney;
    }

    public void setFinalServiceMoney(BigDecimal finalServiceMoney) {
        this.finalServiceMoney = finalServiceMoney;
    }

    public BigDecimal getFinalMoney() {
        return this.finalMoney;
    }

    public void setFinalMoney(BigDecimal finalMoney) {
        this.finalMoney = finalMoney;
    }

    public Integer getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    public Integer getVpsChannel() {
        return this.vpsChannel;
    }

    public void setVpsChannel(Integer vpsChannel) {
        this.vpsChannel = vpsChannel;
    }

    public String getPaymentRemark() {
        return this.paymentRemark;
    }

    public void setPaymentRemark(String paymentRemark) {
        this.paymentRemark = paymentRemark;
    }

    public Date getPaymentTime() {
        return this.paymentTime;
    }

    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }

    public BigDecimal getSubsidyMoney() {
        return this.subsidyMoney;
    }

    public void setSubsidyMoney(BigDecimal subsidyMoney) {
        this.subsidyMoney = subsidyMoney;
    }

    public String getOrderDetail() {
        return this.orderDetail;
    }

    public void setOrderDetail(String orderDetail) {
        this.orderDetail = orderDetail;
    }
}

