/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.io;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.control.ClientControl;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.DeviceDiscoverEventListener;
import com.jhscale.meter.io.listener.SocketClientEventListener;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.log.PortLogBack;
import com.jhscale.meter.model.device.Device;
import com.jhscale.meter.model.device.InitDeviceEntity;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.model.ReadResponse;
import com.jhscale.meter.utils.ByteUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;

public class PortManager<T extends Device> {
    static final int STATE_NONE = 0;
    static final int STATE_LISTEN = 1;
    static final int STATE_CONNECTING = 2;
    static final int STATE_CONNECTED = 3;
    private Integer readBytesLength = 128;
    private DeviceControl control;
    private DeviceDiscoverEventListener discoverEventListener;
    private Set<T> devices;
    private boolean discovered = false;
    private T device;
    private DeviceClientEventListener clientEventListener;
    private InputStream inputStream;
    private OutputStream outputStream;
    private long max_time_out = 10000L;
    protected Thread thread;
    private PortManager server;
    private Map<String, PortManager> clientMaps = Collections.synchronizedMap(new HashMap());
    private boolean log = false;
    private boolean logBack = false;
    private PortLogBack portLogBack;
    private boolean status;

    public PortManager() {
    }

    public PortManager(DeviceControl control, DeviceDiscoverEventListener discoverEventListener) throws MeterException {
        this.control = control;
        this.discoverEventListener = discoverEventListener;
        this.devices = new HashSet<T>();
        this.control.initDevice();
    }

    public PortManager(DeviceControl control, T device) throws MeterException {
        this.control = control;
        this.device = device;
        this.control.initDevice();
    }

    public PortManager(DeviceControl control, T device, DeviceClientEventListener clientEventListener) throws MeterException {
        this.control = control;
        this.device = device;
        this.clientEventListener = clientEventListener;
        this.control.initDevice();
    }

    public PortManager(DeviceControl control, T device, PortManager server) throws MeterException {
        this.control = control;
        this.device = device;
        this.clientEventListener = server.clientEventListener;
        this.server = server;
        this.control.initDevice();
    }

    public PortManager _this() {
        return this;
    }

    public void initPort(InitDeviceEntity entity) throws MeterException {
        this.control.initDevice();
        if (Objects.nonNull(entity)) {
            if (Objects.nonNull(entity.getStreamLength())) {
                this.readBytesLength = entity.getStreamLength();
            }
            this.control.initParam(entity);
        }
    }

    public boolean discovery() throws MeterException {
        if (this.devices == null) {
            this.devices = new HashSet<T>();
        }
        this.devices.clear();
        if (this.discoverEventListener != null) {
            this.control.addListener(this.discoverEventListener, this.devices);
        }
        this.discovered = this.control.discovery();
        return this.discovered;
    }

    public boolean cancelDiscovery(boolean clear) throws MeterException {
        if (this.control.cancelDiscovery()) {
            if (clear) {
                if (this.devices == null) {
                    this.devices = new HashSet<T>();
                }
                this.devices.clear();
            }
            this.discovered = false;
            return true;
        }
        return false;
    }

    public boolean openPort() throws MeterException {
        if (this.device == null) {
            return false;
        }
        if (this.status) {
            return true;
        }
        this.control.openPort(this.device);
        if (this.clientEventListener != null) {
            this.control.addListener(this.clientEventListener, this);
        }
        this.status = this.getInputStream() != null && this.getOutputStream() != null;
        return this.status;
    }

    public boolean openPortAddEventListenerBefore() throws MeterException {
        if (this.device == null) {
            return false;
        }
        if (this.status) {
            return true;
        }
        if (this.clientEventListener != null) {
            this.control.addListener(this.clientEventListener, this);
        }
        this.getControl().openPort(this.device);
        this.setStatus(true);
        return this.isStatus();
    }

    public PortManager log(boolean log) {
        this.log = log;
        return this;
    }

    public PortManager logBack(boolean logBack, PortLogBack portLogBack) {
        this.logBack = logBack;
        this.portLogBack = portLogBack;
        return this;
    }

    public PortManager time_out(long time_out) {
        this.max_time_out = time_out;
        return this;
    }

    public void writeDataImmediately(Vector<Byte> data) throws MeterException {
        this.writeDataImmediately(PortManager.convertVectorByteToBytes(data));
    }

    public void writeDataImmediately(byte[] bytes) throws MeterException {
        this.writeDataImmediately(bytes, 0, bytes.length);
    }

    public void writeDataImmediatelyWithoutFlush(byte[] bytes) throws MeterException {
        this.write_log(bytes);
        try {
            if (bytes.length > 0) {
                this.getOutputStream().write(bytes, 0, bytes.length);
            }
        }
        catch (IOException e) {
            JLog.error("PortManager write error\uff1a{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.\u6d41\u5199\u5165\u9519\u8bef);
        }
    }

    public void writeDataImmediatelyFlush() throws MeterException {
        try {
            this.getOutputStream().flush();
        }
        catch (IOException e) {
            JLog.error("PortManager write error\uff1a{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.\u6d41\u5199\u5165\u9519\u8bef);
        }
    }

    public byte[] sendWithAccept(byte[] request) throws MeterException {
        long start = System.currentTimeMillis();
        this.writeDataImmediately(request);
        long start1 = System.currentTimeMillis();
        byte[] response = new byte[]{};
        while (System.currentTimeMillis() - start1 <= this.max_time_out) {
            try {
                int available = this.getInputStream().available();
                if (available <= 0) continue;
                response = this.readData(available);
                break;
            }
            catch (IOException e) {
                JLog.error("PortManager write error\uff1a{}", e.getMessage(), e);
                throw new MeterException(MeterStateEnum.\u6d41\u8bfb\u53d6\u9519\u8bef);
            }
        }
        if (this.log) {
            if (response == null || response.length == 0) {
                System.out.println(String.format("Max Time Out:[%s]ms,\u672a\u63a5\u5230\u54cd\u5e94\u4fe1\u606f", this.max_time_out));
            } else {
                System.out.println(String.format("Time Total:[%s]ms\uff0cSend:[%s]ms\uff0cAccept:[%s]ms", System.currentTimeMillis() - start, start1 - start, System.currentTimeMillis() - start1));
            }
        }
        if (GlobalPara.getInstance().isRunLog()) {
            if (response == null || response.length == 0) {
                System.out.println(String.format("Max Time Out:[%s]ms,\u672a\u63a5\u5230\u54cd\u5e94\u4fe1\u606f", this.max_time_out));
            } else {
                System.out.println(String.format("Time Total:[%s]ms\uff0cSend:[%s]ms\uff0cAccept:[%s]ms", System.currentTimeMillis() - start, start1 - start, System.currentTimeMillis() - start1));
            }
        }
        return response;
    }

    public void writeDataImmediately(Vector<Byte> data, int offset, int len) throws MeterException {
        this.writeDataImmediately(PortManager.convertVectorByteToBytes(data), offset, len);
    }

    public void writeDataImmediately(byte[] bytes, int offset, int len) throws MeterException {
        this.write_log(bytes);
        if (bytes.length == 0) {
            return;
        }
        byte[] buffer = new byte[2048];
        try {
            while (offset < len) {
                int remaining = len - offset;
                int toWrite = Math.min(remaining, buffer.length);
                System.arraycopy(bytes, offset, buffer, 0, toWrite);
                this.getOutputStream().write(buffer, 0, toWrite);
                offset += toWrite;
            }
            this.getOutputStream().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            JLog.error("PortManager write error\uff1a{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.\u6d41\u5199\u5165\u9519\u8bef);
        }
    }

    protected void write_log(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            int min;
            byte[] buffer;
            if (this.log || this.logBack) {
                buffer = new byte[1024];
                min = Math.min(buffer.length, bytes.length);
                System.arraycopy(bytes, 0, buffer, 0, min);
                String logStr = "Write:[ " + ByteUtils.toHexString(Arrays.copyOfRange(buffer, 0, min)) + " ]";
                if (this.log) {
                    System.out.println(this.log);
                }
                if (this.logBack && this.portLogBack != null) {
                    this.portLogBack.logBack(logStr);
                }
            }
            if (GlobalPara.getInstance().isRunLog()) {
                buffer = new byte[1024];
                min = Math.min(buffer.length, bytes.length);
                System.arraycopy(bytes, 0, buffer, 0, min);
                System.out.println("Write:[ " + ByteUtils.toHexString(Arrays.copyOfRange(buffer, 0, min)) + " ]");
            }
        }
    }

    public byte[] readData() throws MeterException {
        byte[] accept = new byte[this.readBytesLength.intValue()];
        ReadResponse response = this.readData(accept);
        return PortManager.invalidBytes(accept, response.getLength());
    }

    public byte[] readData(int length) throws MeterException {
        byte[] accept = new byte[length];
        ReadResponse response = this.readData(accept);
        return PortManager.invalidBytes(accept, response.getLength());
    }

    public ReadResponse readData(byte[] bytes) throws MeterException {
        try {
            int len = this.getInputStream() != null && this.getInputStream().available() > 0 ? this.getInputStream().read(bytes) : 0;
            this.read_log(bytes, len);
            return new ReadResponse(len, bytes);
        }
        catch (IOException e) {
            JLog.error("PortManager read error\uff1a{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.\u6d41\u8bfb\u53d6\u9519\u8bef);
        }
    }

    protected void read_log(byte[] bytes, int len) {
        byte[] content = PortManager.invalidBytes(bytes, len);
        if (content != null && content.length > 0) {
            String logStr = "Read:[ " + ByteUtils.toHexString(content) + " ]";
            if ((this.log || this.logBack) && bytes != null && len > 0) {
                if (this.log) {
                    System.out.println(logStr);
                }
                if (this.logBack && this.portLogBack != null) {
                    this.portLogBack.logBack(logStr);
                }
            }
        }
    }

    public boolean closePort() throws MeterException {
        if (!this.status) {
            return true;
        }
        try {
            JLog.info("{} close [ {} ] start...", this.device.getClass().getName(), ((Device)this.device).getDevice());
            if (this.clientMaps != null && !this.clientMaps.isEmpty()) {
                for (String next : this.clientMaps.keySet()) {
                    PortManager portManager = this.clientMaps.remove(next);
                    portManager.closePort();
                }
                this.clientMaps.clear();
            }
            if (this.thread != null) {
                this.thread.isInterrupted();
                this.thread.destroy();
                this.thread = null;
            }
            if (this.getInputStream() != null) {
                try {
                    this.getInputStream().close();
                }
                catch (Exception iterator) {
                    // empty catch block
                }
            }
            if (this.getOutputStream() != null) {
                try {
                    this.getOutputStream().close();
                }
                catch (Exception iterator) {
                    // empty catch block
                }
            }
            if (this.control != null) {
                this.control.close();
            }
            if (this.clientEventListener != null) {
                this.clientEventListener.stop();
            }
            JLog.info("{} close [ {} ] success", this.device.getClass().getName(), ((Device)this.device).getDevice());
            this.status = false;
            return true;
        }
        catch (Exception e) {
            JLog.error("{} close [ {} ] error\uff1a{}", this.device.getClass().getName(), ((Device)this.device).getDevice(), e.getMessage(), e);
            return false;
        }
    }

    public String portname() {
        return Objects.nonNull(this.device) ? ((Device)this.device).getDevice() : null;
    }

    public Set<T> getDevices() {
        return this.devices;
    }

    public InputStream getInputStream() throws MeterException {
        return this.inputStream != null ? this.inputStream : this.control.getInputStream();
    }

    public OutputStream getOutputStream() throws MeterException {
        return this.outputStream != null ? this.outputStream : this.control.getOutputStream();
    }

    public DeviceControl getControl() {
        return this.control;
    }

    public void setControl(DeviceControl control) {
        this.control = control;
    }

    public DeviceDiscoverEventListener getDiscoverEventListener() {
        return this.discoverEventListener;
    }

    public void setDiscoverEventListener(DeviceDiscoverEventListener discoverEventListener) {
        this.discoverEventListener = discoverEventListener;
    }

    public T getDevice() {
        return this.device;
    }

    public void setDevice(T device) {
        this.device = device;
    }

    public DeviceClientEventListener getClientEventListener() {
        return this.clientEventListener;
    }

    public void setClientEventListener(DeviceClientEventListener clientEventListener) {
        this.clientEventListener = clientEventListener;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    protected static byte[] convertVectorByteToBytes(Vector<Byte> data) {
        byte[] sendData = new byte[data.size()];
        if (data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                sendData[i] = data.get(i);
            }
        }
        return sendData;
    }

    protected static Vector<Byte> convertBytesToVectorByte(byte[] bytes) {
        Vector<Byte> vector = new Vector<Byte>();
        for (byte b : bytes) {
            vector.add(b);
        }
        return vector;
    }

    public static byte[] invalidBytes(byte[] source, int length) {
        try {
            return Arrays.copyOf(source, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    protected class ClientThread
    extends Thread {
        private ClientControl control;
        private long start;
        private long count;
        private boolean run;
        private PortManager portManager;

        public ClientThread(ClientControl control) {
            super(String.format("%s_%s_Thread", PortManager.this.device.getDevice(), System.currentTimeMillis()));
            this.start = System.currentTimeMillis();
            this.count = 0L;
            this.run = true;
            this.control = control;
            this.portManager = PortManager.this._this();
            if (PortManager.this.clientEventListener != null && PortManager.this.clientEventListener instanceof SocketClientEventListener) {
                PortManager.this.server.clientMaps.put(this.portManager.portname(), this.portManager);
                ((SocketClientEventListener)PortManager.this.clientEventListener).onClientLink(this.control.getAddress(), this.control.getPort());
            }
        }

        private boolean doCheck() {
            long count = (System.currentTimeMillis() - this.start) / 1000L;
            if (this.count != count && count % 10L == 0L) {
                this.count = count;
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            while (!this.isInterrupted() && this.run && (!this.doCheck() || this.control.checkLink())) {
                block9: {
                    try {
                        byte[] send;
                        byte[] accept = PortManager.this.readData();
                        if (PortManager.this.clientEventListener != null && PortManager.this.clientEventListener instanceof SocketClientEventListener && (send = ((SocketClientEventListener)PortManager.this.clientEventListener).onClientEventResponse(this.portManager, accept)) != null && send.length > 0) {
                            PortManager.this.writeDataImmediately(send);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (PortManager.this.log) {
                            System.err.printf("\u5355\u7ebf\u7a0b\u8bfb\u53d6\u76d1\u542c\u5f02\u5e38\uff1a%s%n", e.getMessage());
                        }
                        if (PortManager.this.clientEventListener == null) break block9;
                        if (e instanceof MeterException) {
                            PortManager.this.clientEventListener.onClientEventExp((MeterException)e);
                        }
                        PortManager.this.clientEventListener.onClientEventExp(new MeterException(MeterStateEnum.\u591a\u8fde\u63a5\u901a\u8baf\u8bfb\u5199\u5f02\u5e38));
                    }
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (PortManager.this.clientEventListener != null && PortManager.this.clientEventListener instanceof SocketClientEventListener) {
                PortManager.this.clientMaps.remove(this.portManager.portname());
                ((SocketClientEventListener)PortManager.this.clientEventListener).onClientBreak(this.control.getAddress(), this.control.getPort());
            }
        }

        public void destroy() {
            this.run = false;
        }
    }
}

