/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.io;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.control.SocketControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.model.device.UDPDevice;
import com.jhscale.meter.protocol.model.ReadResponse;
import com.jhscale.meter.protocol.model.SocketReadResponse;
import java.util.Arrays;

public class UDPLink
extends PortManager<UDPDevice> {
    public static final String TAG = "UDP";

    public UDPLink() {
    }

    public UDPLink(SocketControl control, UDPDevice device, DeviceClientEventListener clientEventListener) throws MeterException {
        super((DeviceControl)control, device, clientEventListener);
    }

    @Override
    public boolean openPort() throws MeterException {
        try {
            return super.openPortAddEventListenerBefore();
        }
        catch (Exception e) {
            JLog.error("{} open [ {} ] error\uff1a{}", TAG, super.portname(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.UDP\u6253\u5f00\u5931\u8d25);
        }
    }

    @Override
    public void writeDataImmediately(byte[] bytes, int offset, int len) throws MeterException {
        try {
            byte[] send = Arrays.copyOfRange(bytes, offset, len);
            this.write_log(send);
            ((SocketControl)this.getControl()).write(send);
        }
        catch (MeterException e) {
            throw e;
        }
        catch (Exception ep) {
            throw new MeterException(MeterStateEnum.UDP\u5199\u6570\u636e\u5931\u8d25);
        }
    }

    @Override
    public ReadResponse readData(byte[] bytes) throws MeterException {
        try {
            bytes = bytes == null ? new byte[1024] : bytes;
            SocketReadResponse response = ((SocketControl)this.getControl()).read(bytes);
            this.read_log(bytes, response.getLength());
            return response;
        }
        catch (Exception e) {
            throw new MeterException(MeterStateEnum.UDP\u8bfb\u6570\u636e\u5931\u8d25);
        }
    }
}

