/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.io.control.win;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.DeviceDiscoverEventListener;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.model.device.BlueDevice;
import com.jhscale.meter.model.device.InitDeviceEntity;
import com.jhscale.meter.utils.BluecoveUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class WBluetoothControl
implements DeviceControl<BlueDevice> {
    private WBluetoothDiscoverEventListener discoverEventListener;
    private WBluetoothClientListener clientListener;
    private StreamConnection streamConnection;

    @Override
    public void initDevice() throws MeterException {
        BluecoveUtils.doctorDevice();
    }

    @Override
    public void initParam(InitDeviceEntity entity) {
    }

    @Override
    public void addListener(DeviceDiscoverEventListener discoverEventListener, Set<BlueDevice> devicesDiscovered) {
        this.discoverEventListener = new WBluetoothDiscoverEventListener(discoverEventListener, devicesDiscovered);
    }

    @Override
    public boolean discovery() throws MeterException {
        try {
            JLog.debug("{} discovery \u672c\u673a\u84dd\u7259\u540d\u79f0: [ {} ] \u5f00\u542f\u8bbe\u5907\u67e5\u627e...", "BTPort", LocalDevice.getLocalDevice().getFriendlyName());
            return LocalDevice.getLocalDevice().getDiscoveryAgent().startInquiry(10390323, (DiscoveryListener)this.discoverEventListener);
        }
        catch (BluetoothStateException e) {
            JLog.error("{} discovery \u641c\u7d22\u84dd\u7259\u8bbe\u5907\u67e5\u627e\u5f00\u542f\u5f02\u5e38\uff1a{}", new Object[]{"BTPort", e.getMessage(), e});
            throw new MeterException(MeterStateEnum.\u84dd\u7259\u5f00\u542f\u67e5\u627e\u8bbe\u5907\u5f02\u5e38);
        }
    }

    @Override
    public boolean cancelDiscovery() throws MeterException {
        try {
            JLog.debug("{} cancelDiscovery \u672c\u673a\u84dd\u7259\u540d\u79f0: [ {} ] \u5173\u95ed\u8bbe\u5907\u67e5\u627e...", "BTPort", LocalDevice.getLocalDevice().getFriendlyName());
            LocalDevice.getLocalDevice().getDiscoveryAgent().cancelInquiry((DiscoveryListener)this.discoverEventListener);
            this.discoverEventListener = null;
            return true;
        }
        catch (BluetoothStateException e) {
            JLog.error("{} cancelDiscovery \u641c\u7d22\u84dd\u7259\u8bbe\u5907\u67e5\u627e\u5173\u95ed\u5f02\u5e38\uff1a{}", new Object[]{"BTPort", e.getMessage(), e});
            throw new MeterException(MeterStateEnum.\u84dd\u7259\u5173\u95ed\u67e5\u627e\u8bbe\u5907\u5f02\u5e38);
        }
    }

    @Override
    public void openPort(BlueDevice device) throws MeterException {
        try {
            JLog.debug("{} openport \u6253\u5f00\u84dd\u7259\u8fde\u63a5: [ {} ] ", "BTPort", device.getDevice());
            this.streamConnection = (StreamConnection)Connector.open((String)("btspp://" + device.getDevice() + ":1"));
        }
        catch (IOException e) {
            JLog.error("{} openport \u6253\u5f00\u84dd\u7259\u8fde\u63a5\u5931\u8d25\uff1a{}", "BTPort", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.\u84dd\u7259\u6253\u5f00\u5931\u8d25);
        }
    }

    @Override
    public void addListener(DeviceClientEventListener clientEventListener, PortManager portManager) throws MeterException {
        this.clientListener = new WBluetoothClientListener(clientEventListener, portManager);
        this.clientListener.start();
    }

    @Override
    public InputStream getInputStream() throws MeterException {
        if (!this.checkLink()) {
            throw new MeterException(MeterStateEnum.\u84dd\u7259\u672a\u6253\u5f00);
        }
        try {
            return this.streamConnection.openDataInputStream();
        }
        catch (IOException e) {
            throw new MeterException(MeterStateEnum.\u83b7\u53d6\u84dd\u7259\u8f93\u5165\u6d41\u5931\u8d25);
        }
    }

    @Override
    public OutputStream getOutputStream() throws MeterException {
        if (!this.checkLink()) {
            throw new MeterException(MeterStateEnum.\u84dd\u7259\u672a\u6253\u5f00);
        }
        try {
            return this.streamConnection.openDataOutputStream();
        }
        catch (IOException e) {
            throw new MeterException(MeterStateEnum.\u83b7\u53d6\u84dd\u7259\u8f93\u51fa\u6d41\u5931\u8d25);
        }
    }

    @Override
    public void close() throws MeterException {
        if (this.streamConnection != null) {
            this.clientListener.clientState = false;
            try {
                Thread.sleep(100L);
                this.streamConnection.close();
            }
            catch (IOException | InterruptedException e) {
                JLog.error("{} close \u5173\u95ed\u84dd\u7259\u8fde\u63a5\u5931\u8d25\uff1a{}", "BTPort", e.getMessage(), e);
                throw new MeterException(MeterStateEnum.\u84dd\u7259\u5173\u95ed\u5f02\u5e38);
            }
            this.streamConnection = null;
            this.clientListener = null;
        }
    }

    @Override
    public boolean checkLink() {
        return this.streamConnection != null;
    }

    private static class WBluetoothClientListener
    extends Thread {
        private DeviceClientEventListener clientEventListener;
        private PortManager portManager;
        private boolean clientState = true;

        public WBluetoothClientListener(DeviceClientEventListener clientEventListener, PortManager portManager) {
            super("WBluetoothClientListener_Thread");
            this.clientEventListener = clientEventListener;
            this.portManager = portManager;
        }

        @Override
        public void run() {
            while (this.clientState) {
                try {
                    if (this.clientEventListener != null) {
                        this.clientEventListener.onClientEvent(this.portManager.readData());
                    }
                    Thread.sleep(100L);
                }
                catch (MeterException e) {
                    JLog.error("{} Listener Read [ {} ] error:{}", "BTPort", this.portManager.portname(), e.getMessage(), e);
                    if (this.clientEventListener == null) continue;
                    this.clientEventListener.onClientEventExp(e);
                }
                catch (InterruptedException e) {
                    JLog.error("{} Listener Read Time [ {} ] error:{}", "BTPort", this.portManager.portname(), e.getMessage(), e);
                }
            }
        }
    }

    private static class WBluetoothDiscoverEventListener
    implements DiscoveryListener {
        private DeviceDiscoverEventListener discoverEventListener;
        private Set<BlueDevice> devicesDiscovered;

        public WBluetoothDiscoverEventListener(DeviceDiscoverEventListener discoverEventListener, Set<BlueDevice> devicesDiscovered) {
            this.discoverEventListener = discoverEventListener;
            this.devicesDiscovered = devicesDiscovered;
        }

        public void inquiryCompleted(int discType) {
            JLog.debug("{} RemoteDeviceDiscovery \u641c\u7d22\u5b8c\u6210", "BTPort");
            if (this.discoverEventListener != null) {
                this.discoverEventListener.onDiscoverSuccessEvent(this.devicesDiscovered);
            }
        }

        public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
            BlueDevice blueDevice = BluecoveUtils.deviceInfo(remoteDevice);
            JLog.debug("{} RemoteDeviceDiscovery \u53d1\u73b0\u8bbe\u5907: [ {} ]", "BTPort", blueDevice.getBlueName());
            if (this.discoverEventListener != null) {
                this.discoverEventListener.onDiscoverEvent(blueDevice);
            }
            if (this.devicesDiscovered != null) {
                this.devicesDiscovered.add(blueDevice);
            }
        }

        public void servicesDiscovered(int arg0, ServiceRecord[] arg1) {
            JLog.debug("{} RemoteDeviceDiscovery servicesDiscovered", "BTPort");
        }

        public void serviceSearchCompleted(int arg0, int arg1) {
            JLog.debug("{} RemoteDeviceDiscovery serviceSearchCompleted", "BTPort");
        }
    }
}

