/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.io.control.win;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.DeviceDiscoverEventListener;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.model.device.InitDeviceEntity;
import com.jhscale.meter.model.device.SerialDevice;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.TooManyListenersException;

public class WSerialPortControl
implements DeviceControl<SerialDevice> {
    private SerialPort serialPort;
    private WSerialDiscoverEventListener discoverEventListener;

    @Override
    public void initDevice() {
    }

    @Override
    public void initParam(InitDeviceEntity entity) {
    }

    @Override
    public void addListener(DeviceDiscoverEventListener discoverEventListener, Set<SerialDevice> devicesDiscovered) {
        this.discoverEventListener = new WSerialDiscoverEventListener(discoverEventListener, devicesDiscovered);
    }

    @Override
    public boolean discovery() {
        if (this.discoverEventListener != null) {
            this.discoverEventListener.start();
        }
        return true;
    }

    @Override
    public boolean cancelDiscovery() {
        if (this.discoverEventListener != null) {
            this.discoverEventListener.discoverEventState = false;
        }
        this.discoverEventListener = null;
        return true;
    }

    @Override
    public void openPort(SerialDevice device) throws MeterException {
        try {
            JLog.info("{} open [ {} ] start...", "SerialPort", device.getDevice());
            CommPort commPort = CommPortIdentifier.getPortIdentifier((String)device.getDevice()).open(device.getDevice(), 2000);
            if (!(commPort instanceof SerialPort)) {
                throw new MeterException(MeterStateEnum.\u7aef\u53e3\u6307\u5411\u8bbe\u5907\u4e0d\u662f\u4e32\u53e3\u7c7b\u578b);
            }
            this.serialPort = (SerialPort)commPort;
            this.serialPort.setSerialPortParams(device.getBaudrate(), 8, 1, 0);
            JLog.info("{} open [ {} ] success", "SerialPort", device.getDevice());
        }
        catch (NoSuchPortException e) {
            throw new MeterException(MeterStateEnum.\u6ca1\u6709\u8be5\u7aef\u53e3\u5bf9\u5e94\u7684\u4e32\u53e3\u8bbe\u5907);
        }
        catch (PortInUseException e) {
            throw new MeterException(MeterStateEnum.\u7aef\u53e3\u5df2\u88ab\u5360\u7528);
        }
        catch (UnsupportedCommOperationException e) {
            throw new MeterException(MeterStateEnum.\u8bbe\u7f6e\u4e32\u53e3\u53c2\u6570\u5931\u8d25);
        }
    }

    @Override
    public void addListener(final DeviceClientEventListener clientEventListener, final PortManager portManager) throws MeterException {
        if (!this.checkLink()) {
            throw new MeterException(MeterStateEnum.\u4e32\u53e3\u672a\u6253\u5f00);
        }
        try {
            this.serialPort.addEventListener(new SerialPortEventListener(){

                public void serialEvent(SerialPortEvent serialPortEvent) {
                    try {
                        int eventType = serialPortEvent.getEventType();
                        byte[] bytes = portManager.readData();
                        if (clientEventListener != null) {
                            clientEventListener.onClientEvent(1 == eventType ? bytes : new byte[]{});
                        }
                    }
                    catch (MeterException e) {
                        JLog.error("{} Listener Read [ {} ] error:{}", "SerialPort", portManager.portname(), e.getMessage(), e);
                        clientEventListener.onClientEventExp(e);
                    }
                }
            });
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.notifyOnBreakInterrupt(true);
        }
        catch (TooManyListenersException e) {
            JLog.error("{} addListener [ {} ] error\uff1a{}", "SerialPort", portManager.portname(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.\u76d1\u542c\u7c7b\u5bf9\u8c61\u8fc7\u591a);
        }
    }

    @Override
    public InputStream getInputStream() throws MeterException {
        if (!this.checkLink()) {
            throw new MeterException(MeterStateEnum.\u4e32\u53e3\u672a\u6253\u5f00);
        }
        try {
            return this.serialPort.getInputStream();
        }
        catch (Exception e) {
            throw new MeterException(MeterStateEnum.\u83b7\u53d6\u4e32\u53e3\u8f93\u5165\u6d41\u5931\u8d25);
        }
    }

    @Override
    public OutputStream getOutputStream() throws MeterException {
        if (!this.checkLink()) {
            throw new MeterException(MeterStateEnum.\u4e32\u53e3\u672a\u6253\u5f00);
        }
        try {
            return this.serialPort.getOutputStream();
        }
        catch (Exception e) {
            throw new MeterException(MeterStateEnum.\u83b7\u53d6\u4e32\u53e3\u8f93\u51fa\u6d41\u5931\u8d25);
        }
    }

    @Override
    public void close() throws MeterException {
        if (this.serialPort != null) {
            this.serialPort.close();
            this.serialPort = null;
        }
    }

    @Override
    public boolean checkLink() {
        return this.serialPort != null;
    }

    private static class WSerialDiscoverEventListener
    extends Thread {
        private DeviceDiscoverEventListener deviceDiscoverEventListener;
        private Set<SerialDevice> devicesDiscovered;
        private boolean discoverEventState = true;

        public WSerialDiscoverEventListener(DeviceDiscoverEventListener deviceDiscoverEventListener, Set<SerialDevice> devicesDiscovered) {
            super("WSerialDiscoverEventListener_Thread");
            this.deviceDiscoverEventListener = deviceDiscoverEventListener;
            this.devicesDiscovered = devicesDiscovered;
        }

        @Override
        public void run() {
            try {
                Enumeration portList = CommPortIdentifier.getPortIdentifiers();
                while (this.discoverEventState && portList.hasMoreElements()) {
                    CommPortIdentifier commPortIdentifier = (CommPortIdentifier)portList.nextElement();
                    SerialDevice serialDevice = new SerialDevice(commPortIdentifier.getName(), commPortIdentifier);
                    if (this.devicesDiscovered != null) {
                        this.devicesDiscovered.add(serialDevice);
                    }
                    if (this.deviceDiscoverEventListener == null) continue;
                    this.deviceDiscoverEventListener.onDiscoverEvent(serialDevice);
                }
                if (this.deviceDiscoverEventListener != null) {
                    this.deviceDiscoverEventListener.onDiscoverSuccessEvent(this.devicesDiscovered);
                }
            }
            catch (Exception e) {
                JLog.error("{} discovery error\uff1a{}", "SerialPort", e.getMessage(), e);
            }
        }
    }
}

