/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.io.control.win;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.control.SocketControl;
import com.jhscale.meter.model.device.TCPClientDevice;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class WTCPClientControl
implements SocketControl<TCPClientDevice> {
    private Socket socket;

    @Override
    public void openPort(TCPClientDevice device) throws MeterException {
        try {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(device.getIp(), device.getPort()), device.getTimeOut());
        }
        catch (IOException e) {
            throw new MeterException(MeterStateEnum.TCP_Client\u6253\u5f00\u5931\u8d25);
        }
    }

    @Override
    public InputStream getInputStream() throws MeterException {
        try {
            return this.socket.getInputStream();
        }
        catch (Exception e) {
            throw new MeterException(MeterStateEnum.TCP_Client\u83b7\u53d6\u8f93\u5165\u6d41);
        }
    }

    @Override
    public OutputStream getOutputStream() throws MeterException {
        try {
            return this.socket.getOutputStream();
        }
        catch (Exception e) {
            throw new MeterException(MeterStateEnum.TCP_Client\u83b7\u53d6\u8f93\u51fa\u6d41);
        }
    }

    @Override
    public void close() throws MeterException {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                throw new MeterException(MeterStateEnum.TCP_Client\u5173\u95ed\u5931\u8d25);
            }
            this.socket = null;
        }
    }
}

