/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.io.control.win;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.control.ClientControl;
import com.jhscale.meter.model.device.TCPServerClientDevice;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class WTCPServerClientControl
implements ClientControl<TCPServerClientDevice> {
    private Socket socket;

    @Override
    public boolean checkLink() {
        if (this.socket != null) {
            try {
                this.socket.sendUrgentData(255);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void openPort(TCPServerClientDevice device) throws MeterException {
        this.socket = (Socket)device.getDeviceInfo();
    }

    @Override
    public InputStream getInputStream() throws MeterException {
        try {
            return this.socket.getInputStream();
        }
        catch (Exception e) {
            throw new MeterException(MeterStateEnum.TCP_Server_Client\u83b7\u53d6\u8f93\u5165\u6d41);
        }
    }

    @Override
    public OutputStream getOutputStream() throws MeterException {
        try {
            return this.socket.getOutputStream();
        }
        catch (Exception e) {
            throw new MeterException(MeterStateEnum.TCP_Server_Client\u83b7\u53d6\u8f93\u51fa\u6d41);
        }
    }

    @Override
    public void close() throws MeterException {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                throw new MeterException(MeterStateEnum.TCP_Server_Client\u5173\u95ed\u5931\u8d25);
            }
            this.socket = null;
        }
    }

    @Override
    public InetAddress getAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }
}

