/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.io.control.win;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.TCPServerClient;
import com.jhscale.meter.io.control.ClientControl;
import com.jhscale.meter.io.control.SocketControl;
import com.jhscale.meter.io.control.win.WTCPServerClientControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.model.device.TCPServerClientDevice;
import com.jhscale.meter.model.device.TCPServerDevice;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class WTCPServerControl
implements SocketControl<TCPServerDevice> {
    private PortManager portManager;
    private WTCPServerThread thread;

    @Override
    public void openPort(TCPServerDevice device) throws MeterException {
        try {
            this.thread = new WTCPServerThread(this.portManager, new ServerSocket(device.getPort()));
            this.thread.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addListener(DeviceClientEventListener clientEventListener, PortManager portManager) throws MeterException {
        this.portManager = portManager;
    }

    @Override
    public InputStream getInputStream() throws MeterException {
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws MeterException {
        return null;
    }

    @Override
    public void close() throws MeterException {
        if (this.thread != null) {
            this.thread.close();
            this.thread = null;
        }
    }

    private static class WTCPServerThread
    extends Thread {
        private final PortManager<TCPServerDevice> portManager;
        private ServerSocket serverSocket;

        WTCPServerThread(PortManager portManager, ServerSocket serverSocket) {
            super(String.format("%s_%s_Thread", portManager.getClass().getSimpleName(), System.currentTimeMillis()));
            this.portManager = portManager;
            this.serverSocket = serverSocket;
        }

        @Override
        public void run() {
            while (!this.isInterrupted() && this.serverSocket != null) {
                try {
                    Socket socket = this.serverSocket.accept();
                    socket.setSendBufferSize(0x100000);
                    String socket_network = String.format("%s:%s", socket.getInetAddress().getHostAddress(), socket.getPort());
                    System.out.printf("\u5ba2\u6237\u7aef\u4fe1\u606f\uff1a%s%n", socket_network);
                    TCPServerClient tcpServerClient = new TCPServerClient((ClientControl)new WTCPServerClientControl(), new TCPServerClientDevice<Socket>(socket_network, socket), this.portManager);
                    tcpServerClient.openPort();
                }
                catch (SocketException e) {
                    System.err.printf("TCP Server Control: %s%n", e.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        synchronized void close() {
            try {
                if (this.serverSocket != null) {
                    this.interrupt();
                    this.serverSocket.close();
                    this.serverSocket = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

