/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.io.control.win;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.SocketControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.SocketClientEventListener;
import com.jhscale.meter.model.device.UDPDevice;
import com.jhscale.meter.protocol.model.SocketReadResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class WUDPControl
implements SocketControl<UDPDevice> {
    private UDPDevice udpDevice;
    private DatagramSocket socket;
    private DeviceClientEventListener clientEventListener;
    private PortManager portManager;
    private WUDPThread thread;

    @Override
    public void openPort(UDPDevice device) throws MeterException {
        try {
            this.udpDevice = device;
            this.socket = new DatagramSocket(device.getListener());
            this.thread = new WUDPThread(this.portManager, this.clientEventListener);
            this.thread.start();
        }
        catch (IOException e) {
            throw new MeterException(MeterStateEnum.UDP\u6253\u5f00\u5931\u8d25);
        }
    }

    @Override
    public void addListener(DeviceClientEventListener clientEventListener, PortManager portManager) throws MeterException {
        this.clientEventListener = clientEventListener;
        this.portManager = portManager;
    }

    @Override
    public InputStream getInputStream() throws MeterException {
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws MeterException {
        return null;
    }

    @Override
    public void close() throws MeterException {
        if (this.socket != null) {
            this.thread.close();
            this.socket.close();
            this.socket = null;
            this.thread = null;
        }
    }

    @Override
    public synchronized void write(byte[] bytes) throws MeterException {
        if (this.socket != null) {
            try {
                DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.udpDevice.broadcastAddress(), this.udpDevice.getBroadcast());
                this.socket.send(packet);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new MeterException(MeterStateEnum.UDP\u5199\u6570\u636e\u5931\u8d25);
            }
        }
    }

    @Override
    public SocketReadResponse read(byte[] bytes) throws MeterException {
        if (this.socket != null) {
            try {
                DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
                this.socket.receive(packet);
                return new SocketReadResponse(packet.getLength(), bytes, packet.getAddress(), packet.getPort());
            }
            catch (IOException e) {
                throw new MeterException(MeterStateEnum.UDP\u8bfb\u6570\u636e\u5931\u8d25);
            }
        }
        return new SocketReadResponse(-1);
    }

    private static class WUDPThread
    extends Thread {
        private PortManager portManager;
        private DeviceClientEventListener clientEventListener;

        public WUDPThread(PortManager portManager, DeviceClientEventListener clientEventListener) {
            this.portManager = portManager;
            this.clientEventListener = clientEventListener;
        }

        @Override
        public void run() {
            while (!this.isInterrupted() && this.portManager != null) {
                try {
                    byte[] bytes;
                    byte[] buffer = new byte[1024];
                    SocketReadResponse response = (SocketReadResponse)this.portManager.readData(buffer);
                    if (this.clientEventListener == null || !(this.clientEventListener instanceof SocketClientEventListener) || (bytes = ((SocketClientEventListener)this.clientEventListener).onClientEvent(this.portManager, response.getFrom_address(), response.getFrom_port(), response.invalidBytes())) == null || bytes.length <= 0) continue;
                    this.portManager.writeDataImmediately(bytes);
                }
                catch (Exception e) {
                    this.close();
                }
            }
        }

        synchronized void close() {
            if (this.portManager != null) {
                this.interrupt();
                this.portManager = null;
            }
        }
    }
}

