/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.io.control.win;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.entity.JEndpointInputStream;
import com.jhscale.meter.io.entity.JEndpointOutputStream;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.io.listener.DeviceDiscoverEventListener;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.model.device.InitDeviceEntity;
import com.jhscale.meter.model.device.USBDevice;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;

public class WUSBControl
implements DeviceControl<USBDevice> {
    private Short VID;
    private Short PID;
    private UsbInterface iface;
    private WUSBDeviceDiscoverEventListener discoverEventListener;
    private WUSBClientListener clientListener;
    private JEndpointInputStream inputStream;
    private JEndpointOutputStream outputStream;

    @Override
    public void initDevice() throws MeterException {
    }

    @Override
    public void initParam(InitDeviceEntity entity) {
        this.VID = entity.getVID();
        this.PID = entity.getPID();
    }

    @Override
    public void addListener(DeviceDiscoverEventListener discoverEventListener, Set<USBDevice> devicesDiscovered) {
        this.discoverEventListener = new WUSBDeviceDiscoverEventListener(this.VID, this.PID, discoverEventListener, devicesDiscovered);
    }

    @Override
    public boolean discovery() throws MeterException {
        if (this.discoverEventListener != null) {
            this.discoverEventListener.start();
        }
        return true;
    }

    @Override
    public boolean cancelDiscovery() throws MeterException {
        this.discoverEventListener = null;
        return true;
    }

    @Override
    public void openPort(USBDevice device) throws MeterException {
        try {
            UsbDevice usbDevice = null;
            if (device.getDeviceInfo() != null) {
                usbDevice = (UsbDevice)device.getDeviceInfo();
            } else {
                usbDevice = WUSBDeviceDiscoverEventListener.findDevice(UsbHostManager.getUsbServices().getRootUsbHub(), device.getVid(), device.getPid());
                if (usbDevice != null) {
                    device.setDevice(usbDevice.toString());
                    device.setDeviceInfo(usbDevice);
                }
            }
            if (Objects.isNull(usbDevice)) {
                throw new MeterException(MeterStateEnum.\u672a\u627e\u5230USB\u63a5\u53e3);
            }
            UsbConfiguration configuration = usbDevice.getActiveUsbConfiguration();
            UsbInterface iface = null;
            if (configuration.getUsbInterfaces().size() <= 0) {
                throw new MeterException(MeterStateEnum.USB\u8fde\u63a5\u5931\u8d25);
            }
            iface = (UsbInterface)configuration.getUsbInterfaces().get(0);
            iface.claim();
            this.iface = iface;
        }
        catch (UsbException e) {
            JLog.error("{} openPort USB\u8fde\u63a5\u5931\u8d25\uff1a{}", new Object[]{"BTPort", e.getMessage(), e});
            throw new MeterException(MeterStateEnum.USB\u8fde\u63a5\u5931\u8d25);
        }
    }

    @Override
    public void addListener(DeviceClientEventListener clientEventListener, PortManager portManager) throws MeterException {
        this.clientListener = new WUSBClientListener(clientEventListener, portManager);
        this.clientListener.start();
    }

    @Override
    public InputStream getInputStream() throws MeterException {
        if (!this.checkLink()) {
            throw new MeterException(MeterStateEnum.USB\u672a\u6253\u5f00);
        }
        try {
            if (this.inputStream == null) {
                UsbEndpoint usbEndpoint = (UsbEndpoint)this.iface.getUsbEndpoints().get(0);
                if (usbEndpoint.getUsbEndpointDescriptor().toString().contains("OUT")) {
                    usbEndpoint = (UsbEndpoint)this.iface.getUsbEndpoints().get(1);
                }
                this.inputStream = new JEndpointInputStream(usbEndpoint);
            }
            return this.inputStream;
        }
        catch (Exception e) {
            throw new MeterException(MeterStateEnum.\u83b7\u53d6\u4e32\u53e3\u8f93\u5165\u6d41\u5931\u8d25);
        }
    }

    @Override
    public OutputStream getOutputStream() throws MeterException {
        if (!this.checkLink()) {
            throw new MeterException(MeterStateEnum.USB\u672a\u6253\u5f00);
        }
        try {
            if (this.outputStream == null) {
                UsbEndpoint usbEndpoint = (UsbEndpoint)this.iface.getUsbEndpoints().get(0);
                if (!usbEndpoint.getUsbEndpointDescriptor().toString().contains("OUT")) {
                    usbEndpoint = (UsbEndpoint)this.iface.getUsbEndpoints().get(1);
                }
                this.outputStream = new JEndpointOutputStream(usbEndpoint);
            }
            return this.outputStream;
        }
        catch (Exception e) {
            throw new MeterException(MeterStateEnum.\u83b7\u53d6\u4e32\u53e3\u8f93\u5165\u6d41\u5931\u8d25);
        }
    }

    @Override
    public void close() throws MeterException {
        try {
            if (this.iface != null) {
                this.inputStream.close();
                this.inputStream = null;
                this.outputStream.close();
                this.outputStream = null;
                this.iface = null;
                this.clientListener.clientState = false;
                Thread.sleep(100L);
                this.clientListener = null;
            }
        }
        catch (Exception e) {
            JLog.error("{} close \u5173\u95edUSB\u8fde\u63a5\u5931\u8d25\uff1a{}", "USB", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.USB\u5173\u95ed\u5f02\u5e38);
        }
    }

    @Override
    public boolean checkLink() {
        return this.iface != null;
    }

    private static class WUSBClientListener
    extends Thread {
        private DeviceClientEventListener clientEventListener;
        private PortManager portManager;
        private boolean clientState = true;

        public WUSBClientListener(DeviceClientEventListener clientEventListener, PortManager portManager) {
            this.clientEventListener = clientEventListener;
            this.portManager = portManager;
        }

        @Override
        public void run() {
            while (this.clientState) {
                try {
                    if (this.clientEventListener != null) {
                        this.clientEventListener.onClientEvent(this.portManager.readData());
                    }
                    Thread.sleep(100L);
                }
                catch (MeterException e) {
                    JLog.error("{} Listener Read [ {} ] error:{}", "USB", this.portManager.portname(), e.getMessage(), e);
                    if (this.clientEventListener == null) continue;
                    this.clientEventListener.onClientEventExp(e);
                }
                catch (InterruptedException e) {
                    JLog.error("{} Listener Read Time [ {} ] error:{}", "USB", this.portManager.portname(), e.getMessage(), e);
                }
            }
        }
    }

    private static class WUSBDeviceDiscoverEventListener
    extends Thread {
        private Short VID;
        private Short PID;
        private DeviceDiscoverEventListener deviceDiscoverEventListener;
        private Set<USBDevice> devicesDiscovered;

        public WUSBDeviceDiscoverEventListener(Short VID, Short PID, DeviceDiscoverEventListener deviceDiscoverEventListener, Set<USBDevice> devicesDiscovered) {
            this.VID = VID;
            this.PID = PID;
            this.deviceDiscoverEventListener = deviceDiscoverEventListener;
            this.devicesDiscovered = devicesDiscovered;
        }

        @Override
        public void run() {
            block3: {
                try {
                    this.findDevice(UsbHostManager.getUsbServices().getRootUsbHub());
                    if (this.deviceDiscoverEventListener != null) {
                        this.deviceDiscoverEventListener.onDiscoverSuccessEvent(this.devicesDiscovered);
                    }
                }
                catch (UsbException e) {
                    JLog.error("{} discovery error\uff1a{}", new Object[]{"USB", e.getMessage(), e});
                    if (this.deviceDiscoverEventListener == null) break block3;
                    this.deviceDiscoverEventListener.onDiscoverEventExp(new MeterException(MeterStateEnum.USB\u8bbe\u522b\u67e5\u627e\u5f02\u5e38));
                }
            }
        }

        private void findDevice(UsbHub hub) {
            List list = hub.getAttachedUsbDevices();
            for (UsbDevice device : list) {
                UsbDeviceDescriptor desc = device.getUsbDeviceDescriptor();
                USBDevice usbDevice = new USBDevice(device.toString(), device);
                if (Objects.nonNull(this.VID) && Objects.nonNull(this.PID)) {
                    if (desc.idVendor() == this.VID.shortValue() && desc.idProduct() == this.PID.shortValue()) {
                        if (this.deviceDiscoverEventListener != null) {
                            this.deviceDiscoverEventListener.onDiscoverEvent(usbDevice);
                        }
                        if (this.devicesDiscovered != null) {
                            this.devicesDiscovered.add(usbDevice);
                        }
                    }
                } else {
                    if (this.deviceDiscoverEventListener != null) {
                        this.deviceDiscoverEventListener.onDiscoverEvent(usbDevice);
                    }
                    if (this.devicesDiscovered != null) {
                        this.devicesDiscovered.add(usbDevice);
                    }
                }
                if (!device.isUsbHub()) continue;
                this.findDevice((UsbHub)device);
            }
        }

        private static UsbDevice findDevice(UsbHub hub, short vid, short pid) {
            UsbDevice device = null;
            List list = hub.getAttachedUsbDevices();
            for (int i = 0; i < list.size(); ++i) {
                device = (UsbDevice)list.get(i);
                UsbDeviceDescriptor desc = device.getUsbDeviceDescriptor();
                if (desc.idVendor() == vid && desc.idProduct() == pid) {
                    return device;
                }
                if (!device.isUsbHub() || (device = WUSBDeviceDiscoverEventListener.findDevice((UsbHub)device, vid, pid)) == null) continue;
                return device;
            }
            return null;
        }
    }
}

