/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.io.entity;

import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.log.JLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbPipe;

public class JEndpointInputStream
extends InputStream {
    private List<Byte> bytes;
    private USBReadThread readThread;

    public JEndpointInputStream(UsbEndpoint usbEndpoint) throws UsbException {
        UsbPipe usbPipe = usbEndpoint.getUsbPipe();
        usbPipe.open();
        this.bytes = Collections.synchronizedList(new ArrayList());
        this.readThread = new USBReadThread(usbPipe, this.bytes);
        this.readThread.start();
    }

    @Override
    public int read() throws IOException {
        return Byte.toUnsignedInt(this.bytes.remove(0));
    }

    @Override
    public int available() throws IOException {
        return this.bytes.size();
    }

    @Override
    public void close() throws IOException {
        try {
            this.readThread.run = false;
            this.readThread.usbPipe.close();
            Thread.sleep(100L);
            this.readThread = null;
            this.bytes = null;
        }
        catch (Exception e) {
            throw new IOException(MeterStateEnum.USB_IN\u5173\u95ed\u5f02\u5e38.toString());
        }
    }

    private static class USBReadThread
    extends Thread {
        private UsbPipe usbPipe;
        private List<Byte> bytes;
        private boolean run = true;

        public USBReadThread(UsbPipe usbPipe, List<Byte> bytes) {
            super("USBReadThread");
            this.usbPipe = usbPipe;
            this.bytes = bytes;
        }

        @Override
        public void run() {
            byte[] b1 = new byte[128];
            while (this.run) {
                try {
                    int length = this.usbPipe.syncSubmit(b1);
                    byte[] b2 = PortManager.invalidBytes(b1, length);
                    if (b2 == null || b2.length <= 0) continue;
                    for (byte b : b2) {
                        this.bytes.add(b);
                    }
                }
                catch (UsbException e) {
                    JLog.error("{} InputStream error\uff1a{}", new Object[]{"USB", e.getMessage(), e});
                }
            }
        }
    }
}

