/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.log;

public class JLog {
    private static Log log = null;

    private JLog(Log log) {
        JLog.log = log;
    }

    public static void init(Log log) {
        Singleton.init(log);
    }

    public static JLog getInstance() {
        return Singleton.manager;
    }

    public static void info(String format, Object ... arguments) {
        if (log == null) {
            return;
        }
        log.info(format, arguments);
    }

    public static void info(String msg, Throwable t) {
        if (log == null) {
            return;
        }
        log.info(msg, t);
    }

    public static void debug(String format, Object ... arguments) {
        if (log == null) {
            return;
        }
        log.debug(format, arguments);
    }

    public static void debug(String msg, Throwable t) {
        if (log == null) {
            return;
        }
        log.debug(msg, t);
    }

    public static void warn(String format, Object ... arguments) {
        if (log == null) {
            return;
        }
        log.warn(format, arguments);
    }

    public static void warn(String msg, Throwable t) {
        if (log == null) {
            return;
        }
        log.warn(msg, t);
    }

    public static void error(String format, Object ... arguments) {
        if (log == null) {
            return;
        }
        log.error(format, arguments);
    }

    public static void error(String msg, Throwable t) {
        if (log == null) {
            return;
        }
        log.error(msg, t);
    }

    private static class Singleton {
        private static JLog manager = null;

        private Singleton() {
        }

        private static synchronized void init(Log log) {
            if (log != null && manager == null) {
                manager = new JLog(log);
            }
        }
    }

    public static interface Log {
        public void info(String var1, Object ... var2);

        public void info(String var1, Throwable var2);

        public void debug(String var1, Object ... var2);

        public void debug(String var1, Throwable var2);

        public void warn(String var1, Object ... var2);

        public void warn(String var1, Throwable var2);

        public void error(String var1, Object ... var2);

        public void error(String var1, Throwable var2);
    }
}

