/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.logistics;

import com.jhscale.meter.utils.ByteUtils;
import java.io.Serializable;
import java.util.Objects;

public class Agree
implements Serializable,
Comparable<Agree> {
    private int order;
    private String agreeName;
    private int length;
    private String nikeName;
    private boolean state = false;
    private byte[] bytes;
    private String result;

    public Agree() {
    }

    public Agree(byte[] bytes) {
        this.bytes = bytes;
    }

    public Agree(String agreeName, int length) {
        this.order = Integer.parseInt(agreeName.replace("\u534f\u8bae", ""));
        this.agreeName = agreeName;
        this.length = length;
    }

    public Agree(String agreeName, int length, byte[] bytes) {
        this(agreeName, length);
        this.bytes = bytes;
    }

    public Agree(String agreeName, int length, String nikeName) {
        this(agreeName, length);
        this.nikeName = nikeName;
    }

    public Agree(String agreeName, int length, String nikeName, byte[] bytes) {
        this(agreeName, length, nikeName);
        this.bytes = bytes;
    }

    public Agree(String agreeName, int length, String nikeName, boolean state) {
        this(agreeName, length, nikeName);
        this.state = state;
    }

    public Agree(String agreeName, int length, String nikeName, boolean state, byte[] bytes) {
        this(agreeName, length, nikeName, state);
        this.bytes = bytes;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getAgreeName() {
        return this.agreeName;
    }

    public void setAgreeName(String agreeName) {
        this.agreeName = agreeName;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getNikeName() {
        return this.nikeName;
    }

    public void setNikeName(String nikeName) {
        this.nikeName = nikeName;
    }

    public boolean isState() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    @Override
    public int compareTo(Agree o) {
        if (o.getOrder() == this.order) {
            return 0;
        }
        if (o.getOrder() < this.order) {
            return 1;
        }
        return -1;
    }

    public boolean check(byte[] bytes) {
        return Objects.nonNull(bytes) && bytes.length == this.length;
    }

    public StringBuffer assembler(String content) {
        return new StringBuffer();
    }

    public String parse() {
        String result = ByteUtils.toHexAscii(this.bytes);
        result = this.check(this.bytes) ? ByteUtils.hex2Ascii(result) : result + " \u6570\u636e\u5305\u534f\u8bae\u4e0d\u6b63\u786e";
        this.result = result;
        return result;
    }
}

