/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.lora;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.GJSONUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.lora.LoRaHost;
import com.jhscale.meter.lora.LoRaReceive;
import com.jhscale.meter.lora.LoRaResponse;
import com.jhscale.meter.lora.LoRaSend;
import io.swagger.annotations.ApiModelProperty;

public class LoRaDevice
extends JSONModel {
    @ApiModelProperty(value="\u8bbe\u5907\u5730\u5740", name="addr")
    private int addr = 0;
    @ApiModelProperty(value="\u63cf\u8ff0", name="description")
    private String description = "";
    @ApiModelProperty(value="\u56fa\u4ef6\u7248\u672c", name="firmware")
    private int firmware = 0;
    @ApiModelProperty(value="\u56fa\u4ef6\u65e5\u671f(\u9700\u8981)", name="firmwareDate_Need")
    private int firmwareDate_Need = 0;
    @ApiModelProperty(value="\u56fa\u4ef6\u65e5\u671f(\u5b9e\u9645)", name="firmwareDate_Current")
    private int firmwareDate_Current = 0;

    public LoRaDevice() {
    }

    public LoRaDevice(int addr, String description, int firmware, int firmwareDate_Need) {
        this.addr = addr;
        this.description = description;
        this.firmware = firmware;
        this.firmwareDate_Need = firmwareDate_Need;
    }

    public int ConvertNum2Date(int num) {
        int year = num >> 9 & 0x7F;
        int month = num >> 5 & 0xF;
        int day = num & 0x1F;
        return year * 10000 + month * 100 + day;
    }

    public int ConvertDate2Num(int date) {
        int year = date / 10000 % 100;
        int month = date / 100 % 100;
        int day = date % 100;
        return (year << 9) + (month << 5) + day;
    }

    public boolean FirmwareIsOK(byte[] input) {
        int fm = (input[0] & 0xFF) + (input[1] & 0xFF) * 256 + (input[2] & 0xFF) * 65536 + (input[3] & 0xFF) * 0x1000000;
        int date = this.ConvertNum2Date((input[4] & 0xFF) + (input[5] & 0xFF) * 256);
        if (fm != this.firmware) {
            return false;
        }
        if (date < this.firmwareDate_Need) {
            return false;
        }
        this.firmwareDate_Current = date;
        return true;
    }

    public void CMD_Routine() {
        LoRaHost.getInstance().Send(new LoRaSend(this.addr, 32895, new byte[]{97, 98, 99, 100, 101, 102, 103, 104}, new LoRaResponse(){

            @Override
            public void response(LoRaReceive receive) {
                System.out.println(String.format("\u6210\u529f\uff1a[%s]", GJSONUtils.objectToJSON((Object)((Object)receive))));
            }

            @Override
            public void exp(MeterException e) {
                System.out.println(String.format("\u8bf7\u6c42\u5f02\u5e38\uff1a[%s]", e.getMessage()));
            }
        }));
    }

    public void Task_Routine() {
    }

    public void CMD_Version() {
        int addr = this.addr;
        final LoRaDevice device = this;
        LoRaHost.getInstance().Send(new LoRaSend(addr, 32768, null, new LoRaResponse(){

            @Override
            public void response(LoRaReceive receive) {
                if (!device.FirmwareIsOK(receive.getData())) {
                    System.out.println(String.format("\u5931\u8d25\uff1a\u8bbe\u5907\u4fe1\u606f\u4e0d\u5339\u914d", new Object[0]));
                } else {
                    System.out.println(String.format("\u6210\u529f\uff1a[%s]", GJSONUtils.objectToJSON((Object)((Object)device))));
                }
            }

            @Override
            public void exp(MeterException e) {
                System.out.println(String.format("\u8bf7\u6c42\u5f02\u5e38\uff1a[%s]", e.getMessage()));
            }
        }));
    }

    public int getAddr() {
        return this.addr;
    }

    public String getDescription() {
        return this.description;
    }

    public int getFirmware() {
        return this.firmware;
    }

    public int getFirmwareDate_Need() {
        return this.firmwareDate_Need;
    }

    public int getFirmwareDate_Current() {
        return this.firmwareDate_Current;
    }

    public void setAddr(int addr) {
        this.addr = addr;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFirmware(int firmware) {
        this.firmware = firmware;
    }

    public void setFirmwareDate_Need(int firmwareDate_Need) {
        this.firmwareDate_Need = firmwareDate_Need;
    }

    public void setFirmwareDate_Current(int firmwareDate_Current) {
        this.firmwareDate_Current = firmwareDate_Current;
    }
}

