/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.lora;

import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.FileUtils;
import com.jhscale.common.utils.GJSONUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.lora.LoRaDevice;
import com.jhscale.meter.lora.LoRaHost;
import com.jhscale.meter.lora.LoRaReceive;
import com.jhscale.meter.lora.LoRaResponse;
import com.jhscale.meter.lora.LoRaSend;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LoRaDevice_EZY
extends LoRaDevice {
    @ApiModelProperty(value="\u51c0\u91cd", name="net")
    private BigDecimal net = BigDecimal.ZERO;
    @ApiModelProperty(value="\u76ae\u91cd", name="tare")
    private BigDecimal tare = BigDecimal.ZERO;
    @ApiModelProperty(value="\u603b\u91cd", name="gross")
    private BigDecimal gross = BigDecimal.ZERO;
    @ApiModelProperty(value="\u5355\u4f4d", name="unit")
    private String unit = "kg";
    @ApiModelProperty(value="\u7a33\u5b9a", name="isStable")
    private boolean stable = true;
    @ApiModelProperty(value="\u96f6\u70b9", name="isZero")
    private boolean zero = true;
    @ApiModelProperty(value="\u9519\u8bef\u72b6\u6001", name="error")
    private int error = 0;
    @ApiModelProperty(value="\u5141\u8bb8\u6807\u5b9a", name="isJP")
    private boolean isJP = false;
    @ApiModelProperty(value="\u4e8b\u4ef6\u91cd\u91cf", name="eventNet")
    private BigDecimal eventNet = null;
    @ApiModelProperty(value="\u4e8b\u4ef6\u65f6\u95f4", name="eventTime")
    private Long eventTime = null;
    @ApiModelProperty(value="\u4e8b\u4ef6\u65f6\u957f", name="eventLast")
    private Integer eventLast = null;
    @ApiModelProperty(value="\u4e8b\u4ef6\u7f13\u51b2\u4f4d\u79fb", name="eventBuf_Offset")
    private int eventBuf_Offset = 0;
    @ApiModelProperty(value="\u4e8b\u4ef6\u7f13\u51b2", name="eventBuf")
    private BigDecimal[] eventBuf = null;
    @ApiModelProperty(value="\u4e8b\u4ef6\u7d2f\u52a0\u7b49\u7ea7", name="eventLevel")
    private Integer eventLevel = null;

    private LoRaDevice_EZY LoRaWeightResult(byte[] input) {
        if (input.length < 5) {
            return null;
        }
        BigDecimal tempGross = null;
        BigDecimal tempTare = null;
        this.net = LoRaHost.GetNumS32(input, 0);
        this.stable = (input[4] & 0x80) != 0;
        this.zero = (input[4] & 0x40) != 0;
        this.isJP = (input[4] & 0x10) != 0;
        this.error = input[4] & 7;
        if (input.length < 6) {
            this.tare = new BigDecimal(0).movePointLeft(this.net.scale());
            this.gross = this.net;
        } else {
            int temp = input[5] & 7;
            this.unit = temp == 0 ? "kg" : (temp == 1 ? "g" : (temp == 2 ? "ton" : (temp == 3 ? "lb" : (temp == 4 ? "oz" : (temp == 5 ? "ct" : "kg")))));
            int pos = 6;
            if ((input[5] & 0x20) != 0) {
                tempTare = LoRaHost.GetNumS32(input, pos);
                pos += 4;
            }
            if ((input[5] & 0x10) != 0) {
                tempGross = LoRaHost.GetNumS32(input, pos);
                pos += 4;
            }
            if (tempTare == null) {
                if (tempGross == null) {
                    this.tare = new BigDecimal(0).movePointLeft(this.net.scale());
                    this.gross = this.net;
                } else {
                    this.gross = tempGross;
                    this.tare = this.gross.subtract(this.net);
                }
            } else if (tempGross == null) {
                this.tare = tempTare;
                this.gross = this.tare.add(this.net);
            } else {
                this.tare = tempTare;
                this.gross = tempGross;
            }
            if ((input[5] & 0xF) != 0) {
                if ((input[5] & 0xF) == 2 && input.length >= pos + 5) {
                    byte eventType = input[pos];
                    if ((eventType & 1) == 0) {
                        this.eventLevel = input[pos + 1] & 0xFF;
                        this.eventBuf = new BigDecimal[LoRaHost.GetU16(input, pos + 2)];
                        this.eventBuf_Offset = 0;
                        pos += 4;
                    } else {
                        ++pos;
                    }
                    while (input.length >= pos + 4) {
                        if (this.eventBuf_Offset < this.eventBuf.length) {
                            this.eventBuf[this.eventBuf_Offset] = LoRaHost.GetNumS32(input, pos);
                            ++this.eventBuf_Offset;
                        }
                        pos += 4;
                    }
                    if ((eventType & 0x80) != 0) {
                        String content = "";
                        content = content + "Level," + this.eventLevel.toString() + "\r\n";
                        content = content + "Lng," + Integer.toString(this.eventBuf_Offset) + "\r\n";
                        content = content + "Time," + Double.toString((double)(this.eventBuf_Offset << this.eventLevel) / 320.0) + "s\r\n";
                        for (int i = 0; i < this.eventBuf_Offset; ++i) {
                            content = content + Integer.toString(i) + "," + this.eventBuf[i].toString() + "\r\n";
                        }
                        Date date = new Date();
                        SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmss");
                        FileUtils.writer((String)content, (File)new File("H:\\TEST", Integer.toString(this.getAddr()) + "_" + df.format(date) + ".csv"));
                    }
                } else if ((input[5] & 0xF) == 1 && input.length >= pos + 8) {
                    this.eventTime = System.currentTimeMillis() - (long)(LoRaHost.GetU16(input, pos) * 10);
                    this.eventLast = LoRaHost.GetU16(input, pos + 2);
                    this.eventNet = LoRaHost.GetNumS32(input, pos + 4);
                }
            }
        }
        return this;
    }

    public LoRaDevice_EZY(int addr, String description) {
        super(addr, description, 293, 230426);
    }

    @Override
    public void CMD_Routine() {
        this.CMD_Weight(2);
    }

    @Override
    public void Task_Routine() {
        this.Task_Weight(2);
    }

    public void CMD_Weight(Integer value) {
        int addr = this.getAddr();
        byte[] para = null;
        if (value != null) {
            para = new byte[]{(byte)(value & 0xFF)};
        }
        LoRaHost.getInstance().Send(new LoRaSend(addr, 32, para, new LoRaResponse(){

            @Override
            public void response(LoRaReceive receive) {
                LoRaDevice_EZY object = LoRaDevice_EZY.this.LoRaWeightResult(receive.getData());
                System.out.println(String.format("\u6210\u529f\uff1a[%s]", GJSONUtils.objectToJSON((Object)((Object)object))));
            }

            @Override
            public void exp(MeterException e) {
                System.out.println(String.format("\u8bf7\u6c42\u5f02\u5e38\uff1a[%s]", e.getMessage()));
            }
        }));
    }

    public void Task_Weight(Integer value) {
        int addr = this.getAddr();
        byte[] para = null;
        if (value != null) {
            para = new byte[]{(byte)(value & 0xFF)};
        }
        LoRaHost.getInstance().Send(new LoRaSend(addr, 32, para, new LoRaResponse(){

            @Override
            public void response(LoRaReceive receive) {
                LoRaDevice_EZY object = LoRaDevice_EZY.this.LoRaWeightResult(receive.getData());
                System.out.println(String.format("\u6210\u529f\uff1a[%s]", GJSONUtils.objectToJSON((Object)((Object)object))));
            }

            @Override
            public void exp(MeterException e) {
                System.out.println(String.format("\u8bf7\u6c42\u5f02\u5e38\uff1a[%s]", e.getMessage()));
            }
        }, -1));
    }

    public void CMD_Zero(boolean always) {
        int addr = this.getAddr();
        LoRaHost.getInstance().Send(new LoRaSend(addr, 129, new byte[]{(byte)(always ? 85 : 51)}, new LoRaResponse(){

            @Override
            public void response(LoRaReceive receive) {
                if (receive.getData().length == 1 && receive.getData()[0] == -86) {
                    System.out.println(String.format("\u6210\u529f\uff1a\u7f6e\u96f6", new Object[0]));
                } else {
                    System.out.println(String.format("\u5931\u8d25\uff1a\u7f6e\u96f6", new Object[0]));
                }
            }

            @Override
            public void exp(MeterException e) {
                System.out.println(String.format("\u8bf7\u6c42\u5f02\u5e38\uff1a[%s]", e.getMessage()));
            }
        }));
    }

    public void CMD_Tare(boolean always) {
        int addr = this.getAddr();
        LoRaHost.getInstance().Send(new LoRaSend(addr, 130, new byte[]{(byte)(always ? 85 : 51)}, new LoRaResponse(){

            @Override
            public void response(LoRaReceive receive) {
                if (receive.getData().length == 1 && receive.getData()[0] == -86) {
                    System.out.println(String.format("\u6210\u529f\uff1a\u53bb\u76ae", new Object[0]));
                } else {
                    System.out.println(String.format("\u5931\u8d25\uff1a\u53bb\u76ae", new Object[0]));
                }
            }

            @Override
            public void exp(MeterException e) {
                System.out.println(String.format("\u8bf7\u6c42\u5f02\u5e38\uff1a[%s]", e.getMessage()));
            }
        }));
    }

    public void CMD_Tare(BigDecimal tare, boolean always) {
        int addr = this.getAddr();
        int value = ByteUtils.toSPF((BigDecimal)tare);
        LoRaHost.getInstance().Send(new LoRaSend(addr, 130, new byte[]{(byte)(always ? 85 : 51), (byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)}, new LoRaResponse(){

            @Override
            public void response(LoRaReceive receive) {
                if (receive.getData().length == 1 && receive.getData()[0] == -86) {
                    System.out.println(String.format("\u6210\u529f\uff1a\u53bb\u76ae", new Object[0]));
                } else {
                    System.out.println(String.format("\u5931\u8d25\uff1a\u53bb\u76ae", new Object[0]));
                }
            }

            @Override
            public void exp(MeterException e) {
                System.out.println(String.format("\u8bf7\u6c42\u5f02\u5e38\uff1a[%s]", e.getMessage()));
            }
        }));
    }

    public void CMD_Calibrate(BigDecimal weight, int wAll, int dot, int cAll, int unit, int degreeOffset) {
        int addr = this.getAddr();
        int value1 = ByteUtils.toSPF((BigDecimal)weight);
        int value2 = wAll << 3 | dot;
        byte[] output = new byte[]{(byte)(value1 & 0xFF), (byte)(value1 >> 8 & 0xFF), (byte)(value1 >> 16 & 0xFF), (byte)(value1 >> 24 & 0xFF), (byte)(value2 & 0xFF), (byte)(value2 >> 8 & 0xFF), (byte)(value2 >> 16 & 0xFF), (byte)(value2 >> 24 & 0xFF), (byte)(cAll & 0xFF), (byte)(cAll >> 8 & 0xFF), (byte)(cAll >> 16 & 0xFF), (byte)(cAll >> 24 & 0xFF), (byte)unit, (byte)degreeOffset};
        LoRaHost.getInstance().Send(new LoRaSend(addr, 131, output, new LoRaResponse(){

            @Override
            public void response(LoRaReceive receive) {
                if (receive.getData().length == 1 && receive.getData()[0] == -86) {
                    System.out.println(String.format("\u6210\u529f\uff1a\u6807\u5b9a", new Object[0]));
                } else {
                    System.out.println(String.format("\u5931\u8d25\uff1a\u6807\u5b9a", new Object[0]));
                }
            }

            @Override
            public void exp(MeterException e) {
                System.out.println(String.format("\u8bf7\u6c42\u5f02\u5e38\uff1a[%s]", e.getMessage()));
            }
        }));
    }
}

