/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.lora;

import com.jhscale.common.utils.ByteUtils;
import com.jhscale.meter.entity.MeterQueue;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.lora.LoRaAction;
import com.jhscale.meter.lora.LoRaDevice;
import com.jhscale.meter.lora.LoRaPara;
import com.jhscale.meter.lora.LoRaReceive;
import com.jhscale.meter.lora.LoRaResponse;
import com.jhscale.meter.lora.LoRaSend;
import com.jhscale.meter.model.device.Device;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoRaHost
implements DeviceClientEventListener {
    private static final int HostAddr = 256;
    @ApiModelProperty(value="\u4ece\u8bbe\u5907\u5217\u8868", name="received_Valid")
    private Map<Integer, LoRaDevice> devices = new HashMap<Integer, LoRaDevice>();
    @ApiModelProperty(value="LoRa\u53c2\u6570", name="para")
    public LoRaPara para = new LoRaPara();
    private PortManager messenger;
    private LoRaThread thread;
    private Map<Integer, LoRaResponse> taskbuf = new HashMap<Integer, LoRaResponse>();
    private short[] buffer = new short[65536];
    private int buffer_stt = 0;
    private int buffer_end = 0;
    private byte[] initPara = null;
    private LoRaAction initAction = null;

    public static BigDecimal GetNumS32(int value) {
        return new BigDecimal(value >> 3).movePointLeft(value & 7);
    }

    public static int GetU16(byte[] input, int offset) {
        return (input[offset] & 0xFF) + (input[offset + 1] & 0xFF) * 256;
    }

    public static int GetS32(byte[] input, int offset) {
        return (input[offset] & 0xFF) + (input[offset + 1] & 0xFF) * 256 + (input[offset + 2] & 0xFF) * 65536 + (input[offset + 3] & 0xFF) * 0x1000000;
    }

    public static BigDecimal GetNumS32(byte[] input, int offset) {
        if (input.length < offset + 4) {
            return null;
        }
        return LoRaHost.GetNumS32((input[offset] & 0xFF) + (input[offset + 1] & 0xFF) * 256 + (input[offset + 2] & 0xFF) * 65536 + (input[offset + 3] & 0xFF) * 0x1000000);
    }

    private LoRaHost() {
    }

    public static LoRaHost getInstance() {
        return SingleLoRaHost.SINGLETON;
    }

    public boolean Init_Manager(DeviceControl control, Device device, long timeout) throws MeterException {
        this.thread = new LoRaThread(timeout);
        this.thread.start();
        this.messenger = new PortManager<Device>(control, device, this);
        this.messenger.openPort();
        return true;
    }

    public boolean Stop_Manager() throws MeterException {
        if (this.thread != null) {
            this.thread.run = false;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
        if (this.messenger != null) {
            this.messenger.closePort();
            this.messenger = null;
        }
        return true;
    }

    public void Send(LoRaSend send) {
        this.thread.addSend(send);
    }

    public LoRaDevice getDevice(int id) {
        return this.devices.get(id);
    }

    public boolean addDevice(LoRaDevice ... devices) {
        if (devices != null && devices.length > 0) {
            return this.addDevice(Arrays.asList(devices));
        }
        return false;
    }

    public boolean addDevice(List<LoRaDevice> devices) {
        if (devices != null && !devices.isEmpty()) {
            ArrayList<LoRaDevice> temp = new ArrayList<LoRaDevice>();
            for (LoRaDevice device : devices) {
                int addr = device.getAddr();
                if (addr < 1 || addr > 31) continue;
                temp.add(device);
            }
            if (!temp.isEmpty()) {
                temp.stream().forEach(d -> this.devices.put(d.getAddr(), (LoRaDevice)((Object)d)));
                return true;
            }
        }
        return false;
    }

    public void clearDevices() {
        this.devices.clear();
    }

    private void TaskBuf_Clear() {
        this.taskbuf.clear();
    }

    private void TaskBuf_Put(int addrCmd, LoRaResponse lrp) {
        this.taskbuf.put(addrCmd, lrp);
    }

    private void Receive_Deal(int addr, int command, byte[] data) {
        LoRaReceive receive = new LoRaReceive(addr, command, data);
        LoRaResponse response = this.taskbuf.get(receive.getAddrCmd());
        if (response != null) {
            response.response(receive);
        } else if (this.thread.waitACK && this.thread.loRaSend != null && this.thread.loRaSend.getResponse() != null && this.thread.loRaSend.getCmd() == receive.getCmd() && (this.thread.loRaSend.getAddr() == 0 || this.thread.loRaSend.getAddr() == receive.getAddr())) {
            this.thread.loRaSend.getResponse().response(receive);
            this.thread.waitACK = false;
        }
    }

    public void Receive(byte[] bytes) {
        int length;
        for (int loop = 0; loop < bytes.length; ++loop) {
            this.buffer[this.buffer_end] = (short)(bytes[loop] & 0xFF);
            int nextpos = this.buffer_end + 1 & 0xFFFF;
            if (nextpos == this.buffer_stt) break;
            this.buffer_end = nextpos;
        }
        while ((length = this.buffer_end - this.buffer_stt & 0xFFFF) >= 4) {
            if (this.buffer[this.buffer_stt] != 242) {
                this.buffer_stt = this.buffer_stt + 1 & 0xFFFF;
                continue;
            }
            short type = this.buffer[this.buffer_stt + 1 & 0xFFFF];
            short cnlng = this.buffer[this.buffer_stt + 2 & 0xFFFF];
            if (length < cnlng + 4) break;
            if (this.buffer[this.buffer_stt + cnlng + 3 & 0xFFFF] != 243) {
                this.buffer_stt = this.buffer_stt + 1 & 0xFFFF;
                continue;
            }
            if (type == 82) {
                short head = this.buffer[this.buffer_stt + 3 & 0xFFFF];
                if ((head & 0xC0) == 0 && (head & 0x1F) > 0) {
                    int pos;
                    int cmd = this.buffer[this.buffer_stt + 4 & 0xFFFF];
                    if ((cmd & 0x80) != 0) {
                        cmd = cmd & 0x7F | (this.buffer[this.buffer_stt + 5 & 0xFFFF] << 7) + 128;
                        pos = 3;
                    } else {
                        pos = 2;
                    }
                    int cmdlng = cnlng - pos;
                    if (cmdlng >= 0) {
                        byte[] cmdbuf = new byte[cmdlng];
                        for (int loop = 0; loop < cmdlng; ++loop) {
                            cmdbuf[loop] = (byte)this.buffer[this.buffer_stt + pos + 3 + loop & 0xFFFF];
                        }
                        this.Receive_Deal(head, cmd, cmdbuf);
                    }
                }
            } else if (type == 81) {
                if (cnlng >= 1) {
                    short cmd = this.buffer[this.buffer_stt + 3 & 0xFFFF];
                    int cmdlng = cnlng - 1;
                    byte[] cmdbuf = new byte[cmdlng];
                    for (int loop = 0; loop < cmdlng; ++loop) {
                        cmdbuf[loop] = (byte)this.buffer[this.buffer_stt + 4 + loop & 0xFFFF];
                    }
                    this.Receive_Deal(256, cmd, cmdbuf);
                } else {
                    this.Init_Again();
                }
            }
            this.buffer_stt = this.buffer_stt + cnlng + 4 & 0xFFFF;
        }
    }

    public void Task_Clear() {
        LoRaHost.getInstance().Send(new LoRaSend(new byte[]{-14, 84, 0, -13}));
        LoRaHost.getInstance().TaskBuf_Clear();
    }

    public void Task_All() {
        for (LoRaDevice value : LoRaHost.getInstance().devices.values()) {
            value.Task_Routine();
        }
    }

    public void CMD_Version() {
        for (LoRaDevice value : LoRaHost.getInstance().devices.values()) {
            value.CMD_Version();
        }
    }

    public void CMD_ChangeDevicePara(int addr_old, final int addr_new, final LoRaPara para, final boolean checkInfo) {
        LoRaHost.getInstance().Send(new LoRaSend(addr_old, 32768, null, new LoRaResponse(){

            @Override
            public void response(LoRaReceive receive) {
                int addr_mid = receive.getAddr();
                if (checkInfo) {
                    LoRaDevice device = LoRaHost.getInstance().getDevice(addr_new);
                    if (device == null) {
                        System.out.println(String.format("\u5931\u8d25\uff1a\u672a\u77e5\u5730\u5740", new Object[0]));
                    }
                    if (!device.FirmwareIsOK(receive.getData())) {
                        System.out.println(String.format("\u5931\u8d25\uff1a\u8bbe\u5907\u4fe1\u606f\u4e0d\u5339\u914d", new Object[0]));
                    }
                }
                LoRaHost.getInstance().Send(new LoRaSend(addr_mid, 32769, para.getPara(addr_new), new LoRaResponse(){

                    @Override
                    public void response(LoRaReceive receive) {
                        System.out.println(String.format("\u6210\u529f\uff1a\u4fee\u6539\u8bbe\u5907\u4fe1\u606f", new Object[0]));
                    }

                    @Override
                    public void exp(MeterException e) {
                        System.out.println(String.format("\u8bf7\u6c42\u5f02\u5e38\uff1a[%s]", e.getMessage()));
                    }
                }));
            }

            @Override
            public void exp(MeterException e) {
                System.out.println(String.format("\u8bf7\u6c42\u5f02\u5e38\uff1a[%s]", e.getMessage()));
            }
        }));
    }

    public void Init_RunAction() {
        if (this.initAction != null) {
            this.initAction.execute();
        }
    }

    public void Init_AsPara(byte[] para, LoRaAction action) {
        this.initPara = para;
        this.initAction = action;
        LoRaHost.getInstance().Send(new LoRaSend(256, 73, para, new LoRaResponse(){

            @Override
            public void response(LoRaReceive receive) {
                if (LoRaHost.getInstance().para.setPara(receive.getData())) {
                    System.out.println(String.format("\u6210\u529f\uff1a\u542f\u52a8Host", new Object[0]));
                    LoRaHost.getInstance().Init_RunAction();
                } else {
                    System.out.println(String.format("\u5931\u8d25\uff1a\u542f\u52a8Host\u8fd4\u53c2\u4e0d\u8be6", new Object[0]));
                }
            }

            @Override
            public void exp(MeterException e) {
                System.out.println(String.format("\u8bf7\u6c42\u5f02\u5e38\uff1a[%s]", e.getMessage()));
            }
        }));
    }

    public void Init_AsWorking(int freqType, LoRaAction action) {
        this.Init_AsPara(new byte[]{(byte)(freqType & 0xFF), (byte)(freqType >> 8 & 0xFF)}, action);
    }

    public void Init_AsMatching(LoRaAction action) {
        this.Init_AsPara(null, action);
    }

    public void Init_Again() {
        this.Init_AsPara(this.initPara, this.initAction);
    }

    @Override
    public void onClientEvent(byte[] bytes) throws MeterException {
        System.out.println(String.format("\u76d1\u542c\u7ed3\u679c\u6570\u636e\uff1a[%s]", ByteUtils.bytes2HexString((byte[])bytes)));
        this.Receive(bytes);
    }

    @Override
    public void onClientEventExp(MeterException e) {
        System.out.println(String.format("\u76d1\u542c\u7ed3\u679c\u5f02\u5e38\uff1a[%s]", e.getMessage()));
    }

    public class LoRaThread
    extends Thread {
        private boolean run = true;
        private boolean waitACK = false;
        private MeterQueue<LoRaSend> sending = new MeterQueue();
        private LoRaSend loRaSend;
        private long time_out = 2000L;

        public LoRaThread(long timeout) {
            if (timeout > 0L) {
                this.time_out = timeout;
            }
        }

        public void addSend(LoRaSend send) {
            this.sending.enqueue(send);
        }

        @Override
        public void run() {
            while (this.run) {
                if (!this.waitACK) {
                    if (!this.sending.isEmpty()) {
                        LoRaSend dequeue = this.sending.dequeue();
                        if (dequeue == null) continue;
                        LoRaResponse response = dequeue.getResponse();
                        try {
                            if (response != null) {
                                if (dequeue.getTimeout() >= 0) {
                                    this.waitACK = true;
                                    this.loRaSend = dequeue;
                                } else {
                                    LoRaHost.this.TaskBuf_Put(dequeue.getAddrCmd(), response);
                                }
                            }
                            System.out.println(String.format("\u53d1\u9001\u5185\u5bb9\u6570\u636e\uff1a[%s]", ByteUtils.bytes2HexString((byte[])dequeue.getData())));
                            LoRaHost.this.messenger.writeDataImmediately(dequeue.getData());
                        }
                        catch (MeterException e) {
                            e.printStackTrace();
                            if (response != null) {
                                response.exp(e);
                            }
                            this.waitACK = false;
                        }
                    }
                } else if (this.loRaSend.isTimeout()) {
                    this.loRaSend.getResponse().exp(new MeterException(MeterStateEnum.\u901a\u8baf\u54cd\u5e94\u8d85\u65f6));
                    this.waitACK = false;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static class SingleLoRaHost {
        private static final LoRaHost SINGLETON = new LoRaHost();

        private SingleLoRaHost() {
        }
    }
}

