/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.lora;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.lora.LoRaResponse;
import io.swagger.annotations.ApiModelProperty;

public class LoRaSend
extends JSONModel {
    @ApiModelProperty(value="\u5408\u6cd5\u6570\u636e", name="valid")
    private boolean valid = false;
    @ApiModelProperty(value="\u53d1\u9001_\u6570\u636e\u5730\u5740", name="addr")
    private int addr;
    @ApiModelProperty(value="\u53d1\u9001_\u6570\u636e\u547d\u4ee4", name="cmd")
    private int cmd;
    @ApiModelProperty(value="\u53d1\u9001_\u6570\u636e\u5185\u5bb9", name="send_Data")
    private byte[] data = new byte[0];
    @ApiModelProperty(value="\u5f00\u59cb\u65f6\u95f4", name="start")
    private long start = System.currentTimeMillis();
    @ApiModelProperty(value="\u8d85\u65f6\u65f6\u95f4", name="timeout")
    private int timeout = 1000;
    @ApiModelProperty(value="\u54cd\u5e94\u7ed3\u679c\u4fe1\u606f", name="response")
    private LoRaResponse response;

    private void LoRaSend_Init(int addr, int cmd, byte[] datas, LoRaResponse response, int timeout) {
        this.valid = true;
        this.addr = addr;
        this.cmd = cmd;
        this.response = response;
        this.timeout = timeout;
        if (addr > 255) {
            int dlng = datas == null ? 0 : datas.length;
            byte[] output = new byte[5 + dlng];
            output[0] = -14;
            output[1] = 81;
            output[2] = (byte)(1 + dlng);
            output[3] = (byte)cmd;
            output[4 + dlng] = -13;
            for (int loop = 0; loop < dlng; ++loop) {
                output[4 + loop] = datas[loop];
            }
            this.data = output;
        } else {
            int offset;
            byte[] output;
            if (addr > 31) {
                this.valid = false;
                return;
            }
            int dlng = datas == null ? 0 : datas.length;
            if (cmd >= 128) {
                output = new byte[7 + dlng];
                output[4] = (byte)((cmd -= 128) & 0x7F | 0x80);
                output[5] = (byte)(cmd >> 7);
                offset = 6;
            } else {
                output = new byte[6 + dlng];
                output[4] = (byte)cmd;
                offset = 5;
            }
            output[3] = response != null ? (byte)(addr | 0x80) : (byte)(addr | 0x40);
            output[0] = -14;
            output[1] = timeout < 0 ? 84 : 83;
            output[2] = (byte)(offset - 3 + dlng);
            output[offset + dlng] = -13;
            for (int loop = 0; loop < dlng; ++loop) {
                output[offset + loop] = datas[loop];
            }
            this.data = output;
        }
    }

    public LoRaSend(int addr, int cmd, byte[] datas, LoRaResponse response, int timout) {
        this.LoRaSend_Init(addr, cmd, datas, response, timout);
    }

    public LoRaSend(int addr, int cmd, byte[] datas, LoRaResponse response) {
        this.LoRaSend_Init(addr, cmd, datas, response, 1000);
    }

    public LoRaSend(int addr, int cmd, byte[] datas) {
        this.LoRaSend_Init(addr, cmd, datas, null, 1000);
    }

    public LoRaSend(byte[] input) {
        this.valid = true;
        this.addr = 0;
        this.cmd = 0;
        this.response = null;
        this.timeout = 0;
        this.data = input;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getAddr() {
        return this.addr;
    }

    public int getCmd() {
        return this.cmd;
    }

    public int getAddrCmd() {
        return this.addr * 65536 + this.cmd;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.start + (long)this.timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public LoRaResponse getResponse() {
        return this.response;
    }
}

