/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.model.device;

import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.model.device.Device;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;

public class UDPDevice<T>
extends Device {
    private int listener;
    private int broadcast;
    private String broadcastAddress;

    public UDPDevice() {
    }

    public UDPDevice(int listener, int broadcast) {
        this.listener = listener;
        this.broadcast = broadcast;
    }

    public static UDPDevice UDP_Terminal() {
        return new UDPDevice(33583, 33584);
    }

    public static UDPDevice UDP_PC() {
        return new UDPDevice(33584, 33583);
    }

    public InetAddress broadcastAddress() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.broadcastAddress)) {
                return InetAddress.getByName(this.broadcastAddress);
            }
            return InetAddress.getByName(SystemtUtils.route_broadcast());
        }
        catch (Exception e) {
            try {
                return InetAddress.getByName("255.255.255.255");
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
    }

    public int getListener() {
        return this.listener;
    }

    public void setListener(int listener) {
        this.listener = listener;
    }

    public int getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(int broadcast) {
        this.broadcast = broadcast;
    }

    public String getBroadcastAddress() {
        return this.broadcastAddress;
    }

    public void setBroadcastAddress(String broadcastAddress) {
        this.broadcastAddress = broadcastAddress;
    }
}

