/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.mqtt;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.mqtt.annotations.COrder;
import com.jhscale.meter.mqtt.em.Encoding;
import com.jhscale.meter.mqtt.entity.Mark;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.MQTTUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class IMQTT
extends JSONModel {
    private Charset charset;
    private StringBuffer buffer;

    public IMQTT() {
        this.buffer = new StringBuffer();
    }

    public IMQTT(Charset charset) {
        this.charset = charset;
        this.buffer = new StringBuffer();
    }

    public IMQTT(String innerContent) {
        this(Encoding.GBK.getCharset(), innerContent);
    }

    public IMQTT(Charset charset, String innerContent) {
        this.charset = charset;
        this.buffer = new StringBuffer(innerContent);
    }

    protected void copy(IMQTT imqtt) {
        this.charset = imqtt.charset;
        this.buffer = imqtt.buffer;
    }

    protected void copy(Charset charset, String data) {
        this.charset = charset;
        this.buffer = new StringBuffer(data);
    }

    protected void clear() {
        this.buffer.setLength(0);
    }

    public boolean hasNext() {
        return this.buffer.length() > 0;
    }

    public IMQTT packSubContent() {
        return this;
    }

    public IMQTT unpackSubContent(Mark mark) {
        return null;
    }

    public void fillingSub() {
    }

    private String substring(int index) {
        String substring = this.buffer.substring(0, index);
        this.buffer = new StringBuffer(this.buffer.substring(index));
        return substring;
    }

    public String int2SHex(Integer val, int length) {
        return ByteUtils.convert(ByteUtils.appendFill(Integer.toHexString(val), length));
    }

    public Integer shex2Int(String hex) {
        if (StringUtils.isBlank((CharSequence)hex)) {
            hex = "00";
        }
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        return Integer.parseInt(ByteUtils.convert(hex), 16);
    }

    public IMQTT append(String text) {
        text = StringUtils.isBlank((CharSequence)text) ? "" : text;
        byte[] bytes = Objects.isNull(this.charset) ? text.getBytes() : text.getBytes(this.charset);
        String hexText = StringUtils.isBlank((CharSequence)text) ? "" : ByteUtils.toHexAscii(bytes);
        this.buffer.append(hexText).append("00");
        return this;
    }

    public IMQTT appendNull(String text) {
        return StringUtils.isNotBlank((CharSequence)text) ? this.append(text) : this;
    }

    public String parseText() {
        int index = ByteUtils.indexOf(this.buffer.toString(), "00");
        if (index == -1) {
            return "";
        }
        return new String(ByteUtils.fromHexAscii(this.substring(index + 2)), this.charset).trim();
    }

    public IMQTT append(Date date) {
        long timeDefault = 946656000000L;
        long timeNow = Objects.nonNull(date) ? date.getTime() : 0L;
        long second = (timeNow - timeDefault) / 1000L;
        String hexTime = ByteUtils.completeBytes(Long.toHexString(second), 8);
        this.buffer.append(hexTime);
        return this;
    }

    public Date parseDate() {
        return ByteUtils.convertTime(this.substring(8));
    }

    public IMQTT append(BigDecimal val) {
        val = Objects.nonNull(val) ? val : BigDecimal.ZERO;
        int i = ByteUtils.toSPF2(val);
        this.buffer.append(ByteUtils.completeBytes(Long.toHexString(i), 8));
        return this;
    }

    public IMQTT appendNull(BigDecimal val) {
        return Objects.nonNull(val) ? this.append(val) : this;
    }

    public BigDecimal parseBigDecimal() {
        return ByteUtils.convertBigDecimal(this.substring(8));
    }

    public IMQTT append(Integer val, int len) {
        return Objects.nonNull(val) ? this.append(Integer.toHexString(val), len) : this;
    }

    public IMQTT append(char character) {
        return this.append(character, 2);
    }

    private IMQTT append(long val, int length) {
        this.buffer.append(ByteUtils.completeBytes(Long.toHexString(val), length));
        return this;
    }

    public IMQTT append(String hex, int len) {
        return this.appendCovert(ByteUtils.appendFill(hex, len));
    }

    public IMQTT appendCovert(String hex) {
        return this.appendHex(ByteUtils.convert(hex));
    }

    public IMQTT appendHex(String hex) {
        if (StringUtils.isNotBlank((CharSequence)hex)) {
            this.buffer.append(hex);
        }
        return this;
    }

    public IMQTT appendTopHex(String hex) {
        if (StringUtils.isNotBlank((CharSequence)hex)) {
            this.buffer.insert(0, hex);
        }
        return this;
    }

    public IMQTT appendBin(String bin, int len) {
        this.buffer.append(this.int2SHex(MQTTUtils.bit2Int(bin), len));
        return this;
    }

    protected String parseBin(int len) {
        String bit = MQTTUtils.hex2Bit(this.parseCovert(len));
        return ByteUtils.appendFill(bit, 16);
    }

    public IMQTT appendCmd(String cmd) {
        return this.appendCovert(cmd);
    }

    public String parseCmd() {
        return this.parseCovert(4);
    }

    public String parseCovert(int len) {
        return ByteUtils.convert(this.parseHex(len));
    }

    public String parseHex(int len) {
        return this.substring(len);
    }

    public String parseHex() {
        return this.substring(this.buffer.length());
    }

    public int parseInt(int len) {
        return Integer.parseInt(this.parseCovert(len), 16);
    }

    public char parseChar() {
        return (char)this.parseInt(2);
    }

    public String parseBit() {
        return MQTTUtils.hex2Bit(this.parseHex(2));
    }

    public IMQTT appendFloat() {
        ArrayList<Character> chars1 = new ArrayList<Character>();
        ArrayList<Character> chars2 = new ArrayList<Character>();
        ArrayList<Character> chars3 = new ArrayList<Character>();
        ArrayList<Character> chars4 = new ArrayList<Character>();
        ArrayList<Character> chars5 = new ArrayList<Character>();
        ArrayList<Character> chars6 = new ArrayList<Character>();
        ArrayList<Character> chars7 = new ArrayList<Character>();
        ArrayList<Character> chars8 = new ArrayList<Character>();
        ArrayList<Character> chars9 = new ArrayList<Character>();
        List<String> params = this.paramArray();
        for (int i = 0; i < 63; ++i) {
            if (i < 7) {
                MQTTUtils.bitPart(chars1, params, i);
            }
            if (i >= 7 && i < 15) {
                MQTTUtils.bitPart(chars3, params, i);
            }
            if (i >= 15 && i < 23) {
                MQTTUtils.bitPart(chars4, params, i);
            }
            if (i >= 23 && i < 31) {
                MQTTUtils.bitPart(chars5, params, i);
            }
            if (i >= 31 && i < 39) {
                MQTTUtils.bitPart(chars6, params, i);
            }
            if (i >= 39 && i < 47) {
                MQTTUtils.bitPart(chars7, params, i);
            }
            if (i >= 47 && i < 55) {
                MQTTUtils.bitPart(chars8, params, i);
            }
            if (i < 55) continue;
            MQTTUtils.bitPart(chars9, params, i);
        }
        MQTTUtils.collect(chars2, chars3);
        MQTTUtils.collect(chars2, chars4);
        MQTTUtils.collect(chars2, chars5);
        MQTTUtils.collect(chars2, chars6);
        MQTTUtils.collect(chars2, chars7);
        MQTTUtils.collect(chars2, chars8);
        MQTTUtils.collect(chars2, chars9);
        chars2.add(Character.valueOf('0'));
        MQTTUtils.collect(chars1, chars2);
        StringBuffer sb = new StringBuffer();
        sb.append(ByteUtils.dataFormat(MQTTUtils.floatArr2Hex(chars1)));
        if (chars2.contains(Character.valueOf('1'))) {
            sb.append(ByteUtils.dataFormat(MQTTUtils.floatArr2Hex(chars2)));
        }
        if (chars3.contains(Character.valueOf('1'))) {
            sb.append(ByteUtils.dataFormat(MQTTUtils.floatArr2Hex(chars3)));
        }
        if (chars4.contains(Character.valueOf('1'))) {
            sb.append(ByteUtils.dataFormat(MQTTUtils.floatArr2Hex(chars4)));
        }
        if (chars5.contains(Character.valueOf('1'))) {
            sb.append(ByteUtils.dataFormat(MQTTUtils.floatArr2Hex(chars5)));
        }
        if (chars6.contains(Character.valueOf('1'))) {
            sb.append(ByteUtils.dataFormat(MQTTUtils.floatArr2Hex(chars6)));
        }
        if (chars7.contains(Character.valueOf('1'))) {
            sb.append(ByteUtils.dataFormat(MQTTUtils.floatArr2Hex(chars7)));
        }
        if (chars8.contains(Character.valueOf('1'))) {
            sb.append(ByteUtils.dataFormat(MQTTUtils.floatArr2Hex(chars8)));
        }
        if (chars9.contains(Character.valueOf('1'))) {
            sb.append(ByteUtils.dataFormat(MQTTUtils.floatArr2Hex(chars9)));
        }
        this.buffer.append(sb);
        return this;
    }

    public char[] parseFloat() {
        char[] chars = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
        String bit1 = MQTTUtils.hex2Bit(this.substring(2));
        for (int i = 0; i < bit1.length(); ++i) {
            chars[i] = bit1.charAt(i);
        }
        if (bit1.charAt(bit1.length() - 1) == '1') {
            String bit2 = MQTTUtils.hex2Bit(this.substring(2));
            for (int i = 0; i < bit2.length(); ++i) {
                char c;
                chars[8 + i] = c = bit2.charAt(i);
                if (c != '1') continue;
                String bit3 = MQTTUtils.hex2Bit(this.substring(2));
                for (int j = 0; j < bit3.length(); ++j) {
                    chars[8 * (i + 2) + j] = bit3.charAt(j);
                }
            }
        }
        return chars;
    }

    public List<String> paramArray() {
        List<String> ignoreParams = this.ignoreParams();
        List fields = super.allFieldList(ignoreParams.toArray(new String[ignoreParams.size()]));
        if (fields == null || fields.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<Field> orderFields = new ArrayList<Field>();
        for (Field field : fields) {
            COrder annotation = field.getAnnotation(COrder.class);
            if (annotation == null) continue;
            orderFields.add(field);
        }
        if (orderFields == null || orderFields.isEmpty()) {
            return new ArrayList<String>();
        }
        Collections.sort(orderFields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getAnnotation(COrder.class).order() - o2.getAnnotation(COrder.class).order();
            }
        });
        String[] array = new String[orderFields.size()];
        for (int i = 0; i < orderFields.size(); ++i) {
            Field field = (Field)orderFields.get(i);
            String str = null;
            try {
                field.setAccessible(true);
                Object val = field.get((Object)this);
                str = Objects.isNull(val) ? null : String.valueOf(val);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            array[i] = str;
        }
        return Stream.of(array).collect(Collectors.toList());
    }

    public List<String> ignoreParams() {
        return new ArrayList<String>();
    }

    public String over() {
        JLog.debug("IMQTT buffer:{}", this.buffer);
        return this.buffer.toString();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }
}

